define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"1-preface.html",
                    "topics":[
                        {
                            "title":"Purpose",
                            "href":"purpose.html"
                        },
                        {
                            "title":"Audience",
                            "href":"1.2-audience.html"
                        },
                        {
                            "title":"Documentation Accessibility",
                            "href":"do-not-use-shared-global-topic-documentation-accessibility.html"
                        },
                        {
                            "title":"Critical Patches",
                            "href":"critical-patches-1.html"
                        },
                        {
                            "title":"Diversity and Inclusion",
                            "href":"do-not-use-shared-global-topic-diversity-and-inclusion.html"
                        },
                        {
                            "title":"Conventions",
                            "href":"1.6-conventions-1-1.html"
                        },
                        {
                            "title":"Related Documents",
                            "href":"1.5-related-documents.html"
                        },
                        {
                            "title":"Screenshot Disclaimer",
                            "href":"1.6-screenshot-disclaimer.html"
                        },
                        {
                            "title":"Acronyms and Abbreviations",
                            "href":"1.7-acronyms-and-abbreviations-1-1.html"
                        },
                        {
                            "title":"Symbols and Icons",
                            "href":"1.9-symbols-and-icons-1.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Trade Finance",
                    "href":"3-trade-finance.html"
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Overview (Dashboard)",
                    "href":"4-overview-dashboard.html"
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Initiate a Letter of Credit",
                    "href":"5-initiate-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Search LC Template",
                            "href":"5.1-search-lc-template.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Copy and Initiate LC",
                            "href":"5.2-copy-and-initiate-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Initiate a Letter of Credit - By Drafts",
                            "href":"5.3-drafts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Back to Back LC",
                            "href":"5.4-back-back-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Initiate a Letter of Credit",
                            "href":"5.5-initiate-letter-credit.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">3.5.1 </span> Initiate a Letter of Credit - LC Details",
                                    "href":"5.5.1-initiate-letter-credit-lc-details.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.2 </span> Goods and Shipment Details",
                                    "href":"5.5.2-goods-and-shipment-details-tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.3 </span> Documents and Conditions",
                                    "href":"5.5.3-documents-and-conditions-tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.4 </span> Linkages",
                                    "href":"5.5.4-linkages-tab.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.5 </span> Instructions",
                                    "href":"5.5.5-instructions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.6 </span> Insurance",
                                    "href":"5.5.6-insurance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.7 </span> Charges Commissions and Taxes",
                                    "href":"5.5.7-charges-commissions-and-taxes.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">3.5.8 </span> Attachments",
                                    "href":"5.5.8-attachments.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> Initiate Back to Back Letter of Credit",
                            "href":"5.6-initiate-back-back-letter-credit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.7 </span> Save as Draft",
                            "href":"5.7-draft.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.8 </span> FAQs",
                            "href":"5.8-faqs.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Import LC Amendment",
                    "href":"6-initiate-import-lc-amendment.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Search Import LC Amendments",
                            "href":"6.1-search-import-lc-amendments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Initiate Import LC Amendment",
                            "href":"6.2-initiate-import-lc-amendment.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Re-Open Closed LC",
                            "href":"6.3-open-closed-lc.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> View Import Letter of Credit",
                    "href":"7-view-import-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> View Import Letter of Credit - Search",
                            "href":"7.1-view-import-lc-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> View Import Letter of Credit - LC Details",
                            "href":"7.2-view-import-letter-credit-lc-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Attached Documents",
                            "href":"7.2.1-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Amendments",
                            "href":"7.2.2-amendments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Bills",
                            "href":"7.2.3-bills.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> Shipping Guarantee",
                            "href":"7.2.4-shipping-guarantee.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> Linkages",
                            "href":"7.2.5-linkages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.8 </span> Charges Commissions and Taxes",
                            "href":"7.2.6-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.9 </span> SWIFT Messages",
                            "href":"7.2.7-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.10 </span> Advice",
                            "href":"7.2.8-advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.11 </span> Bank",
                            "href":"7.2.8-bank.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> View Import Bill",
                    "href":"8-view-import-bill.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> View Import Bill - Search",
                            "href":"8.1-view-import-bill-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> View Import Bill Under LC - View Bill Details",
                            "href":"8.2-view-import-bill-lc-view-bill-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> View Import Bill Under LC - Discrepancies",
                            "href":"8.3-view-import-bill-lc-discrepancies.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Attached Documents",
                            "href":"8.4-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Shipping Guarantee",
                            "href":"8.5-view-import-bill-lc-shipping-guarantee.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.6 </span> Linkages",
                            "href":"8.6-view-import-bill-lc-linkages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.7 </span> Charges and Taxes",
                            "href":"8.7-charges-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.8 </span> SWIFT Messages",
                            "href":"8.8-view-import-bill-lc-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.9 </span> Advice",
                            "href":"8.9-view-import-bill-lc-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Bill Discrepancy Acceptance",
                    "href":"9-bill-discrepancies-acceptance-settlement.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Bill Discrepancy Acceptance - Discrepancy Details",
                            "href":"9.2-bill-discrepancy-acceptance-discrepancy-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Bill Discrepancy Acceptance – Settlement Details",
                            "href":"9.3-bill-discrepancy-acceptance-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Bill Discrepancy Acceptance – Forex Deals",
                            "href":"9.4-bill-discrepancy-acceptance-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> Bill Discrepancy Acceptance - Charges and Taxes",
                            "href":"9.5-bill-discrepancy-acceptance-charges-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.5 </span> Attachments",
                            "href":"9.6-bill-discrepancy-acceptance-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Bill Settlement",
                    "href":"10-settlement-bills.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Bill Settlement – Single Bill – Settlement Details",
                            "href":"10.1-bill-settlement-single-bill-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Bill Settlement – Single Bill – Forex Deals",
                            "href":"10.2-bill-settlement-single-bill-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Bill Settlement - Single - Charges and Taxes",
                            "href":"10.3-bill-settlement-single-charges-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Bill Settlement -Single Bill - Attachments",
                            "href":"10.4-bill-settlement-attachments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.5 </span> Bill Settlement – Multiple Bill – Detailed Settlement Instruction",
                            "href":"10.5-bill-settlement-multiple-bill-search.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Modify Bill",
                    "href":"11-modify-bills.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Modify Bill - Search",
                            "href":"11.1-modify-bill-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Modify Bill – Settlement Details",
                            "href":"11.2-modify-bill-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> Modify Bill – Forex Deals",
                            "href":"11.3-modify-bill-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> Modify Bills - Charges, Commissions and Taxes",
                            "href":"11.4-modify-bill-charges-commission-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> Modify Bills - Attachments",
                            "href":"11.5-modify-bill-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> View Export Letter of Credit",
                    "href":"12-view-export-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> View Export Letter of Credit - Search",
                            "href":"12.1-view-export-lc-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> View Export Letter of Credit - LC Details",
                            "href":"12.2-view-export-letter-credit-lc-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> View Export Letter Of Credit - Attached Documents",
                            "href":"12.3-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> View Export Letter Of Credit - Amendments",
                            "href":"12.4-view-export-letter-credit-amendments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> View Export Letter Of Credit - Bills",
                            "href":"12.5-view-export-lc-bills.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.6 </span> View Export Letter of Credit - Charges Commissions and Taxes",
                            "href":"12.6-view-export-letter-credit-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.7 </span> SWIFT Messages",
                            "href":"12.7-view-export-letter-credit-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.8 </span> Advice",
                            "href":"12.8-view-export-lc-advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.9 </span> Bank",
                            "href":"12.9-view-export-lc-bank.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.10 </span> View Export Letter of Credit - Assignment",
                            "href":"12.10-view-export-lc-assignmernt.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.11 </span> View Export Letter of Credit - Transferred LC",
                            "href":"12.11-view-export-lc-transferred-lc.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.12 </span> FAQs",
                            "href":"12.12-faqs.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> LC Amendment Acceptance",
                    "href":"13-lc-amendment-acceptance.html"
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Initiate Bills",
                    "href":"14-initiate-bills.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Search Bills Drafts",
                            "href":"14.1-search-bills-drafts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> Initiate a Bill - LC Details",
                            "href":"14.2-initiate-bill-lc-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.3 </span> Initiate Bill - Bill Details",
                            "href":"14.3-initiate-bills-bill-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.4 </span> Initiate Bills - Assignee Details",
                            "href":"14.4-initiate-bill-assignee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.5 </span> Initiate Bills – Forex Deals",
                            "href":"14.5-initiate-bill-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.6 </span> Goods and Shipment Details",
                            "href":"14.6-goods-and-shipment-details-tab.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.7 </span> Initiate Bills - Discount",
                            "href":"14.6-initiate-bills-discount.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.8 </span> Initiate Bills - Charges and Taxes",
                            "href":"14.7-initiate-bills-charges-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.9 </span> Initiate Bills - Attachments",
                            "href":"14.8-initiate-bills-attachments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.10 </span> Save as Draft",
                            "href":"14.8-draft.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Modify Bill",
                    "href":"15-modify-bills.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Modify Bill - Search",
                            "href":"15.1-modify-bill-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> Modify Bills - Discount",
                            "href":"15.2-modify-bills-discount.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.3 </span> Modify Bills – Forex Deals",
                            "href":"15.3-modify-bill-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.4 </span> Modify Bills - Charges and Taxes",
                            "href":"15.4-modify-bills-charges-commission-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.5 </span> Modify Bills - Attachments",
                            "href":"15.5-modify-bills-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> View Export Bill",
                    "href":"16-view-export-bill.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> View Export Bill - Search",
                            "href":"16.1-view-export-bill-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> View Export Bill Under LC - View Bill Details",
                            "href":"16.2-view-export-bill-lc-view-bill-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> View Export Bill Under LC - Discrepancies",
                            "href":"16.3-view-export-bill-lc-discrepancies.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.4 </span> View Export Bill Under LC - Attached Documents",
                            "href":"16.4-view-export-bill-lc-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.5 </span> View Export Bill Under LC - Charges and Taxes",
                            "href":"16.5-view-export-bill-lc-charges-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.6 </span> View Export Bill Under LC - SWIFT Messages",
                            "href":"16.6-view-export-bill-lc-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.7 </span> View Export Bill Under LC - Advice",
                            "href":"16.7-view-export-bill-lc-advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.8 </span> View Export Bill Under LC - Assignment",
                            "href":"16.9-view-export-bill-lc-assignmernt.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.9 </span> View Export Bill Under LC - Loans",
                            "href":"16.8-view-export-bill-lc-loan.html"
                        },
                        {
                            "title":"<span class=\"secnum\">14.10 </span> FAQs",
                            "href":"16.11-faqs.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> View Import Collection",
                    "href":"17-view-import-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> View Import Collection - Search",
                            "href":"17.1-view-import-collection-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> View Import Collection - View Collection Details",
                            "href":"17.2-view-import-collection-view-collection-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> View Import Collection - Attached Documents",
                            "href":"17.3-view-import-collection-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.4 </span> Charges and Taxes",
                            "href":"17.4-view-import-collection-charges-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.5 </span> SWIFT Messages",
                            "href":"17.5-view-import-collection-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.6 </span> Advice",
                            "href":"17.6-view-import-collection-advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15.7 </span> View Import Collection - Loans",
                            "href":"17.9-view-import-collection-loan.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Settlement of Collection",
                    "href":"18-settlement-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> Settlement of Collection – Single Collection – Settlement Details",
                            "href":"18.1-settlement-collection-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> Settlement of Collection – Multiple Collection - Detailed Settlement Instruction",
                            "href":"18.5-settlement-collection-multiple-collection-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.3 </span> Settlement of Collection – Multiple Collection – Loan",
                            "href":"18.6-settlement-collection-multiple-collection-loan.html"
                        },
                        {
                            "title":"<span class=\"secnum\">16.4 </span> Settlement of Collection – Multiple Collection – Custom",
                            "href":"18.7-settlement-collection-multiple-collection-custom.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Acceptance of Import Collection",
                    "href":"acceptance-import-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> Acceptance of Import Collection - Collection Details",
                            "href":"acceptance-import-collection-collection-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.2 </span> Acceptance of Import Collection – Settlement Details",
                            "href":"acceptance-import-collection-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.3 </span> Acceptance of Import Collection – Forex Deals",
                            "href":"acceptance-import-collection-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.4 </span> Acceptance of Import Collection - Charges and Taxes",
                            "href":"acceptance-import-collection-charges.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17.5 </span> Acceptance of Import Collection - Attachments",
                            "href":"acceptance-import-collection-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Modify Collection",
                    "href":"19-modify-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">18.1 </span> Modify Collection - Search",
                            "href":"19.1-modify-collection-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.2 </span> Modify Collection – Settlement Details",
                            "href":"19.2-modify-collection-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.3 </span> Modify Collection – Forex Deals",
                            "href":"19.3-modify-collection-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.4 </span> Modify Collection - Charges, Commissions and Taxes",
                            "href":"19.3-modify-collection-charges-commission-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">18.5 </span> Modify Collection - Attachments",
                            "href":"19.5-modify-collection-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> Initiate Collection",
                    "href":"20-initiate-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">19.1 </span> Initiate Collection - Search - By Drafts",
                            "href":"20.1-initiate-collection-drafts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.2 </span> Initiate Collection - Collection Details",
                            "href":"20.2-initiate-collection-collection-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.3 </span> Initiate Collection – Goods and Shipment Details",
                            "href":"20.3-goods-and-shipment-details-tab.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.4 </span> Initiate Collection – Bank and Instructions",
                            "href":"20.4-initiate-collection-bank-and-instructions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.5 </span> Initiate Collection - Discount",
                            "href":"20.5-initiate-collection-discount.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.6 </span> Initiate Collection – Forex Deals",
                            "href":"20.6-initiate-collection-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.7 </span> Initiate Collection - Charges and Taxes",
                            "href":"20.6-initiate-collection-charges-commission-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.8 </span> Initiate Collection - Attachments",
                            "href":"20.7-initiate-collection-attachments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.9 </span> Save as Template",
                            "href":"20.8-template.html"
                        },
                        {
                            "title":"<span class=\"secnum\">19.10 </span> Save as Draft",
                            "href":"20.9-initiate-collection-draft.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">20 </span> View Export Collection",
                    "href":"21-view-export-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">20.1 </span> View Export Collection - Search",
                            "href":"21.1-view-export-collection-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.2 </span> View Export Collection - View Collection Details",
                            "href":"21.2-view-export-collection-view-collection-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.3 </span> View Export Collection - Attached Documents",
                            "href":"21.3-view-export-collection-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.4 </span> Charges and Taxes",
                            "href":"21.4-view-export-collection-charges-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.5 </span> SWIFT Messages",
                            "href":"21.5-view-export-collection-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.6 </span> Advice",
                            "href":"21.6-view-export-collection-advices.html"
                        },
                        {
                            "title":"<span class=\"secnum\">20.7 </span> View Export Collection - Loans",
                            "href":"21.7-view-export-collection-loan.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">21 </span> Modify Collection",
                    "href":"22-modify-collection.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">21.1 </span> Modify Collection - Search",
                            "href":"22.1-modify-collection-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">21.2 </span> Modify Collection - Discount",
                            "href":"22.2-modify-collection-discount.html"
                        },
                        {
                            "title":"<span class=\"secnum\">21.3 </span> Modify Collection – Forex Deals",
                            "href":"22.3-modify-collection-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">21.4 </span> Initiate Collection - Charges and Taxes",
                            "href":"22.4-modify-collection-charges-commission-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">21.5 </span> Modify Collection - Attachments",
                            "href":"22.5-modify-collection-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">22 </span> View Inward Guarantee/Stand By LC",
                    "href":"23-view-inward-guarantee-stand-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">22.1 </span> View Inward Guarantee/Stand By LC - Search",
                            "href":"23.1-view-inward-guarantee-stand-lc-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.2 </span> View Inward Guarantee – View Guarantee Details",
                            "href":"23.2-view-inward-guarantee-inward-guarantee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.3 </span> View Inward Bank Guarantee - Amendments",
                            "href":"23.3-view-inward-guarantee-amendments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.4 </span> View Inward Guarantee - Attached Documents",
                            "href":"23.4-view-inward-guarantee-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.5 </span> Linkages",
                            "href":"23.5-view-inward-guarantee-linkages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.6 </span> Charges Commissions and Taxes",
                            "href":"23.6-view-inward-guarantee-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.7 </span> SWIFT Messages",
                            "href":"23.7-view-inward-guarantee-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">22.8 </span> Advice",
                            "href":"23.8-view-inward-guarantee-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">23 </span> Acceptance for Guarantee/Stand By LC Amendment/Cancellation",
                    "href":"24-acceptance-guarantee-stand-lc-amendment-cancellation.html"
                },
                {
                    "title":"<span class=\"secnum\">24 </span> Lodge Claims",
                    "href":"25-lodge-claims.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">24.1 </span> Lodge Claims - Search",
                            "href":"25.1-lodge-claim-search-claims.html"
                        },
                        {
                            "title":"<span class=\"secnum\">24.2 </span> Claims",
                            "href":"25.2-claims.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">25 </span> View Claims",
                    "href":"26-view-claims.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">25.1 </span> View Claims - Search",
                            "href":"26.1-view-claim-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">25.2 </span> Claims",
                            "href":"26.2-view-claim-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">25.3 </span> View Claim - Attached Documents",
                            "href":"26.3-view-claims-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">25.4 </span> Charges and Taxes",
                            "href":"26.4-view-claim-charges-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">25.5 </span> SWIFT Messages",
                            "href":"26.5-view-claim-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">25.6 </span> Advice",
                            "href":"26.8-view-claim-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">26 </span> Modify Claim",
                    "href":"27-modify-claim.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">26.1 </span> Modify Claim - Search",
                            "href":"27.1-modify-claim-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">26.2 </span> Modify Claim - Claim Response",
                            "href":"27.2-modify-claim-claim-response.html"
                        },
                        {
                            "title":"<span class=\"secnum\">26.3 </span> Modify Claim - Charges, Commissions and Taxes",
                            "href":"27.3-modify-claim-charges-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">26.4 </span> Modify Claim - Attachments",
                            "href":"27.4-modify-claim-attached-documents.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">27 </span> View Outward Guarantee/Stand By LC",
                    "href":"30-view-outward-guarantee-stand-lc.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">27.1 </span> View Outward Guarantee/Stand By LC - Search",
                            "href":"30.1-view-outward-guarantee-stand-lc-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.2 </span> View Outward Guarantee – View Guarantee Details",
                            "href":"30.2-view-outward-guarantee-view-guarantee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.3 </span> View Outward Bank Guarantee - Amendments",
                            "href":"30.3-view-outward-guarantee-amendments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.4 </span> View Outward Guarantee - Attached Documents",
                            "href":"30.4-view-outward-guarantee-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.5 </span> Linkages",
                            "href":"30.5-view-outward-guarantee-linkages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.6 </span> Charges Commissions and Taxes",
                            "href":"30.6-view-outward-guarantee-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.7 </span> SWIFT Messages",
                            "href":"30.7-view-outward-guarantee-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27.8 </span> Advice",
                            "href":"30.8-view-outward-guarantee-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">28 </span> Cancel Outward Guarantee/Stand By LC",
                    "href":"31-cancel-outward-guarantee.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">28.1 </span> Cancel Outward Guarantee/Stand By LC – Outward Guarantee Details",
                            "href":"31.1-cancel-outward-guarantee-outward-guarantee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">28.2 </span> Charges Commissions and Taxes",
                            "href":"31.2-cancel-outward-guarantee-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">28.3 </span> Cancel Outward Guarantee/Stand By LC - Attachments",
                            "href":"31.3-cancel-outward-guarantee-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">29 </span> Bank Guarantee/Stand By LC Settlement",
                    "href":"32-bank-guarantee-stand-lc-settlement.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">29.1 </span> Bank Guarantee Settlement/Stand By LC - Search",
                            "href":"32.1-bank-guarantee-settlement-stand-lc-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.2 </span> Bank Guarantee Settlement – Settlement Details",
                            "href":"32.2-bank-guarantee-settlement-settlement-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.3 </span> Bank Guarantee Settlement – Forex Deals",
                            "href":"32.3-bank-guarantee-settlement-forex-deals.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.4 </span> Bank Guarantee Settlement - Charges Commissions and Taxes",
                            "href":"32.4-bank-guarantee-settlement-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">29.5 </span> Bank Guarantee Settlement - Attachments",
                            "href":"32.5-bank-guarantee-settlement-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">30 </span> Initiate Shipping Guarantee",
                    "href":"33-initiate-shipping-guarantee.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">30.1 </span> Search LC Template",
                            "href":"33.1-search-shipping-guaranteetemplate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.2 </span> Search Shipping Guarantee - Drafts",
                            "href":"33.2-search-shipping-guarantee-drafts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.3 </span> Initiate Shipping Guarantee - Shipping Guarantee Details",
                            "href":"33.3-initiate-shipping-guarantee-shipping-guarantee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.4 </span> Initiate Shipping Guarantee – Goods and Shipment Details",
                            "href":"33.4-initiate-shipping-guarantee-goods-and-shipment-details-tab.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.5 </span> Linkages",
                            "href":"33.5-initiate-shipping-guarantee-linkages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.6 </span> Initiate Shipping Guarantee – Charges Commissions and Taxes",
                            "href":"33.6-initiate-shipping-guarantee-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30.7 </span> Initiate Shipping Guarantee - Instructions and Attachments",
                            "href":"33.7-initiate-shipping-guarantee-instructions-and-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">31 </span> View Shipping Guarantee",
                    "href":"34-view-shipping-guarantee.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">31.1 </span> View Shipping Guarantee - Search",
                            "href":"34.1-view-shipping-guarantee-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">31.2 </span> View Shipping Guarantee – Shipping Guarantee Details",
                            "href":"34.2-view-shipping-guarantee-shipping-guarantee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">31.3 </span> View Shipping Guarantee - Attached Documents",
                            "href":"34.3-view-shipping-guarantee-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">31.4 </span> View Shipping Guarantee - Charges Commissions and Taxes",
                            "href":"34.4-view-shipping-guarantee-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">31.5 </span> Linkages",
                            "href":"34.5-view-shipping-guarantee-linkages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">31.6 </span> Advice",
                            "href":"34.6-view-view-shipping-guarantee-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">32 </span> Other Party Maintenance",
                    "href":"35-other-party-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">32.1 </span> Other Party Maintenance - View",
                            "href":"35.1-other-party-maintenance-view-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">32.2 </span> Other Party Maintenance - Create",
                            "href":"35.2-other-party-maintenance-create.html"
                        },
                        {
                            "title":"<span class=\"secnum\">32.3 </span> Edit Other Party Maintenance",
                            "href":"35.3-edit-other-party-maintenance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">32.4 </span> Other Party Maintenance - Delete",
                            "href":"35.4-other-party-maintenance-delete.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">33 </span> Additional Condition Maintenance",
                    "href":"36-additional-condition-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">33.1 </span> Additional Condition Maintenance - Create",
                            "href":"36.1-additional-condition-maintenance-create.html"
                        },
                        {
                            "title":"<span class=\"secnum\">33.2 </span> Additional Conditions Maintenance - View",
                            "href":"36.2-additional-condition-maintenance-view-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">33.3 </span> Additional Conditions Maintenance - Edit",
                            "href":"36.3-additional-condition-maintenance-edit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">33.4 </span> Additional Conditions Maintenance - Delete",
                            "href":"36.4-additional-condition-maintenance-delete.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">34 </span> Clause Maintenance",
                    "href":"37-clause-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">34.1 </span> Clause Maintenance - Create",
                            "href":"37.1-clause-maintenance-create.html"
                        },
                        {
                            "title":"<span class=\"secnum\">34.2 </span> Clause Maintenance - View",
                            "href":"37.2-clause-maintenance-view-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">34.3 </span> Clause Maintenance - Edit",
                            "href":"37.3-clause-maintenance-edit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">34.4 </span> Clause Maintenance - Delete",
                            "href":"37.4-clause-maintenance-delete.html"
                        },
                        {
                            "title":"<span class=\"secnum\">34.5 </span> Clause Maintenance - Duplicate",
                            "href":"37.5-clause-maintenance-duplicate.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">35 </span> Trade Finance Application Tracker",
                    "href":"38-application-tracker.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">35.1 </span> Pending Clarification",
                            "href":"38.1pending-clarification.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">36 </span> Assign Proceeds",
                    "href":"39-assign-proceeds.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">36.1 </span> Assign Proceeds - Search",
                            "href":"39.1-assign-proceeds-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">36.2 </span> Assign Proceeds - Assignee Details",
                            "href":"39.2-assign-proceeds-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">36.3 </span> Assign Proceeds - Assignee Details",
                            "href":"39.3-assign-proceeds-add-assignee-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">36.4 </span> Assign Proceeds - Assignee Details - Modify",
                            "href":"39.3-assign-proceeds-modify-assignee-details.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">37 </span> Assignee Maintenance",
                    "href":"40-assignee-maintenance.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">37.1 </span> Assignee Maintenance - Create",
                            "href":"40.1-assignee-maintenance-create.html"
                        },
                        {
                            "title":"<span class=\"secnum\">37.2 </span> Assignee Maintenance - Assignee Details",
                            "href":"40.2-assignee-maintenance-view-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">37.3 </span> Edit Assignee",
                            "href":"40.3-assignee-maintenance-edit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">37.4 </span> Assignee Details - Delete",
                            "href":"40.4-assignee-maintenance-delete.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">38 </span> Transfer Letter of Credit",
                    "href":"41-transfer-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">38.1 </span> Transfer Letter of Credit - Search",
                            "href":"41.1-transfer-letter-credit-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">38.2 </span> Transfer Letter of Credit - Add Second Beneficiary Details",
                            "href":"41.2-transfer-letter-credit-add-second-beneficiary-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">38.3 </span> Transfer Letter of Credit - Goods, Shipment & LC Details",
                            "href":"41.3-transfer-letter-credit-goods-shipment-lc-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">38.4 </span> Transfer Letter of Credit - Documents and Conditions",
                            "href":"41.4-transfer-letter-credit-documents-and-conditions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">38.5 </span> Transfer Letter of Credit - Instructions",
                            "href":"41.5-transfer-letter-credit-instructions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">38.6 </span> Transfer Letter of Credit - Charges Commissions and Taxes",
                            "href":"41.6-transfer-letter-credit-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">38.7 </span> Transfer Letter of Credit - Attachments",
                            "href":"41.7-transfer-letter-credit-attachments.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">39 </span> Amend Transfer Letter of Credit",
                    "href":"42-amend-transfer-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">39.1 </span> Amend Transfer Letter of Credit - Search",
                            "href":"42.1-amend-transfer-letter-credit-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">39.2 </span> Amend Transfer Letter of Credit - LC Details",
                            "href":"42.2-amend-letter-credit-lc-details.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">40 </span> View Transfer Letter of Credit",
                    "href":"43-view-transfer-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">40.1 </span> View Transfer Letter of Credit - Search",
                            "href":"43.1-view-transfer-letter-credit-search.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.2 </span> View Transfer Letter of Credit - LC Details",
                            "href":"43.2-viewtransfer-letter-credit-lc-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.3 </span> View Transfer Letter of Credit - Attached Documents",
                            "href":"43.3-view-transfer-letter-credit-attached-documents.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.4 </span> View Transfer Letter of Credit - Amendments",
                            "href":"43.4-view-transfer-letter-credit-amendments.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.5 </span> View Transfer Letter of Credit - Bills",
                            "href":"43.5-view-transfer-letter-credit-bills.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.6 </span> View Transfer Letter of Credit - Charges Commissions and Taxes",
                            "href":"43.6-view-transfer-letter-credit-charges-commissions-and-taxes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.7 </span> SWIFT Messages",
                            "href":"43.7-view-transfer-letter-credit-swift-messages.html"
                        },
                        {
                            "title":"<span class=\"secnum\">40.8 </span> Advice",
                            "href":"43.8-view-transfer-letter-credit-advices.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">41 </span> Cancel Transfer Letter of Credit",
                    "href":"44-cancel-transfer-letter-credit.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">41.1 </span> Cancel Transfer Letter of Credit - LC Details",
                            "href":"44.1-cancel-transfer-letter-credit-lc-details.html"
                        },
                        {
                            "title":"<span class=\"secnum\">41.2 </span> Cancel Transfer Letter of Credit - Charges Commissions and Taxes",
                            "href":"44.2-cancel-transfer-letter-credit-charges-commissions-and-taxes-1.html"
                        },
                        {
                            "title":"<span class=\"secnum\">41.3 </span> Cancel Transfer Letter of Credit - Attachments",
                            "href":"44.3-cancel-transfer-letter-credit-attachments.html"
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});