/* If you want to see this plug-in in action, you can save,
 * build and run the plug-in code in this file.
 */

/*
 * MESSAGING SERVER - Sample Plugin DLL
 * Author     : Sean Maurik
 * 4.0 Update : Sam Robertson
 *
 * Purpose    : This plugin creates a log file; writes the
 *		first recipient of the first message passed into
 *		the plug-in, and then writes the control data obtained
 *		during the accept connection.  The plug-in goes on to
 *		add a recipient to the recipient list and some
 *		text to the bottom of the message.
*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#include "msg4plugins.h"

#ifdef WIN32
#define SAMPLE_EXPORT __declspec(dllexport)
#else
#define SAMPLE_EXPORT
#endif

SAMPLE_EXPORT int SamplePluginInit(pblock *Config)
{
    /* We don't have any global data or initialization
     * to do for this sample, so this init function
     * just returns that it has completed.
     */
    return 1;
}

SAMPLE_EXPORT int SamplePlugin(pblock *Config,
                               Message **ppInMsg,
                               Message ***pppOutMsg)
{
    char *bodyfile;
    Recipient *pRecip;
    Recipient new_rcpt;
    FILE *f;
    FILE *body;
    char *ControlText;

    /* create a log file */
    f = fopen("log.out","w");

    /* print the first recipient */
    pRecip = GetFirstRecipient (ppInMsg[0]);
    if (pRecip) {
	fprintf(f,"Recip #1 is %s\n",GetRecipientAddress(pRecip));
    }

    /* print out the control data to the log */
    ControlText = GetControlData(ppInMsg[0]);
    if (ControlText) {
	fprintf(f, "Control Data follows\n%s", ControlText);
    }

    /* free control data returned by GetControlData */
    FreeControlData(ControlText);

    /* now add a new recipient */
    new_rcpt.Addr821 = (char*) malloc(strlen("<testuser@test.com>") + 1);
    strcpy(new_rcpt.Addr821, "<testuser@test.com>");
    new_rcpt.Ext     = NULL;
    new_rcpt.flags   = 0;

    /* this is the tricky part - you must have this magic value set */
    new_rcpt.magic = 0xdeadbeef;

    /* finally make the call */
    AddRecipient(ppInMsg[0],&new_rcpt);
    free(new_rcpt.Addr821);

    /* get body filename and path */
    bodyfile = GetMessageFile(*ppInMsg);
    fprintf(f,"GetMessageFile = %s\n",bodyfile);

    /* now open the message file and add some text */
    body = fopen(bodyfile,"a");
    if (body == NULL) {
	fprintf(f,"Couldn't append to body\n");
    } else {
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fprintf(body,"This is a new body line\n");
	fclose(body);
    }

    /* now return and the message will continue */
    return MSG_CONTINUE;
}