/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;

public class ContainerExplorer
implements Closeable {
    private static final String PREFIX_EXCLUDE = "exc:";
    private static final String PREFIX_GLOB = "glob:";
    private static final String PREFIX_REGEX = "regex:";
    private static final ConcurrentHashMap<Path, AtomicInteger> CONTAINER_USAGE_MAP = new ConcurrentHashMap();
    private final ContainerExplorerData data;

    public static ContainerExplorer create(URI containerURI) throws IOException {
        return containerURI != null ? ContainerExplorer.create(Paths.get(containerURI)) : null;
    }

    public static ContainerExplorer create(String containerName) throws IOException {
        return containerName != null && !containerName.isEmpty() ? ContainerExplorer.create(Paths.get(containerName, new String[0])) : null;
    }

    public static ContainerExplorer create(Path container) throws IOException {
        ContainerExplorerData data = ContainerExplorer.createContainerExplorerData(container);
        return data != null ? new ContainerExplorer(data) : null;
    }

    public static Path findFile(ContainerExplorer containerExplorer, Collection<? extends String> patterns) throws IOException {
        try {
            List<Path> files = ContainerExplorer.findFiles(containerExplorer, patterns, false, null);
            if (files.size() == 1) {
                return files.get(0);
            }
            assert (files.isEmpty());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public static List<Path> findFiles(ContainerExplorer containerExplorer, Collection<? extends String> patterns) throws IOException {
        try {
            return ContainerExplorer.findFiles(containerExplorer, patterns, true, null);
        }
        catch (InterruptedException e) {
            return new ArrayList<Path>(0);
        }
    }

    protected static List<Path> findFiles(ContainerExplorer containerExplorer, Collection<? extends String> patterns, boolean findAll, Object monitor) throws IOException, InterruptedException {
        FindResult findResult;
        List<PreparedPattern> list;
        if (!(containerExplorer == null || containerExplorer.isClosed() || patterns == null || patterns.isEmpty() || (list = containerExplorer.preparePatterns(patterns)).isEmpty() || (findResult = containerExplorer.findFiles(list, findAll, monitor)) == null || findResult.getPathPreparedPatternMap().isEmpty())) {
            return new ArrayList<Path>(findResult.getPathPreparedPatternMap().keySet());
        }
        return new ArrayList<Path>(0);
    }

    public static List<Path> findAndCopyFiles(ContainerExplorer containerExplorer, Collection<? extends String> patterns, Path targetDirectory, CopyOption option, boolean usePatternPath) throws IOException {
        try {
            return ContainerExplorer.findAndCopyFiles(containerExplorer, patterns, targetDirectory, option, usePatternPath, null);
        }
        catch (InterruptedException e) {
            return new ArrayList<Path>(0);
        }
    }

    protected static List<Path> findAndCopyFiles(ContainerExplorer containerExplorer, Collection<? extends String> patterns, Path targetDirectory, CopyOption option, boolean usePatternPath, Object monitor) throws IOException, InterruptedException {
        if (containerExplorer != null && !containerExplorer.isClosed() && patterns != null && !patterns.isEmpty()) {
            FindResult findResult;
            containerExplorer.monitorBeginTask(monitor, 3);
            List<PreparedPattern> list = containerExplorer.preparePatterns(patterns);
            if (!list.isEmpty() && (findResult = containerExplorer.findFiles(list, true, containerExplorer.monitorCreateSubMonitor(monitor, 1))) != null && !findResult.getPathPreparedPatternMap().isEmpty()) {
                List<Path> copies = null;
                if (usePatternPath) {
                    List<ExplorerPair<String>> pathElements = containerExplorer.toPatternPathMap(findResult);
                    if (!pathElements.isEmpty()) {
                        copies = containerExplorer.copyToDirectory(pathElements, targetDirectory, option, containerExplorer.monitorCreateSubMonitor(monitor, 2));
                    }
                } else {
                    copies = containerExplorer.copyToDirectory(findResult.getPathPreparedPatternMap().keySet(), targetDirectory, option, containerExplorer.monitorCreateSubMonitor(monitor, 2));
                }
                if (copies != null) {
                    containerExplorer.monitorDone(monitor);
                    return copies;
                }
            }
            containerExplorer.monitorDone(monitor);
        }
        return new ArrayList<Path>(0);
    }

    protected static ContainerExplorerData createContainerExplorerData(Path container) throws IOException {
        if (container != null) {
            AtomicInteger atomicInteger;
            AtomicInteger aux;
            URI uri;
            if (Files.isDirectory(container = container.toAbsolutePath(), new LinkOption[0])) {
                return new ContainerExplorerData(FileSystems.getDefault(), container, container);
            }
            try {
                uri = new URI("jar:" + container.toUri());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            FileSystem fileSystem = null;
            try {
                fileSystem = FileSystems.getFileSystem(uri);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (fileSystem == null || !fileSystem.isOpen()) {
                fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            if ((aux = CONTAINER_USAGE_MAP.putIfAbsent(container, atomicInteger = new AtomicInteger())) != null) {
                atomicInteger = aux;
            }
            atomicInteger.incrementAndGet();
            return new ContainerExplorerData(fileSystem, container, fileSystem.getPath("/", new String[0]));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(ContainerExplorer containerExplorer) throws IOException {
        AtomicInteger atomicInteger;
        Path container;
        FileSystem fileSystem;
        ContainerExplorerData containerExplorerData = containerExplorer.data;
        synchronized (containerExplorerData) {
            fileSystem = containerExplorer.getFileSystem();
            container = containerExplorer.getContainer();
            containerExplorer.data.dispose();
        }
        if (fileSystem != null && container != null && (atomicInteger = CONTAINER_USAGE_MAP.get(container)) != null && atomicInteger.decrementAndGet() <= 0) {
            CONTAINER_USAGE_MAP.remove(container);
            try {
                fileSystem.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected ContainerExplorer(ContainerExplorerData data) {
        this.data = Objects.requireNonNull(data, "data cannot be null");
    }

    public final boolean isClosed() {
        FileSystem fileSystem = this.getFileSystem();
        return fileSystem == null || !fileSystem.isOpen();
    }

    @Override
    public final void close() throws IOException {
        ContainerExplorer.close(this);
    }

    public final Path getContainer() {
        return this.data.getContainer();
    }

    public final boolean isContainerPath(Path path) {
        return this.startsWith(path, this.getContainer());
    }

    public final Path getRoot() {
        return this.data.getRoot();
    }

    public final boolean isRootPath(Path path) {
        return this.startsWith(path, this.getRoot());
    }

    private boolean startsWith(Path path, Path prefix) {
        try {
            return path != null && path.startsWith(prefix);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final FileSystem getFileSystem() {
        return this.data.getFileSystem();
    }

    public final String toPattern(Path path) {
        if (!this.isClosed() && this.isRootPath(path)) {
            if (path.equals(this.getRoot())) {
                return "**";
            }
            String separator = this.getFileSystem().getSeparator();
            String pattern = this.getRoot().relativize(path).toString();
            if (pattern.startsWith(separator) && pattern.length() > separator.length()) {
                pattern = pattern.substring(separator.length());
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (!pattern.endsWith(this.getFileSystem().getSeparator())) {
                    pattern = pattern + separator;
                }
                pattern = pattern + "**";
            }
            return pattern.replace('\\', '/');
        }
        return null;
    }

    public final List<PreparedPattern> preparePatterns(Collection<? extends String> patterns) {
        if (!this.isClosed() && patterns != null && !patterns.isEmpty()) {
            patterns = new ArrayList<String>(patterns);
            LinkedHashMap<String, PreparedPattern> map = new LinkedHashMap<String, PreparedPattern>();
            for (String string : new LinkedHashSet<String>(patterns)) {
                PreparedPattern preparedPattern = (PreparedPattern)map.get(string);
                if (preparedPattern != null || (preparedPattern = this.preparePattern(string)) == null) continue;
                map.put(string, preparedPattern);
            }
            if (!map.isEmpty() && !this.isClosed()) {
                return new ArrayList<PreparedPattern>(map.values());
            }
        }
        return new ArrayList<PreparedPattern>(0);
    }

    public final PreparedPattern preparePattern(String pattern) {
        if (!this.isClosed() && pattern != null && !pattern.isEmpty()) {
            boolean exclusionPattern;
            String syntaxAndPattern = pattern;
            boolean bl = exclusionPattern = syntaxAndPattern.length() > PREFIX_EXCLUDE.length() && syntaxAndPattern.startsWith(PREFIX_EXCLUDE);
            if (exclusionPattern) {
                syntaxAndPattern = syntaxAndPattern.substring(PREFIX_EXCLUDE.length());
            }
            if (syntaxAndPattern.length() > 0) {
                String separator = this.getFileSystem().getSeparator();
                if (syntaxAndPattern.startsWith(PREFIX_REGEX)) {
                    if (syntaxAndPattern.length() > PREFIX_REGEX.length()) {
                        String regex = syntaxAndPattern.substring(PREFIX_REGEX.length());
                        if (regex.charAt(0) == '/' || regex.startsWith("\\\\")) {
                            syntaxAndPattern = null;
                        } else {
                            String root = this.getRoot().toString();
                            if (!root.endsWith(separator)) {
                                root = root + separator;
                            }
                            if (separator.indexOf(92) >= 0) {
                                root = root.replaceAll("\\\\", "\\\\\\\\");
                                regex = regex.replace("/", "\\\\");
                            } else {
                                regex = regex.replace("\\\\", "/");
                            }
                            if (!regex.startsWith(root)) {
                                StringBuilder sb = new StringBuilder(PREFIX_REGEX).append(root).append(regex);
                                syntaxAndPattern = sb.toString();
                            }
                        }
                    } else {
                        syntaxAndPattern = null;
                    }
                } else {
                    String glob = null;
                    if (syntaxAndPattern.startsWith(PREFIX_GLOB)) {
                        if (syntaxAndPattern.length() > PREFIX_GLOB.length()) {
                            glob = syntaxAndPattern.substring(PREFIX_GLOB.length());
                        } else {
                            syntaxAndPattern = null;
                        }
                    } else {
                        glob = syntaxAndPattern;
                    }
                    if (syntaxAndPattern != null && glob != null) {
                        char c0 = glob.charAt(0);
                        if (c0 == '/' || c0 == '\\') {
                            syntaxAndPattern = null;
                        } else {
                            String root = this.getRoot().toString();
                            if (!glob.startsWith(root)) {
                                StringBuilder sb = new StringBuilder(PREFIX_GLOB).append(root);
                                if (!root.endsWith(separator)) {
                                    sb.append(separator);
                                }
                                sb.append(glob);
                                syntaxAndPattern = sb.toString().replace('\\', '/');
                            } else {
                                syntaxAndPattern = syntaxAndPattern.replace('\\', '/');
                            }
                        }
                    }
                }
                if (syntaxAndPattern != null) {
                    try {
                        PathMatcher pathMatcher = this.getFileSystem().getPathMatcher(syntaxAndPattern);
                        return new PreparedPattern(pattern, pathMatcher, !exclusionPattern);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    public final boolean wouldFind(Path path, Collection<? extends PreparedPattern> preparedPatterns, boolean findDirectory) {
        if (this.isClosed() || path == null || path.getFileSystem() != this.getFileSystem()) {
            return false;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            return findDirectory;
        }
        return this.wouldFindFile(null, path, preparedPatterns);
    }

    protected final boolean wouldFindFile(FindResult findResult, Path path, Collection<? extends PreparedPattern> preparedPatterns) {
        assert (path != null);
        assert (path.getFileSystem() == this.getFileSystem()) : path;
        preparedPatterns = new ArrayList<PreparedPattern>(preparedPatterns);
        for (PreparedPattern preparedPattern : preparedPatterns) {
            if (preparedPattern == null || preparedPattern.getPathMatcher() == null || !preparedPattern.getPathMatcher().matches(path)) continue;
            boolean inclusionPattern = preparedPattern.isInclusionPattern();
            if (findResult != null) {
                findResult.getNotMatchedPatterns().remove(preparedPattern.getPattern());
                if (inclusionPattern) {
                    findResult.getPathPreparedPatternMap().put(path.toAbsolutePath(), preparedPattern);
                }
            }
            return inclusionPattern;
        }
        return false;
    }

    public final FindResult findFile(Collection<? extends PreparedPattern> preparedPatterns) throws IOException {
        try {
            FindResult findResult = this.findFiles(preparedPatterns, false, null);
            if (findResult != null && findResult.getPathPreparedPatternMap().size() == 1) {
                return findResult;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public final FindResult findFiles(Collection<? extends PreparedPattern> preparedPatterns) throws IOException {
        try {
            return this.findFiles(preparedPatterns, true, null);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    protected final FindResult findFiles(Collection<? extends PreparedPattern> preparedPatterns, boolean findAll, Object monitor) throws IOException, InterruptedException {
        if (!this.isClosed() && preparedPatterns != null && !preparedPatterns.isEmpty()) {
            preparedPatterns = new ArrayList<PreparedPattern>(preparedPatterns);
            this.monitorBeginUnknownSizeTask(monitor);
            FindResult findResult = new FindResult();
            Iterator<? extends PreparedPattern> i = preparedPatterns.iterator();
            while (i.hasNext()) {
                PreparedPattern preparedPattern = i.next();
                if (preparedPattern == null || preparedPattern.getPathMatcher() == null) {
                    i.remove();
                    continue;
                }
                findResult.getNotMatchedPatterns().add(preparedPattern.getPattern());
            }
            if (!preparedPatterns.isEmpty()) {
                try {
                    Finder finder = new Finder(this, findResult, preparedPatterns, findAll, monitor);
                    Files.walkFileTree(this.getRoot(), finder);
                    finder.dispose();
                    this.monitorDone(monitor);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof InterruptedException) {
                        throw (InterruptedException)e.getCause();
                    }
                    throw e;
                }
                if (!findResult.isEmpty()) {
                    return findResult;
                }
            }
        }
        return null;
    }

    public final List<ExplorerPair<String>> toPatternPathMap(FindResult findResult) {
        LinkedHashMap<Path, PreparedPattern> map;
        if (findResult != null && findResult.getPathPreparedPatternMap() != null && !(map = new LinkedHashMap<Path, PreparedPattern>(findResult.getPathPreparedPatternMap())).isEmpty()) {
            ArrayList<ExplorerPair<String>> list = new ArrayList<ExplorerPair<String>>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String patternPath = this.toPatternPath((PreparedPattern)entry.getValue(), (Path)entry.getKey());
                if (patternPath == null) continue;
                list.add(new ExplorerPair<String>((Path)entry.getKey(), patternPath));
            }
            return list;
        }
        return new ArrayList<ExplorerPair<String>>(0);
    }

    public final String toPatternPath(PreparedPattern preparedPattern, Path path) {
        if (preparedPattern != null && preparedPattern.getPathMatcher() != null && preparedPattern.isInclusionPattern() && this.isRootPath(path) && !this.getRoot().equals(path) && preparedPattern.getPathMatcher().matches(path)) {
            String fileName = path.getFileName().toString();
            Path parent = path.getParent();
            if (parent != null) {
                Path grandParent = parent.getParent();
                while (grandParent != null && preparedPattern.getPathMatcher().matches(grandParent.resolve(fileName))) {
                    parent = grandParent;
                    grandParent = parent.getParent();
                }
                Path relativePath = parent.relativize(path);
                if (relativePath != null && relativePath.getNameCount() > 0) {
                    return relativePath.toString().replace('\\', '/');
                }
            }
        }
        return null;
    }

    public final List<Path> copyToDirectory(List<ExplorerPair<String>> pairs, Path targetDirectory, CopyOption option) throws IOException {
        try {
            return this.copyToDirectory(pairs, targetDirectory, option, (Object)null);
        }
        catch (InterruptedException e) {
            return new ArrayList<Path>(0);
        }
    }

    protected final List<Path> copyToDirectory(List<ExplorerPair<String>> pairs, Path targetDirectory, CopyOption option, Object monitor) throws IOException, InterruptedException {
        if (!this.isClosed() && pairs != null && !pairs.isEmpty() && targetDirectory != null) {
            java.nio.file.CopyOption[] copyOptionArray;
            ArrayList<ExplorerPair<String>> list = new ArrayList<ExplorerPair<String>>(pairs);
            this.monitorBeginTask(monitor, list.size());
            if (option == null) {
                option = CopyOption.ABORT;
            }
            if (option == CopyOption.REPLACE) {
                StandardCopyOption[] standardCopyOptionArray = new StandardCopyOption[2];
                standardCopyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                copyOptionArray = standardCopyOptionArray;
                standardCopyOptionArray[1] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                java.nio.file.CopyOption[] copyOptionArray2 = new StandardCopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            }
            java.nio.file.CopyOption[] copyOptions = copyOptionArray;
            targetDirectory = targetDirectory.toAbsolutePath();
            ArrayList<Path> copiedPaths = new ArrayList<Path>(list.size());
            for (ExplorerPair explorerPair : list) {
                this.monitorCheckCanceled(monitor);
                if (explorerPair.getElement() != null) {
                    Path target = targetDirectory.resolve((String)explorerPair.getElement());
                    if (option != CopyOption.SKIP || !Files.exists(target, new LinkOption[0])) {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        copiedPaths.add(Files.copy(explorerPair.getPath(), target, copyOptions));
                    }
                }
                this.monitorWorked(monitor, 1);
            }
            this.monitorDone(monitor);
            if (!copiedPaths.isEmpty()) {
                return copiedPaths;
            }
        }
        return new ArrayList<Path>(0);
    }

    public final List<Path> copyToDirectory(Collection<? extends Path> paths, Path targetDirectory, CopyOption option) throws IOException {
        try {
            return this.copyToDirectory(paths, targetDirectory, option, null);
        }
        catch (InterruptedException e) {
            return new ArrayList<Path>(0);
        }
    }

    protected final List<Path> copyToDirectory(Collection<? extends Path> paths, Path targetDirectory, CopyOption option, Object monitor) throws IOException, InterruptedException {
        if (!this.isClosed() && paths != null && !paths.isEmpty() && targetDirectory != null) {
            java.nio.file.CopyOption[] copyOptionArray;
            paths = new ArrayList<Path>(paths);
            this.monitorBeginTask(monitor, paths.size());
            if (option == null) {
                option = CopyOption.ABORT;
            }
            if (option == CopyOption.REPLACE) {
                StandardCopyOption[] standardCopyOptionArray = new StandardCopyOption[2];
                standardCopyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                copyOptionArray = standardCopyOptionArray;
                standardCopyOptionArray[1] = StandardCopyOption.COPY_ATTRIBUTES;
            } else {
                java.nio.file.CopyOption[] copyOptionArray2 = new StandardCopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.COPY_ATTRIBUTES;
            }
            java.nio.file.CopyOption[] copyOptions = copyOptionArray;
            targetDirectory = targetDirectory.toAbsolutePath();
            ArrayList<Path> copiedPaths = new ArrayList<Path>(paths.size());
            for (Path path : paths) {
                this.monitorCheckCanceled(monitor);
                if (this.isRootPath(path)) {
                    Path path2 = path.toAbsolutePath();
                    Path target = targetDirectory.resolve(this.getRoot().relativize(path2).toString());
                    if (option != CopyOption.SKIP || !Files.exists(target, new LinkOption[0])) {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        copiedPaths.add(Files.copy(path2, target, copyOptions));
                    }
                }
                this.monitorWorked(monitor, 1);
            }
            this.monitorDone(monitor);
            if (!copiedPaths.isEmpty()) {
                return copiedPaths;
            }
        }
        return new ArrayList<Path>(0);
    }

    protected void monitorBeginTask(Object monitor, int totalWork) {
    }

    protected void monitorBeginUnknownSizeTask(Object monitor) {
    }

    protected void monitorWorked(Object monitor, int work) {
    }

    protected void monitorCheckCanceled(Object monitor) throws InterruptedException {
    }

    protected Object monitorCreateSubMonitor(Object monitor, int work) throws InterruptedException {
        return null;
    }

    protected void monitorDone(Object monitor) {
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [data=");
        builder.append(this.data);
        builder.append(", closed=");
        builder.append(this.isClosed());
        builder.append("]");
        return builder.toString();
    }

    private static class Finder
    extends SimpleFileVisitor<Path>
    implements IDisposable {
        private ContainerExplorer containerExplorer;
        private FindResult findResult;
        private Collection<? extends PreparedPattern> preparedPatterns;
        private Object monitor;
        private boolean findAll;

        public Finder(ContainerExplorer containerExplorer, FindResult findResult, Collection<? extends PreparedPattern> preparedPatterns, boolean findAll, Object monitor) {
            assert (containerExplorer != null && !containerExplorer.isClosed());
            assert (findResult != null);
            assert (preparedPatterns != null);
            assert (!preparedPatterns.isEmpty());
            this.containerExplorer = containerExplorer;
            this.findResult = findResult;
            this.preparedPatterns = preparedPatterns;
            this.findAll = findAll;
            this.monitor = monitor;
        }

        @Override
        public void dispose() {
            this.containerExplorer = null;
            this.findResult = null;
            this.preparedPatterns = null;
            this.monitor = null;
        }

        private FileVisitResult fileVisitResult() {
            return this.findAll || this.findResult.getPathPreparedPatternMap().isEmpty() ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return this.fileVisitResult();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            try {
                this.containerExplorer.monitorCheckCanceled(this.monitor);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.containerExplorer.wouldFindFile(this.findResult, file, this.preparedPatterns);
            this.containerExplorer.monitorWorked(this.monitor, 1);
            return this.fileVisitResult();
        }
    }

    public static final class ExplorerPair<T> {
        private final Path path;
        private final T element;

        public ExplorerPair(Path path, T target) {
            this.path = Objects.requireNonNull(path, "path cannot be null");
            this.element = Objects.requireNonNull(target, "target cannot be null");
        }

        public Path getPath() {
            return this.path;
        }

        public T getElement() {
            return this.element;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ExplorerPair other = (ExplorerPair)obj;
            return Objects.equals(this.path, other.path) && Objects.deepEquals(this.element, other.element);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PathElement [path=");
            builder.append(this.path);
            builder.append(", element=");
            builder.append(this.element);
            builder.append("]");
            return builder.toString();
        }
    }

    public static final class FindResult {
        private Map<Path, PreparedPattern> pathPreparedPatternMap;
        private List<String> notMatchedPatterns;

        private FindResult() {
        }

        public Map<Path, PreparedPattern> getPathPreparedPatternMap() {
            return this.pathPreparedPatternMap == null ? (this.pathPreparedPatternMap = new LinkedHashMap<Path, PreparedPattern>()) : this.pathPreparedPatternMap;
        }

        public List<String> getNotMatchedPatterns() {
            return this.notMatchedPatterns == null ? (this.notMatchedPatterns = new LinkedList<String>()) : this.notMatchedPatterns;
        }

        boolean isEmpty() {
            return !(this.pathPreparedPatternMap != null && !this.pathPreparedPatternMap.isEmpty() || this.notMatchedPatterns != null && !this.notMatchedPatterns.isEmpty());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FindResult [paths=");
            builder.append(this.pathPreparedPatternMap);
            builder.append(", notMatchedPatterns=");
            builder.append(this.notMatchedPatterns);
            builder.append("]");
            return builder.toString();
        }
    }

    public static final class PreparedPattern
    implements IDisposable {
        private String pattern;
        private boolean inclusionPattern;
        private PathMatcher pathMatcher;

        private PreparedPattern(String pattern, PathMatcher pathMatcher, boolean inclusionPattern) {
            assert (pattern != null);
            assert (pathMatcher != null);
            this.pattern = pattern;
            this.inclusionPattern = inclusionPattern;
            this.pathMatcher = pathMatcher;
        }

        @Override
        public void dispose() {
            this.pathMatcher = null;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isInclusionPattern() {
            return this.inclusionPattern;
        }

        PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PreparedPattern [pattern=");
            builder.append(this.pattern);
            builder.append(", inclusionPattern=");
            builder.append(this.inclusionPattern);
            builder.append("]");
            return builder.toString();
        }
    }

    protected static final class ContainerExplorerData
    implements IDisposable {
        private FileSystem fileSystem;
        private Path container;
        private Path root;

        private ContainerExplorerData(FileSystem fileSystem, Path container, Path root) {
            assert (fileSystem != null);
            assert (fileSystem.isOpen());
            assert (container != null);
            assert (container.isAbsolute()) : container;
            assert (root != null);
            assert (root.isAbsolute()) : root;
            this.fileSystem = fileSystem;
            this.container = container;
            this.root = root;
        }

        @Override
        public void dispose() {
            this.fileSystem = null;
            this.container = null;
            this.root = null;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public Path getContainer() {
            return this.container;
        }

        public Path getRoot() {
            return this.root;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ContainerExplorerData [container=");
            builder.append(this.container);
            builder.append(", root=");
            builder.append(this.root);
            builder.append("]");
            return builder.toString();
        }
    }

    public static enum CopyOption {
        ABORT,
        SKIP,
        REPLACE;

    }
}

