/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.mobile.rt.v13.build.settings;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class FileUtils {
    public static boolean doesUrlResourceExist(String urlSpec) throws MalformedURLException, UnsupportedEncodingException {
        if (urlSpec == null || urlSpec.length() <= 0) {
            return false;
        }
        URL fileUrl = new URL(urlSpec);
        String decoded = URLDecoder.decode(fileUrl.getPath(), "UTF-8");
        boolean exists = new File(decoded).exists();
        return exists;
    }

    public static void closeStream(Closeable closeable, Logger logger) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                if (null != logger) {
                    logger.warning(MessageFormat.format("Failed to free a stream resource. Exception = {0}.", ioe.getMessage()));
                }
                ioe.printStackTrace();
            }
        }
    }
}

