/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.mobile.rt.v13.build.settings;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScanHelper {
    private static final String EMPTY_STR = "";
    private static final String _PERIOD_REGEX = "\\.";
    private static final String FORWARD_SLASH = "/";
    private static final String XLIFF_BUNDLE_TYPE = ".xlf";
    private static final String LOADBUNDLE_ELEMENT = "loadBundle";
    private static final String BASENAME = "basename";
    private static final String ID = "id";
    private static final String APPLICATION = "application";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLDocument getDocument(URL srcXmlUrl) {
        if (null == srcXmlUrl) {
            throw new IllegalArgumentException();
        }
        InputStream xmlInput = null;
        try {
            xmlInput = srcXmlUrl.openStream();
            DOMParser parser = new DOMParser();
            parser.parse(xmlInput);
            XMLDocument xMLDocument = parser.getDocument();
            return xMLDocument;
        }
        catch (IOException e) {
            e.printStackTrace();
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        catch (XMLParseException e) {
            e.printStackTrace();
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        catch (SAXException e) {
            e.printStackTrace();
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        finally {
            if (xmlInput != null) {
                try {
                    xmlInput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean hasPreferences(URL appFile, URL farsDir) {
        XMLDocument appDocument = ScanHelper.getDocument(appFile);
        XMLElement root = (XMLElement)appDocument.getDocumentElement();
        NodeList nodeList = root.getElementsByTagNameNS("adfmf", "preferences");
        return nodeList != null && nodeList.getLength() > 0;
    }

    public static XMLDocument getXmlDom(String filePath) throws Exception {
        File appXml = new File(filePath);
        if (!appXml.exists()) {
            throw new Exception("File does not exist: " + filePath);
        }
        URL appXmlUrl = appXml.toURI().toURL();
        return ScanHelper.getDocument(appXmlUrl);
    }

    private static String getXmlElementAttribute(Document xmlDocument, String xmlElementName, String xmlAttributeName) {
        String attributeValue = EMPTY_STR;
        try {
            Element rootElement = xmlDocument.getDocumentElement();
            if (xmlElementName.equals(rootElement.getLocalName())) {
                attributeValue = rootElement.getAttributeNS(null, xmlAttributeName);
            } else {
                NodeList childNodes = rootElement.getChildNodes();
                if (null != childNodes) {
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node child = childNodes.item(i);
                        if (!(child instanceof Element) || !xmlElementName.equals(child.getLocalName())) continue;
                        attributeValue = ((Element)child).getAttributeNS(null, xmlAttributeName);
                        break;
                    }
                }
            }
            if (null == attributeValue) {
                attributeValue = EMPTY_STR;
            }
            attributeValue = attributeValue.trim();
        }
        catch (Exception e) {
            attributeValue = EMPTY_STR;
        }
        return attributeValue;
    }

    public static String getApplicationLoadBundleBaseName(String appPath) {
        String applicationBaseName = null;
        try {
            applicationBaseName = ScanHelper.getXmlElementAttribute((Document)ScanHelper.getXmlDom(appPath), LOADBUNDLE_ELEMENT, BASENAME);
        }
        catch (Exception e) {
            applicationBaseName = EMPTY_STR;
        }
        return applicationBaseName;
    }

    public static String getApplicationId(String appPath) {
        String applicationBaseName = null;
        try {
            applicationBaseName = ScanHelper.getXmlElementAttribute((Document)ScanHelper.getXmlDom(appPath), APPLICATION, ID);
        }
        catch (Exception e) {
            applicationBaseName = EMPTY_STR;
        }
        return applicationBaseName;
    }

    public static String getFeatureLoadBundleBaseName(URL farUrl) throws Exception {
        File featureXmlFile = new File(new File(farUrl.toURI()), "META-INF/maf-feature.xml");
        if (!featureXmlFile.exists()) {
            throw new Exception("Feature XML file does not exist: " + featureXmlFile);
        }
        XMLDocument doc = ScanHelper.getXmlDom(featureXmlFile.getAbsolutePath());
        return ScanHelper.getXmlElementAttribute((Document)doc, LOADBUNDLE_ELEMENT, BASENAME);
    }

    public static Map<String, String> getLanguageTokenMapFromFeatureFar(URL farDirectoryUrl) throws Exception {
        String loadBundleBaseName = null;
        loadBundleBaseName = ScanHelper.getFeatureLoadBundleBaseName(farDirectoryUrl);
        if (loadBundleBaseName == null || loadBundleBaseName.length() <= 0) {
            return new HashMap<String, String>();
        }
        String xliffFileRelativePath = ScanHelper._convertLoadBundleBaseNameToXliffRelativePath(loadBundleBaseName);
        URL coreXliffFileUrl = new File(new File(farDirectoryUrl.toURI()), xliffFileRelativePath).toURI().toURL();
        return ScanHelper._getLanguageTokenMap(coreXliffFileUrl);
    }

    private static String _convertLoadBundleBaseNameToXliffRelativePath(String loadBundleBaseName) {
        String loadBundleBaseNameAsPath = loadBundleBaseName.replaceAll(_PERIOD_REGEX, FORWARD_SLASH);
        return loadBundleBaseNameAsPath + XLIFF_BUNDLE_TYPE;
    }

    private static Map<String, String> _getLanguageTokenMap(URL coreXliffFileUrl) throws Exception {
        HashMap<String, String> localeTokenMap = new HashMap<String, String>();
        return localeTokenMap;
    }

    public static interface URLFilenameFilter {
        public boolean accept(URL var1, String var2);
    }
}

