/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.fdom;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.TypedAttributes;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetReader2;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FDOMInfosetReader
implements InfosetReader2 {
    public Node currentNode;
    public Node originalNode;
    boolean first = true;
    int event = -1;
    int elemCount = 0;
    boolean isDoc = true;
    SAXAttrList attList = new SAXAttrList(100);
    boolean firstC = false;
    boolean nSibling = false;
    int reportEndElement = 0;
    boolean getNext = true;

    public FDOMInfosetReader(Node node) {
        this.currentNode = node;
        this.originalNode = node;
        if (this.currentNode.getNodeType() != 9) {
            this.isDoc = false;
            this.first = false;
        }
        this.event = this.getEvent();
    }

    @Override
    public void close() {
    }

    private int getEvent() {
        if (this.currentNode == null && this.isDoc) {
            return 8;
        }
        if (this.currentNode == null) {
            return this.event;
        }
        short s = this.currentNode.getNodeType();
        switch (s) {
            case 2: {
                return 10;
            }
            case 4: {
                return 12;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 7;
            }
            case 1: {
                ++this.elemCount;
                return 1;
            }
            case 6: {
                return 14;
            }
            case 5: {
                return 9;
            }
            case 7: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 10: {
                return 11;
            }
        }
        return 0;
    }

    @Override
    public void next() {
        if (this.first) {
            this.first = false;
            return;
        }
        if (this.reportEndElement > 0) {
            --this.reportEndElement;
            --this.elemCount;
            this.event = 2;
            this.getNext = false;
            return;
        }
        if (this.currentNode == null) {
            if (this.isDoc) {
                this.event = 8;
            }
            return;
        }
        if (!this.getNext) {
            this.event = this.getEvent();
            this.getNext = true;
            return;
        }
        this.currentNode = this.getNextNode(false);
        if (this.reportEndElement > 0) {
            --this.reportEndElement;
            --this.elemCount;
            this.event = 2;
            this.getNext = false;
            return;
        }
        this.event = this.getEvent();
    }

    private Node getNextNode(boolean bl) {
        this.reportEndElement = 0;
        Node node = this.currentNode;
        Node node2 = node.getFirstChild();
        if (node2 == null && node.getNodeType() == 1 && !bl) {
            ++this.reportEndElement;
        }
        while (node2 == null) {
            node2 = node.getNextSibling();
            if (node2 != null) continue;
            if ((node = node.getParentNode()) == null) break;
            if (node.getNodeType() != 1 || bl) continue;
            ++this.reportEndElement;
        }
        return node2;
    }

    @Override
    public Object clone() {
        FDOMInfosetReader fDOMInfosetReader = new FDOMInfosetReader(this.originalNode);
        fDOMInfosetReader.originalNode = this.originalNode;
        fDOMInfosetReader.first = this.first;
        fDOMInfosetReader.currentNode = this.currentNode;
        fDOMInfosetReader.first = this.first;
        fDOMInfosetReader.event = this.event;
        fDOMInfosetReader.elemCount = this.elemCount;
        return fDOMInfosetReader;
    }

    @Override
    public String getAttribute(QName qName) {
        if (this.currentNode.getNodeType() == 1 && qName != null) {
            return ((Element)this.currentNode).getAttribute(qName.toString());
        }
        return null;
    }

    @Override
    public TypedAttributes getAttributes() {
        NamedNodeMap namedNodeMap;
        this.attList.reset();
        if (this.currentNode.getNodeType() == 1 && (namedNodeMap = ((Element)this.currentNode).getAttributes()) != null && namedNodeMap.getLength() > 0) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node = namedNodeMap.item(i);
                String string = node.getNamespaceURI() == null ? "" : node.getNamespaceURI();
                String string2 = node.getPrefix() == null ? "" : node.getPrefix();
                String string3 = node.getLocalName() == null ? "" : node.getLocalName();
                String string4 = node.getNodeName() == null ? "" : node.getNodeName();
                this.attList.addAttr(string2, string3, string4, node.getNodeValue(), true, 0, string);
            }
        }
        return this.attList;
    }

    @Override
    public char[] getData() {
        String string = this.currentNode.getTextContent();
        if (string != null) {
            return string.toCharArray();
        }
        return null;
    }

    @Override
    public int getDataLength() {
        char[] cArray = this.getData();
        if (cArray != null) {
            return cArray.length;
        }
        return 0;
    }

    @Override
    public int getDataStart() {
        return 0;
    }

    @Override
    public DTD getDoctype() {
        return null;
    }

    @Override
    public String getEncoding() {
        if (this.currentNode.getNodeType() == 9) {
            return ((Document)this.currentNode).getInputEncoding();
        }
        return this.currentNode.getOwnerDocument().getInputEncoding();
    }

    @Override
    public int getEventFlags() {
        return 0;
    }

    @Override
    public int getEventType() {
        return this.event;
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.currentNode.lookupNamespaceURI(string);
    }

    @Override
    public InfosetReader.Offset getOffset() {
        return null;
    }

    @Override
    public Object getOffsetObject() {
        if (this.event != 2 && this.event != 8) {
            return this.currentNode;
        }
        return null;
    }

    @Override
    public String getPrefix(String string) {
        return this.currentNode.lookupPrefix(string);
    }

    @Override
    public int getPrimitiveTypeId() {
        return 0;
    }

    @Override
    public QName getQName() {
        short s = this.currentNode.getNodeType();
        switch (s) {
            case 7: {
                return QxNameHash.create("", ((ProcessingInstruction)this.currentNode).getTarget(), "");
            }
            case 1: 
            case 2: {
                String string = this.currentNode.getNamespaceURI() == null ? "" : this.currentNode.getNamespaceURI();
                String string2 = this.currentNode.getPrefix() == null ? "" : this.currentNode.getPrefix();
                String string3 = this.currentNode.getNodeName() == null ? "" : XMLUtil.getLocalName(this.currentNode.getNodeName());
                return QxNameHash.create(string, string3, string2);
            }
            case 5: {
                return QxNameHash.create("", this.currentNode.getNodeName(), "");
            }
        }
        return QxNameHash.create("", "", "");
    }

    @Override
    public String getStandalone() {
        return null;
    }

    @Override
    public BinaryStream getStream() {
        return null;
    }

    @Override
    public QName getTypeName() {
        return null;
    }

    @Override
    public String getValue() {
        return this.currentNode.getTextContent();
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.elemCount > 0) {
            return true;
        }
        if (!this.getNext && this.isDoc && this.event != 8) {
            return true;
        }
        if (this.reportEndElement > 0) {
            return true;
        }
        return this.currentNode != null && this.getNextNode(true) != null;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isNSResolutionSupported() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public boolean isSeekSupported() {
        return true;
    }

    @Override
    public InfosetReader.Offset offsetFromBytes(byte[] byArray, int n) {
        return null;
    }

    @Override
    public byte offsetToBytes(InfosetReader.Offset offset, byte[] byArray, int n) {
        return 0;
    }

    @Override
    public Object offsetObjectFromBytes(byte[] byArray, int n) {
        return null;
    }

    @Override
    public byte offsetObjectToBytes(Object object, byte[] byArray, int n) {
        return 0;
    }

    @Override
    public void seek(InfosetReader.Offset offset) {
    }

    @Override
    public void seekFromObject(Object object) {
        this.currentNode = (Node)object;
        this.event = this.getEvent();
        if (this.event == 1) {
            --this.elemCount;
        }
        this.reportEndElement = 0;
        this.getNext = true;
    }

    @Override
    public void skip() {
        this.skipNode();
    }

    void skipNode() {
        if (this.event == 1) {
            Node node = this.currentNode.getNextSibling();
            if (node != null) {
                this.currentNode = node;
                this.event = 2;
                this.getNext = false;
            } else {
                this.event = 2;
                this.getNext = false;
                node = null;
                Node node2 = this.currentNode.getParentNode();
                this.reportEndElement = 0;
                while (node2 != null && node2.getNodeType() != 9) {
                    node = node2.getNextSibling();
                    if (node != null) {
                        ++this.reportEndElement;
                        break;
                    }
                    node2 = node2.getParentNode();
                    ++this.reportEndElement;
                }
                this.currentNode = node;
            }
        } else if (this.event != 4 && this.event != 3 && this.event != 5) {
            throw new RuntimeException("Invalid SKIP event");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof Node && this.currentNode != null) {
            short s = this.currentNode.compareDocumentPosition((Node)object);
            if (s == 4 || s == 16) {
                return 1;
            }
            if (s == 2 || s == 8) {
                return -1;
            }
        }
        return 0;
    }
}

