/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.datamodel;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import oracle.i18n.text.OraCollator;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.OraURI;
import oracle.xml.util.OraURIException;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLConstants;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

public abstract class OXMLItem
extends XSDDataValue
implements XMLItem,
OXMLConstants {
    protected XMLNode nodeValue;
    protected OXMLSequenceType stype;
    static final int MAX_OP = 6;
    static final int NUM_PRIMITIVE_TYPES = 22;
    static boolean[][] castTable;
    private static final int[][] opComb;
    private static final int[][] opTable;
    private static final boolean[][] compTable;
    public static final DecimalFormat numberFormat;

    @Override
    protected void reset() {
        super.reset();
        this.stype = OXMLSequenceType.TUNTYPED;
        this.nodeValue = null;
    }

    public int getPrimitiveType() {
        if (this.isNode()) {
            return 90;
        }
        return this.stype.getPrimitiveId();
    }

    public OXMLSequenceType getItemType() {
        if (this.stype == null && this.nodeValue != null) {
            this.stype = OXMLSequenceType.createNodeType(this.nodeValue);
        }
        return this.stype;
    }

    public boolean isNode() {
        return this.nodeValue != null;
    }

    public abstract void atomize(OXMLSequence var1) throws XQException;

    public abstract OXMLSequence atomize() throws XQException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (this.stype == oXMLSequenceType) {
            return;
        }
        if (this.stype.isOfType(oXMLSequenceType)) {
            this.setType(oXMLSequenceType);
            return;
        }
        int n = oXMLSequenceType.getPrimitiveId();
        OXMLSequenceType oXMLSequenceType2 = OXMLSequenceType.getConstantType(1, n);
        int n2 = this.stype.getPrimitiveId();
        int n3 = n2 = n2 == 22 ? 5 : n2;
        if (n == 22) {
            if (!castTable[n2][5]) throw new XQException("XPTY0004");
            this.convert2Integer();
        } else {
            if (!castTable[n2][n]) throw new XQException("XPTY0004");
            switch (n) {
                case 3: {
                    this.convert2Float();
                    break;
                }
                case 4: {
                    this.convert2Double();
                    break;
                }
                case 5: {
                    this.convert2Decimal();
                    break;
                }
                case 2: {
                    this.convert2Boolean();
                    break;
                }
                case 16: {
                    this.convert2Base64Binary();
                    break;
                }
                case 15: {
                    this.convert2HexBinary();
                    break;
                }
                case 17: {
                    this.convert2URI();
                    break;
                }
                case 18: {
                    this.convert2QName();
                    break;
                }
                case 1: {
                    this.setString(OXMLSequenceType.TSTRING, this.getLexicalValue());
                    break;
                }
                case 0: {
                    this.setUntypedLexical(this.getLexicalValue());
                    break;
                }
                case 19: {
                    this.setString(OXMLSequenceType.TNOTATION, this.getLexicalValue());
                    break;
                }
                case 20: 
                case 21: {
                    if (n2 == 6) {
                        if (n == 21) {
                            this.intValue = 0;
                        } else {
                            this.doubleValue = 0.0;
                        }
                    } else if (n2 == 20 && n == 21 || n2 == 21 && n == 20) {
                        this.intValue = 0;
                        this.doubleValue = 0.0;
                    } else {
                        String string = this.getLexicalValue();
                        this.parseLexical(6);
                        this.objValue = null;
                        this.setType(oXMLSequenceType2);
                        try {
                            oXMLSequenceType2.getDataType().validateValue(string);
                        }
                        catch (Exception exception) {
                            throw new XQException("FORG0001");
                        }
                    }
                    this.lexicalValue = null;
                    this.nodeValue = null;
                    this.objValue = null;
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 6: {
                    if (n2 == 1 || n2 == 0) {
                        this.parseLexical(6);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 7: {
                    if (n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 9: {
                    if (n2 == 7) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 8: {
                    if (n2 == 7) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(5, 1);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 10: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 11: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 12: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 13: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 14: {
                    if (n2 == 7 || n2 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
            }
        }
        if (oXMLSequenceType.exactlyMatches(oXMLSequenceType2)) return;
        try {
            oXMLSequenceType.getDataType().validateValue(this.getLexicalValue());
            this.setType(oXMLSequenceType);
            return;
        }
        catch (Exception exception) {
            throw new XQException("FORG0001");
        }
    }

    protected OXMLFunctionContext getContext() throws XQException {
        throw new XQException("FONC0001");
    }

    private void parseLexical(int n) {
        this.getLexicalValue();
        try {
            this.setValue(n, this.lexicalValue.trim());
        }
        catch (XSDException xSDException) {
            throw new XQException("FORG0001");
        }
        this.nodeValue = null;
        this.lexicalValue = null;
    }

    private void convert2Float() throws XQException {
        int n = this.stype.getPrimitiveId();
        double d = -1.0;
        switch (n) {
            case 3: {
                return;
            }
            case 5: 
            case 22: {
                d = this.booleanValue ? (double)((BigDecimal)this.objValue).floatValue() : (double)this.intValue;
                break;
            }
            case 4: {
                if (this.doubleValue > 3.4028234663852886E38) {
                    d = Double.POSITIVE_INFINITY;
                    break;
                }
                if (this.doubleValue < -3.4028234663852886E38) {
                    d = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (Math.abs(this.doubleValue) < (double)1.4E-45f) {
                    d = 0.0;
                    break;
                }
                d = this.doubleValue;
                break;
            }
            case 2: {
                d = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("INF")) {
                    d = Double.POSITIVE_INFINITY;
                    break;
                }
                if (string.equals("-INF")) {
                    d = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (string.equals("Infinity") || string.equals("-Infinity")) {
                    throw new XQException("FORG0001");
                }
                try {
                    d = Float.parseFloat(this.getLexicalValue().trim());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setDouble(OXMLSequenceType.TFLOAT, d);
    }

    protected void convert2Double() throws XQException {
        int n = this.stype.getPrimitiveId();
        double d = -1.0;
        switch (n) {
            case 4: {
                return;
            }
            case 5: 
            case 22: {
                d = this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
                break;
            }
            case 3: {
                d = (float)this.doubleValue;
                break;
            }
            case 2: {
                d = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("INF")) {
                    d = Double.POSITIVE_INFINITY;
                    break;
                }
                if (string.equals("-INF")) {
                    d = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (string.equals("Infinity") || string.equals("-Infinity")) {
                    throw new XQException("FORG0001");
                }
                try {
                    d = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setDouble(OXMLSequenceType.TDOUBLE, d);
    }

    private void convert2Decimal() throws XQException {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 5: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isInfinite(this.doubleValue) || Double.isNaN(this.doubleValue)) {
                    throw new XQException("FOCA0002");
                }
                this.setDecimal(OXMLSequenceType.TDECIMAL, new BigDecimal(this.doubleValue));
                break;
            }
            case 2: {
                int n2 = this.booleanValue ? 1 : 0;
                this.setInt(OXMLSequenceType.TDECIMAL, n2);
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.length() == 0) {
                    throw new XQException("FORG0001");
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                    throw new XQException("FORG0001");
                }
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                int n3 = string.length() - 1;
                try {
                    int n4 = Integer.parseInt(this.lexicalValue);
                    this.setInt(OXMLSequenceType.TDECIMAL, n4);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.charAt(n3) == '.') {
                        string = string.substring(0, n3);
                    }
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new XQException("FORG0001");
                    }
                }
            }
        }
    }

    private void convert2Integer() throws XQException {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 22: {
                return;
            }
            case 5: {
                if (this.booleanValue) {
                    BigDecimal bigDecimal = ((BigDecimal)this.objValue).setScale(0, 1);
                    BigDecimal bigDecimal2 = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
                    BigDecimal bigDecimal3 = new BigDecimal(Integer.toString(Integer.MAX_VALUE));
                    if (bigDecimal.compareTo(bigDecimal3) <= 0 && bigDecimal.compareTo(bigDecimal2) >= 0) {
                        int n2 = bigDecimal.intValue();
                        this.setInt(OXMLSequenceType.TINTEGER, n2);
                        break;
                    }
                    this.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    break;
                }
                this.setInt(OXMLSequenceType.TINTEGER, this.intValue);
                break;
            }
            case 3: 
            case 4: {
                this.convertFloatDouble2Integer();
                break;
            }
            case 2: {
                int n3 = this.booleanValue ? 1 : 0;
                this.setInt(OXMLSequenceType.TINTEGER, n3);
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.length() == 0) {
                    throw new XQException("FORG0001");
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0 || string.indexOf(46) >= 0) {
                    throw new XQException("FORG0001");
                }
                int n4 = string.length() - 1;
                if (n4 >= 0 && string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                try {
                    int n5 = Integer.parseInt(this.lexicalValue);
                    this.setInt(OXMLSequenceType.TINTEGER, n5);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new XQException("FORG0001");
                    }
                }
            }
        }
    }

    private void convertFloatDouble2Integer() throws XQException {
        if (Double.isNaN(this.doubleValue) || Double.isInfinite(this.doubleValue)) {
            throw new XQException("FOCA0002");
        }
        double d = Math.floor(this.doubleValue);
        double d2 = d = d < 0.0 ? d + 1.0 : d;
        if (d > 2.147483647E9 || d < -2.147483648E9) {
            this.setDecimal(OXMLSequenceType.TINTEGER, new BigDecimal(d));
        } else {
            this.setInt(OXMLSequenceType.TINTEGER, (int)d);
        }
    }

    protected void convert2Boolean() throws XQException {
        int n = this.stype.getPrimitiveId();
        boolean bl = false;
        switch (n) {
            case 2: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue) || this.doubleValue == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    bl = ((BigDecimal)this.objValue).intValue() != 0;
                    break;
                }
                bl = this.intValue != 0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("true") || string.equals("1")) {
                    bl = true;
                    break;
                }
                if (string.equals("false") || string.equals("0")) {
                    bl = false;
                    break;
                }
                throw new XQException("FORG0001");
            }
        }
        this.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    private void convert2URI() throws XQException {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 17: {
                return;
            }
            case 0: 
            case 1: {
                try {
                    new OraURI(this.getLexicalValue().trim());
                    break;
                }
                catch (OraURIException oraURIException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setString(OXMLSequenceType.TANYURI, this.lexicalValue);
    }

    private void convert2HexBinary() {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 15: {
                return;
            }
            case 16: {
                this.lexicalValue = FNUtil.encodeHex(FNUtil.decodeBase64(this.getLexicalValue()));
                break;
            }
            case 0: 
            case 1: {
                try {
                    this.setValue(15, this.getLexicalValue());
                    break;
                }
                catch (XSDException xSDException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setString(OXMLSequenceType.THEXBINARY, this.lexicalValue);
    }

    private void convert2Base64Binary() {
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 16: {
                return;
            }
            case 15: {
                this.lexicalValue = FNUtil.encodeBase64(FNUtil.decodeHex(this.getLexicalValue()));
                break;
            }
            case 0: 
            case 1: {
                try {
                    this.setValue(16, this.getLexicalValue());
                    break;
                }
                catch (XSDException xSDException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setString(OXMLSequenceType.TBASE64BINARY, this.lexicalValue);
    }

    protected abstract void convert2QName() throws XQException;

    public boolean matchesType(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (this.stype == null && this.nodeValue != null) {
            this.stype = OXMLSequenceType.createNodeType(this.nodeValue);
        }
        if (this.stype != null) {
            return this.stype.isOfTypeIgnoreOccurence(oXMLSequenceType);
        }
        throw new XQException("XPTY0004");
    }

    @Override
    public boolean instanceOfType(int n) {
        boolean bl = false;
        switch (n) {
            case 99: {
                bl = this.isNode();
                break;
            }
            case 7: {
                bl = this.matchesType(OXMLSequenceType.TDTDURATION);
                break;
            }
            case 8: {
                bl = this.matchesType(OXMLSequenceType.TYMDURATION);
                break;
            }
            case 20: {
                bl = this.matchesType(OXMLSequenceType.TDURATION);
                break;
            }
            case 9: {
                bl = this.matchesType(OXMLSequenceType.TANYURI);
                break;
            }
            case 10: {
                bl = this.matchesType(OXMLSequenceType.TBASE64BINARY);
                break;
            }
            case 11: {
                bl = this.matchesType(OXMLSequenceType.TBOOLEAN);
                break;
            }
            case 13: {
                bl = this.matchesType(FNUtil.TINT);
                break;
            }
            case 14: {
                bl = this.matchesType(OXMLSequenceType.TINTEGER);
                break;
            }
            case 16: {
                bl = this.matchesType(FNUtil.TLONG);
                break;
            }
            case 17: {
                bl = this.matchesType(OXMLSequenceType.TDATETIME);
                break;
            }
            case 18: {
                bl = this.matchesType(OXMLSequenceType.TDECIMAL);
                break;
            }
            case 19: {
                bl = this.matchesType(OXMLSequenceType.TDOUBLE);
                break;
            }
            case 21: {
                bl = this.matchesType(OXMLSequenceType.TFLOAT);
                break;
            }
            case 27: {
                bl = this.matchesType(OXMLSequenceType.THEXBINARY);
                break;
            }
            case 30: {
                bl = this.matchesType(OXMLSequenceType.TSTRING);
            }
        }
        return bl;
    }

    public boolean isCastable(OXMLSequenceType oXMLSequenceType) throws XQException {
        boolean bl = true;
        OXMLItem oXMLItem = this.getContext().createItem();
        oXMLItem.copyItem(this);
        try {
            oXMLItem.convert(oXMLSequenceType);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void compareValue(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2) throws XQException {
        OraCollator oraCollator = null;
        OXMLFunctionContext oXMLFunctionContext = null;
        try {
            oXMLFunctionContext = this.getContext();
        }
        catch (XQException xQException) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
            this.compareValue(oXMLItem, n, oXMLItem2, oraCollator);
            return;
        }
        if (oXMLFunctionContext == null) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
        } else {
            String string = oXMLFunctionContext.getDefaultCollation();
            oraCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        }
        this.compareValue(oXMLItem, n, oXMLItem2, oraCollator);
    }

    public void compareValue(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2, OraCollator oraCollator) throws XQException {
        switch (n) {
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                switch (this.basicType) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        throw new XQException("XPTY0004");
                    }
                    case 6: {
                        if (this.stype.getPrimitiveId() == oXMLItem.stype.getPrimitiveId()) break;
                        throw new XQException("XPTY0004");
                    }
                }
                if (this.stype.getPrimitiveId() != 6 && oXMLItem.stype.getPrimitiveId() != 6) break;
                throw new XQException("XPTY0004");
            }
        }
        int n2 = this.compareValue(oXMLItem, oraCollator);
        if (n2 == -2 && this.isNumeric()) {
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, n == 211);
        } else if (this.basicType == 6 && (n == 210 || n == 211)) {
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, n == 210 ? n2 == 0 : n2 != 0);
        } else {
            if (n2 > 1 || n2 < -1 || n < 210 || n > 215) {
                throw new XQException("XPTY0004");
            }
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, compTable[n2 + 1][n - 210]);
        }
    }

    private boolean isNumeric() {
        return this.basicType == 3 || this.basicType == 4 || this.basicType == 5;
    }

    public int compareValue(OXMLItem oXMLItem) throws XQException {
        OraCollator oraCollator = null;
        OXMLFunctionContext oXMLFunctionContext = null;
        try {
            oXMLFunctionContext = this.getContext();
        }
        catch (XQException xQException) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
            return this.compareValue(oXMLItem, oraCollator);
        }
        if (oXMLFunctionContext == null) {
            oraCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
        } else {
            String string = oXMLFunctionContext.getDefaultCollation();
            oraCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        }
        return this.compareValue(oXMLItem, oraCollator);
    }

    public int compareValue(OXMLItem oXMLItem, OraCollator oraCollator) throws XQException {
        int n = this.stype.getPrimitiveId();
        n = n == 0 ? 1 : n;
        int n2 = oXMLItem.stype.getPrimitiveId();
        n2 = n2 == 0 ? 1 : n2;
        switch (this.getComp(n, n2)) {
            case 2: {
                if (this.booleanValue == oXMLItem.booleanValue) {
                    return 0;
                }
                if (this.booleanValue) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (Double.isNaN(this.doubleValue) || Double.isNaN(oXMLItem.doubleValue)) {
                    return -2;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    if (Double.isInfinite(oXMLItem.doubleValue)) {
                        if (this.doubleValue > 0.0) {
                            return oXMLItem.doubleValue > 0.0 ? 0 : 1;
                        }
                        return oXMLItem.doubleValue < 0.0 ? 0 : -1;
                    }
                    return this.doubleValue > 0.0 ? 1 : -1;
                }
                float f = this.floatValue() - oXMLItem.floatValue();
                if (f > 0.0f) {
                    return 1;
                }
                if (f < 0.0f) {
                    return -1;
                }
                if (f == 0.0f) {
                    return 0;
                }
            }
            case 4: {
                if (Double.isNaN(this.doubleValue) || Double.isNaN(oXMLItem.doubleValue)) {
                    return -2;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    if (Double.isInfinite(oXMLItem.doubleValue)) {
                        if (this.doubleValue > 0.0) {
                            return oXMLItem.doubleValue > 0.0 ? 0 : 1;
                        }
                        return oXMLItem.doubleValue < 0.0 ? 0 : -1;
                    }
                    return this.doubleValue > 0.0 ? 1 : -1;
                }
                double d = this.doubleValue() - oXMLItem.doubleValue();
                if (d > 0.0) {
                    return 1;
                }
                if (d < 0.0) {
                    return -1;
                }
                if (d == 0.0) {
                    return 0;
                }
            }
            case 5: 
            case 22: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    return this.getDecimal().compareTo(oXMLItem.getDecimal());
                }
                if (this.intValue > oXMLItem.intValue) {
                    return 1;
                }
                if (this.intValue < oXMLItem.intValue) {
                    return -1;
                }
                return 0;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                GregorianCalendar gregorianCalendar2 = (GregorianCalendar)oXMLItem.objValue;
                if (this.booleanValue != oXMLItem.booleanValue) {
                    TimeZone timeZone = this.getContext().getImplicitTimezone();
                    if (!this.booleanValue) {
                        gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                        gregorianCalendar.setTimeZone(timeZone);
                    } else {
                        gregorianCalendar2 = (GregorianCalendar)gregorianCalendar2.clone();
                        gregorianCalendar2.setTimeZone(timeZone);
                    }
                }
                if (gregorianCalendar.after(gregorianCalendar2)) {
                    return 1;
                }
                if (gregorianCalendar2.after(gregorianCalendar)) {
                    return -1;
                }
                return 0;
            }
            case 6: 
            case 20: 
            case 21: {
                return this.compareVal(oXMLItem, 6);
            }
            case 1: {
                int n3 = oraCollator.compare(this.getString(), oXMLItem.getString());
                n3 = n3 > 0 ? 1 : (n3 < 0 ? -1 : 0);
                return n3;
            }
            case 15: 
            case 16: 
            case 17: {
                int n4 = this.getString().compareTo(oXMLItem.getString());
                n4 = n4 > 0 ? 1 : (n4 < 0 ? -1 : 0);
                return n4;
            }
            case 19: {
                int n5;
                OXMLItem oXMLItem2 = this.getContext().createItem();
                oXMLItem2.setString(OXMLSequenceType.TSTRING, this.getString());
                oXMLItem2.convert2QName();
                OXMLItem oXMLItem3 = this.getContext().createItem();
                oXMLItem3.setString(OXMLSequenceType.TSTRING, oXMLItem.getString());
                oXMLItem3.convert2QName();
                boolean bl = oXMLItem2.getQName().equals(oXMLItem3.getQName());
                int n6 = n5 = bl ? 0 : -1;
                if (n5 != 0) {
                    n5 = oXMLItem2.getQName().toString().compareTo(oXMLItem3.getQName().toString());
                }
                n5 = n5 > 0 ? 1 : (n5 < 0 ? -1 : 0);
                return n5;
            }
            case 18: {
                int n7;
                boolean bl = this.getQName().equals(oXMLItem.getQName());
                int n8 = n7 = bl ? 0 : -1;
                if (n7 != 0) {
                    n7 = this.getQName().toString().compareTo(oXMLItem.getQName().toString());
                }
                n7 = n7 > 0 ? 1 : (n7 < 0 ? -1 : 0);
                return n7;
            }
        }
        throw new XQException("XPTY0004");
    }

    private int getComp(int n, int n2) throws XQException {
        if (n == n2) {
            return n;
        }
        if ((n <= 5 && n >= 3 || n == 22) && (n2 <= 5 && n2 >= 3 || n2 == 22)) {
            switch (n) {
                case 22: {
                    return n2;
                }
                case 5: {
                    return n2 == 22 ? n : n2;
                }
                case 3: {
                    return n2 == 4 ? n2 : n;
                }
                case 4: {
                    return n;
                }
            }
        }
        if (n == 1 && n2 == 17 || n2 == 1 && n == 17) {
            return 1;
        }
        if (!(n != 6 && n != 21 && n != 20 || n2 != 6 && n2 != 21 && n2 != 20)) {
            return 6;
        }
        throw new XQException("XPTY0004");
    }

    private double doubleValue() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 3) {
            return (float)this.doubleValue;
        }
        if (n == 4) {
            return this.doubleValue;
        }
        if (n == 5 || n == 22) {
            return this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
        }
        throw new XQException("XPTY0004");
    }

    private float floatValue() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 3) {
            return (float)this.doubleValue;
        }
        if (n == 5 || n == 22) {
            return this.booleanValue ? ((BigDecimal)this.objValue).floatValue() : (float)this.intValue;
        }
        throw new XQException("XPTY0004");
    }

    private BigDecimal decimalValue() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 5 || n == 22) {
            return this.booleanValue ? (BigDecimal)this.objValue : BigDecimal.valueOf(this.intValue);
        }
        throw new XQException("XPTY0004");
    }

    public void setDecimal(OXMLSequenceType oXMLSequenceType, long l) throws XQException {
        this.booleanValue = false;
        if ((long)((int)l) == l) {
            this.setInt(oXMLSequenceType, (int)l);
        } else {
            this.setDecimal(oXMLSequenceType, new BigDecimal(l));
        }
    }

    public void compareNodes(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2) throws XQException {
        int n2 = FNUtil.compareNodeOrder(this.nodeValue, oXMLItem.nodeValue);
        boolean bl = false;
        switch (n) {
            case 208: {
                bl = n2 == 0;
                break;
            }
            case 209: {
                if (!XMLParser.getIs1010Compatible()) break;
                bl = n2 != 0;
                break;
            }
            case 223: {
                bl = n2 > 0;
                break;
            }
            case 222: {
                bl = n2 < 0;
            }
        }
        oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    public void negate() throws XQException {
        int n = this.stype.getPrimitiveId();
        if (n == 5 || n == 22) {
            if (this.booleanValue) {
                this.objValue = ((BigDecimal)this.objValue).negate();
                BigDecimal bigDecimal = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
                if (((BigDecimal)this.objValue).compareTo(bigDecimal) == 0) {
                    this.booleanValue = false;
                    this.intValue = Integer.MIN_VALUE;
                }
            } else if (this.intValue == Integer.MIN_VALUE) {
                this.booleanValue = true;
                this.objValue = new BigDecimal(this.intValue);
                this.objValue = ((BigDecimal)this.objValue).negate();
            } else {
                this.intValue = -this.intValue;
            }
            this.lexicalValue = null;
        } else if (n == 4 || n == 3) {
            this.doubleValue = -this.doubleValue;
            this.lexicalValue = null;
        }
    }

    public void arithmetic(OXMLItem oXMLItem, int n, OXMLItem oXMLItem2) throws XQException {
        if (this.stype == null || oXMLItem.stype == null) {
            throw new XQException("FOTY0014");
        }
        int n2 = this.stype.getPrimitiveId();
        int n3 = oXMLItem.stype.getPrimitiveId();
        switch (OXMLItem.getCase(this.basicType, oXMLItem.basicType, n)) {
            case 1: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() + oXMLItem.floatValue());
                return;
            }
            case 2: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() + oXMLItem.doubleValue());
                return;
            }
            case 3: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().add(oXMLItem.decimalValue());
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue + (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 4: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() - oXMLItem.floatValue());
                return;
            }
            case 5: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() - oXMLItem.doubleValue());
                return;
            }
            case 6: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().subtract(oXMLItem.decimalValue());
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue - (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 7: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() * oXMLItem.floatValue());
                return;
            }
            case 8: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() * oXMLItem.doubleValue());
                return;
            }
            case 9: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().multiply(oXMLItem.decimalValue());
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue * (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 10: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() / oXMLItem.floatValue());
                return;
            }
            case 11: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() / oXMLItem.doubleValue());
                return;
            }
            case 12: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isZero()) {
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, 0L);
                    return;
                }
                if (!this.booleanValue && !oXMLItem.booleanValue && this.intValue % oXMLItem.intValue == 0) {
                    long l = (long)this.intValue / (long)oXMLItem.intValue;
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                } else {
                    BigDecimal bigDecimal = this.decimalValue().divide(oXMLItem.decimalValue(), 20, 1);
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                }
                return;
            }
            case 13: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isZero()) {
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, 0L);
                    return;
                }
                if (!this.booleanValue && !oXMLItem.booleanValue && this.intValue % oXMLItem.intValue == 0) {
                    long l = (long)this.intValue / (long)oXMLItem.intValue;
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                } else {
                    BigDecimal bigDecimal = this.decimalValue().divide(oXMLItem.decimalValue(), 0, 1);
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                }
                return;
            }
            case 32: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isINF() || this.isNaN() || oXMLItem.isNaN()) {
                    throw new XQException("FOAR0002");
                }
                float f = oXMLItem.floatValue();
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() / f);
                oXMLItem2.convertFloatDouble2Integer();
                return;
            }
            case 33: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isINF() || this.isNaN() || oXMLItem.isNaN()) {
                    throw new XQException("FOAR0002");
                }
                double d = oXMLItem.doubleValue();
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() / d);
                oXMLItem2.convertFloatDouble2Integer();
                return;
            }
            case 14: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() % oXMLItem.floatValue());
                return;
            }
            case 15: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() % oXMLItem.doubleValue());
                return;
            }
            case 16: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().subtract(this.decimalValue().divide(oXMLItem.decimalValue(), 0, 1).multiply(oXMLItem.decimalValue()));
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l = (long)this.intValue % (long)oXMLItem.intValue;
                    if (n2 == 22 && n3 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l);
                    }
                }
                return;
            }
            case 17: {
                if (n2 != n3 || n2 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), this.intValue + oXMLItem.intValue, this.doubleValue + oXMLItem.doubleValue);
                return;
            }
            case 18: {
                if (n2 != n3 || n2 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), this.intValue - oXMLItem.intValue, this.doubleValue - oXMLItem.doubleValue);
                return;
            }
            case 19: {
                if (n2 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (oXMLItem.isNaN()) {
                    throw new XQException("FOCA0005");
                }
                if (oXMLItem.isINF()) {
                    throw new XQException("FODT0002");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), (int)((double)this.intValue * oXMLItem.doubleValue()), this.doubleValue * oXMLItem.doubleValue());
                return;
            }
            case 36: {
                if (n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (this.isNaN()) {
                    throw new XQException("FOCA0005");
                }
                if (this.isINF()) {
                    throw new XQException("FODT0002");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), (int)((double)oXMLItem.intValue * this.doubleValue()), oXMLItem.doubleValue * this.doubleValue());
                return;
            }
            case 37: {
                if (n2 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), (int)((double)this.intValue * (oXMLItem.intFormat() ? (double)oXMLItem.intValue : oXMLItem.doubleValue())), this.doubleValue * (oXMLItem.intFormat() ? (double)oXMLItem.intValue : oXMLItem.doubleValue()));
                return;
            }
            case 38: {
                if (n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), (int)((double)oXMLItem.intValue * (this.intFormat() ? (double)this.intValue : this.doubleValue())), oXMLItem.doubleValue * (this.intFormat() ? (double)this.intValue : this.doubleValue()));
                return;
            }
            case 20: {
                if (n2 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (oXMLItem.isNaN()) {
                    throw new XQException("FOCA0005");
                }
                if (oXMLItem.isZero()) {
                    throw new XQException("FODT0002");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n2), (int)((double)this.intValue / oXMLItem.doubleValue()), this.doubleValue / oXMLItem.doubleValue());
                return;
            }
            case 34: {
                BigDecimal bigDecimal;
                if (n2 != n3 || n2 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (n2 == 20) {
                    if (oXMLItem.intValue == 0) {
                        throw new XQException("FODT0002");
                    }
                    if (this.intValue == 0) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, 0L);
                        return;
                    }
                    bigDecimal = new BigDecimal(this.intValue).divide(new BigDecimal(oXMLItem.intValue), 20, 1);
                } else {
                    if (oXMLItem.doubleValue == 0.0) {
                        throw new XQException("FODT0002");
                    }
                    if (this.doubleValue == 0.0) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, 0L);
                        return;
                    }
                    bigDecimal = new BigDecimal(this.doubleValue).divide(new BigDecimal(oXMLItem.doubleValue), 20, 1);
                }
                oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, this.booleanValue == oXMLItem.booleanValue ? bigDecimal : bigDecimal.negate());
                return;
            }
            case 21: 
            case 22: 
            case 35: {
                long l = ((GregorianCalendar)this.objValue).getTimeInMillis() - ((GregorianCalendar)oXMLItem.objValue).getTimeInMillis();
                oXMLItem2.setDuration(OXMLSequenceType.TDTDURATION, 0, (double)l / 1000.0);
                return;
            }
            case 23: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                int n4 = gregorianCalendar.get(5);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n3 == 20) {
                    gregorianCalendar.add(2, oXMLItem.intValue);
                } else if (n3 == 21) {
                    this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n4 > 28 && n3 == 20) {
                        this.adjustDay(gregorianCalendar, n4);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 24: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                int n5 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n3 == 20) {
                    gregorianCalendar.add(2, -oXMLItem.intValue);
                } else if (n3 == 21) {
                    this.addTime(gregorianCalendar, -oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n5 > 28 && n3 == 20) {
                        this.adjustDay(gregorianCalendar, n5);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 25: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                int n6 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n3 == 20) {
                    gregorianCalendar.add(2, oXMLItem.intValue);
                } else if (n3 == 21) {
                    this.addDays(gregorianCalendar, oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n6 > 28 && n3 == 20) {
                        this.adjustDay(gregorianCalendar, n6);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, this.booleanValue, gregorianCalendar);
                return;
            }
            case 26: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                int n7 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n3 == 20) {
                    gregorianCalendar.add(2, -oXMLItem.intValue);
                } else if (n3 == 21) {
                    this.addDays(gregorianCalendar, -oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n7 > 28 && n3 == 20) {
                        this.adjustDay(gregorianCalendar, n7);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, this.booleanValue, gregorianCalendar);
                return;
            }
            case 27: {
                if (n3 != 21) {
                    throw new XQException("XPTY0004");
                }
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 28: {
                if (n3 != 21) {
                    throw new XQException("XPTY0004");
                }
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                this.addTime(gregorianCalendar, -oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 29: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                int n8 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n2 == 20) {
                    gregorianCalendar.add(2, oXMLItem.intValue);
                } else if (n2 == 21) {
                    this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n8 > 28 && n2 == 20) {
                        this.adjustDay(gregorianCalendar, n8);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
            case 30: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                int n9 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n2 == 20) {
                    gregorianCalendar.add(2, this.intValue);
                } else if (n2 == 21) {
                    this.addDays(gregorianCalendar, this.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n9 > 28 && n2 == 20) {
                        this.adjustDay(gregorianCalendar, n9);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
            case 31: {
                if (n2 != 21) {
                    throw new XQException("XPTY0004");
                }
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(timeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
        }
        throw new XQException("XPTY0004");
    }

    public boolean isZero() {
        boolean bl = false;
        switch (this.getPrimitiveType()) {
            case 5: 
            case 22: {
                bl = this.booleanValue ? ((BigDecimal)this.objValue).compareTo(new BigDecimal(0)) == 0 : this.intValue == 0;
                break;
            }
            case 3: {
                bl = this.floatValue() == 0.0f;
                break;
            }
            case 4: {
                bl = this.doubleValue() == 0.0;
            }
        }
        return bl;
    }

    public boolean isNaN() {
        boolean bl = false;
        switch (this.getPrimitiveType()) {
            case 3: 
            case 4: {
                bl = Double.isNaN(this.doubleValue);
            }
        }
        return bl;
    }

    private boolean isINF() {
        boolean bl = false;
        switch (this.getPrimitiveType()) {
            case 3: 
            case 4: {
                bl = Double.isInfinite(this.doubleValue);
            }
        }
        return bl;
    }

    private void adjustDay(GregorianCalendar gregorianCalendar, int n) {
        int n2;
        int n3 = gregorianCalendar.get(5);
        int n4 = n2 = gregorianCalendar.get(0) == 1 ? -1 : 1;
        if (n3 == 1) {
            gregorianCalendar.add(5, n2);
        }
    }

    private boolean isBigTimeZone(TimeZone timeZone) {
        int n = timeZone.getRawOffset();
        return n < -43200000 || n > 43200000;
    }

    private void addTime(GregorianCalendar gregorianCalendar, double d) {
        if (d == 0.0) {
            return;
        }
        int n = (int)d / 86400;
        gregorianCalendar.add(5, n);
        d -= (double)(n * 86400);
        n = (int)d;
        gregorianCalendar.add(13, n);
        d -= (double)n;
        n = (int)d * 1000;
        gregorianCalendar.add(14, n);
    }

    private void addDays(GregorianCalendar gregorianCalendar, double d) {
        if (d == 0.0) {
            return;
        }
        int n = (int)d / 86400;
        gregorianCalendar.add(5, n);
    }

    public void copyItem(OXMLItem oXMLItem) {
        this.copyDataValue(oXMLItem);
        this.nodeValue = oXMLItem.nodeValue;
        this.stype = oXMLItem.stype;
    }

    @Override
    public XMLNode getNode() {
        return this.nodeValue;
    }

    public void setNode(XMLNode xMLNode) throws XQException {
        this.setNode(null, xMLNode);
    }

    public void setNode(OXMLSequenceType oXMLSequenceType, XMLNode xMLNode) throws XQException {
        this.nodeValue = xMLNode;
        this.lexicalValue = null;
        this.objValue = null;
        this.stype = oXMLSequenceType;
    }

    @Override
    public String getLexicalValue() {
        if (this.lexicalValue != null) {
            return this.lexicalValue;
        }
        if (this.isNode()) {
            this.lexicalValue = this.nodeValue.getText();
            return this.lexicalValue;
        }
        int n = this.stype.getPrimitiveId();
        switch (n) {
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue)) {
                    this.lexicalValue = "NaN";
                    break;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    this.lexicalValue = this.doubleValue > 0.0 ? "INF" : "-INF";
                    break;
                }
                double d = n == 4 ? this.doubleValue : Double.parseDouble(Float.toString((float)this.doubleValue));
                double d2 = Math.abs(d);
                DecimalFormat decimalFormat = d2 != 0.0 && (d2 >= 1000000.0 || d2 < 1.0E-6) ? new DecimalFormat("0.0################E0##") : this.getDecimalFormat();
                this.lexicalValue = decimalFormat.format(d);
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    this.lexicalValue = this.getBigDecimalLexical((BigDecimal)this.objValue);
                    break;
                }
                DecimalFormat decimalFormat = this.getDecimalFormat();
                this.lexicalValue = decimalFormat.format(this.intValue);
                break;
            }
            case 2: {
                this.lexicalValue = this.booleanValue ? "true" : "false";
                break;
            }
            case 6: 
            case 20: 
            case 21: {
                this.lexicalValue = this.getDurationLexical(n);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.lexicalValue = this.getDateTimeLexical(n);
                break;
            }
            case 18: {
                QName qName = (QName)this.objValue;
                String string = qName.getPrefix();
                String string2 = qName.getLocalPart();
                if (string == null || string.length() == 0) {
                    this.lexicalValue = string2;
                    break;
                }
                this.lexicalValue = string + ':' + string2;
                break;
            }
        }
        this.lexicalValue = this.lexicalValue.intern();
        return this.lexicalValue;
    }

    private DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(100);
        return decimalFormat;
    }

    public String getBigDecimalLexical(BigDecimal bigDecimal) {
        int n;
        String string = bigDecimal.toString();
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = string.indexOf(46);
        if (n3 < 0) {
            n3 = n2;
        }
        int n4 = n = string.charAt(0) == '+' ? 1 : 0;
        while (n < n3 - 1 && string.charAt(n) == '0') {
            ++n;
        }
        stringBuffer.append(string.substring(n, n3));
        if (n3 != n2) {
            for (n = n2 - 1; n > n3 && string.charAt(n) == '0'; --n) {
            }
            if (n > n3) {
                stringBuffer.append(string.substring(n3, n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public String getDurationLexical() {
        return this.getDurationLexical(this.stype.getPrimitiveId());
    }

    String getDurationLexical(int n) {
        long l;
        long l2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.intValue < 0 || this.doubleValue < 0.0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (n != 21) {
            l2 = this.intValue >= 0 ? (long)this.intValue : (long)(-this.intValue);
            l = l2 / 12L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('Y');
            }
            if ((l = l2 % 12L) > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('M');
            }
            if (n == 20 && stringBuffer.length() <= 2) {
                return "P0M";
            }
        }
        if (n != 20) {
            int n2;
            l2 = (long)(this.doubleValue >= 0.0 ? this.doubleValue * 1000.0 : -this.doubleValue * 1000.0);
            l = l2 / 86400000L;
            l2 %= 86400000L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('D');
            }
            stringBuffer.append('T');
            l = l2 / 3600000L;
            l2 %= 3600000L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('H');
            }
            l = l2 / 60000L;
            l2 %= 60000L;
            if (l > 0L) {
                stringBuffer.append(l);
                stringBuffer.append('M');
            }
            if (l2 > 0L) {
                l = l2 / 1000L;
                stringBuffer.append(l);
                if ((l2 %= 1000L) > 0L) {
                    int n3;
                    stringBuffer.append('.');
                    if (l2 < 100L) {
                        stringBuffer.append('0');
                    }
                    if (l2 < 10L) {
                        stringBuffer.append('0');
                    }
                    String string = String.valueOf(l2);
                    for (n3 = string.length() - 1; n3 >= 0 && string.charAt(n3) == '0'; --n3) {
                    }
                    stringBuffer.append(string.substring(0, n3 + 1));
                }
                stringBuffer.append('S');
            }
            if (stringBuffer.charAt(n2 = stringBuffer.length() - 1) == 'T') {
                if (stringBuffer.charAt(n2 - 1) == 'P') {
                    return "PT0S";
                }
                stringBuffer.deleteCharAt(n2);
            }
        }
        return stringBuffer.toString();
    }

    String getDateTimeLexical(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
        if (n == 7 || n == 9 || n == 10 || n == 11) {
            if (gregorianCalendar.get(0) == 0) {
                stringBuffer.append('-');
                n2 = 1;
            }
            stringBuffer.append(gregorianCalendar.get(1));
            while (stringBuffer.length() - n2 < 4) {
                stringBuffer.insert(n2, '0');
            }
        }
        if (n != 11 && n != 8) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append('-');
            if (n != 14) {
                n2 = gregorianCalendar.get(2) + 1;
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2);
            } else {
                stringBuffer.append('-');
            }
            if (n != 12 && n != 10) {
                if (n != 14) {
                    stringBuffer.append('-');
                }
                if ((n2 = gregorianCalendar.get(5)) < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n2);
            }
        }
        if (n == 7 || n == 8) {
            if (n == 7) {
                stringBuffer.append('T');
            }
            if ((n2 = gregorianCalendar.get(11)) < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            stringBuffer.append(':');
            n2 = gregorianCalendar.get(12);
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            stringBuffer.append(':');
            n2 = gregorianCalendar.get(13);
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            n2 = gregorianCalendar.get(14);
            if (n2 > 0) {
                int n3;
                stringBuffer.append('.');
                if (n2 < 100) {
                    stringBuffer.append('0');
                }
                if (n2 < 10) {
                    stringBuffer.append('0');
                }
                String string = String.valueOf(n2);
                for (n3 = string.length() - 1; n3 >= 0 && string.charAt(n3) == '0'; --n3) {
                }
                stringBuffer.append(string.substring(0, n3 + 1));
            }
        }
        if (this.booleanValue) {
            int n4 = gregorianCalendar.getTimeZone().getRawOffset() / 60000;
            if (n4 == 0) {
                stringBuffer.append('Z');
                return stringBuffer.toString();
            }
            if (n4 > 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
                n4 = -n4;
            }
            n2 = n4 / 60;
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            n2 = n4 % 60;
            stringBuffer.append(':');
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
        }
        return stringBuffer.toString();
    }

    public Object getExternalObject() {
        return this.objValue;
    }

    public void setExternalObject(Object object) throws XQException {
        this.stype = null;
        this.basicType = -1;
        this.objValue = object;
        this.lexicalValue = null;
        this.nodeValue = null;
    }

    public void setUntypedLexical(String string) throws XQException {
        this.lexicalValue = string;
        this.basicType = 0;
        this.nodeValue = null;
        this.objValue = null;
        this.stype = OXMLSequenceType.TUNTYPED;
    }

    @Override
    public String getString() {
        return this.lexicalValue;
    }

    public void setString(OXMLSequenceType oXMLSequenceType, String string) throws XQException {
        this.setType(oXMLSequenceType);
        this.lexicalValue = string;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 1 && this.basicType != 17 && this.basicType != 19 && this.basicType != 16 && this.basicType != 15) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public boolean getBoolean() {
        return this.booleanValue;
    }

    public void setBoolean(OXMLSequenceType oXMLSequenceType, boolean bl) throws XQException {
        this.setType(oXMLSequenceType);
        this.booleanValue = bl;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 2) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public GregorianCalendar getCalendar() {
        return (GregorianCalendar)this.objValue;
    }

    public boolean hasTimeZone() {
        return this.booleanValue;
    }

    public void setCalendar(OXMLSequenceType oXMLSequenceType, boolean bl, GregorianCalendar gregorianCalendar) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = gregorianCalendar;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.booleanValue = bl;
        if (this.basicType < 7 || this.basicType > 14 || !bl && gregorianCalendar.get(15) != 0) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public int getYearMonthDuration() {
        return this.intValue;
    }

    @Override
    public double getDayTimeDuration() {
        return this.doubleValue;
    }

    public void setDuration(OXMLSequenceType oXMLSequenceType, int n, double d) throws XQException {
        this.setType(oXMLSequenceType);
        this.intValue = n;
        this.doubleValue = d;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 6) {
            throw new XQException("FOTY0001");
        }
    }

    public boolean withinRange() throws XQException {
        return !this.booleanValue;
    }

    @Override
    public boolean intFormat() {
        return this.withinRange();
    }

    @Override
    public int getInt() {
        return this.intValue;
    }

    public void setInt(OXMLSequenceType oXMLSequenceType, int n) throws XQException {
        this.setType(oXMLSequenceType);
        this.intValue = n;
        this.booleanValue = false;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 5) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public double getDouble() {
        return this.doubleValue;
    }

    @Override
    public float getFloat() {
        return (float)this.doubleValue;
    }

    public void setDouble(OXMLSequenceType oXMLSequenceType, double d) throws XQException {
        this.setType(oXMLSequenceType);
        this.doubleValue = d;
        if (this.basicType == 3) {
            if (d > 3.4028234663852886E38) {
                this.doubleValue = Double.POSITIVE_INFINITY;
            } else if (d < -3.4028234663852886E38) {
                this.doubleValue = Double.NEGATIVE_INFINITY;
            } else if (Math.abs(d) < (double)1.4E-45f) {
                this.doubleValue = 0.0;
            }
        }
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 4 && this.basicType != 3) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public BigDecimal getDecimal() {
        if (this.booleanValue) {
            return (BigDecimal)this.objValue;
        }
        return new BigDecimal((double)this.intValue);
    }

    public void setDecimal(OXMLSequenceType oXMLSequenceType, BigDecimal bigDecimal) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = bigDecimal;
        this.booleanValue = true;
        this.lexicalValue = null;
        this.nodeValue = null;
        if (this.basicType != 5) {
            throw new XQException("FOTY0001");
        }
    }

    public QName getQName() {
        return (QName)this.objValue;
    }

    public void setQName(OXMLSequenceType oXMLSequenceType, QName qName) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = qName;
        this.lexicalValue = null;
        this.nodeValue = null;
        if (this.basicType != 18) {
            throw new XQException("FOTY0001");
        }
    }

    private void setType(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (oXMLSequenceType == null) {
            throw new XQException("FOTY0001");
        }
        this.stype = oXMLSequenceType;
        int n = oXMLSequenceType.getPrimitiveId();
        this.basicType = n == 21 || n == 20 ? 6 : (n == 22 ? 5 : n);
    }

    static int getCase(int n, int n2, int n3) throws XQException {
        if (n3 > 2005 || n < 3 || n2 < 3 || n > 9 || n2 > 9) {
            throw new XQException("XPTY0004");
        }
        return opTable[n3 - 200][opComb[n - 3][n2 - 3]];
    }

    static {
        int n;
        castTable = new boolean[22][22];
        for (n = 0; n < 22; ++n) {
            for (int i = 0; i < 22; ++i) {
                OXMLItem.castTable[n][i] = false;
            }
        }
        for (n = 0; n < 22; ++n) {
            OXMLItem.castTable[n][n] = true;
            OXMLItem.castTable[0][n] = true;
            OXMLItem.castTable[n][0] = true;
            OXMLItem.castTable[n][1] = true;
            OXMLItem.castTable[1][n] = true;
        }
        OXMLItem.castTable[0][19] = false;
        OXMLItem.castTable[6][20] = true;
        OXMLItem.castTable[6][21] = true;
        OXMLItem.castTable[20][6] = true;
        OXMLItem.castTable[21][6] = true;
        OXMLItem.castTable[20][21] = true;
        OXMLItem.castTable[21][20] = true;
        OXMLItem.castTable[7][8] = true;
        OXMLItem.castTable[7][9] = true;
        OXMLItem.castTable[7][10] = true;
        OXMLItem.castTable[7][11] = true;
        OXMLItem.castTable[7][13] = true;
        OXMLItem.castTable[7][12] = true;
        OXMLItem.castTable[7][14] = true;
        OXMLItem.castTable[9][7] = true;
        OXMLItem.castTable[9][10] = true;
        OXMLItem.castTable[9][11] = true;
        OXMLItem.castTable[9][13] = true;
        OXMLItem.castTable[9][12] = true;
        OXMLItem.castTable[9][14] = true;
        OXMLItem.castTable[3][4] = true;
        OXMLItem.castTable[3][5] = true;
        OXMLItem.castTable[3][2] = true;
        OXMLItem.castTable[4][3] = true;
        OXMLItem.castTable[4][5] = true;
        OXMLItem.castTable[4][2] = true;
        OXMLItem.castTable[5][3] = true;
        OXMLItem.castTable[5][4] = true;
        OXMLItem.castTable[5][2] = true;
        OXMLItem.castTable[2][3] = true;
        OXMLItem.castTable[2][4] = true;
        OXMLItem.castTable[2][5] = true;
        OXMLItem.castTable[16][15] = true;
        OXMLItem.castTable[15][16] = true;
        opComb = new int[][]{{1, 2, 1, 16, 0, 0, 0}, {2, 2, 2, 17, 0, 0, 0}, {1, 2, 3, 4, 0, 0, 0}, {18, 19, 5, 6, 10, 14, 13}, {0, 0, 0, 9, 15, 0, 0}, {0, 0, 0, 11, 0, 8, 0}, {0, 0, 0, 12, 0, 0, 7}};
        opTable = new int[][]{{0, 1, 2, 3, 0, 0, 17, 0, 0, 23, 29, 27, 25, 30, 31, 0, 0, 0, 0, 0}, {0, 4, 5, 6, 0, 0, 18, 21, 22, 24, 0, 28, 26, 0, 0, 35, 0, 0, 0, 0}, {0, 7, 8, 9, 38, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 36, 19, 19}, {0, 10, 11, 12, 0, 20, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20}, {0, 32, 33, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 14, 15, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        compTable = new boolean[][]{{false, true, true, true, false, false}, {true, false, false, true, false, true}, {false, true, false, false, true, true}};
        numberFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(100);
    }
}

