/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.util.XMLUtil;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLAttribute;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLEventHandler;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLMiscElements;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLVariable;

class XSLResultDocument
extends XSLNode
implements XSLConstants {
    private static final String OUTPUT_VERSION = "output-version";
    private NSName format;
    private NSName qn4type;
    private String href;
    private String method;
    private String cdataSecElemQNameList;
    private String doctypepub;
    private String doctypesys;
    private String encoding;
    private String eua;
    private String ict;
    private String indent;
    private String mediatype;
    private String omitxmldec;
    private String standalone;
    private String outversion;
    private String ucmlist;
    private String normalizationform;
    private String bom;
    private XSLNode.AttrValueTmpl hrefavt;
    private XSLNode.AttrValueTmpl methodavt;
    private XSLNode.AttrValueTmpl doctypepubavt;
    private XSLNode.AttrValueTmpl doctypesysavt;
    private XSLNode.AttrValueTmpl encodingavt;
    private XSLNode.AttrValueTmpl eua_avt;
    private XSLNode.AttrValueTmpl ict_avt;
    private XSLNode.AttrValueTmpl indentavt;
    private XSLNode.AttrValueTmpl mediatypeavt;
    private XSLNode.AttrValueTmpl omitxmldecavt;
    private XSLNode.AttrValueTmpl standaloneavt;
    private XSLNode.AttrValueTmpl outversionavt;
    private XSLNode.AttrValueTmpl normalizationformavt;
    private XSLNode.AttrValueTmpl bomavt;

    XSLResultDocument(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 7;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "result-document", "", (byte)-1);
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        if (this.parent instanceof XSLVariable || this.parent instanceof XSLAttribute || this.parent instanceof XSLMiscElements || this.parent instanceof XSLFunction) {
            // empty if block
        }
        this.process(xSLTContext);
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, "result-document", "", (byte)-1, null);
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "") {
            if (string3 == "format") {
                this.format = this.resolveQname(string4);
            } else if (string3 == "type") {
                this.qn4type = this.resolveQname(string4);
            } else if (string3 == "href") {
                this.hrefavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "method") {
                this.methodavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "cdata-section-elements") {
                this.cdataSecElemQNameList = string4;
            } else if (string3 == "doctype-public") {
                this.doctypepubavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "doctype-system") {
                this.doctypesysavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "encoding") {
                this.encodingavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "escape-uri-attributes") {
                this.eua_avt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "include-content-type") {
                this.ict_avt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "indent") {
                this.indentavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "media-type") {
                this.mediatypeavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "omit-xml-declaration") {
                this.omitxmldecavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "standalone") {
                this.standaloneavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "byte-order-mark") {
                this.bomavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == OUTPUT_VERSION) {
                this.outversionavt = new XSLNode.AttrValueTmpl(string4, this);
            } else if (string3 == "use-character-maps") {
                this.ucmlist = string4.trim();
            } else if (string3 == "normalization-form") {
                this.normalizationformavt = new XSLNode.AttrValueTmpl(string4, this);
            }
        }
        super.setAttribute(string, string2, string3, string4);
    }

    private void processAttributes(XSLOutput xSLOutput, XSLTContext xSLTContext) throws XSLException, XQException {
        Collection<String> collection;
        if (this.methodavt != null) {
            this.method = this.methodavt.getValue(xSLTContext);
            xSLOutput.setMethod(this.method);
        }
        if (this.cdataSecElemQNameList != null) {
            collection = xSLOutput.getCdataSectionElements();
            collection = xSLOutput.processCdataSectionElement((Set<String>)collection, xSLOutput, this.cdataSecElemQNameList);
            xSLOutput.setCdataSectionElements((Set<String>)collection);
        }
        if (this.doctypepubavt != null) {
            this.doctypepub = this.doctypepubavt.getValue(xSLTContext);
            xSLOutput.setDoctypePublic(this.doctypepub);
        }
        if (this.doctypesysavt != null) {
            this.doctypesys = this.doctypesysavt.getValue(xSLTContext);
            xSLOutput.setDoctypeSystem(this.doctypesys);
        }
        if (this.encodingavt != null) {
            this.encoding = this.encodingavt.getValue(xSLTContext);
            xSLOutput.setEncoding(this.encoding);
        }
        if (this.eua_avt != null) {
            this.eua = this.eua_avt.getValue(xSLTContext);
            xSLOutput.setEscapeURIAttributes(XMLUtil.checkYesNo(this.eua, this.xss.err));
        }
        if (this.ict_avt != null) {
            this.ict = this.ict_avt.getValue(xSLTContext);
            xSLOutput.setIncludeContentType(XMLUtil.checkYesNo(this.ict, this.xss.err));
        }
        if (this.indentavt != null) {
            this.indent = this.indentavt.getValue(xSLTContext);
            xSLOutput.setIndent(XMLUtil.checkYesNo(this.indent, this.xss.err));
        }
        if (this.mediatypeavt != null) {
            this.mediatype = this.mediatypeavt.getValue(xSLTContext);
            xSLOutput.setMediaType(this.mediatype);
        }
        if (this.omitxmldecavt != null) {
            this.omitxmldec = this.omitxmldecavt.getValue(xSLTContext);
            xSLOutput.setOmitXMLDecl(XMLUtil.checkYesNo(this.omitxmldec, this.xss.err));
        }
        if (this.standaloneavt != null) {
            this.standalone = this.standaloneavt.getValue(xSLTContext);
            xSLOutput.setStandalone(this.standalone);
        }
        if (this.outversionavt != null) {
            this.outversion = this.outversionavt.getValue(xSLTContext);
            xSLOutput.setVersion(this.outversion);
        }
        if (this.ucmlist != null && this.ucmlist.length() > 0) {
            collection = xSLOutput.processUseCharacterMaps(this.ucmlist);
            collection = xSLOutput.mergeCharacterMaps(xSLOutput.calledUCM(), (Vector)collection);
            xSLOutput.makeCharacterMaps((Vector)collection);
        }
        if (this.normalizationformavt != null) {
            this.normalizationform = this.normalizationformavt.getValue(xSLTContext);
            xSLOutput.setNormalizationForm(this.normalizationform);
        }
        if (this.bomavt != null) {
            this.bom = this.bomavt.getValue(xSLTContext);
            xSLOutput.setBOM(XMLUtil.checkYesNo(this.bom, this.xss.err));
        }
    }

    private void process(XSLTContext xSLTContext) throws XSLException, XQException {
        this.href = this.hrefavt == null ? null : this.hrefavt.getValue(xSLTContext);
        if (this.href == null || this.href.length() == 0) {
            this.processChildren(xSLTContext);
        } else {
            XSLEventHandler xSLEventHandler = xSLTContext.getEventHandler();
            URL uRL = xSLTContext.getBaseURL();
            try {
                Object object;
                URL uRL2 = new URL(uRL, this.href);
                String string = uRL2.getFile();
                File file = new File(string);
                String string2 = file.getParent();
                if (string2 != null && !((File)(object = new File(string2))).exists()) {
                    ((File)object).mkdirs();
                }
                object = new FileOutputStream(file);
                XSLOutput xSLOutput = this.xss.getOutput2(this.format);
                this.processAttributes(xSLOutput, xSLTContext);
                XSLSAXPrintDriver xSLSAXPrintDriver = new XSLSAXPrintDriver((OutputStream)object, xSLOutput);
                XSLEventHandler xSLEventHandler2 = new XSLEventHandler(xSLSAXPrintDriver, xSLSAXPrintDriver, xSLTContext);
                xSLTContext.setEventHandler(xSLEventHandler2);
                this.processChildren(xSLTContext);
                xSLSAXPrintDriver.flush();
                ((FileOutputStream)object).close();
            }
            catch (MalformedURLException malformedURLException) {
                XMLError xMLError = xSLTContext.getError();
                xMLError.error1(1003, 1, this.href);
            }
            catch (FileNotFoundException fileNotFoundException) {
                XMLError xMLError = xSLTContext.getError();
                xMLError.error1(1003, 1, this.href);
            }
            catch (IOException iOException) {
                XMLError xMLError = xSLTContext.getError();
                xMLError.error1(1003, 1, this.href);
            }
        }
    }
}

