
JDTProjectClasspath = function(projectPath, classPathFile)
{
	this.projectPath = projectPath;
	this.classPathFile = classPathFile;
	this.srcCpEntries = new Array();
	this.conCpEntries = new Array();
	this.unresolvedCpEntries = new Array();
	this.resolvedCpEntries = new Array();
	this.allSrcCpEntries = null;
	
	this.init = function(xpath)
	{
		// the .classpath file is of the form: <classpath><classpathentry .../> <classpathentry ... /> ... </classpath>
		// so select all the classpathentry elements and pull out all the interesting data
        var fi = new java.io.FileInputStream(this.classPathFile);
        try
        {
            var input = new org.xml.sax.InputSource(fi);
            var nodeset = xpath.evaluate("/classpath/classpathentry", input, javax.xml.xpath.XPathConstants.NODESET);
            if (nodeset != null && nodeset.getLength() > 0)
            {
            	for (var i = 0; i < nodeset.getLength(); i++)
            	{
            		var node = nodeset.item(i);
            		if (node instanceof org.w3c.dom.Element)
            		{
            			var kind = node.getAttribute("kind");
            			if ("src".equals(kind))
            			{
            				this.handleSourceFolder(node);
            			}
            			else if ("con".equals(kind))
            			{
            				this.handleCpContainer(node);
            			}
            		}
            	}
            }
            return null;
        }
        finally
        {
            if (fi != null)
            {
                fi.close();
            }
        }
	};
	
	this.getAllSrcCpEntries = function()
	{
		if (this.allSrcCpEntries == null)
		{
			this.allSrcCpEntries = this.resolvedCpEntries.concat(this.srcCpEntries);
			this.allSrcCpEntries.concat(this.resolvedCpEntries);
		}
		return this.allSrcCpEntries;
	};
	this.handleSourceFolder = function(classPathEntryNode)
	{
		var path = classPathEntryNode.getAttribute("path");
		// in jdt, src folder paths either are either relative (no leading slash) to
		// the current project or are absolute (leading slash) starting from the workspace root
	
		// handle local source folder
		if (!path.startsWith("/"))
		{
            var output = classPathEntryNode.getAttribute("output");
            var binDir = null; // this will result default bin folder being used
            if (output != null && !output.trim().isEmpty()) {
            	// here the output is specified, so capture that.
                binDir = output.trim();
            } 
            var cpEntry = new SrcClasspathEntry("src", path, binDir);
            cpEntry.absPath = this.projectPath + "/" + path;
            this.srcCpEntries.push(cpEntry);
		}
		else
		{
			// otherwise, it's a project
			var projectName = path.substring(1);
			var cpEntry = new UnresolvedClasspathEntry("src", path, projectName);
			this.unresolvedCpEntries.push(cpEntry);
		}
	};
	
	this.handleCpContainer = function(classPathEntryNode)
	{
		var path = classPathEntryNode.getAttribute("path");
		// in jdt, "con" or "classpath containers", the path is basically an identifier that JDT
		// can use at compile time.  
		
		// the path has one or more segments separated by "/" characters.
		// the first segment identifies the container type and an associated handler
		// the remaining characters provide arguments or hints that provide specifics to the handler
		var segments = path.split("/");
		if (segments.length == 0)
		{
			return;
		}
		
		var id = segments.shift();
		var cpEntry = new ConClasspathEntry("con", path, id, segments.slice(1));
		this.conCpEntries.push(cpEntry);
	};
	
	/**
	 * kind -- a String containing "src"
	 * projectName -- a String containing the project name
	 */
	function UnresolvedClasspathEntry(kind, path, projectName)
	{
		this.kind = kind;
		this.path = path;
		this.projectName = projectName;
	}
	
	/**
	 * kind --  a String containing "con"
	 * path -- the original path from the classpath entry
	 * id -- the first segment of the path used by JDT to identify the container type and associated handlers
	 * hints -- and array zero or more segments of path after the id
	 */
	function ConClasspathEntry(kind, path, id, hints)
	{
		this.kind = kind;
		this.path = path;
		this.id = id;
		this.hints = hints;
		
		this.calcPathId = function()
		{
			return this.id + "." + this.hints.join(".");
		};
	}

	function SrcClasspathEntry(kind, path, binDir)
	{
		this.kind = kind;
		this.path = path;
		this.absPath = null;
		this.binDir = binDir;

        this.hasFile = function(relativeFilePath) {
            var file=this.getFile(relativeFilePath);
            if (file != null)
            {
                return file.isFile();
            }
            return false;
        };
        /**
         * @returns a java.io.File pointing to the file discovered relative
         * to my absPath or null if not found.
         */
        this.getFile = function(relativeFilePath) {
            if (this.absPath != null)
            {
                return new java.io.File(this.absPath, relativeFilePath);
            }
            return null;
        };
	}

    this.getDefaultBinFolder = function() 
    {
		var xpath = javax.xml.xpath.XPathFactory.newInstance().newXPath();

        var fi = new java.io.FileInputStream(this.classPathFile);
        try
        {
            var input = new org.xml.sax.InputSource(fi);
            var defaultOutput = xpath.evaluate("/classpath/classpathentry[@kind='output']", input, javax.xml.xpath.XPathConstants.NODESET);
            if (defaultOutput != null && defaultOutput.getLength() > 0)
            {
                node = defaultOutput.item(0);
                defaultBinDir = node.getAttribute("path");
                antHelper.echo("Default Output: "+defaultBinDir);
                return defaultBinDir;
            }
            return null;
        }
        finally
        {
            if (fi != null)
            {
                fi.close();
            }
        }
    };
   
    /**
     * Resolve dependencies 
     * 
     * classpaths -- a hash map key = projectPath, value = each JDTProjectClasspath in the closure.
     * projects -- a hash map key = projectName, value = abs path to the project root
     */
	this.resolveDependencies = function(classpaths, projects) {
		for (var i = 0; i < this.unresolvedCpEntries.length; i++) {
			var unresolvedCp = this.unresolvedCpEntries[i];
			var projectName = unresolvedCp.projectName;
			if (projectName !== null) {
				var projectPath = projects.get(projectName);
				if (projectPath !== null) {
					var jdtProjectClasspath = classpaths.get(projectPath);
					if (jdtProjectClasspath !== null) {
						for (var j = 0; j < this.srcCpEntries.length; j++) {
							var foreignSrcEntry = jdtProjectClasspath.srcCpEntries[j];
							var resolvedSrcEntry = new SrcClasspathEntry(
									foreignSrcEntry.kind, unresolvedCp.path + "/" + foreignSrcEntry.path,
									foreignSrcEntry.binDir);
							resolvedSrcEntry.absPath = projectPath + "/"+foreignSrcEntry.path;
							this.resolvedCpEntries.push(resolvedSrcEntry);
						}
					}
				}
			}
		}
	};
};
