/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 */

ACTIVITIES_ELEM = "androidManifestActivities";
ACTIVITY_ELEM = "activity";
ANDROID_PLUGIN_INFO_ELEM = "androidPluginInfo";
ANDROID_SUPPORT_V4_JAR_RELATIVE_PATH = "extras/android/support/v4/android-support-v4.jar";
ANDROID_SUPPORT_V13_JAR_RELATIVE_PATH = "extras/android/support/v13/android-support-v13.jar";
APPLICATION_BUNDLE_ID_REGEX = "[a-zA-Z]+[a-zA-Z0-9_]*(\\.[a-zA-Z][a-zA-Z0-9_]*)+";
APPLICATION_ELEM = "application";
BEGIN_ROOT_ELEMENT = "<root xmlns:android=\"http://schemas.android.com/apk/res/android\">";
DEFAULT_EXTRA_PACKAGES = "oracle.idm.mobile";
EMPTY_STRING = "";
END_ROOT_ELEMENT = "</root>";
NAME_ATTR = "name";
PLUGIN_ELEM = "plugin";
PLUGINS_ELEM = "plugins";
RESOURCE_PACKAGE_NAME_ELEM = "resourcePackageName";
VALUE_ATTR = "value";
XML_VERSION_ELEMENT = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";


eval(''+new String(org.apache.tools.ant.util.FileUtils.readFully(new java.io.FileReader(self.project.getProperty("oepe.bin.js.dir")+"/loader.js"))));
load("common.js");
load("cordova-plugins-common.js");


processCordovaPlugins();


function processCordovaPlugins() {
    try {
        // follows the algorithm in the deployImpl() method of the JDev Deployer class, 
        // oracle.adfmf.framework.dt.deploy.android.deployers.plugins.AndroidPluginDeployer
        antHelper.echo("Processing Cordova plugins for deployment...");
        var plugins = deployUtils.getCordovaPlugins(deployUtils.ANDROID_PLATFORM, createAndroidPluginInfo);
        if (plugins.length > 0) {
            copyResources(plugins);
            copyAssets(plugins);
            updatePreferencesXml(plugins);
            updateConfigXml(plugins);
            updateAndroidManifest(plugins);
        }
        createPropertiesFile(plugins);
    } catch (e) {
        if (e instanceof CordovaPluginException) {
            project.setProperty("processCordovaPlugins.fail.message", e.toString());
        } else if (e instanceof java.lang.Throwable) {
            project.setProperty("processCordovaPlugins.fail.message", e.getMessage());
        } else {
            project.setProperty("processCordovaPlugins.fail.message", "Error processing Cordova plugins.");
        }
    }
}

function createAndroidPluginInfo(name, fullyQualName, implClass, pluginConfig, pluginElem) {
    var infoElem = deployUtils.getFirstNamedChildElement(pluginElem, ANDROID_PLUGIN_INFO_ELEM);
    var resPackageName = deployUtils.getElementTextContent(deployUtils.getFirstNamedChildElement(infoElem, RESOURCE_PACKAGE_NAME_ELEM));
    var manifestActivities = deployUtils.getElementTextContent(deployUtils.getFirstNamedChildElement(infoElem, ACTIVITIES_ELEM));
    return new AndroidCordovaPluginInfo(name, fullyQualName, implClass, resPackageName, manifestActivities, pluginConfig);
}

function copyResources(plugins) {
    var destDir = getApplicationResourceOutputDir();
    for (var i = 0; i < plugins.length; i++) {
        var plugin = plugins[i];
        var pluginName = plugin.getName();
        var pluginResourceDir = plugin.getPluginResDir();
        if (!pluginResourceDir) {
            // Additional resources are optional. Continue to the next plugin.
            continue;
        }

        antHelper.echo("Copying plugin \"" + pluginName
                + "\" resources from " + pluginResourceDir.getAbsolutePath() + "...");
        // handling to copy the value resources
        var copyTask = copyUtils.createCopyTask(self.project, self.getOwningTarget());
        copyTask.setTodir(destDir);
        var fileSet = copyUtils.createFileSet(pluginResourceDir);
        copyTask.add(fileSet);
        copyTask.add(copyUtils.createFileNameMapperForValueRes(pluginName));
        copyTask.perform();
        // copy the remaining resources, ignoring preferences.xml
        copyTask = copyUtils.createCopyTask(self.project, self.getOwningTarget());
        copyTask.setTodir(destDir);
        copyTask.setIncludeEmptyDirs(false);
        fileSet = copyUtils.createFileSet(pluginResourceDir);
        fileSet.setExcludes("value*/**, **/preferences.xml");
        copyTask.add(fileSet);
        copyTask.perform();
    }
}

function getApplicationResourceOutputDir() {
    var stagingPath = deployUtils.getStagingPath();
    var resourceOutputDir = new java.io.File(stagingPath + '/res');
    if (!resourceOutputDir || !resourceOutputDir.isDirectory()) {
        throw new CordovaPluginException("Could not find application resources directory " + stagingPath + "/res");
    }

    return resourceOutputDir;
}

function copyAssets(plugins) {
    var destDir = getApplicationAssetsOutputDir();
    for (var i = 0; i < plugins.length; i++) {
        var plugin = plugins[i];
        var pluginName = plugin.getName();
        var pluginAssetsDir = plugin.getPluginAssetsDir();
        if (!pluginAssetsDir) {
            // Assets are optional. Continue to the next plugin.
            continue;
        }
        antHelper.echo("Copying plugin \"" + pluginName
                + "\" assets from " + pluginAssetsDir.getAbsolutePath() + "...");
        var copyTask = copyUtils.createCopyTask(self.project, self.getOwningTarget());
        copyTask.setTodir(destDir);
        copyTask.add(copyUtils.createFileSet(pluginAssetsDir));
        copyTask.perform();
    }
}

function getApplicationAssetsOutputDir() {
    var stagingPath = deployUtils.getStagingPath();
    var webContentDir = new java.io.File(stagingPath + '/assets');
    if (!webContentDir || !webContentDir.isDirectory()) {
        throw new CordovaPluginException("Could not find application assets web content directory " + stagingPath + "/assets/www");
    }

    return webContentDir;
}

function updatePreferencesXml(plugins) {
    antHelper.echo("Updating preferences.xml with Cordova plugin preferences...");
    var preferencesXmlLocation = self.project.getProperty("adf.staging.res.xml.dir");
    var preferencesXmlFileLocation = preferencesXmlLocation + "/preferences.xml";
    var preferencesXmlFile = new java.io.File(preferencesXmlFileLocation);
    if (!preferencesXmlFile.isFile()) {
        // need to create (copy) an initial preferences.xml file
        var pluginsToAdd = new Array();
        var firstPrefXmlUrl = null;
        for (var i = 0; i < plugins.length; i++) {
            var plugin = plugins[i];
            var pluginPrefsXmlLoc = plugin.getPluginPreferencesXmlFileLocation();
            if (!pluginPrefsXmlLoc) {
                // optional
                continue;
            }
            var pluginPrefsXmlFile = new java.io.File(pluginPrefsXmlLoc);
            if (!firstPrefXmlUrl && pluginPrefsXmlFile.isFile()) {
                firstPrefXmlUrl = pluginPrefsXmlFile.getAbsolutePath();
                // copy this preferences.xml
                var copyTask = copyUtils.createCopyTask(self.project, self.getOwningTarget());
                copyTask.setTodir(new java.io.File(preferencesXmlLocation));
                copyTask.setFile(pluginPrefsXmlFile);
                copyTask.perform();
            } else {
                pluginsToAdd.push(plugin);
            }
        }
        addPluginPreferences(preferencesXmlFileLocation, pluginsToAdd);
    } else {
        addPluginPreferences(preferencesXmlFileLocation, plugins);
    }
}

function addPluginPreferences(preferencesXmlFileLocation, plugins) {
    if (!preferencesXmlFileLocation || !plugins || plugins.length <= 0) {
        return;
    }

    var preferencesXmlStream = new java.io.FileInputStream(preferencesXmlFileLocation);
    var preferencesXmlIs = new org.xml.sax.InputSource(preferencesXmlStream);
    var xmlDocument = new XMLDocument(preferencesXmlIs);
    var pluginPrefDom = xmlDocument.load();
    var os = null;
    try {
        var docElem = pluginPrefDom.getDocumentElement();
        if (docElem) {
            for (var i = 0; i < plugins.length; i++) {
                var plugin = plugins[i];
                addCurrentPluginPreferences(pluginPrefDom, plugin);
            }
        } else {
            throw new CordovaPluginException("No document element in: " + preferencesXmlFileLocation);
        }

        os = new java.io.FileOutputStream(preferencesXmlFileLocation);
        xmlDocument.save(os);
    } finally {
        if (preferencesXmlStream) {
            try {
                preferencesXmlStream.close();
            } catch (e) {
                // do nothing
            }
        }

        if (os) {
            try {
                os.close();
            } catch (e) {
                // do nothing
            }
        }
    }
}

function addCurrentPluginPreferences(preferencesXmlDom, plugin) {
    var xmlFileUrl = plugin.getPluginPreferencesXmlFileLocation();
    if (!xmlFileUrl) {
        // optional
        return;
    }
    var prefsXmlFile = new java.io.File(xmlFileUrl);
    if (prefsXmlFile.isFile()) {
        var prefsXmlStream = null;
        try {
            prefsXmlStream = new java.io.FileInputStream(xmlFileUrl);
            var prefsInputStream = new org.xml.sax.InputSource(prefsXmlStream);
            var xmlDoc = new XMLDocument(prefsInputStream);
            var prefsDocument = xmlDoc.load();
            var docElem = prefsDocument.getDocumentElement();
            if (docElem) {
                var pluginPrefList = docElem.getChildNodes();
                if (pluginPrefList) {
                    for (var i = 0; i < pluginPrefList.getLength(); i++) {
                        var child = pluginPrefList.item(i);
                        if (child instanceof org.w3c.dom.Element
                                && "PreferenceCategory".equals(child.getTagName())) {
                            var copiedNode = preferencesXmlDom.importNode(child, true);
                            if (copiedNode) {
                                preferencesXmlDom.getDocumentElement().appendChild(copiedNode);
                            }
                        }
                    }
                }
            }
        } catch (e) {
            antHelper.echo(e);
        } finally {
            if (prefsXmlStream) {
                try {
                    prefsXmlStream.close();
                } catch (e) {
                    // do nothing
                }
            }
        }
    }
}

function updateConfigXml(plugins) {
    antHelper.echo("Updating config.xml with Cordova plugin configurations...");
    var configXmlLocation = self.project.getProperty("adf.staging.res.xml.dir");
    var configXmlFileLocation = configXmlLocation + "/config.xml";
    var configXmlStream = new java.io.FileInputStream(configXmlFileLocation);
    var configXmlIs = new org.xml.sax.InputSource(configXmlStream);
    var xmlDocument = new XMLDocument(configXmlIs);
    var configXmlDom = xmlDocument.load();

    var os = null;
    try {
        var configXmlFile = new java.io.File(configXmlFileLocation);
        if (!configXmlFile.isFile()) {
            throw new CordovaPluginException("The config.xml file could not be found: " + configXmlFileLocation);
        }

        var pluginsNode = findOrCreatePluginsNode(configXmlDom);
        if (pluginsNode) {
            var definedPluginNames = getDefinedPluginNames(pluginsNode);
            for (var i = 0; i < plugins.length; i++) {
                var currPlugin = plugins[i];
                var pluginFullyQualifiedName = currPlugin.getFullyQualifiedName();
                var pluginImplClass = currPlugin.getImplClass();
                if (definedPluginNames.contains(pluginFullyQualifiedName)) {
                    antHelper.echo("Warning: File \"" + configXmlFileLocation
                            + "\" already contains plugin \"" + currPlugin.getName()
                            + "\".  The plugin with the fully qualified name \"" + pluginFullyQualifiedName
                            + "\" will not be added.");
                } else {
                    var currPluginElem = configXmlDom.createElementNS(null, PLUGIN_ELEM);
                    currPluginElem.setAttributeNS(null, NAME_ATTR, pluginFullyQualifiedName);
                    currPluginElem.setAttributeNS(null, VALUE_ATTR, pluginImplClass);
                    pluginsNode.appendChild(currPluginElem);
                }
            }
        } else {
            antHelper.echo("Could not find the plugins node in the config.xml file: " + configXmlFileLocation);
        }

        os = new java.io.FileOutputStream(configXmlFileLocation);
        xmlDocument.save(os);
    } finally {
        if (configXmlStream) {
            try {
                configXmlStream.close();
            } catch (e) {
                // do nothing
            }
        }

        if (os) {
            try {
                os.close();
            } catch (e) {
                // do nothing
            }
        }
    }
}

function findOrCreatePluginsNode(configXmlDom) {
    var elem = deployUtils.getFirstNamedChildElement(configXmlDom.getDocumentElement(), PLUGINS_ELEM);
    if (elem) {
        return elem;
    }

    var pluginsNode = configXmlDom.createElementNS(null, PLUGINS_ELEM);
    configXmlDom.getDocumentElement().appendChild(pluginsNode);

    return pluginsNode;
}

function getDefinedPluginNames(pluginsNode) {
    var definedPluginNames = new java.util.HashSet();
    if (pluginsNode instanceof org.w3c.dom.Element) {
        var children = pluginsNode.getChildNodes();
        for (var i = 0; i < children.getLength (); i++) {
            var child = children.item(i);
            if (child instanceof org.w3c.dom.Element
                    && PLUGIN_ELEM.equals(child.getTagName())) {
                var pluginName = child.getAttribute(NAME_ATTR);
                definedPluginNames.add(child);
            }
        }
    }

    return definedPluginNames;
}

function updateAndroidManifest(plugins) {
    antHelper.echo("Updating AndroidManifest.xml with Cordova plugin activities...");
    var androidManifestFileLocation = deployUtils.getStagingPath()
            + "/AndroidManifest.xml";
    var androidManifestStream = new java.io.FileInputStream(androidManifestFileLocation);
    var androidManifestIs = new org.xml.sax.InputSource(androidManifestStream);
    var xmlDocument = new XMLDocument(androidManifestIs);
    var androidManifestDom = xmlDocument.load();

    var os = null;
    try {
        var androidManifestFile = new java.io.File(androidManifestFileLocation);
        if (!androidManifestFile.isFile()) {
            throw new CordovaPluginException("The AndroidManifest.xml file could not be found: " + androidManifestFileLocation);
        }

        var appElem = deployUtils.getFirstNamedChildElement(androidManifestDom.getDocumentElement(), APPLICATION_ELEM);
        if (appElem) {
            for (var i = 0; i < plugins.length; i++) {
                var currPlugin = plugins[i];
                var activitiesFragment = currPlugin.getManifestActivities();
                if (activitiesFragment && !EMPTY_STRING.equals(activitiesFragment)) {
                    var fragmentWrapperXml = XML_VERSION_ELEMENT
                        + BEGIN_ROOT_ELEMENT + activitiesFragment
                        + END_ROOT_ELEMENT;
                    var fragmentWrapperDom = getXmlDom(fragmentWrapperXml);
                    if (fragmentWrapperDom) {
                        var node = fragmentWrapperDom.getDocumentElement();
                        if (node) {
                            var importNode = androidManifestDom.importNode(node, true);
                            var activitiesList = deployUtils.getNamedChildElements(importNode, ACTIVITY_ELEM);
                            if (activitiesList.length > 0) {
                                for (var j = 0; j < activitiesList.length; j++) {
                                    var activityNode = activitiesList[j];
                                    appElem.appendChild(activityNode);
                                }
                            }
                        }
                    }
                }
            }
        }

        os = new java.io.FileOutputStream(androidManifestFileLocation);
        xmlDocument.save(os);
    } finally {
        if (androidManifestStream) {
            try {
                androidManifestStream.close();
            } catch (e) {
                // do nothing
            }
        }
        if (os) {
            try {
                os.close();
            } catch (e) {
                // do nothing
            }
        }
    }
}

function createPropertiesFile(plugins) {
    antHelper.echo("Setup extra packages property...");
    var cordovaPluginsProps = new java.util.Properties();
    var packageList = new java.lang.StringBuilder("--extra-packages ");
    var libraryPathsList = new java.lang.StringBuilder();
    var dependentLibPathsList = new java.lang.StringBuilder();
    for (var i = 0; i < plugins.length; i++) {
        var plugin = plugins[i];
        var packageName = plugin.getResourcePackageName();
        if (packageName && !EMPTY_STRING.equals(packageName)) {
            if (!isValidPackageName(packageName)) {
                throw new CordovaPluginException("The plugin, \""
                        + plugin.getName()
                        +"\" has an invalid resource package name: "
                        + packageName);
            }
            packageList.append(packageName);
            packageList.append(":");
        }
        var libraryPaths = getLibraryPaths(plugin);
        if (libraryPaths && !EMPTY_STRING.equals(libraryPaths.trim())) {
            var pluginLibPathsName = "oepe.maf.cordova.plugin.libs.path." + i;
            cordovaPluginsProps.put(pluginLibPathsName, libraryPaths);
            appendPropertyToPath(libraryPathsList, pluginLibPathsName);
        }
        var dependentLibPaths = getDependentLibraryPaths(plugin);
        if (dependentLibPaths && !EMPTY_STRING.equals(dependentLibPaths.trim())) {
            var pluginDependentLibPathsName = "oepe.maf.cordova.plugin.dependent.libs.path." + i;
            cordovaPluginsProps.put(pluginDependentLibPathsName, dependentLibPaths);
            appendPropertyToPath(dependentLibPathsList, pluginDependentLibPathsName);
        }
    }

    var libPathsListProp = "oepe.maf.cordova.plugins.library.paths";
    cordovaPluginsProps.put(libPathsListProp, libraryPathsList.toString());
    var dependLibPathsListProp = "oepe.maf.cordova.plugins.dependent.library.paths";
    cordovaPluginsProps.put(dependLibPathsListProp, dependentLibPathsList.toString());
    var supportJarPath = getAndroidSupportJarPath();
    var supportJarProp = "oepe.maf.android.support.jar.path";
    cordovaPluginsProps.put(supportJarProp, supportJarPath);
    var jarsPath = new java.lang.StringBuilder();
    if (libraryPathsList.length() > 0) {
        appendPropertyToPath(jarsPath, libPathsListProp);
    }
    if (dependentLibPathsList.length() > 0) {
        appendPropertyToPath(jarsPath, dependLibPathsListProp);
    }
    if (supportJarPath && !EMPTY_STRING.equals(supportJarPath.trim())) {
        appendPropertyToPath(jarsPath, supportJarProp);
    }
    cordovaPluginsProps.put("oepe.maf.dex.option.cordova.plugins.jars.path", jarsPath.toString());

    packageList.append(DEFAULT_EXTRA_PACKAGES);
    cordovaPluginsProps.put("oepe.maf.aapt.extra.packages.option", packageList.toString());

    var file = new java.io.File(deployUtils.getStagingPath() + "/cordova-plugin.properties");
    var os = new java.io.FileOutputStream(file);
    try {
        cordovaPluginsProps.store(os, "Created by OEPE mobile builder.  Do not modify");
    } finally {
        if (os !== null) {
            try {
                os.close();
            } catch (e) {
                // do nothing
            }
        }
    }
}

function isValidPackageName(packageName) {
    return packageName.matches(APPLICATION_BUNDLE_ID_REGEX);
}

function getLibraryPaths(plugin) {
    return getJarsFromDir(plugin.getPluginBinDir());
}

function getDependentLibraryPaths(plugin) {
    return getJarsFromDir(plugin.getPluginLibsDir());
}

function getJarsFromDir(pluginDir) {
    var jars = new java.lang.StringBuilder();
    if (pluginDir && pluginDir.isDirectory()) {
        var files = pluginDir.listFiles();
        if (files && files.length > 0) {
            for (var i = 0; i < files.length; i++) {
                var extension = fileUtils.getFileExtension(files[i].getAbsolutePath());
                if (extension && extension.equals(".jar")) {
                    appendPath(jars, files[i].getAbsolutePath());
                }
            }
        }

        if (jars.length() > 0) {
            return jars.toString();
        }
    }

    return null;
}

function getAndroidSupportJarPath() {
    var relativePath = ANDROID_SUPPORT_V4_JAR_RELATIVE_PATH;
    try {
        var minimumSupportedSdkVersion = self.project.getProperty("oepe.maf.android.minSdkVersion");
        if (java.lang.Integer.parseInt(minimumSupportedSdkVersion) >= 13 ) {
            relativePath = ANDROID_SUPPORT_V13_JAR_RELATIVE_PATH;
        }
    } catch (nfe) {
        antHelper.echo("Warning: Invalid minimum SDK value: " + minimumSupportedSdkVersion);
    }

    var sdkPath = self.project.getProperty("sdk.dir");
    if (sdkPath && !EMPTY_STRING.equals(sdkPath)) {
        var supportJarPath = new java.io.File(sdkPath, relativePath);
        if (supportJarPath && supportJarPath.isFile()) {
            return supportJarPath.getAbsolutePath();
        }
    }
    return "";
}

function appendPropertyToPath(path, propertyName) {
    if (path.length() > 0) {
        path.append(";");
    }
    path.append("${");
    path.append(propertyName);
    path.append("}");
}

function appendPath(path, additionalPath) {
    if (additionalPath && additionalPath.length() > 0) {
        if (path.length() > 0) {
            path.append(";");
        }
        path.append(additionalPath);
    }
}

function getXmlDom(xml) {
    var xmlStream = null;
    try {
        xmlStream = new java.io.ByteArrayInputStream(new java.lang.String(xml).getBytes("UTF-8"));
        var inputSource = new org.xml.sax.InputSource(xmlStream);
        var xmlDocument = new XMLDocument(inputSource);
        var xmlDom = xmlDocument.load();
        return xmlDom;
    } finally {
        if (xmlStream) {
            try {
                xmlStream.close();
            } catch (e) {
                // do nothing
            }
        }
    }
}


function AndroidCordovaPluginInfo(name, fullyQualifiedName, implClass, resPackageName, androidManifestActivities, pluginConfig)
{
    this._name = name;
    this._fullyQualifiedName = fullyQualifiedName;
    this._implClass = implClass;
    this._resPackageName = resPackageName;
    this._androidManifestActivities = androidManifestActivities;
    this._pluginConfig = pluginConfig;

    this.getName = function() {
        return this._name;
    }

    this.getFullyQualifiedName = function() {
        return this._fullyQualifiedName;
    }

    this.getImplClass = function() {
        return this._implClass;
    }

    this.getResourcePackageName = function() {
        return this._resPackageName;
    }

    this.getManifestActivities = function() {
        return this._androidManifestActivities;
    }

    this.getPluginResDir = function() {
        var pluginResDir = this._pluginConfig.getPluginResDir();
        if (!pluginResDir || !pluginResDir.isDirectory()) {
            // additional resources are optional
            return null;
        }
        return pluginResDir;
    }

    this.getPluginAssetsDir = function() {
        var assetDirRelPath = "/assets";
        var pluginDir = this._pluginConfig.getPluginDir();
        var pluginAssetsDir = new java.io.File(pluginDir, assetDirRelPath);
        if (!pluginAssetsDir || !pluginAssetsDir.isDirectory()) {
            // assets are optional
            return null;
        }
        return pluginAssetsDir;
    }

    this.getPluginBinDir = function() {
        return this._pluginConfig.getPluginBinDir();
    }

    this.getPluginLibsDir = function() {
        return this._pluginConfig.getPluginLibsDir();
    }

    this.getPluginPreferencesXmlFileLocation = function() {
        var resDir = this.getPluginResDir();
        if (!resDir) {
            // optional
            return null;
        }
        return resDir.getAbsolutePath() + "/xml/preferences.xml";
    }
}
