//Copyright  2014 Oracle and/or its affiliates. All rights reserved.
package maf.code.corner.hr.mobile.beans;

//Copyright  2014 Oracle and/or its affiliates. All rights reserved.

import java.util.ArrayList;

import maf.code.corner.hr.mobile.entities.EmployeesEntity;

import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.bindings.iterator.BasicIterator;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.exception.AdfInvocationException;

public class BrowseEmployeesBean {
    public BrowseEmployeesBean() {
    }

    public void onEmployeeSelect(ActionEvent actionEvent) {
       
        //access iterator binding 
        BasicIterator employeeIterator = (BasicIterator) AdfmfJavaUtilities.getELValue("#{bindings.allEmployeesIterator.iterator}");
        //get the selected employee object represented by the data provider
        EmployeesEntity selectedEmployee = (EmployeesEntity) employeeIterator.getDataProvider();
        
        //set the user selected employee object to the DeptEmpDC as the selected employee data
        EmployeesEntity[] selectedEmp = new EmployeesEntity[1];
        selectedEmp[0] = selectedEmployee;
        
        //prepare method arguments for Data Control call
        ArrayList parameterNames = new ArrayList();
            parameterNames.add("employeeToEdit");
        ArrayList  parameterTypes = new ArrayList();
          parameterTypes.add(EmployeesEntity[].class);
        ArrayList parameterValues = new ArrayList();
            parameterValues.add(selectedEmp);

        try {
            AdfmfJavaUtilities.invokeDataControlMethod("DeptEmpDC", null, "setEditableEmployee", parameterNames,
                                                       parameterValues, parameterTypes);
            
        } catch (AdfInvocationException e) {
            //just print stack trace for now. In a production application you would
            //use logging for cases in which you can recover from failure
            e.printStackTrace();
        }
    }
}

