//Copyright  2014 Oracle and/or its affiliates. All rights reserved.
package maf.code.corner.hr.mobile.entities;

//Copyright  2014 Oracle and/or its affiliates. All rights reserved.

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class DepartmentsEntity {
    
    private Integer departmentId = null;
    private String departmentName = null;
    private Integer locationId = null;
    private Integer managerId = null;
    
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DepartmentsEntity() {
        super();
    }


    public void setDepartmentId(Integer departmentId) {
        Integer oldDepartmentId = this.departmentId;
        this.departmentId = departmentId;
        propertyChangeSupport.firePropertyChange("departmentId", oldDepartmentId, departmentId);
    }

    public Integer getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentName(String departmentName) {
        String oldDepartmentName = this.departmentName;
        this.departmentName = departmentName;
        propertyChangeSupport.firePropertyChange("departmentName", oldDepartmentName, departmentName);
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setLocationId(Integer locationId) {
        Integer oldLocationId = this.locationId;
        this.locationId = locationId;
        propertyChangeSupport.firePropertyChange("locationId", oldLocationId, locationId);
    }

    public Integer getLocationId() {
        return locationId;
    }

    public void setManagerId(Integer managerId) {
        Integer oldManagerId = this.managerId;
        this.managerId = managerId;
        propertyChangeSupport.firePropertyChange("managerId", oldManagerId, managerId);
    }

    public Integer getManagerId() {
        return managerId;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }
    
    public Object clone() {

        DepartmentsEntity dept = new DepartmentsEntity();

        dept.setDepartmentId(departmentId);
        dept.setDepartmentName(departmentName);
        dept.setLocationId(locationId);
        dept.setManagerId(managerId);

        return dept;
    }
}
