//Copyright  2014 Oracle and/or its affiliates. All rights reserved.
package maf.code.corner.hr.mobile.entities;

//Copyright  2014 Oracle and/or its affiliates. All rights reserved.

import java.util.Date;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;


public class EmployeesEntity {
    
    private Double commissionPct = null;
    private String email = null;
    private Integer employeeId = null;
    private String firstName = null;
    private Date hireDate = null;
    private String jobId = null;
    private String lastName = null;
    private Integer managerId = null;
    private String phoneNumber = null;
    private Integer salary = null;
    
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public EmployeesEntity() {
        super();
    }


    public void setCommissionPct(Double commissionPct) {
        Double oldCommissionPct = this.commissionPct;
        this.commissionPct = commissionPct;
        propertyChangeSupport.firePropertyChange("commissionPct", oldCommissionPct, commissionPct);
    }

    public Double getCommissionPct() {
        return commissionPct;
    }

    public void setEmail(String email) {
        String oldEmail = this.email;
        this.email = email;
        propertyChangeSupport.firePropertyChange("email", oldEmail, email);
    }

    public String getEmail() {
        return email;
    }

    public void setEmployeeId(Integer employeeId) {
        Integer oldEmployeeId = this.employeeId;
        this.employeeId = employeeId;
        propertyChangeSupport.firePropertyChange("employeeId", oldEmployeeId, employeeId);
    }

    public Integer getEmployeeId() {
        return employeeId;
    }

    public void setFirstName(String firstName) {
        String oldFirstName = this.firstName;
        this.firstName = firstName;
        propertyChangeSupport.firePropertyChange("firstName", oldFirstName, firstName);
    }

    public String getFirstName() {
        return firstName;
    }

    public void setHireDate(Date hireDate) {
        Date oldHireDate = this.hireDate;
        this.hireDate = hireDate;
        propertyChangeSupport.firePropertyChange("hireDate", oldHireDate, hireDate);
    }

    public Date getHireDate() {
        return hireDate;
    }

    public void setJobId(String jobId) {
        String oldJobId = this.jobId;
        this.jobId = jobId;
        propertyChangeSupport.firePropertyChange("jobId", oldJobId, jobId);
    }

    public String getJobId() {
        return jobId;
    }

    public void setLastName(String lastName) {
        String oldLastName = this.lastName;
        this.lastName = lastName;
        propertyChangeSupport.firePropertyChange("lastName", oldLastName, lastName);
    }

    public String getLastName() {
        return lastName;
    }

    public void setManagerId(Integer managerId) {
        Integer oldManagerId = this.managerId;
        this.managerId = managerId;
        propertyChangeSupport.firePropertyChange("managerId", oldManagerId, managerId);
    }

    public Integer getManagerId() {
        return managerId;
    }

    public void setPhoneNumber(String phoneNumber) {
        String oldPhoneNumber = this.phoneNumber;
        this.phoneNumber = phoneNumber;
        propertyChangeSupport.firePropertyChange("phoneNumber", oldPhoneNumber, phoneNumber);
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setSalary(Integer salary) {
        Integer oldSalary = this.salary;
        this.salary = salary;
        propertyChangeSupport.firePropertyChange("salary", oldSalary, salary);
    }

    public Integer getSalary() {
        return salary;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }
    
    public Object clone() {

        EmployeesEntity emp = new EmployeesEntity();

        emp.setCommissionPct(commissionPct);
        emp.setEmail(email);
        emp.setEmployeeId(employeeId);
        emp.setFirstName(firstName);
        emp.setHireDate(hireDate);
        emp.setJobId(jobId);
        emp.setLastName(lastName);
        emp.setManagerId(managerId);
        emp.setPhoneNumber(phoneNumber);
        emp.setSalary(salary);
        return emp;
    }
}
