//Copyright  2014 Oracle and/or its affiliates. All rights reserved.
package maf.code.corner.hr.mobile.json.helper;

import maf.code.corner.hr.mobile.entities.DepartmentsEntity;

//Copyright  2014 Oracle and/or its affiliates. All rights reserved.

public class DepartmentEntityToJson {
    public DepartmentEntityToJson() {
        super();
    }
    
    /**
     * Converts local department entity to JSON object string
     * Example:
     * {
     *      "departmentId" : 10,
     *      "departmentName" : "Administration",
     *      "locationId" : 1700,
     *      "managerId" : 200
     *  }
     * @param department
     * @return
     */
    public static String getJson(DepartmentsEntity department){
        
    StringBuffer sb = new StringBuffer();
    sb.append("{");
    
    if(department.getDepartmentId()!=null){
     sb.append("\"departmentId\":\"");
     sb.append(department.getDepartmentId()+"\",");
    }
    if(department.getDepartmentName()!=null){
     sb.append("\"departmentName\":\"");
     sb.append(department.getDepartmentName()+"\",");
    }
    if(department.getLocationId()!=null){
     sb.append("\"locationId\":\"");
     sb.append(department.getLocationId()+"\",");
    }
    if(department.getManagerId()!= null){
     sb.append("\"managerId\":\"");
     sb.append(department.getManagerId()+"\",");
    }

    sb.deleteCharAt(sb.lastIndexOf(","));
    
    sb.append("}");
    
    String jsonObject = sb.toString();     
                
    return jsonObject;
    
    }
}