//Copyright  2014 Oracle and/or its affiliates. All rights reserved.
package maf.code.corner.hr.mobile.json.helper;

//Copyright  2014 Oracle and/or its affiliates. All rights reserved.

import com.sun.util.logging.Level;

import maf.code.corner.hr.mobile.entities.EmployeesEntity;

import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.util.logging.Trace;

public class EmployeesEntityToJson {
    public EmployeesEntityToJson() {
        super();
    }
    
    /**
     * Converts local employees entity to JSON object string
     * Example:
     * {
     *       "employeeId" : 100,
     *       "firstName" : "Steven",
     *       "lastName" : "King",
     *       "hireDate" : "1987-06-17",
     *       "jobId" : "AD_PRES",
     *       "email" : "SKING",
     *       "phoneNumber" : "515.123.4567",
     *       "salary" : 24000,
     *       "commissionPct":0.2
     * }
     * @param employee
     * @return
     */
    public static String getJson(EmployeesEntity employee){
        
        JSONBeanSerializationHelper jbsh = new JSONBeanSerializationHelper();
        
        String jsonObject = null;
        
        try {
            jsonObject = (String) jbsh.toJSON(employee);
        } catch (Exception e) {
            Trace.log("EmployeesEntityToJson",Level.SEVERE, JsonArrayToDepartmentsArray.class,"getJson", "Parsing of entity to REST JSON payload failed: "+e.getLocalizedMessage());
        }  
                    
        return jsonObject;
    
    }
}