//Copyright  2014 Oracle and/or its affiliates. All rights reserved.
package maf.code.corner.hr.mobile.json.helper;

//Copyright  2014 Oracle and/or its affiliates. All rights reserved.

import com.sun.util.logging.Level;

import maf.code.corner.hr.mobile.entities.EmployeesEntity;
import maf.code.corner.hr.mobile.json.dao.EmployeesResultArray;

import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.util.logging.Trace;

public class JsonArrayToEmployeesArray {
    public JsonArrayToEmployeesArray() {
        super();
    }
    
    public static EmployeesEntity[] getEmployeesArray(String jsonArrayAsString){
        

        EmployeesResultArray employeesResult = null;
        
        //object that serializes the JSON payload into the Java object
        JSONBeanSerializationHelper jbsh = new JSONBeanSerializationHelper();
     
        
        try {
            employeesResult = (EmployeesResultArray) jbsh.fromJSON(EmployeesResultArray.class, jsonArrayAsString);           
           

        } catch (Exception e) {
            Trace.log("JSONArray_to_JavaArray",Level.SEVERE, JsonArrayToEmployeesArray.class,"getEmployeesArray", "Parsing of REST response failed: "+e.getLocalizedMessage());
        }

      return employeesResult.getEmployees();
    }
}