package maf.code.corner.sample;

import java.util.List;

import javax.ejb.Local;

import maf.code.corner.sample.entities.Departments;
import maf.code.corner.sample.entities.Employees;

@Local
public interface HrServiceLocal {
    Object queryByRange(String jpqlStmt, int firstResult, int maxResults);

    <T> T persistEntity(T entity);

    <T> T mergeEntity(T entity);

    Departments persistDepartments(Departments departments);

    Departments mergeDepartments(Departments departments);

    void removeDepartments(Departments departments);

    List<Departments> getDepartmentsFindAll();

    Employees persistEmployees(Employees employees);

    Employees mergeEmployees(Employees employees);

    void removeEmployees(Employees employees);

    List<Employees> getEmployeesFindAll();

    Departments findDepartment(Integer departmentId);

    Employees getEmployee(Integer employeeId);

    List<Employees> getEmployeesFindByDepartment(Integer departmentId);
}
