package maf.code.corner.sample.entities;

import java.io.Serializable;

import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * Departments.java
 *
 *
 * Entity bea that uses JAXB to convert to XML or JSON format to be used with REST Service accessing this EJB
 *
 * @author Frank Nimphius, 2014
 * @version 1.0
 *
 */
@Entity
@NamedQueries({ @NamedQuery(name = "Departments.findAll", query = "select o from Departments o") })
@SequenceGenerator(name = "Departments_Id_Seq_Gen", sequenceName = "DEPARTMENTS_ID_SEQ_GEN", allocationSize = 50,
                   initialValue = 200)
@XmlRootElement
@XmlType(propOrder = { "departmentId", "departmentName", "locationId", "managerId"})
@XmlSeeAlso (Employees.class)
public class Departments implements Serializable {
    private static final long serialVersionUID = -2247671566880508556L;
    @Id
    @Column(name = "DEPARTMENT_ID", nullable = false)
    private Integer departmentId;
    @Column(name = "DEPARTMENT_NAME", nullable = false, length = 30)
    private String departmentName;
    @Column(name = "LOCATION_ID")
    private Integer locationId;
    @Column(name = "MANAGER_ID")
    private Integer managerId;
    @OneToMany(mappedBy = "departments", cascade = { CascadeType.PERSIST, CascadeType.MERGE })
    private List<Employees> employeeList;

    public Departments() {
    }

    public Departments(Integer departmentId, String departmentName, Integer locationId, Integer managerId) {
        this.departmentId = departmentId;
        this.departmentName = departmentName;
        this.locationId = locationId;
        this.managerId = managerId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getDepartmentId() {
        return departmentId;
    }

    @XmlElement
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    @XmlElement
    public Integer getLocationId() {
        return locationId;
    }

    public void setLocationId(Integer locationId) {
        this.locationId = locationId;
    }

    @XmlElement
    public Integer getManagerId() {
        return managerId;
    }

    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    @XmlTransient
    @XmlElement(name="employeesInDepartment")
    public List<Employees> getEmployeeList() {
        return employeeList;
    }

    public void setEmployeeList(List<Employees> employeesList1) {
        this.employeeList = employeesList1;
    }

    public Employees addEmployees(Employees employees) {
        getEmployeeList().add(employees);
        employees.setDepartments(this);
        return employees;
    }

    public Employees removeEmployees(Employees employees) {
        getEmployeeList().remove(employees);
        employees.setDepartments(null);
        return employees;
    }
}
