package maf.code.corner.sample.rs.resources;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import maf.code.corner.sample.HrServiceLocal;
import maf.code.corner.sample.entities.Departments;
import maf.code.corner.sample.entities.Employees;
import maf.code.corner.sample.rs.resources.base.DeptsImpl;

/**
 *  Annotated REST SubResource class. Its a design decision for this sample application to separate the REST annotations
 *  from the EJB access code. The benefit is that the sources are easier to read as if as if all code lines would be in 
 *  a single file.
 *
 *  @author Frank Nimphius 2014
 */
public class DeptsRestImpl extends DeptsImpl {
    
    public DeptsRestImpl(){
      super();
    };
    
    public DeptsRestImpl(HrServiceLocal hrServiceLocal, List<Departments> departments) {
        super(hrServiceLocal,departments);
    }

    @PUT
    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    public Response create(Departments d) {
        // TODO Implement this method
        return super.create(d);
    }

    @DELETE
    @Path("remove/{departmentId}")
    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    public Response delete(@PathParam ("departmentId") Integer departmentId) {
        // TODO Implement this method
        return super.delete(departmentId);
    }

    @GET
    @Produces("application/json, application/xml")
    public Response getDepartmentsList() {
        return super.getDepartmentsList();
    }

    public void setDepartmentsList(List<Departments> departmentsList) {
        // TODO Implement this method
        super.setDepartmentsList(departmentsList);
    }


    @POST
    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    public Response update(Departments updatedDepartment) {
        // TODO Implement this method
        return super.update(updatedDepartment);
    }


    @Path("/{departmentId}")
    @GET
    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    public Response findDepartment(@PathParam ("departmentId") Integer departmentId) {
        return super.findDepartment(departmentId);
    }

    @PUT
    @Path("/{departmentId}/employee")
    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    public Response createEmployee(@PathParam ("departmentId") Integer departmentId, Employees e) {
        return super.createEmployee(departmentId, e);
    }
    
    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    @Path("{departmentId}/employees")
    @GET
    public Response getEmployeesInDepartment(@PathParam ("departmentId") Integer departmentId) {
        return super.getEmployeesInDepartment(departmentId);
    }
}
