package maf.code.corner.sample.rs.resources;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

import maf.code.corner.sample.HrServiceLocal;
import maf.code.corner.sample.entities.Employees;
import maf.code.corner.sample.rs.resources.base.EmpsImpl;


 /**
  *  Annotated REST SubResource class. Its a design decision for this sample application to separate the REST annotations
  *  from the EJB access code. The benefit is that the sources are easier to read as if as if all code lines would be in 
  *  a single file.
  *
  *  @author Frank Nimphius 2014
  */
public class EmpsRestImpl extends EmpsImpl {
    
    public EmpsRestImpl(){super();};
    
    public EmpsRestImpl(HrServiceLocal hrServiceLocal, List<Employees> employees) {
        super(hrServiceLocal,employees);
    }

    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    @PUT
    public Response create(Employees e) {
        return super.create(e);
    }

    @DELETE
    @Path("remove/{employeeId}")
    @Consumes("application/json, application/xml")
    public Response delete(@PathParam ("employeeId") Integer employeeId) {
        return super.delete(employeeId);
    }

    @GET
    @Produces("application/json, application/xml")
    public Response getEmployeeList() {
        return super.getEmployeeList();
    }

    public void setEmployeeList(List<Employees> employeeList) {
        super.setEmployeeList(employeeList);
    }

    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    @POST
    public Response update(Employees updatedEmployee) {
        return super.update(updatedEmployee);
    }


    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    @Path("/{employeeId}")
    @GET
    public Response findEmployee(@PathParam ("employeeId") Integer employeeId) {
        return super.findEmployee(employeeId);
    }

    @Produces("application/json, application/xml")
    @Consumes("application/json, application/xml")
    @Path("/relocate")
    @POST
    public Response relocateEmployee(@QueryParam("departmentId") Integer departmentId,@QueryParam ("empoyeeId") Integer employeeId) {
        return super.relocateEmployee(departmentId, employeeId);
    }
}
