package maf.code.corner.sample.rs.resources.base;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import maf.code.corner.sample.HrServiceLocal;
import maf.code.corner.sample.entities.Departments;
import maf.code.corner.sample.entities.Employees;
import maf.code.corner.sample.rs.lists.DeptList;
import maf.code.corner.sample.rs.lists.EmpList;

/**
 /**
 *  Its a design decision for this sample application to separate the REST annotations from the EJB access code. The 
 *  benefit is that the sources are easier to read as if as if all code lines would be in a single file. This class is
 *  an EJB implementation class to provide data to the REST service  
 * 
 * //TODO add proper error handling and messages instead of throwing WebApplicationException 
 * @author Frank Nimphius 2014
 */
public class DeptsImpl {
    
    List<Departments> departmentsList = null;
    HrServiceLocal hrServiceLocal = null;
    
    
    public DeptsImpl(){};
    
    public DeptsImpl(HrServiceLocal hrServiceLocal, List<Departments> departmentsList) {
        super();
        this.hrServiceLocal = hrServiceLocal;
        this.departmentsList = departmentsList;
    }

    public void setDepartmentsList(List<Departments> departmentsList) {
        this.departmentsList = departmentsList;
    }

    public Response getDepartmentsList() {
        if(departmentsList == null){
           departmentsList = hrServiceLocal.getDepartmentsFindAll();
        }
        DeptList deptList = new DeptList();
        deptList.setDepts(departmentsList);
        return Response.ok(deptList).build();
    }
    
    public Response delete(Integer departmentId){
      Departments d =  hrServiceLocal.findDepartment(departmentId);
      
        //throw a resource not found exception
        if(d == null){
            WebApplicationException waex = new WebApplicationException("Department "+departmentId+" not found",400);
            throw waex;
        }
      
      hrServiceLocal.removeDepartments(d);
      return Response.ok().build();
    }
    
    /**
     * Updates the current department object with changed attribute values of the updated department object. The employees
     * list is not updated as it is not contained in the REST payload. All departments interaction is performed by this class. 
     * The sub-classes of this class mainly show responsible for setting the response payload and the to define the REST
     * path and query parameters
     * 
     * @param updatedDepartment
     * @return
     */
    public Response update(Departments updatedDepartment){
      Departments currentDepartment =  hrServiceLocal.findDepartment(updatedDepartment.getDepartmentId());
      
      //throw a resource not found exception
      if(currentDepartment == null){
          WebApplicationException waex = new WebApplicationException("Department "+updatedDepartment.getDepartmentId()+" not found",400);
          throw waex;
      }
      
      if(updatedDepartment.getManagerId()!=null){currentDepartment.setManagerId(updatedDepartment.getManagerId());};
      if(updatedDepartment.getDepartmentName()!=null){currentDepartment.setDepartmentName(updatedDepartment.getDepartmentName());};
      if(updatedDepartment.getLocationId()!=null){currentDepartment.setLocationId(updatedDepartment.getLocationId());};
        
      Departments update = hrServiceLocal.mergeDepartments(currentDepartment);    
      
      return Response.ok(update).build();
    }
    
    public Response create(Departments d){
      Departments persistedDepartment = hrServiceLocal.persistDepartments(d);
      return Response.ok(persistedDepartment).build();
    }
    
    public Response findDepartment(Integer departmentId){
       Departments department =  hrServiceLocal.findDepartment(departmentId); 
       
       //throw a resource not found exception
       if(department == null){
           WebApplicationException waex = new WebApplicationException("Department "+departmentId+" not found",400);
           throw waex;
       }
       
       //return list, which is easier to work with in MAF bindings
       ArrayList<Departments> departmentsList = new ArrayList<Departments>();
       departmentsList.add(department);
       DeptList deptList = new DeptList();
       deptList.setDepts(departmentsList);
       return Response.ok(deptList).build();
    }
    
    //create new employee for department
    public Response createEmployee(Integer departmentId, Employees e){
        Departments dept = hrServiceLocal.findDepartment(departmentId);
        
            if(dept == null){
                WebApplicationException waex = new WebApplicationException("Department "+departmentId+" not found", 400);
                throw waex;
            }
        
        Employees newEmployee = new Employees();
        newEmployee.setEmployeeId(e.getEmployeeId());
        newEmployee.setEmail(e.getEmail());
        newEmployee.setFirstName(e.getFirstName());
        newEmployee.setLastName(e.getLastName());
        newEmployee.setHireDate(e.getHireDate());
        newEmployee.setJobId(e.getJobId());
        newEmployee.setManagerId(e.getManagerId());
        newEmployee.setPhoneNumber(e.getPhoneNumber());
        newEmployee.setSalary(e.getSalary());
        newEmployee.setCommissionPct(e.getCommissionPct());
        newEmployee = hrServiceLocal.persistEmployees(newEmployee);
        dept.addEmployees(newEmployee);
        dept = hrServiceLocal.mergeEntity(dept);
        return Response.ok(newEmployee).build();
    }
    
    public Response getEmployeesInDepartment(Integer departmentId){
        EmpList empList = new EmpList();
        empList.setEmps(hrServiceLocal.getEmployeesFindByDepartment(departmentId));
        return Response.ok(empList).build();
    }
}
