package maf.code.corner.sample.rs.resources.base;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import maf.code.corner.sample.HrServiceLocal;
import maf.code.corner.sample.entities.Departments;
import maf.code.corner.sample.entities.Employees;
import maf.code.corner.sample.rs.lists.EmpList;

 /**
  /**
  *  Its a design decision for this sample application to separate the REST annotations from the EJB access code. The 
  *  benefit is that the sources are easier to read as if as if all code lines would be in a single file. This class is
  *  an EJB implementation class to provide data to the REST service  
  * 
  * //TODO add proper error handling and messages instead of throwing WebApplicationException 
  * @author Frank Nimphius 2014
  */
public class EmpsImpl {
    
    List<Employees> employeeList = null;
    HrServiceLocal hrServiceLocal = null;
    
    public EmpsImpl(){};
    
    public EmpsImpl(HrServiceLocal hrServiceLocal, List<Employees> employeeList) {
        super();
        this.hrServiceLocal = hrServiceLocal;
        this.employeeList = employeeList;
    }

    public void setEmployeeList(List<Employees> employeeList) {
        this.employeeList = employeeList;
    }

    public Response getEmployeeList() {
        if(employeeList == null){
           employeeList = hrServiceLocal.getEmployeesFindAll();
        }
        EmpList empList = new EmpList();
        empList.setEmps(employeeList);
        return Response.ok(empList).build();
    }
    
    public Response delete(Integer employeeId){
      Employees e =  hrServiceLocal.getEmployee(employeeId);
      
        //throw a resource not found exception
        if(e == null){
            WebApplicationException waex = new WebApplicationException("Employee "+employeeId+" not found",400);
            throw waex;
        }
      
      hrServiceLocal.removeEmployees(e);
      return Response.ok().build();
    }
    
    /**
     * Updates the current department object with changed attribute values of the updated department object. The employees
     * list is not updated as it is not contained in the REST payload
     * 
     * @param updatedEmployee
     * @return
     */
    public Response update(Employees updatedEmployee){
      Employees currentEmployee =  hrServiceLocal.getEmployee(updatedEmployee.getEmployeeId());
      //throw a resource not found exception
      if(currentEmployee == null){
          WebApplicationException waex = new WebApplicationException("Employee "+updatedEmployee.getEmployeeId()+" not found",400);
          throw waex;
      }
      
      if(updatedEmployee.getEmail() != null){ currentEmployee.setEmail(updatedEmployee.getEmail()); };
      if(updatedEmployee.getFirstName() != null){currentEmployee.setFirstName(updatedEmployee.getFirstName());};
      if(updatedEmployee.getLastName() != null){currentEmployee.setLastName(updatedEmployee.getLastName());};
      if(updatedEmployee.getHireDate() != null){currentEmployee.setHireDate(updatedEmployee.getHireDate());};
      if(updatedEmployee.getJobId() != null){currentEmployee.setJobId(updatedEmployee.getJobId());};
      if(updatedEmployee.getManagerId() != null){currentEmployee.setManagerId(updatedEmployee.getManagerId());};
      if(updatedEmployee.getPhoneNumber() != null){currentEmployee.setPhoneNumber(updatedEmployee.getPhoneNumber());};
      if(updatedEmployee.getSalary() != null){currentEmployee.setSalary(updatedEmployee.getSalary());};
      if(updatedEmployee.getCommissionPct() != null){currentEmployee.setCommissionPct(updatedEmployee.getCommissionPct());};
           
      Employees update = hrServiceLocal.mergeEmployees(currentEmployee);    
      
      return Response.ok(update).build();
    }
    
    public Response create(Employees e){
      Employees persistedEmployee = hrServiceLocal.persistEmployees(e);
      return Response.ok(persistedEmployee).build();
    }
    
    public Response findEmployee(Integer employeeId){
       Employees employee =  hrServiceLocal.getEmployee(employeeId); 
       //throw a resource not found exception with message
       if(employee == null){
           WebApplicationException waex = new WebApplicationException("Employee "+employeeId+" not found",400);
           throw waex;
       }
       
        //return list, which is easier to work with in MAF bindings
        ArrayList<Employees> employeeList = new ArrayList<Employees>();
        employeeList.add(employee);
        EmpList empList = new EmpList();
        empList.setEmps(employeeList);
        return Response.ok(empList).build();
    }
    
    //relocate employee to a new department
    public Response relocateEmployee(Integer departmentId, Integer employeeId){
        Departments d = hrServiceLocal.findDepartment(departmentId);
        Employees e = hrServiceLocal.getEmployee(employeeId);
        
        //throw a resource not found exception
        if(d == null || e == null){
            WebApplicationException waex = new WebApplicationException("Department "+departmentId+" or Employee "+employeeId+" not found",400);
            throw waex;
        }
        
        e.setDepartments(d);
        hrServiceLocal.mergeEmployees(e);
        
        return Response.ok().build();
    }
}
