package maf.code.corner.sample.rs.services;

import javax.ejb.EJB;
import javax.ejb.Singleton;

import javax.ws.rs.GET;
import javax.ws.rs.Path;

import javax.ws.rs.core.Response;

import maf.code.corner.sample.HrServiceLocal;
import maf.code.corner.sample.rs.resources.DeptsRestImpl;
import maf.code.corner.sample.rs.resources.EmpsRestImpl;
import maf.code.corner.sample.rs.resources.base.DeptsImpl;
import maf.code.corner.sample.rs.resources.base.EmpsImpl;

/**
 * HrRestService REST service class.
 *
 * Note: this REST service has been created for demonstration and testing puposes. Its not meant to be production
 * quality and instead expected to evolve over time with additional functionality that will close gaps that exist
 * in this current implementation (e.g. improved error and exception handling)
 * 
 * This class is the root service class that branches to two different REST implementation classes that implement 
 * CRUD operations for the departments and employees data in the Oracle HR schema. The architecture of this sample
 * is such that the implementation (which currently is EJB based) can be changed without impacting the service API
 *
 * @author Frank Nimphius
 * @version initial, 2014
 */
@Path("hrappsrvc")
@Singleton
public class HrRestService {
    
    @EJB
    HrServiceLocal hrService;
    public HrRestService() {
        super();
    }
    
    //method for testing the root resource
    @GET
    public Response rootUriOk(){
       return Response.ok().build();    
    }
    
    @Path("/departments")
    public DeptsRestImpl getAllDepartments(){
        //passing null as the second argument makes the service to read the full 
        //lis of departments from the EJB model
        return new DeptsRestImpl(hrService, null);
    }
    
    @Path("/employees")
    public EmpsRestImpl getAllDepartmentsXml(){
        //passing null as the second argument makes teh service to read the full lis of departments
        //from the EJB model
        return new EmpsRestImpl(hrService, null);
    }
    
}
