CREATE TABLE S_WAREHOUSE 
(
  ID NUMBER(7, 0) NOT NULL 
, ADDRESS VARCHAR2 (50 BYTE) 
, CITY VARCHAR2(30 BYTE) 
, STATE VARCHAR2(20 BYTE) 
, COUNTRY_ID VARCHAR2(30 BYTE) 
, ZIP_CODE VARCHAR2(75 BYTE) 
, LATITUDE NUMBER
, LONGITUDE NUMBER
, PHONE VARCHAR2(25 BYTE) 
, MANAGER_ID NUMBER(7, 0) 
, CONSTRAINT S_WAREHOUSE_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_TITLE 
(
  TITLE_ID NUMBER(7, 0) NOT NULL 
, TITLE VARCHAR2(20) 
, CONSTRAINT S_TITLE_PK PRIMARY KEY 
  (
    TITLE_ID 
  )
  ENABLE 
);

CREATE TABLE S_REGION 
(
  ID NUMBER(7, 0) NOT NULL 
, NAME VARCHAR2(50 BYTE) NOT NULL 
, CONSTRAINT S_REGION_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_COUNTRIES 
(
  ID NUMBER(7, 0) NOT NULL 
, COUNTRY VARCHAR2(50) 
, REGION_ID NUMBER(7, 0)
, COUNTRY_CODE VARCHAR2(2)
, CONSTRAINT S_COUNTRIES_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
);

CREATE TABLE S_PRODUCT 
(
  ID NUMBER(7, 0) NOT NULL 
, NAME VARCHAR2(50 BYTE) NOT NULL 
, SHORT_DESC VARCHAR2(255 BYTE) 
, LONGTEXT_ID NUMBER(7, 0) 
, IMAGE_ID NUMBER(7, 0)
, CATEGORY_ID NUMBER(7, 0)
, SUGGESTED_WHLSL_PRICE NUMBER(11, 2) 
, WHLSL_UNITS VARCHAR2(25 BYTE) 
, CONSTRAINT S_PRODUCT_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_PAYMENT_TYPE 
(
  ID NUMBER(7, 0) NOT NULL 
, PAYMENT_TYPE VARCHAR2(20) NOT NULL 
, DESCRIPTION VARCHAR2(100) 
, CONSTRAINT S_PAYMENT_TYPE_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
);

CREATE TABLE S_ORD 
(
  ID NUMBER(7, 0) NOT NULL 
, CUSTOMER_ID NUMBER(7, 0) NOT NULL 
, DATE_ORDERED DATE 
, DATE_SHIPPED DATE 
, SALES_REP_ID NUMBER(7, 0) 
, TOTAL NUMBER(11, 2) 
, PAYMENT_TYPE_ID NUMBER(7, 0)
, PAYMENT_OPTION_ID NUMBER (7,0)
, ORDER_FILLED VARCHAR2(1 BYTE) 
, CONSTRAINT S_ORD_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 1638400 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_LONGTEXT 
(
  ID NUMBER(7, 0) NOT NULL 
, USE_FILENAME VARCHAR2(1 BYTE) 
, FILENAME VARCHAR2(255 BYTE) 
, TEXT VARCHAR2(2000 BYTE) 
, CONSTRAINT S_LONGTEXT_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_ITEM_AUDIT 
(
  A NUMBER 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 26542080 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_ITEM 
(
  ORD_ID NUMBER(7, 0) NOT NULL 
, ITEM_ID NUMBER(7, 0) NOT NULL 
, PRODUCT_ID NUMBER(7, 0) NOT NULL 
, PRICE NUMBER(11, 2) 
, QUANTITY NUMBER(9, 0) 
, QUANTITY_SHIPPED NUMBER(9, 0) 
, CONSTRAINT S_ITEM_ORDID_ITEMID_PK PRIMARY KEY 
  (
    ORD_ID 
  , ITEM_ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 1638400 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_INVENTORY 
(
  PRODUCT_ID NUMBER(7, 0) NOT NULL 
, WAREHOUSE_ID NUMBER(7, 0) NOT NULL 
, AMOUNT_IN_STOCK NUMBER(9, 0) 
, REORDER_POINT NUMBER(9, 0) 
, MAX_IN_STOCK NUMBER(9, 0) 
, OUT_OF_STOCK_EXPLANATION VARCHAR2(255 BYTE) 
, RESTOCK_DATE DATE 
, CONSTRAINT S_INVENTORY_PRODID_WARID_PK PRIMARY KEY 
  (
    PRODUCT_ID 
  , WAREHOUSE_ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_IMAGE 
(
  ID NUMBER(7, 0) NOT NULL 
, FORMAT VARCHAR2(25 BYTE) 
, USE_FILENAME VARCHAR2(1 BYTE) 
, FILENAME VARCHAR2(255 BYTE) 
, IMAGE BLOB 
, CONSTRAINT S_IMAGE_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_EMP 
(
  ID NUMBER(7, 0) NOT NULL 
, LAST_NAME VARCHAR2(25 BYTE) NOT NULL 
, FIRST_NAME VARCHAR2(25 BYTE) 
, USERID VARCHAR2(8 BYTE) 
, EMAIL VARCHAR2(100 BYTE) 
, START_DATE DATE 
, COMMENTS VARCHAR2(255 BYTE) 
, MANAGER_ID NUMBER(7, 0) 
, TITLE_ID NUMBER 
, DEPT_ID NUMBER(7, 0) 
, SALARY NUMBER(11, 2) 
, COMMISSION_PCT NUMBER(4, 2) 
, CONSTRAINT S_EMP_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_DEPT 
(
  ID NUMBER(7, 0) NOT NULL 
, NAME VARCHAR2(25 BYTE) NOT NULL 
, REGION_ID NUMBER(7, 0) 
, CONSTRAINT S_DEPT_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_CREDIT_RATING 
(
  ID NUMBER(7, 0) NOT NULL 
, CREDIT_RATING VARCHAR2(20) NOT NULL 
, DESCRIPTION VARCHAR2(200) 
, CONSTRAINT S_CREDIT_RATING_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
);

CREATE TABLE S_PAYMENT_OPTIONS
(	
  ID NUMBER(7,0) NOT NULL
, CUSTOMER_ID NUMBER(7,0) NOT NULL
, PAYMENT_TYPE VARCHAR2(30 BYTE) NOT NULL ENABLE
, ACCOUNT_NUMBER NUMBER(19,0) NOT NULL ENABLE 
, CARD_TYPE VARCHAR2(30 BYTE)
, EXPIRE_DATE DATE 
, CHECK_DIGITS NUMBER(4,0) 
, ROUTING_IDENTIFIER VARCHAR2(15 BYTE) 
, INSTITUTION_NAME VARCHAR2(120 BYTE)
, CONSTRAINT S_PAYMENT_OPTIONS_PK PRIMARY KEY 
  (
  ID
  )
  ENABLE
);


CREATE TABLE S_CUSTOMER 
(
  ID NUMBER(7, 0) NOT NULL 
, NAME VARCHAR2(50 BYTE) NOT NULL 
, PHONE VARCHAR2(25 BYTE) 
, ADDRESS VARCHAR2(400 BYTE) 
, CITY VARCHAR2(30 BYTE) 
, STATE VARCHAR2(20 BYTE) 
, COUNTRY_ID NUMBER(7, 0) 
, ZIP_CODE VARCHAR2(75 BYTE) 
, CREDIT_RATING_ID NUMBER(7, 0) 
, SALES_REP_ID NUMBER(7, 0) 
, COMMENTS VARCHAR2(255 BYTE) 
, CONSTRAINT S_CUSTOMER_ID_PK PRIMARY KEY 
  (
    ID 
  )
  ENABLE 
) 
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);

CREATE TABLE S_PRODUCT_CATEGORIES
(
  ID              NUMBER (7, 0) NOT NULL
, CATEGORY        VARCHAR2(50 BYTE)
, PARENT_CATEGORY_ID NUMBER (7, 0)
, CONSTRAINT "PRODUCT_CATEGORIES_PK" PRIMARY KEY 
  (
   ID
  ) 
  ENABLE
)
LOGGING 
TABLESPACE "USERS" 
PCTFREE 10 
PCTUSED 40 
INITRANS 1 
STORAGE 
( 
  INITIAL 65536 
  MINEXTENTS 1 
  MAXEXTENTS 2147483645 
  FREELISTS 1 
  FREELIST GROUPS 1 
  BUFFER_POOL DEFAULT 
);


ALTER TABLE S_COUNTRIES
ADD CONSTRAINT S_COUNTRIES_UK UNIQUE 
(
  COUNTRY 
)
ENABLE;

ALTER TABLE S_PAYMENT_TYPE
ADD CONSTRAINT S_PAYMENT_TYPE_UK UNIQUE 
(
  PAYMENT_TYPE 
)
ENABLE;

ALTER TABLE S_CREDIT_RATING
ADD CONSTRAINT S_CREDIT_RATING_UK UNIQUE 
(
  CREDIT_RATING 
)
ENABLE;

ALTER TABLE S_REGION
ADD CONSTRAINT S_REGION_NAME_UK UNIQUE 
(
  NAME 
)
ENABLE;

ALTER TABLE S_PRODUCT
ADD CONSTRAINT S_PRODUCT_NAME_UK UNIQUE 
(
  NAME 
)
ENABLE;

ALTER TABLE S_ITEM
ADD CONSTRAINT S_ITEM_ORDID_PRODID_UK UNIQUE 
(
  ORD_ID 
, PRODUCT_ID 
)
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_USERID_UK UNIQUE 
(
  USERID 
)
ENABLE;

ALTER TABLE S_DEPT
ADD CONSTRAINT S_DEPT_NAME_REGION_ID_UK UNIQUE 
(
  NAME 
, REGION_ID 
)
ENABLE;

ALTER TABLE S_PAYMENT_OPTIONS
ADD CONSTRAINT S_PAYMENT_TYPE_CUSTOMER_ID_UK UNIQUE 
(
  PAYMENT_TYPE 
, CUSTOMER_ID 
)
ENABLE;

ALTER TABLE S_COUNTRIES
ADD CONSTRAINT S_COUNTRIES_FK FOREIGN KEY
(
  REGION_ID 
)
REFERENCES S_REGION
(
  ID 
)
ENABLE;


ALTER TABLE S_WAREHOUSE
ADD CONSTRAINT S_WAREHOUSE_MANAGER_ID_FK FOREIGN KEY
(
  MANAGER_ID 
)
REFERENCES S_EMP
(
  ID 
)
ENABLE;

ALTER TABLE S_PRODUCT
ADD CONSTRAINT S_PRODUCT_IMAGE_ID_FK FOREIGN KEY
(
  IMAGE_ID 
)
REFERENCES S_IMAGE
(
  ID 
)
ENABLE;

ALTER TABLE S_PRODUCT
ADD CONSTRAINT S_PRODUCT_LONGTEXT_ID_FK FOREIGN KEY
(
  LONGTEXT_ID 
)
REFERENCES S_LONGTEXT
(
  ID 
)
ENABLE;

ALTER TABLE S_ORD
ADD CONSTRAINT S_ORD_CUSTOMER_ID_FK FOREIGN KEY
(
  CUSTOMER_ID 
)
REFERENCES S_CUSTOMER
(
  ID 
)
ENABLE;

ALTER TABLE S_ORD
ADD CONSTRAINT S_ORD_SALES_REP_ID_FK FOREIGN KEY
(
  SALES_REP_ID 
)
REFERENCES S_EMP
(
  ID 
)
ENABLE;

ALTER TABLE S_ORD
ADD CONSTRAINT S_ORD_PAYMENT_TYPE_FK FOREIGN KEY
(
  PAYMENT_TYPE_ID 
)
REFERENCES S_PAYMENT_TYPE
(
  ID 
)
ENABLE;

ALTER TABLE S_ITEM
ADD CONSTRAINT S_ITEM_ORD_ID_FK FOREIGN KEY
(
  ORD_ID 
)
REFERENCES S_ORD
(
  ID 
)
ENABLE;

ALTER TABLE S_ITEM
ADD CONSTRAINT S_ITEM_PRODUCT_ID_FK FOREIGN KEY
(
  PRODUCT_ID 
)
REFERENCES S_PRODUCT
(
  ID 
)
ENABLE;

ALTER TABLE S_INVENTORY
ADD CONSTRAINT S_INVENTORY_PRODUCT_ID_FK FOREIGN KEY
(
  PRODUCT_ID 
)
REFERENCES S_PRODUCT
(
  ID 
)
ENABLE;

ALTER TABLE S_INVENTORY
ADD CONSTRAINT S_INVENTORY_WAREHOUSE_ID_FK FOREIGN KEY
(
  WAREHOUSE_ID 
)
REFERENCES S_WAREHOUSE
(
  ID 
)
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_DEPT_ID_FK FOREIGN KEY
(
  DEPT_ID 
)
REFERENCES S_DEPT
(
  ID 
)
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_MANAGER_ID_FK FOREIGN KEY
(
  MANAGER_ID 
)
REFERENCES S_EMP
(
  ID 
)
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_S_TITLE_FK1 FOREIGN KEY
(
  TITLE_ID 
)
REFERENCES S_TITLE
(
  TITLE_ID 
)
ENABLE;

ALTER TABLE S_DEPT
ADD CONSTRAINT S_DEPT_REGION_ID_FK FOREIGN KEY
(
  REGION_ID 
)
REFERENCES S_REGION
(
  ID 
)
ENABLE;

ALTER TABLE S_CUSTOMER
ADD CONSTRAINT S_SALES_REP_ID_FK FOREIGN KEY
(
  SALES_REP_ID 
)
REFERENCES S_EMP
(
  ID 
)
ENABLE;

ALTER TABLE S_CUSTOMER
ADD CONSTRAINT S_CUSTOMER_CREDIT_RATING_FK FOREIGN KEY
(
  CREDIT_RATING_ID 
)
REFERENCES S_CREDIT_RATING
(
  ID 
)
ENABLE;

ALTER TABLE S_PRODUCT
ADD CONSTRAINT S_PRODUCT_CATEGORY_ID_FK FOREIGN KEY
(
  CATEGORY_ID 
)
REFERENCES S_PRODUCT_CATEGORIES
(
  ID 
)
ENABLE;

ALTER TABLE S_PAYMENT_OPTIONS
ADD CONSTRAINT S_PMT_OPTIONS_CUST_ID_FK FOREIGN KEY
(
  CUSTOMER_ID 
)
REFERENCES S_CUSTOMER
(
  ID 
)
ENABLE;

ALTER TABLE S_WAREHOUSE
ADD CONSTRAINT S_WAREHOUSE_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_REGION
ADD CONSTRAINT S_REGION_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_REGION
ADD CONSTRAINT S_REGION_NAME_NN CHECK 
(NAME IS NOT NULL)
ENABLE;

ALTER TABLE S_PRODUCT
ADD CONSTRAINT S_PRODUCT_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_PRODUCT
ADD CONSTRAINT S_PRODUCT_NAME_NN CHECK 
(NAME IS NOT NULL)
ENABLE;

ALTER TABLE S_ORD
ADD CONSTRAINT S_ORD_CUSTOMER_ID_NN CHECK 
(CUSTOMER_ID IS NOT NULL)
ENABLE;

ALTER TABLE S_ORD
ADD CONSTRAINT S_ORD_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_ORD
ADD CONSTRAINT S_ORD_ORDER_FILLED_CK CHECK 
(ORDER_FILLED IN ('Y', 'N'))
ENABLE;

ALTER TABLE S_LONGTEXT
ADD CONSTRAINT S_LONGTEXT_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_LONGTEXT
ADD CONSTRAINT S_LONGTEXT_USE_FILENAME_CK CHECK 
(USE_FILENAME IN ('Y', 'N'))
ENABLE;

ALTER TABLE S_ITEM
ADD CONSTRAINT S_ITEM_ITEM_ID_NN CHECK 
(ITEM_ID IS NOT NULL)
ENABLE;

ALTER TABLE S_ITEM
ADD CONSTRAINT S_ITEM_ORD_ID_NN CHECK 
(ORD_ID IS NOT NULL)
ENABLE;

ALTER TABLE S_ITEM
ADD CONSTRAINT S_ITEM_PRODUCT_ID_NN CHECK 
(PRODUCT_ID IS NOT NULL)
ENABLE;

ALTER TABLE S_INVENTORY
ADD CONSTRAINT S_INVENTORY_PRODUCT_ID_NN CHECK 
(PRODUCT_ID IS NOT NULL)
ENABLE;

ALTER TABLE S_INVENTORY
ADD CONSTRAINT S_INVENTORY_WAREHOUSE_ID_NN CHECK 
(WAREHOUSE_ID IS NOT NULL)
ENABLE;

ALTER TABLE S_IMAGE
ADD CONSTRAINT S_IMAGE_FORMAT_CK CHECK 
(FORMAT IN ('JPG', 'JTIFF'))
ENABLE;

ALTER TABLE S_IMAGE
ADD CONSTRAINT S_IMAGE_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_IMAGE
ADD CONSTRAINT S_IMAGE_USE_FILENAME_CK CHECK 
(USE_FILENAME IN ('Y', 'N'))
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_COMMISSION_PCT_CK CHECK 
(COMMISSION_PCT IN (10, 12.5, 15, 17.5, 20))
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_EMP
ADD CONSTRAINT S_EMP_LAST_NAME_NN CHECK 
(LAST_NAME IS NOT NULL)
ENABLE;

ALTER TABLE S_DEPT
ADD CONSTRAINT S_DEPT_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_DEPT
ADD CONSTRAINT S_DEPT_NAME_NN CHECK 
(NAME IS NOT NULL)
ENABLE;

ALTER TABLE S_CUSTOMER
ADD CONSTRAINT S_CUSTOMER_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

ALTER TABLE S_CUSTOMER
ADD CONSTRAINT S_CUSTOMER_NAME_NN CHECK 
(NAME IS NOT NULL)
ENABLE;

ALTER TABLE S_PRODUCT_CATEGORIES
ADD CONSTRAINT S_PRODUCT_CATEGORIES_ID_NN CHECK 
(ID IS NOT NULL)
ENABLE;

