/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSParserFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLLSDocumentBuilder
extends DocumentBuilder {
    private boolean rejecting = false;
    private Node rejectedNode = null;
    private LSParserFilter builderFilter = null;
    private int stackSize = 16;
    private int currentSkip = -1;
    private Node[] skipNodes = new Node[16];

    public XMLLSDocumentBuilder() {
    }

    public XMLLSDocumentBuilder(XMLParser xMLParser) {
        this.xmlParser = xMLParser;
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
        XMLNode xMLNode = this.getCurrentNode();
        Node node = xMLNode.getLastChild();
        if (node != null) {
            if (node.getNodeType() != 7) {
                return;
            }
            if (this.callBuilderFilter(node) && this.builderFilter.acceptNode(node) == 2) {
                node.getParentNode().removeChild(node);
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        XMLNode xMLNode = this.getCurrentNode();
        if (xMLNode == null) {
            return;
        }
        if (!this.rejecting && xMLNode instanceof XMLElement && this.callBuilderFilter(xMLNode)) {
            short s = this.builderFilter.startElement((XMLElement)xMLNode);
            if (s == 2) {
                this.rejecting = true;
                this.rejectedNode = xMLNode;
                this.setNodeFactory(new LSNodeFactorySkip());
                xMLNode.getParentNode().removeChild(xMLNode);
            } else if (s == 3) {
                this.pushSkipNode(xMLNode);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        XMLNode xMLNode = this.getCurrentNode();
        if (xMLNode != null) {
            if (this.rejecting) {
                if (xMLNode == this.rejectedNode) {
                    this.rejecting = false;
                    this.rejectedNode = null;
                    this.resetNodeFactory();
                }
            } else if (xMLNode == this.topSkipNode()) {
                NodeList nodeList = xMLNode.getChildNodes();
                Node node = xMLNode.getParentNode();
                while (xMLNode.getFirstChild() != null) {
                    node.appendChild(xMLNode.getFirstChild());
                }
                node.removeChild(xMLNode);
                this.popSkipNode();
            } else if (this.callBuilderFilter(xMLNode) && this.builderFilter.acceptNode(xMLNode) == 2) {
                xMLNode.getParentNode().removeChild(xMLNode);
            }
        }
        super.endElement(string, string2, string3);
    }

    public void setBuilderFilter(LSParserFilter lSParserFilter) {
        this.builderFilter = lSParserFilter;
    }

    boolean callBuilderFilter(Node node) {
        if (this.builderFilter == null) {
            return false;
        }
        return (1 << node.getNodeType() - 1 & this.builderFilter.getWhatToShow()) != 0;
    }

    Node topSkipNode() {
        if (this.currentSkip >= 0) {
            return this.skipNodes[this.currentSkip];
        }
        return null;
    }

    void popSkipNode() {
        if (this.currentSkip >= 0) {
            this.skipNodes[this.currentSkip--] = null;
        }
    }

    void pushSkipNode(Node node) {
        if (this.currentSkip < this.stackSize - 1) {
            this.skipNodes[++this.currentSkip] = node;
        } else {
            Node[] nodeArray = this.skipNodes;
            this.skipNodes = new Node[this.stackSize * 2];
            System.arraycopy(nodeArray, 0, this.skipNodes, 0, this.stackSize);
            this.stackSize *= 2;
            this.skipNodes[++this.currentSkip] = node;
        }
    }

    public class LSNodeFactorySkip
    extends NodeFactory {
        @Override
        public XMLElement createElement(String string) {
            return null;
        }

        @Override
        public XMLElement createElementNS(String string, String string2, String string3) {
            return null;
        }

        @Override
        public XMLDocument createDocument() {
            return null;
        }

        @Override
        public XMLText createTextNode(String string) {
            return null;
        }

        @Override
        public XMLCDATA createCDATASection(String string) {
            return null;
        }

        @Override
        public XMLComment createComment(String string) {
            return null;
        }

        @Override
        public XMLPI createProcessingInstruction(String string, String string2) {
            return null;
        }

        @Override
        public XMLAttr createAttribute(String string, String string2) {
            return null;
        }

        @Override
        public XMLAttr createAttribute(String string, String string2, String string3, String string4) {
            return null;
        }

        @Override
        public XMLDocumentFragment createDocumentFragment() {
            return null;
        }

        @Override
        public XMLEntityReference createEntityReference(String string) {
            return null;
        }
    }
}

