/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.mobile.rt.v13.build.settings;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.settings.OracleLocale;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.settings.ScanHelper;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.settings.URLFileSystem;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.xsltransformer.XMLTransformer;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.xsltransformer.XSLParameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransformHelper {
    private static final String EMPTY_STR = "";
    private static final String _XSL_PARAM_TARGET_DIR_PATH = "XSL_PARAM_targetDirectoryPath";
    private static final String _XSL_PARAM_APPLICATION_PACKAGE = "XSL_PARAM_applicationPackage";
    private static final String _XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR = "XSL_PARAM_FeatureXmlRelativePathInFAR";
    private static final String _XSL_PARAM_APPLICATION_XLIFF_BASE_PATH = "XSL_PARAM_applicationXliffBasePath";
    private static final String _XSL_PARAM_FAR_URL_NODESET = "XSL_PARAM_FeatureArchiveUrlNodeSet";
    private static final String _XSL_PARAM_LOCALE_DATA_ELEMENTS = "XSL_PARAM_LocaleDataElements";
    private static final String _LOCALE_XML_ELEMENT_NAME = "LocaleData";
    private static final String XLIFF_BUNDLE_TYPE = ".xlf";
    private static final String PERIOD = ".";

    public static void executeIosTransformation(String appFile, String xslFile, String settingsDir, String farsDir) throws Exception {
        ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
        String XSL_PARAM_SETTINGS_BUNDLE_DIRECTORY_PATH = "XSL_PARAM_SettingsBundleFolderPath";
        xslParamList.add(new XSLParameter(EMPTY_STR, XSL_PARAM_SETTINGS_BUNDLE_DIRECTORY_PATH, new File(settingsDir).toURI().toString() + "/"));
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR, "/META-INF/maf-feature.xml"));
        TransformHelper.addFarUrlsToXslParamList(xslParamList, TransformHelper.scanFarDirs(farsDir));
        URL xslUrl = new File(xslFile).toURI().toURL();
        URL adfmfAppXmlFileUrl = new File(appFile).toURI().toURL();
        XMLTransformer.transformXml(xslUrl, adfmfAppXmlFileUrl, xslParamList, null);
    }

    public static void executeIosStringsTransformation(String appFile, String xslFile, String stringsDir, String xlfDir, String farsDir) throws Exception {
        ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
        URL xcodeStringsDirectoryUrl = new URL(new File(stringsDir).toURI().toString() + "/");
        String XSL_PARAM_TARGET_DIR_PATH = "XSL_PARAM_TargetDirectoryPath";
        xslParamList.add(new XSLParameter(EMPTY_STR, "XSL_PARAM_TargetDirectoryPath", xcodeStringsDirectoryUrl.toExternalForm()));
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR, "/META-INF/maf-feature.xml"));
        String XSL_PARAM_APPLICATION_XLIFF_DIR_PATH = "XSL_PARAM_ApplicationXliffBasePath";
        URL xlfDirUrl = new URL(new File(xlfDir).toURI().toString() + "/");
        xslParamList.add(new XSLParameter(EMPTY_STR, "XSL_PARAM_ApplicationXliffBasePath", xlfDirUrl.toExternalForm()));
        TransformHelper.addFarUrlsToXslParamList(xslParamList, TransformHelper.scanFarDirs(farsDir));
        URL xslUrl = new File(xslFile).toURI().toURL();
        URL adfmfAppXmlFileUrl = new File(appFile).toURI().toURL();
        XMLTransformer.transformXml(xslUrl, adfmfAppXmlFileUrl, xslParamList, null);
    }

    public static void executeAndroidTransformation(String appFile, String xslFile, String farsDir, String appPackageNAme, String outputDir) throws Exception {
        List<XSLParameter> xslParamList = TransformHelper.createXslParameterList(appFile, xslFile, farsDir, appPackageNAme, outputDir);
        URL xslUrl = new File(xslFile).toURI().toURL();
        URL adfmfAppXmlFileUrl = new File(appFile).toURI().toURL();
        XMLTransformer.transformXml(xslUrl, adfmfAppXmlFileUrl, xslParamList, null);
    }

    private static List<XSLParameter> createXslParameterList(String appFile, String xslFile, String farsDir, String appPackageName, String outputDir) throws Exception {
        ArrayList<XSLParameter> xslParamList = new ArrayList<XSLParameter>();
        String encoded = new File(outputDir).toURI().toString();
        String result = URLDecoder.decode(encoded, "UTF-8");
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_TARGET_DIR_PATH, result));
        String appPkgName = ScanHelper.getApplicationId(appFile);
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_APPLICATION_PACKAGE, appPkgName != null && appPackageName.length() > 0 ? appPkgName : appPackageName));
        XSLParameter xslLocalesParam = TransformHelper.getLocaleDataElementsParameter(appFile, farsDir);
        xslParamList.add(xslLocalesParam);
        List<URL> farList = TransformHelper.scanFarDirs(farsDir);
        TransformHelper.addFarUrlsToXslParamList(xslParamList, farList);
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_FEATURE_XML_RELATIVE_PATH_IN_FAR, "/META-INF/maf-feature.xml"));
        URL applicationBaseXliffUrl = new File(appFile).getParentFile().toURI().toURL();
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_APPLICATION_XLIFF_BASE_PATH, applicationBaseXliffUrl.toExternalForm()));
        return xslParamList;
    }

    private static XSLParameter getLocaleDataElementsParameter(String appFile, String farsDir) throws Exception {
        List<String> localeList = TransformHelper._getLocaleList(appFile, farsDir);
        NodeList localeNodeList = TransformHelper._localesToNodeList(localeList);
        return new XSLParameter(EMPTY_STR, _XSL_PARAM_LOCALE_DATA_ELEMENTS, localeNodeList);
    }

    private static NodeList _localesToNodeList(List<String> localeList) throws Exception {
        if (null == localeList) {
            throw new IllegalArgumentException();
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        String TEMP_DOCUMENT_ROOT_NAME = "Root";
        Element rootElement = document.createElementNS(null, "Root");
        document.appendChild(rootElement);
        String ORACLE_LOCALE_ATTRIBUTE_NAME = "oracleLocale";
        String ANDROID_LOCALE_ATTRIBUTE_NAME = "androidLocale";
        for (String oracleLocale : localeList) {
            Element element = document.createElementNS(null, _LOCALE_XML_ELEMENT_NAME);
            if (!oracleLocale.isEmpty()) {
                element.setAttributeNS(null, "oracleLocale", oracleLocale);
                String androidLocale = TransformHelper._toAndroidLocale(oracleLocale);
                element.setAttributeNS(null, "androidLocale", androidLocale);
            }
            rootElement.appendChild(element);
        }
        return rootElement.getChildNodes();
    }

    private static String _toAndroidLocale(String oracleLocale) {
        assert (OracleLocale.isValidOracleLocale(oracleLocale));
        String ANDROID_COUNTRY_CODE_PREFIX = "-r";
        String androidLocale = oracleLocale.replace("_", "-r");
        return androidLocale;
    }

    private static List<String> _getLocaleList(String appFile, String farsDir) throws Exception {
        ArrayList<String> xliffLocaleList = new ArrayList<String>();
        HashMap<String, String> localeTokenMap = new HashMap<String, String>();
        Map<String, String> applicationLocaleTokenMap = TransformHelper._getLocaleTokenMapFromApplicationAdf(appFile);
        localeTokenMap.putAll(applicationLocaleTokenMap);
        List<URL> list = TransformHelper.scanFarDirs(farsDir);
        for (URL currFarUrl : list) {
            Map<String, String> farLocaleTokenMap = ScanHelper.getLanguageTokenMapFromFeatureFar(currFarUrl);
            localeTokenMap.putAll(farLocaleTokenMap);
        }
        xliffLocaleList.addAll(localeTokenMap.values());
        for (String oracleLocale : xliffLocaleList) {
            if (OracleLocale.isValidOracleLocale(oracleLocale)) continue;
            String msg = MessageFormat.format("Bad ADF mobile locale %s", oracleLocale);
            throw new Exception(msg);
        }
        return xliffLocaleList;
    }

    private static Map<String, String> _getLocaleTokenMapFromApplicationAdf(String appFile) throws Exception {
        HashMap<String, String> localeTokenMap = new HashMap<String, String>();
        final String appLoadBundleBaseName = ScanHelper.getApplicationLoadBundleBaseName(appFile);
        if (appLoadBundleBaseName == null || appLoadBundleBaseName.length() <= 0) {
            return localeTokenMap;
        }
        ScanHelper.URLFilenameFilter xlifFilter = new ScanHelper.URLFilenameFilter(){

            @Override
            public boolean accept(URL url, String name) {
                if (null == url || name == null || name.length() <= 0) {
                    return false;
                }
                return name.endsWith(TransformHelper.XLIFF_BUNDLE_TYPE) && name.startsWith(appLoadBundleBaseName);
            }
        };
        URL appAdfMetaInfUrl = new File(appFile).getAbsoluteFile().getParentFile().toURI().toURL();
        URL[] filesArray = URLFileSystem.list(appAdfMetaInfUrl, xlifFilter);
        if (null == filesArray) {
            return localeTokenMap;
        }
        for (int i = 0; i < filesArray.length; ++i) {
            String currFileNamePath = filesArray[i].getFile();
            String currLocaleToken = TransformHelper._getLocaleTokenFromFileName(currFileNamePath, appLoadBundleBaseName);
            if (currLocaleToken == null || currLocaleToken.length() <= 0) continue;
            localeTokenMap.put(currLocaleToken, currLocaleToken);
        }
        return localeTokenMap;
    }

    private static List<URL> scanFarDirs(String farsDir) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>();
        File fars = new File(farsDir);
        String[] directories = fars.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File farDir = new File(dir, name);
                return farDir.isDirectory() && new File(farDir, "META-INF/maf-feature.xml").exists();
            }
        });
        if (directories != null) {
            for (String dir : directories) {
                dir = fars.toURI().toString() + dir + "/";
                URL url = new URL(dir);
                list.add(url);
            }
        }
        return list;
    }

    private static void addFarUrlsToXslParamList(List<XSLParameter> xslParamList, List<URL> list) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        String TEMP_DOCUMENT_ROOT_NAME = "Root";
        Element rootElement = document.createElementNS(null, "Root");
        document.appendChild(rootElement);
        String FAR_URL_ELEMENT_TAG_NAME = "FAR_URL";
        for (URL currFarUrl : list) {
            Element element = document.createElementNS(null, "FAR_URL");
            element.appendChild(document.createTextNode(currFarUrl.toExternalForm()));
            rootElement.appendChild(element);
        }
        NodeList nodeList = rootElement.getChildNodes();
        xslParamList.add(new XSLParameter(EMPTY_STR, _XSL_PARAM_FAR_URL_NODESET, nodeList));
    }

    private static String _getLocaleTokenFromFileName(String fileName, String bundleBaseName) {
        int bundleBaseNameIdx = fileName.indexOf(bundleBaseName);
        if (0 > bundleBaseNameIdx) {
            return EMPTY_STR;
        }
        String localeToken = fileName.substring(bundleBaseNameIdx + bundleBaseName.length() + 1);
        int periodIdx = localeToken.indexOf(PERIOD);
        if (0 > periodIdx) {
            return EMPTY_STR;
        }
        localeToken = localeToken.substring(0, periodIdx);
        return localeToken;
    }
}

