/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.mobile.rt.v13.build.xsltransformer;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.settings.FileUtils;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.xsltransformer.TransformException;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.xsltransformer.XSLParameter;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;

public class XMLTransformer {
    public static String transformXml(URL xslUrl, URL srcXmlUrl, List<XSLParameter> xslParamList, Logger logger) throws TransformException {
        String string;
        if (null == xslUrl || null == srcXmlUrl || null == xslParamList) {
            throw new IllegalArgumentException();
        }
        InputStream xslInput = null;
        ByteArrayOutputStream outputStream = null;
        try {
            xslInput = xslUrl.openStream();
            outputStream = XMLTransformer.transformXml(xslInput, srcXmlUrl, xslParamList, logger);
            string = outputStream.toString();
        }
        catch (Exception e) {
            try {
                throw new TransformException(e);
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(xslInput, logger);
                FileUtils.closeStream(outputStream, logger);
                throw throwable;
            }
        }
        FileUtils.closeStream(xslInput, logger);
        FileUtils.closeStream(outputStream, logger);
        return string;
    }

    public static ByteArrayOutputStream transformXml(InputStream xslInputStream, URL srcXmlUrl, List<XSLParameter> xslParamList, Logger logger) throws TransformException {
        if (null == xslInputStream || null == srcXmlUrl || null == xslParamList) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream resultingXml = null;
        InputStream xmlInput = null;
        try {
            xmlInput = srcXmlUrl.openStream();
            DOMParser parser = new DOMParser();
            parser.parse(xmlInput);
            XMLDocument xmlDoc = parser.getDocument();
            XSLProcessor processor = new XSLProcessor();
            for (XSLParameter currParam : xslParamList) {
                processor.setParam(currParam.getNamespace(), currParam.getParameterName(), currParam.getParameterValue());
            }
            XSLStylesheet stylesheet = processor.newXSLStylesheet(xslInputStream);
            resultingXml = new ByteArrayOutputStream();
            processor.processXSL(stylesheet, xmlDoc, (OutputStream)resultingXml);
            ByteArrayOutputStream byteArrayOutputStream = resultingXml;
            return byteArrayOutputStream;
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
        finally {
            FileUtils.closeStream(xmlInput, logger);
        }
    }
}

