/*
importClass(java.io.ByteArrayInputStream);
importClass(java.io.File);
importClass(org.xml.sax.InputSource);
importClass(java.io.FileInputStream);
importClass(java.io.FileOutputStream);
importClass(javax.xml.xpath.XPathFactory);
importClass(javax.xml.xpath.XPathConstants);
importClass(java.util.HashMap);
importClass(javax.xml.namespace.NamespaceContext);
importClass(org.apache.tools.ant.BuildException);
importClass(org.apache.tools.ant.Target);
importClass(org.apache.tools.ant.Location);
importClass(org.apache.tools.ant.types.FileSet);
importClass(org.apache.tools.ant.types.DirSet);
importClass(java.beans.Introspector);
importClass(org.apache.tools.ant.types.Mapper);
importClass(org.apache.tools.ant.types.resources.PropertyResource);
importClass(org.apache.tools.ant.types.resources.FileResource);
importClass(org.w3c.dom.Text);
importClass(org.w3c.dom.Element);
importClass(java.util.Properties);
importClass(java.util.HashSet);
importClass(javax.xml.parsers.DocumentBuilderFactory);
importClass(javax.xml.transform.TransformerFactory);
importClass(javax.xml.transform.Transformer);
importClass(javax.xml.transform.TransformerException);
importClass(javax.xml.transform.TransformerConfigurationException);
importClass(javax.xml.transform.dom.DOMSource); 
importClass(javax.xml.transform.stream.StreamResult); 
*/

eval(''+new String(org.apache.tools.ant.util.FileUtils.readFully(new java.io.FileReader(self.project.getProperty("oepe.bin.js.dir")+"/loader.js"))));
load("common.js");

updateConfigXml();
updateAndroidManifest();


function updateAndroidManifest()
{
    var varAppPackage = self.project.getProperty("var.app.package");
	var deviceAccessToPermissionsMap = new java.util.HashMap();

	var permissionNames = new java.util.HashSet();
	permissionNames.add("android.permission.CAMERA");
	permissionNames.add("android.permission.RECORD_AUDIO");
	deviceAccessToPermissionsMap.put("oepe.maf.device.access.camera", permissionNames);

	permissionNames = new java.util.HashSet();
	permissionNames.add("android.permission.READ_CONTACTS");
	permissionNames.add("android.permission.WRITE_CONTACTS");
	permissionNames.add("android.permission.GET_ACCOUNTS");
	deviceAccessToPermissionsMap.put("oepe.maf.device.access.contacts", permissionNames);


	deviceAccessToPermissionsMap.put("oepe.maf.device.access.emails", java.util.Collections.emptySet());

	deviceAccessToPermissionsMap.put("oepe.maf.device.access.files", java.util.Collections.emptySet());

	permissionNames = new java.util.HashSet();
	permissionNames.add("android.permission.ACCESS_COARSE_LOCATION");
	permissionNames.add("android.permission.ACCESS_FINE_LOCATION");
	permissionNames.add("android.permission.ACCESS_LOCATION_EXTRA_COMMANDS");
	deviceAccessToPermissionsMap.put("oepe.maf.device.access.location", permissionNames);
	
	permissionNames = new java.util.HashSet();
	permissionNames.add("android.permission.INTERNET");
	permissionNames.add("android.permission.READ_PHONE_STATE");
	permissionNames.add("android.permission.ACCESS_NETWORK_STATE");
	deviceAccessToPermissionsMap.put("oepe.maf.device.access.network", permissionNames);

    permissionNames = new java.util.HashSet();
    permissionNames.add("android.permission.GET_TASKS");
    
    permissionNames.add("android.permission.WAKE_LOCK");
    permissionNames.add("com.google.android.c2dm.permission.RECEIVE");
    permissionNames.add("$$app.package$$.permission.C2D_MESSAGE".replace("$$app.package$$", varAppPackage));
    permissionNames.add("android.permission.ACCESS_NETWORK_STATE");
    permissionNames.add("android.permission.GET_ACCOUNTS");
    deviceAccessToPermissionsMap.put("oepe.maf.device.access.pushnotifications", permissionNames);

	deviceAccessToPermissionsMap.put("oepe.maf.device.access.sms", java.util.Collections.singleton("android.permission.RECEIVE_SMS"));
	deviceAccessToPermissionsMap.put("oepe.maf.device.access.phone", java.util.Collections.emptySet());

	permissionsToDeviceAccessMap = invertMapOfStringSets(deviceAccessToPermissionsMap);
	
	var androidManifestLocation = self.project.getProperty("adf.build.root.dir");
	var androidManifestFileLocation = androidManifestLocation+"/AndroidManifest.xml";
	var androidManifestStream = new java.io.FileInputStream(androidManifestFileLocation);
	var androidManifestIs = new org.xml.sax.InputSource(androidManifestStream);
	
	var document = new XMLDocument(androidManifestIs);
	var xmlDoc = document.load();
	
	var alreadyConfigured = new java.util.HashSet();

	try
	{
		var rootNode = xmlDoc.getDocumentElement();
		for (var i = 0; i < rootNode.getChildNodes().getLength(); i++)
		{
			var child = rootNode.getChildNodes().item(i);
			if (child instanceof org.w3c.dom.Element && "uses-permission".equals(child.getTagName()))
			{
				var permNameAttr = child.getAttribute("android:name");
				var needsDeviceAccess = permissionsToDeviceAccessMap.get(permNameAttr);

				if (needsDeviceAccess != null)
				{
					var possibleNeededAccessIt = needsDeviceAccess.iterator();
					while(possibleNeededAccessIt.hasNext())
					{
						var neededAccess = possibleNeededAccessIt.next();
						if (self.project.getProperty(neededAccess))
						{
							alreadyConfigured.add(permNameAttr);
							break;
						}
					}
					if (!alreadyConfigured.contains(permNameAttr))
					{
						antHelper.echo("Info: AndroidManifest.xml contains an undeclared device access permission, which will be removed before deployment: "+permNameAttr);
						if (child.getParentNode() != null)
						{
							child.getParentNode().removeChild(child);
						}
					}
				}
				else
				{
                    alreadyConfigured.add(permNameAttr);
				}
			}
		}
		
		var deviceAccessProperties = self.project.getReference("oepe.maf.device.access.propertyset");
		var deviceAccessIt = deviceAccessProperties.getProperties().keySet().iterator();
		while (deviceAccessIt.hasNext())
		{
			var deviceAccessProperty = deviceAccessIt.next();
			if (deviceAccessProperties.getProperties().get(deviceAccessProperty))
			{
				var requiredPermissionSet = deviceAccessToPermissionsMap.get(deviceAccessProperty);
				if (requiredPermissionSet != null)
				{
					var requiredPermissionSetIt = requiredPermissionSet.iterator();
					while (requiredPermissionSetIt.hasNext())
					{
						var permissionKeyName = requiredPermissionSetIt.next();
						if (!alreadyConfigured.contains(permissionKeyName))
						{
							var newPermissionsElement = xmlDoc.createElement("uses-permission");
							rootNode.appendChild(newPermissionsElement);
							newPermissionsElement.setAttribute("android:name", permissionKeyName);
						}
					}
				}
			}
		}
        
        maybeMergeForPushSMS(rootNode,varAppPackage);
        updateIfDebug(xmlDoc);
        
		var os = new java.io.FileOutputStream(androidManifestFileLocation);
		document.save(os);
	}
	finally
	{
		if (androidManifestStream != null)
		{
			try{androidManifestStream.close();}catch(e){}
		}
		if (os != null)
		{
			try{os.close();}catch(e){}
		}
	}
};

function updateIfDebug(xmlDoc){
	var debugEnabled = self.project.getProperty("java.debug.enabled");
	if ("true".equals(debugEnabled))
	{
		createUsesPermission(xmlDoc, "android.permission.INTERNET");
		createUsesPermission(xmlDoc, "android.permission.ACCESS_NETWORK_STATE");
	}
};

function createUsesPermission(xmlDoc, permissionName){
	var rootNode = xmlDoc.getDocumentElement();
	var newPermissionsElement = xmlDoc.createElement("uses-permission");
	rootNode.appendChild(newPermissionsElement);
	newPermissionsElement.setAttribute("android:name", permissionName);
};

function maybeMergeForPushSMS(xmlDoc,varAppPackage)
{
    
    var pushReceiverBuffer = new java.lang.String("<receiver \
        android:name=\"oracle.adfmf.framework.pushnotification.AdfmfCordovaGCMBroadcastReceiver\" \
        android:permission=\"com.google.android.c2dm.permission.SEND\" > \
        <intent-filter> \
          <action android:name=\"com.google.android.c2dm.intent.RECEIVE\"/> \
          <action android:name=\"com.google.android.c2dm.intent.REGISTRATION\"/> \
          <category android:name=\"$$app.package$$\"/> \
        </intent-filter> \
        </receiver>");
    var pushActivityBuffer = new java.lang.String("<activity android:name=\"oracle.adfmf.framework.pushnotification.AdfmfPushHandlerActivity\"/>");
    var pushServiceBuffer = new java.lang.String("<service android:name=\"oracle.adfmf.framework.pushnotification.AdfmfGCMIntentService\"/>");
    var pushPermissionBuffer = new java.lang.String("<permission android:name=\"$$app.package$$.permission.C2D_MESSAGE\" android:protectionLevel=\"signature\"/>");


    getApplicationNode = function(xmlDoc)
    {
        return xmlUpdater.findElement(xmlDoc, "application", "android:name", "oracle.adfmf.Application");
   };

    var applicationNode = getApplicationNode(xmlDoc);
    if (applicationNode != null)
    {
        if (self.project.getProperty("oepe.maf.device.access.pushnotifications"))
        {
            pushReceiverBuffer = pushReceiverBuffer.replace("$$app.package$$", varAppPackage);
            xmlUpdater.addElementsIfMissing(applicationNode, "receiver", "android:name", "oracle.adfmf.framework.pushnotification.AdfmfCordovaGCMBroadcastReceiver", pushReceiverBuffer);
            xmlUpdater.addElementsIfMissing(applicationNode, "activity", "android:name", "oracle.adfmf.framework.pushnotification.AdfmfPushHandlerActivity", pushActivityBuffer);
            xmlUpdater.addElementsIfMissing(applicationNode, "service", "android:name", "oracle.adfmf.framework.pushnotification.AdfmfGCMIntentService", pushServiceBuffer);
            pushPermissionBuffer = pushPermissionBuffer.replace("$$app.package$$", varAppPackage);
            xmlUpdater.addElementsIfMissing(xmlDoc, "permission", "android:name", "$$app.package$$.permission.C2D_MESSAGE".replace("$$app.package$$", varAppPackage), pushPermissionBuffer);
        }
        else
        {
            xmlUpdater.removeElementIfPresent(applicationNode, "receiver", "android:name", "oracle.adfmf.framework.pushnotification.AdfmfCordovaGCMBroadcastReceiver");
            xmlUpdater.removeElementIfPresent(applicationNode, "activity", "android:name", "oracle.adfmf.framework.pushnotification.AdfmfPushHandlerActivity");
            xmlUpdater.removeElementIfPresent(applicationNode, "service", "android:name", "oracle.adfmf.framework.pushnotification.AdfmfGCMIntentService");
            xmlUpdater.removeElementIfPresent(xmlDoc, "permission", "android:name", "$$app.package$$.permission.C2D_MESSAGE".replace("$$app.package$$", varAppPackage));
        }
    }
};

function updateConfigXml()
{
	var configXmlLocation = self.project.getProperty("adf.staging.res.xml.dir");
	var configXmlStream = new java.io.FileInputStream(configXmlLocation+"/config.xml");
	var configXmlIs = new org.xml.sax.InputSource(configXmlStream);

	var document = new XMLDocument(configXmlIs);
	var xmlDoc = document.load();

	var alreadyConfigured = new java.util.HashMap();

	try
	{
		var xpath = javax.xml.xpath.XPathFactory.newInstance().newXPath();

		var deviceAccessToPluginMap = new java.util.HashMap();
		var pluginName = new java.util.HashSet();
		pluginName.add("Camera");
		pluginName.add("Capture");
		deviceAccessToPluginMap.put("oepe.maf.device.access.camera", pluginName);
		deviceAccessToPluginMap.put("oepe.maf.device.access.contacts", java.util.Collections.singleton("Contacts"));
		deviceAccessToPluginMap.put("oepe.maf.device.access.emails", java.util.Collections.singleton("AdfmfEmail"));
		pluginName = new java.util.HashSet();
		pluginName.add("File");
		pluginName.add("FileTransfer");
		pluginName.add("Storage");
		deviceAccessToPluginMap.put("oepe.maf.device.access.files", pluginName);
		pluginName = new java.util.HashSet();
		pluginName.add("Geolocation");
		pluginName.add("Compass");
		deviceAccessToPluginMap.put("oepe.maf.device.access.location", pluginName);
		deviceAccessToPluginMap.put("oepe.maf.device.access.network", java.util.Collections.singleton("NetworkStatus"));
		deviceAccessToPluginMap.put("oepe.maf.device.access.pushnotifications", java.util.Collections.singleton("PushPlugin"));
		deviceAccessToPluginMap.put("oepe.maf.device.access.sms", java.util.Collections.singleton("AdfmfSMS"));
		deviceAccessToPluginMap.put("oepe.maf.device.access.phone", java.util.Collections.emptySet());
		
		var pluginToDeviceAccessMap = invertMapOfStringSets(deviceAccessToPluginMap);

		var pluginNameToValueMap = new java.util.HashMap();
		pluginNameToValueMap.put("Camera","oracle.adfmf.phonegap.MafCameraLauncher");
		pluginNameToValueMap.put("Capture","org.apache.cordova.Capture");
		pluginNameToValueMap.put("Contacts","org.apache.cordova.ContactManager");
		pluginNameToValueMap.put("AdfmfEmail","oracle.adfmf.phonegap.AdfmfEmail");
		pluginNameToValueMap.put("File","org.apache.cordova.FileUtils");
		pluginNameToValueMap.put("FileTransfer","org.apache.cordova.FileTransfer");
		pluginNameToValueMap.put("Storage","org.apache.cordova.Storage");
		pluginNameToValueMap.put("Geolocation","org.apache.cordova.GeoBroker");
		pluginNameToValueMap.put("Compass","org.apache.cordova.CompassListener");
		pluginNameToValueMap.put("NetworkStatus","org.apache.cordova.NetworkManager");
		pluginNameToValueMap.put("PushPlugin","com.plugin.gcm.PushPlugin");
		pluginNameToValueMap.put("AdfmfSMS","oracle.adfmf.phonegap.AdfmfSMS");
		
		
		var existingAccesses = xpath.evaluate("/cordova/plugins", xmlDoc, javax.xml.xpath.XPathConstants.NODESET);
		var plugins_element = null;
		
		// should only be one
		if (existingAccesses.getLength() == 0)
		{
			plugins_element = xmlDoc.createElement("plugins");
			xmlDoc.getRootElement().addChildNode(plugins_element);
		}
		else
		{
			plugins_element = existingAccesses.item(0);
		}
		
		for (var i = 0; i < plugins_element.getChildNodes().getLength(); i++)
		{
            var pluginElement = plugins_element.item(i);
			if (!(pluginElement instanceof org.w3c.dom.Element) || !"plugin".equals(pluginElement.getTagName()))
			{
				continue;
			}
			var pluginNameAttr = pluginElement.getAttribute("name");
			//antHelper.echo(pluginNameAttr);
			var needsDeviceAccess = pluginToDeviceAccessMap.get(pluginNameAttr);
			
			if (needsDeviceAccess != null)
			{
				var possibleNeededAccessIt = needsDeviceAccess.iterator();
				while(possibleNeededAccessIt.hasNext())
				{
					var neededAccess = possibleNeededAccessIt.next();
					if (self.project.getProperty(neededAccess))
					{
                        antHelper.echo("Device access required: "+pluginNameAttr);
                        alreadyConfigured.put(pluginNameAttr, pluginElement.getAttribute("value"));
						break;
					}
				}

                if (!alreadyConfigured.containsKey(pluginNameAttr))
                {
                    antHelper.echo("Info: config.xml contains undeclared device access plugin, which will be removed before deployment: "+pluginNameAttr);
					if (pluginElement.getParentNode() != null)
					{
						pluginElement.getParentNode().removeChild(pluginElement);
					}
				}
			}
			else
			{
				//antHelper.echo(needsDeviceAccess);
				alreadyConfigured.put(pluginNameAttr, pluginElement.getAttribute("value"));
			}
		}
		
		var deviceAccessProperties = self.project.getReference("oepe.maf.device.access.propertyset");
		var deviceAccessIt = deviceAccessProperties.getProperties().keySet().iterator();
		while (deviceAccessIt.hasNext())
		{
			var deviceAccessProperty = deviceAccessIt.next();
			if (deviceAccessProperties.getProperties().get(deviceAccessProperty))
			{
				var requiredPluginSet = deviceAccessToPluginMap.get(deviceAccessProperty);
				if (requiredPluginSet == null)
				{
					//antHelper.echo(deviceAccessProperty);
				}
				else
				{
					var requiredPluginSetIt = requiredPluginSet.iterator();
					while (requiredPluginSetIt.hasNext())
					{
						var pluginKeyName = requiredPluginSetIt.next();
						if (!alreadyConfigured.containsKey(pluginKeyName))
						{
							var pluginImplValue = pluginNameToValueMap.get(pluginKeyName);
							var newPluginsElement = xmlDoc.createElement("plugin");
							plugins_element.appendChild(newPluginsElement);
							newPluginsElement.setAttribute("name", pluginKeyName);
							newPluginsElement.setAttribute("value", pluginImplValue);
							//antHelper.echo("key="+pluginKeyName+", value="+pluginImplValue);
						}
					}
				}
			}
		}
		var os = new java.io.FileOutputStream(configXmlLocation+"/config.xml");
		document.save(os);
	}
	catch (e)
	{
		antHelper.echo(e);
	}
	finally
	{
		if (configXmlStream != null)
		{
			configXmlStream.close();
		}
		
		if (os != null)
		{
			os.close();
		}
	}
};

function invertMapOfStringSets(map)
{
	var invertedMap = new java.util.HashMap();
	var it = map.keySet().iterator();
	while (it.hasNext())
	{
		var key = it.next();
		var set = map.get(key);
		var setIt = set.iterator();
		while (setIt.hasNext())
		{
			var newKey = setIt.next();
			var invertedSet = invertedMap.get(newKey);
			if (invertedSet == null)
			{
				invertedSet = new java.util.HashSet();
				invertedMap.put(newKey, invertedSet);
			}
			invertedSet.add(key);
		}
	}
	return invertedMap;
};

