/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.mobile.rt.v13.build.settings;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.eclipse.tools.adf.mobile.rt.v13.build.settings.ScanHelper;

public class URLFileSystem {
    public static URL getParent(URL url) throws Exception {
        File file = new File(url.toURI());
        File parentFile = file.getParentFile();
        if (parentFile != null && !file.equals(parentFile)) {
            return parentFile.getAbsoluteFile().toURI().toURL();
        }
        return null;
    }

    public static URL[] list(URL url, ScanHelper.URLFilenameFilter filter) throws Exception {
        if (filter == null) {
            return URLFileSystem.list(url);
        }
        File file = new File(url.toURI());
        String[] names = file.list();
        if (names == null) {
            return null;
        }
        ArrayList<URL> results = new ArrayList<URL>(names.length);
        for (String filename : names) {
            if (!filter.accept(url, filename)) continue;
            File child = new File(file, filename);
            results.add(child.toURI().toURL());
        }
        return results.toArray(new URL[results.size()]);
    }

    public static URL[] list(URL url) throws Exception {
        File file = new File(url.toURI());
        File[] list = file.listFiles();
        if (list == null) {
            return null;
        }
        URL[] urlList = new URL[list.length];
        for (int i = list.length - 1; i >= 0; --i) {
            urlList[i] = list[i].toURI().toURL();
        }
        return urlList;
    }

    public static String getName(URL url) {
        String fileName = URLFileSystem.getFileName(url);
        int firstDot = fileName.lastIndexOf(46);
        return firstDot > 0 ? fileName.substring(0, firstDot) : fileName;
    }

    public static String getFileName(URL url) {
        if (url == null) {
            return "";
        }
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.equals("/")) {
            return "/";
        }
        int lastSep = path.lastIndexOf(47);
        if (lastSep == path.length() - 1) {
            int lastSep2 = path.lastIndexOf(47, lastSep - 1);
            return path.substring(lastSep2 + 1, lastSep);
        }
        return path.substring(lastSep + 1);
    }
}

