﻿var categories = {
"mastercategories":[
{
    "index": 0,
"description": "OFLO REST APIs use HTTP verbs and a RESTful endpoint structure. Request and response payloads are formatted as JSON.\n\nOFLO REST API can be accessed using the following URL format\n\nhttp://host-name:port/{servicename}/{resource}/{resource-specific-parameters}\n-	Host name is the domain.\n-	The resource represents one of the OFLO REST resources. \n-	The resource-specific part of the URL specifies the actual resource being referenced.\n\n",
    "name": "Overview"
},
{
    "index": 1,
	"description": "",
    "name": "obremo-rpm-process-driver-services"
},
{
    "index": 2,
    "description": "",
    "name": "obremo-rpm-projection-services"
},
{
    "index": 3,
    "description": "",
    "name": "obremo-rpm-businessproductdetails-services"
},
{
    "index": 4,
    "description": "",
    "name": "obremo-rpm-businessprocess-services"
},
{
    "index": 5,
    "description": "",
    "name": "obremo-rpm-maintenance-services"
},
{
    "index": 6,
    "description": "",
    "name": "obremo-rpm-sav-account-service"
},
{
    "index": 7,
    "description": "",
    "name": "obremo-rpm-term-deposit-service"
},
{
    "index": 8,
    "description": "",
    "name": "obremo-rpm-lo-loanapplications"
},
{
    "index": 9,
    "description": "",
    "name": "obremo-rpm-cmn-applicantservices"
},
{
    "index": 10,
    "description": "",
    "name": "obremo-rpm-cmn-scorecardservices"
},
{
    "index": 11,
    "description": "",
    "name": "obremo-rpm-cmn-hostservices"
},
{
    "index": 12,
    "description": "",
    "name": "obremo-rpm-cmn-ipaservices"
},
{
    "index": 13,
    "description": "",
    "name": "obremo-rpm-creditcardapplication-services"
},
{
    "index": 14,
    "description": "",
    "name": "obremo-rpm-cmn-collateralservices"
},
{
    "index": 15,
    "description": "",
    "name": "obremo-rpm-cmn-mlservice"
}
]
};
var subCategories = {
    "list":[
        {
            "index": 1,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/application_transaction_master.yaml",
            "description": "Application Transaction Master contains details of application numbers and related process reference numbers",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Application Transaction Master"
        },
        {
            "index": 2,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/cart.yaml",
            "description": "APIs for inserting/deleting from Product Catalogue Cart",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Cart"
        },
        {
            "index": 3,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/comment_service.yaml",
            "description": "APIs for storing comments",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Comments"
        },
        {
            "index": 4,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/process_driver.yaml",
            "description": "APIs Process Driver operations",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Process Driver Services"
        },
        {
            "index": 5,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/process_driver_service.yaml",
            "description": "APIs Process Driver operations for External Systems",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Process Driver Services for External System"
        },

        {
            "index": 6,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/product_details.yaml",
            "description": "APIs Process Driver operations for Product Details",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Process Driver Product Details"
        },
        {
            "index": 7,
            "yaml": "../../OFLO/obremo-rpm-projection-services/batchProcessData.yaml",
            "description": "APIs for fetching data for batch operations",
            "parentcategory": "obremo-rpm-projection-services",
            "displayName": "Batch Process Data"
        },
        {
            "index": 8,
            "yaml": "../../OFLO/obremo-rpm-projection-services/dashboard.yaml",
            "description": "APIs for dashboard data",
            "parentcategory": "obremo-rpm-projection-services",
            "displayName": "Dashboard"
        },
        {
            "index": 9,
            "yaml": "../../OFLO/obremo-rpm-projection-services/inquiry.yaml",
            "description": "APIs for application enquiry",
            "parentcategory": "obremo-rpm-projection-services",
            "displayName": "Inquiry"
        },
        {
            "index": 10,
            "yaml": "../../OFLO/obremo-rpm-projection-services/inquiry_service.yaml",
            "description": "APIs for application enquiry for External Systems",
            "parentcategory": "obremo-rpm-projection-services",
            "displayName": "Inquiry for External Systems"
        },
        {
            "index": 11,
            "yaml": "../../OFLO/obremo-rpm-businessproductdetails-services/rpmtmbusinessproductdetails.yaml",
            "description": "API for Business Product details",
            "parentcategory": "obremo-rpm-businessproductdetails-services",
            "displayName": "Business Product Details"
        },
        {
            "index": 12,
            "yaml": "../../OFLO/obremo-rpm-businessproductdetails-services/rpmtmbussprodhostmaster.yaml",
            "description": "API for Business Product Host Details",
            "parentcategory": "obremo-rpm-businessproductdetails-services",
            "displayName": "Business Product Host Details"
        },
        {
            "index": 13,
            "yaml": "../../OFLO/obremo-rpm-businessproductdetails-services/rpmtmprodattrmaster.yaml",
            "description": "API for Business Product Attribute Details",
            "parentcategory": "obremo-rpm-businessproductdetails-services",
            "displayName": "Business Product Attribute Details"
        },
        {
            "index": 14,
            "yaml": "../../OFLO/obremo-rpm-businessproductdetails-services/rpmtmprodprefmaster.yaml",
            "description": "API for Business Product Preference Details",
            "parentcategory": "obremo-rpm-businessproductdetails-services",
            "displayName": "Business Product Preference Details"
        },
        {
            "index": 15,
            "yaml": "../../OFLO/obremo-rpm-businessproductdetails-services/businessproductAggregate.yaml",
            "description": "API for Business product aggregate",
            "parentcategory": "obremo-rpm-businessproductdetails-services",
            "displayName": "Business Product Aggregate Details"
        },
        {
            "index": 16,
            "yaml": "../../OFLO/obremo-rpm-businessprocess-services/businessprocess_webapi.yaml",
            "description": "API for Business Process",
            "parentcategory": "obremo-rpm-businessprocess-services",
            "displayName": "Business Process"
        },
        {
            "index": 17,
            "yaml": "../../OFLO/obremo-rpm-businessprocess-services/businessprocess_serviceapi.yaml",
            "description": "API for Business Process for External Systems",
            "parentcategory": "obremo-rpm-businessprocess-services",
            "displayName": "Business Process for External Systems"
        },
        {
            "index": 18,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/applicationmaintenance.yaml",
            "description": "API for maintenance data fetch",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Maintenance Data"
        },
        {
            "index": 19,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/applicationmaintenance_serviceapi.yaml",
            "description": "API for maintenance data fetch for External Systems",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Maintenance Data for External Systems"
        },
        {
            "index": 20,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/accountdetails.yaml",
            "description": "API for Current and Savings Account Account Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Account Details"
        },
        {
            "index": 21,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/AccServicesPrefDetails.yaml",
            "description": "API for Current and Savings Account Account Service Preference Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Account Service Preference Details"
        },
        {
            "index": 22,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/ApprovalDetails.yaml",
            "description": "API for Current and Savings Account Approval Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Approval Details"
        },
        // {
        //     "index": 23,
        //     "yaml": "../../OFLO/obremo-rpm-sav-account-service/assessmentdetails.yaml",
        //     "description": "API for Current and Savings Account Assessment Details",
        //     "parentcategory": "obremo-rpm-sav-account-service",
        //     "displayName": "Assessment Details"
        // },
        {
            "index": 24,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/backofficedetails.yaml",
            "description": "API for Current and Savings Account Back Office Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Back Office Details"
        },
        {
            "index": 25,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/ChargeDetails.yaml",
            "description": "API for Current and Savings Account Charge Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Charge Details"
        },
        {
            "index": 26,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/InitialFundingDetails.yaml",
            "description": "API for Current and Savings Account Initial Funding Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Initial Funding Details"
        },
        {
            "index": 27,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/InterestDetails.yaml",
            "description": "API for Current and Savings Account Interest Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Interest Details"
        },
        {
            "index": 28,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/MandateDetails.yaml",
            "description": "API for Current and Savings Account Mandate Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Mandate Details"
        },
        {
            "index": 29,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/Nomineedetails.yaml",
            "description": "API for Current and Savings Account Nominee Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Nominee Details"
        },
        {
            "index": 30,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/ODAdvanceDetails.yaml",
            "description": "API for Current and Savings Account Advance Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Advance Details"
        },
      /*  {
            "index": 31,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/OdSecuredDetails.yaml",
            "description": "API for Current and Savings Account OD Secured Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "OD Secured Details"
        },*/
        {
            "index": 32,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/OdTempUnsecureDetails.yaml",
            "description": "API for Current and Savings Account OD Temp Unsecured Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "OD Temp Unsecured Details"
        },
       /* {
            "index": 33,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/OdUnsecureDetails.yaml",
            "description": "API for Current and Savings Account OD Unsecured Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "OD Unsecured Details"
        },*/
        {
            "index": 34,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/savingApplication.yaml",
            "description": "API for Current and Savings Account Application",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Aggregate Details"
        },
        {
            "index": 35,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/accountdetails.yaml",
            "description": "API for Term Deposit Account Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Account Details"
        },
        {
            "index": 36,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/AccServicesPrefDetails.yaml",
            "description": "API for Term Deposit Account Services Preference Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Account Services Preference Details"
        },
        {
            "index": 37,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/ApprovalDetails.yaml",
            "description": "API for Term Deposit Approval Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Approval Details"
        },
        {
            "index": 38,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/InitialFundingDetails.yaml",
            "description": "API for Term Deposit Initial Funding Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Initial Funding Details"
        },
        {
            "index": 39,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/InterestDetails.yaml",
            "description": "API for Term Deposit Interest Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Interest Details"
        },
        {
            "index": 40,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/MandateDetails.yaml",
            "description": "API for Term Deposit Mandate Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Mandate Details"
        },
        {
            "index": 41,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/Nomineedetails.yaml",
            "description": "API for Term Deposit Nominee Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Nominee Details"
        },
        {
            "index": 42,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/TermDepositApplication.yaml",
            "description": "API for Term Deposit Application",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Aggregate Details"
        },
        {
            "index": 43,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/accountcreation.yaml",
            "description": "API for Loans Account Creation",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Account Creation"
        },
        {
            "index": 44,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/accountdetails.yaml",
            "description": "API for Loans Account Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Account Details"
        },
        {
            "index": 45,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/accountservices.yaml",
            "description": "API for Loans Account Services",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Account Services"
        },
        {
            "index": 46,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/admissiondetails.yaml",
            "description": "API for Loans Admission Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Admission Details"
        },
        {
            "index": 47,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/approvaldetails.yaml",
            "description": "API for Loans Approval Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Approval Details"
        },
    /*    {
            "index": 48,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/Assessmentdetails.yaml",
            "description": "API for Loans Assessment Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Assessment Details"
        },*/
        {
            "index": 49,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/backofficedetails.yaml",
            "description": "API for Loans Back Office Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Back Office Details"
        },
        {
            "index": 50,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/chargedetails.yaml",
            "description": "API for Loans Charge Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Charge Details"
        },
        {
            "index": 51,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/creditratingdetails.yaml",
            "description": "API for Loans Credit Rating Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Credit Rating Details"
        },
        {
            "index": 52,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/customerdecision.yaml",
            "description": "API for Loans Customer Decision",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Customer Decision"
        },
        {
            "index": 53,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/disbursementdetails.yaml",
            "description": "API for Loans Disbursement Decision",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Disbursement Decision"
        },
        {
            "index": 54,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/edufinancialdetails.yaml",
            "description": "API for Loans Education Financial Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Education Financial Details"
        },
        {
            "index": 55,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/guarantordetails.yaml",
            "description": "API for Loans Guarantor Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Guarantor Details"
        },
        {
            "index": 56,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/interestdetails.yaml",
            "description": "API for Loans Interest Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Interest Details"
        },
        {
            "index": 57,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/issueofferdetails.yaml",
            "description": "API for Loans Issue of Offer Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Issue of Offer Details"
        },
        {
            "index": 58,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/loanapplication.yaml",
            "description": "API for Loans Application",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Aggregate Details"
        },
        {
            "index": 59,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/loanapplicationservice.yaml",
            "description": "API for Loans Application Service",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Loan Application"
        },
        {
            "index": 60,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/loandetails.yaml",
            "description": "API for Loans Basic Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Loan Details"
        },
        {
            "index": 61,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/loanproductdetails.yaml",
            "description": "API for Loans Product Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Loan Product Details"
        },
        {
            "index": 62,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/mandatedetails.yaml",
            "description": "API for Loans Mandate Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Mandate Details"
        },
        {
            "index": 63,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/postamendmentdetails.yaml",
            "description": "API for Loans Post Amendment Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Post Amendment Details"
        },
        {
            "index": 64,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/repaymentdetails.yaml",
            "description": "API for Loans Repayment Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Repayment Details"
        },
        {
            "index": 65,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/loansummary.yaml",
            "description": "API for Loans Summary",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Loan Summary"
        },
        {
            "index": 66,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/applicantAggregateServices.yaml",
            "description": "API for Common Applicant Aggregate",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Aggregate Details"
        },
        {
            "index": 67,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/applicantDetailsServiceApi.yaml",
            "description": "API for Common Applicant Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Applicant Details"
        },
        {
            "index": 68,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/applicantservices.yaml",
            "description": "API for Common Applicant Service Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Applicant"
        },
        {
            "index": 69,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/ApplicantTypeServices.yaml",
            "description": "API for Common Applicant Type Services",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Applicant Type Details"
        },
        {
            "index": 70,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/CustOnboardServices.yaml",
            "description": "API for Common Applicant Customer Onboarding Services",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Customer Onboarding Details"
        },
        {
            "index": 71,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/financialdetails.yaml",
            "description": "API for Common Applicant Financial Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Financial Details"
        },
        {
            "index": 72,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/partyMaintenanceWeb.yaml",
            "description": "API for Party Maintenance for Routing Hub",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Party Maintenance"
        },
        {
            "index": 73,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/partyservices.yaml",
            "description": "API for Party Services for Routing Hub",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Party Services"
        },
        {
            "index": 74,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/partyservicesWeb.yaml",
            "description": "API for Web Party Services for Routing Hub",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Party Web Services"
        },
        {
            "index": 75,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/stakeholderservices.yaml",
            "description": "API for Stakeholder Services",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Stakeholder Services"
        },
        {
            "index": 76,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/assessmentdetails.yaml",
            "description": "API for Scorecard Assessment Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Assessment Details"
        },
       /* {
            "index": 77,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/attributelist.yaml",
            "description": "API for Scorecard Attribute Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Attribute List"
        },*/
        {
            "index": 78,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/qualitativeconfiguration.yaml",
            "description": "API for Scorecard Qualitative Configuration",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Qualitative Configuration"
        },
        {
            "index": 79,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/qualitativeconfigurationds.yaml",
            "description": "API for Scorecard Qualitative DS",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Qualitative Configuration Details"
        },
        /*{
            "index": 80,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/quantitativeconfiguration.yaml",
            "description": "API for Scorecard Quantitative Configuration",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Quantitative Configuration"
        },*/
        {
            "index": 81,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/scorecardproductdetails.yaml",
            "description": "API for Scorecard Product Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Product Details"
        },
        {
            "index": 82,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/scorecardservices.yaml",
            "description": "API for Scorecard Services",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Aggregate Details"
        },
        {
            "index": 83,
            "yaml": "../../OFLO/obremo-rpm-cmn-hostservices/casaapplication.yaml",
            "description": "API for Host Current and Savings Account Application",
            "parentcategory": "obremo-rpm-cmn-hostservices",
            "displayName": "Current and Savings Application"
        },
        {
            "index": 84,
            "yaml": "../../OFLO/obremo-rpm-cmn-hostservices/liabilityproduct.yaml",
            "description": "API for Host Liability Product",
            "parentcategory": "obremo-rpm-cmn-hostservices",
            "displayName": "Liability Product Details"
        },
        {
            "index": 85,
            "yaml": "../../OFLO/obremo-rpm-cmn-hostservices/loanproduct.yaml",
            "description": "API for Host Loan Product",
            "parentcategory": "obremo-rpm-cmn-hostservices",
            "displayName": "Loan Product Details"
        },
        {
            "index": 86,
            "yaml": "../../OFLO/obremo-rpm-cmn-hostservices/termdeposit.yaml",
            "description": "API for Host Term Deposit",
            "parentcategory": "obremo-rpm-cmn-hostservices",
            "displayName": "Term Deposit Details"
        },
        {
            "index": 87,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/CoreAccount.yaml",
            "description": "API for Core Account Maintenance",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Core Account List"
        },
        {
            "index": 88,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/extCommDetails.yaml",
            "description": "API for Awaiting Customer Clarification Details",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Awaiting Customer Clarification Details"
        },
        {
            "index": 89,
            "yaml": "../../OFLO/obremo-rpm-cmn-ipaservices/approvalipadetails.yaml",
            "description": "API for In-Principle Approval Details",
            "parentcategory": "obremo-rpm-cmn-ipaservices",
            "displayName": "In-Principle Approval Approval Details"
        },
        {
            "index": 90,
            "yaml": "../../OFLO/obremo-rpm-cmn-ipaservices/documentLinkage.yaml",
            "description": "API for Document Linkage",
            "parentcategory": "obremo-rpm-cmn-ipaservices",
            "displayName": "In-Principle Approval Document Linkage"
        },
        {
            "index": 91,
            "yaml": "../../OFLO/obremo-rpm-cmn-ipaservices/generateipadetails.yaml",
            "description": "API for In-Principle Approval Generate Details",
            "parentcategory": "obremo-rpm-cmn-ipaservices",
            "displayName": "Generate In-Principle Approval Details"
        },
        {
            "index": 92,
            "yaml": "../../OFLO/obremo-rpm-cmn-ipaservices/ipadetails.yaml",
            "description": "API for In-Principle Approval Details",
            "parentcategory": "obremo-rpm-cmn-ipaservices",
            "displayName": "In-Principle Approval Details"
        },
        {
            "index": 93,
            "yaml": "../../OFLO/obremo-rpm-cmn-ipaservices/ipaproductdetails.yaml",
            "description": "API for In-Principle Approval Product Details",
            "parentcategory": "obremo-rpm-cmn-ipaservices",
            "displayName": "In-Principle Approval Product Details"
        },
        {
            "index": 94,
            "yaml": "../../OFLO/obremo-rpm-cmn-ipaservices/ipaservices.yaml",
            "description": "API for In-Principle Approval Aggregate Details",
            "parentcategory": "obremo-rpm-cmn-ipaservices",
            "displayName": "In-Principle Approval Aggregate Details"
        },
        {
            "index": 95,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/creditcarddetails.yaml",
            "description": "API for Credit Card Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Details"
        },
        {
            "index": 96,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/creditcardproductdetails.yaml",
            "description": "API for Credit Card Product Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Product Details"
        },
        {
            "index": 97,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/cardpreference.yaml",
            "description": "API for Credit Card Preference Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Preference Details"
        },
        {
            "index": 98,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/Addoncardholder.yaml",
            "description": "API for Credit Card Addon Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Addon Details"
        },
        {
            "index": 99,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/chargedetails.yaml",
            "description": "API for Credit Card Charge Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Charge Details"
        },
        {
            "index": 100,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/interestdetails.yaml",
            "description": "API for Credit Card Interest Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Interest Details"
        },
        {
            "index": 101,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/assessmentdetails.yaml",
            "description": "API for Credit Card Assessment Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Assessment Details"
        },
        {
            "index": 102,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/approvaldetails.yaml",
            "description": "API for Credit Card Approval Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Approval Details"
        },
        {
            "index": 103,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/creditcardservices.yaml",
            "description": "API for Credit Card Aggregate ",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Credit Card Aggregate"
        },
        {
            "index": 104,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/collateraldetails.yaml",
            "description": "API for Collateral Details",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Collateral Details"
        },
        {
            "index": 105,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/collateralservices.yaml",
            "description": "API for Collateral Aggregate",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Collateral Aggregate Details"
        },
        {
            "index": 106,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/legalopiniondetails.yaml",
            "description": "API for Legal Opinion Details",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Collateral Legal Opinion Details"
        },
        {
            "index": 107,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/perfectiondetails.yaml",
            "description": "API for Perfection Details",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Collateral Perfection Details"
        },
        {
            "index": 108,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/valuationdetails.yaml",
            "description": "API for Valuation Details",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Collateral Valuation Details"
        },
        {
            "index": 109,
            "yaml": "../../OFLO/obremo-rpm-cmn-hostservices/collateralcreation.yaml",
            "description": "API for Collateral Creation",
            "parentcategory": "obremo-rpm-cmn-hostservices",
            "displayName": "Collateral Creation"
        },
        {
            "index": 110,
            "yaml": "../../OFLO/obremo-rpm-cmn-hostservices/collateralenquiry.yaml",
            "description": "API for Collateral Enquiry",
            "parentcategory": "obremo-rpm-cmn-hostservices",
            "displayName": "Collateral Enquiry"
        },
        {
            "index": 111,
            "yaml": "../../OFLO/obremo-rpm-cmn-mlservice/ProcessTimePrediction.yaml",
            "description": "API for Machine Learning Usecase",
            "parentcategory": "obremo-rpm-cmn-mlservice",
            "displayName": "Machine Learning for Process Creation Time Prediction"
        },
        {
            "index": 112,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/applicantproductdetails.yaml",
            "description": "API for Applicant Product Deatils",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Applicant Product Deatils"
        },
        {
            "index": 113,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/ConsentServices.yaml",
            "description": "API for Consent Deatils",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Consent Deatils"
        },
        {
            "index": 114,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/creditratingdetails.yaml",
            "description": "API for Credit Rating Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Credit Rating Details"
        },
        {
            "index": 115,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/documentLinkage.yaml",
            "description": "API for Document Linkage",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Document Linkage"
        },
        {
            "index": 116,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/ProdPref.yaml",
            "description": "API for Product Preference Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Product Preference Details"
        },
        {
            "index": 117,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/relationship.yaml",
            "description": "API for Relationship Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Relationship Details"
        },
        {
            "index": 118,
            "yaml": "../../OFLO/obremo-rpm-cmn-applicantservices/TermsAndConditionServices.yaml",
            "description": "API for Terms And Condition Details",
            "parentcategory": "obremo-rpm-cmn-applicantservices",
            "displayName": "Terms And Condition Details"
        },
        {
            "index": 119,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/documentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Document Linkage"
        },
        {
            "index": 120,
            "yaml": "../../OFLO/obremo-rpm-cmn-collateralservices/solicitordetails.yaml",
            "description": "API for Solicitor Details",
            "parentcategory": "obremo-rpm-cmn-collateralservices",
            "displayName": "Solicitor Details"
        },
        {
            "index": 121,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/assessmentsummary.yaml",
            "description": "API for Scorecard Assessment Summary Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Scorecard Assessment Summary"
        },
        {
            "index": 122,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/manualcreditdecision.yaml",
            "description": "API for Manual Credit Decision Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Manual Credit Decision"
        },
        {
            "index": 123,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/manualcreditrecommendation.yaml",
            "description": "API for Manual Credit Recommendation Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Manual Credit Recommendation"
        },
        {
            "index": 124,
            "yaml": "../../OFLO/obremo-rpm-cmn-scorecardservices/documentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-cmn-scorecardservices",
            "displayName": "Document Linkage"
        },
        {
            "index": 125,
            "yaml": "../../OFLO/obremo-rpm-creditcardapplication-services/documentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-creditcardapplication-services",
            "displayName": "Document Linkage"
        },
        {
            "index": 126,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/creditrestrictions.yaml",
            "description": "API for Credit Restrictions Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Credit Restrictions"
        },
        {
            "index": 127,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/mortgageinsurance.yaml",
            "description": "API for Mortgage Insurance Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Mortgage Insurance"
        },
        {
            "index": 128,
            "yaml": "../../OFLO/obremo-rpm-lo-loanapplications/documentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-lo-loanapplications",
            "displayName": "Document Linkage"
        },
        {
            "index": 129,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/OriginPreferences.yaml",
            "description": "API for Origin Preferences Details",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Origin Preferences"
        },
        {
            "index": 130,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/reasonCode.yaml",
            "description": "API for Reason Code",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Reason Code"
        },
        {
            "index": 131,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/ApplicationParameters.yaml",
            "description": "API for Application Parameters Details",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Application Parameters"
        },
        {
            "index": 132,
            "yaml": "../../OFLO/obremo-rpm-maintenance-services/DocumentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-maintenance-services",
            "displayName": "Document Linkage"
        },
        {
            "index": 133,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/dashboard.yaml",
            "description": "API for Dashboard Details",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Dashboard Details"
        },
        {
            "index": 134,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/reason_service.yaml",
            "description": "API for Reason Service Details",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "reason Service Details"
        },
        {
            "index": 135,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/OdApprovalDetails.yaml",
            "description": "API for OD Approval Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "OD Approval Details"
        },
        {
            "index": 136,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/debitBureauInformation.yaml",
            "description": "API for Debit Bureau Information Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Debit Bureau Information"
        },
        {
            "index": 137,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/manualdecision.yaml",
            "description": "API for Manual Decision Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Manual Decision"
        },
        {
            "index": 138,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/CasaProductDetails.yaml",
            "description": "API for CASA Product Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "CASA Product Details"
        },
        {
            "index": 139,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/customerdecision.yaml",
            "description": "API for Customer Decision Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Customer Decision"
        },
        {
            "index": 140,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/OdAccountLimitDetails.yaml",
            "description": "API for OD Account Limit Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "OD Account Limit"
        },
        {
            "index": 141,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/OfferIssue.yaml",
            "description": "API for Offer Issue Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Offer Issue"
        },
        {
            "index": 142,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/postamendmentdetails.yaml",
            "description": "API for Post Amendment Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Post Amendment Details"
        },
        {
            "index": 143,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/applicantservices.yaml",
            "description": "API for Applicant Service Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Applicant Services"
        },
        {
            "index": 144,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/ApplicantTypeServices.yaml",
            "description": "API for Applicant Type Services Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Applicant Type Services"
        },
        {
            "index": 145,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/documentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Document Linkage Details"
        },
        {
            "index": 146,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/savingAggregate.yaml",
            "description": "API for Saving Aggregate Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Saving Aggregate Details"
        },
        {
            "index": 147,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/tellerTxn.yaml",
            "description": "API for Teller Transaction Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Teller Transaction Details"
        },
        {
            "index": 148,
            "yaml": "../../OFLO/obremo-rpm-sav-account-service/CasaAggregate.yaml",
            "description": "API for Casa Aggregate Details",
            "parentcategory": "obremo-rpm-sav-account-service",
            "displayName": "Casa Aggregate"
        },
        {
            "index": 149,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/backofficedetails.yaml",
            "description": "API for Loans Back Office Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Back Office Details"
        },
        {
            "index": 150,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/applicantservices.yaml",
            "description": "API for Applicant Service Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Applicant Service"
        },
        {
            "index": 151,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/documentLinkage.yaml",
            "description": "API for Document Linkage Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Document Linkage"
        },
        {
            "index": 152,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/ProdAttr.yaml",
            "description": "API for Business Product Attribute Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Product Attribute Details"
        },
        {
            "index": 153,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/ProdPref.yaml",
            "description": "API for Product Preference Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Product Preference Details"
        },
        {
            "index": 154,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/TdApplication.yaml",
            "description": "API for Term Deposit Application Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Term Deposit Application"
        },
        {
            "index": 155,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/tellerTxn.yaml",
            "description": "API for Teller Transaction Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Teller Transaction"
        },
        {
            "index": 156,
            "yaml": "../../OFLO/obremo-rpm-term-deposit-service/TDAggregate.yaml",
            "description": "API for Term Deposit Aggregate Details",
            "parentcategory": "obremo-rpm-term-deposit-service",
            "displayName": "Term Deposit Aggregate"
        },
        {
            "index": 157,
            "yaml": "../../OFLO/obremo-rpm-projection-services/alert.yaml",
            "description": "APIs for Alert Details",
            "parentcategory": "obremo-rpm-projection-services",
            "displayName": "Alert Details"
        },
        {
            "index": 159,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/inquiry.yaml",
            "description": "API for Inquiry Details",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "Inquiry Details"
        },
        {
            "index": 160,
            "yaml": "../../OFLO/obremo-rpm-process-driver-services/inquiry_service.yaml",
            "description": "API for Inquiry Service Details",
            "parentcategory": "obremo-rpm-process-driver-services",
            "displayName": "inquiry Service Details"
        }
    ]}