## (area: all)
The _all_ area includes resources that span functional areas. For this release of the API, the object versioning interface is the only resource included in _all_.

### Overview of Object Versioning
DSR supports the concept of _object versioning_, so that an MMI client can easily track the configuration changes that are made to the DSR. The _configuration level_ is an integer value that gets incremented each time a change is made, and the configuration level integer exists 1) for the OAM server as a whole to track all changes made to the configuration database, and 2) for each individual resource type to track changes made to the instances of that particular resource.

An MMI client requests the current configuration level data from an OAM server, and uses that data to identify where changes have been made since the last time the client had a current view of the configuration. Clients use the Configuration Levels (/all/configurationlevels) URI to retrieve the current configuration level data, and the response to this request returns the server-scoped integer value (identified by "consolidated" in the response data) as well as the various resource-specific integer values for all resources supported by the OAM server (identified by the specific resource name).

Object versioning via configuration level is not yet included by all the functional areas within the DSR MMI API specification. For this release, only the diameter area supports configuration level.
