## (area: "auth")

### Authentication
The _auth_ area provides the tokens (**/auth/tokens**) interface for client authentication. Before performing any other operation with DSR, the client must first obtain an authentication token using the tokens interface.

The client provides credentials to identify itself, and if the credentials are successfully authenticated, DSR returns a valid token. The client then embeds the token in subsequent MMI calls using the `X-Auth-Token` header.

Tokens typically expire after two hours. It is the responsibility of the client to request a fresh token before or when the previous token expires. A valid token can also be used to authenticate a client, so it is possible to replace an unexpired token with a new one that has a fresh two-hour lifetime.

A token created on any OAM server is immediately usable on that server, and becomes usable on all the OAM servers in the DSR topology after a short propagation delay (typically 3-5 seconds). 

It is recommended that MMI clients re-use a valid token for up to its full two hour lifetime, rather than request a new token for each MMI non-authentication request. Requesting a new token for each non-authentication request effectively doubles the number of MMI requests the client sends to the DSR. Clients may observe decreased MMI responsiveness if a new token is requested for every non-authentication MMI request, compared to getting a token and using it for all subsequent MMI requests within its two hour lifetime.

### Authorization
The token grants the bearer the same capabilities as the original MMI authentication credentials. GUI and MMI share the same user accounts and permissions database (GUI group) settings. Note that some user accounts may be limited to GUI-only or MMI-only access.

### Audit Trail
All uses of a token are logged to the system security log (also shared with the GUI). Token creation and expiration generate events in the system event log.
