## (area: "bulk")

The _bulk_ area supplies a bulk export/import facility (**/bulk/configurator**). The bulk export is used to extract configuration information from a DSR in bulk. Bulk export is always done per _area_, although multiple areas can be specified in a single MMI request. All resources included in the specified area(s) are exported together, and the results are written to an XML file located on the OAM server that received the request. For import, xml file size should not be larger than the configured limit i.e. 1048576 bytes.
For larger data import, user needs to segregate data into multiple files with specified file size limit.
Bulk export of individual resources is not supported.

Bulk import is limited to just the comagent, diameter, fabr, rbar, topo , map-diameter and vstp area, and is used to deploy the configuration associated with the topology rapidly for one or more DSR sites. The bulk import facility can only be used to insert (POST) configuration instances; it cannot be used to edit or delete configuration.

Import operation can be performed either in sync or async mode. In async mode,it creates taskid for eg. "mon/tasks/<servername>:<taskid>". Performing get operation on taskid(url mentioned as example) will give information about failure or success accordingly. If import gets failed it will put all error in a log file and will share the path of that log file.

In Sync mode, the import operation is non-atomic; the import operation returns a result code and a list of all the import failures providing details on why the import operation failed. At the end of the import operation, any objects that were successfully configured remain configured; any objects that failed configuration are not configured. It is up to the client to interpret any error messages and take whatever remedial action is necessary to ensure a complete and correct topology configuration.

Some common reasons why an object may fail to be successfully imported are:

1. The object is already in the configuration (duplicate id).
2. The syntax of the XML specification for the object is incorrect (syntax).
3. Internal validation rules block the creation of the object (semantic checks).
4. The server is overloaded and cannot handle a new request.

Managed objects cannot be edited or deleted using the import interface. Rather, the individual resource MMI APIs must be used (e.g., **DELETE /topo/servers/{servername}**).

### Bootstrapping

Whenever a new server is created using either the bulk import operation or the topology server insert (POST), the new server needs to be bootstrapped to activate it and enable it to become part of the functioning system topology. Depending on how much configuration was performed on the bare metal or on the new VM by an infrastructure manager, the bootstrap may have more or less to do. The bootstrap is performed by invoking the **/topo/servers/{servername}/bootstrap** operation directly on the new server, passing a list of bootstrap options. Shortly after the bootstrap has completed, the other servers in the topology should recognize the new server, and the new server is configured and prepared for operation. The progress of the server can be monitored using the server status interface (**/topo/servers/{servername}/status**).
