### Retrieving Resource Instances: GET

There are many ways an MMI client can create the HTTP request sent to the DSR. One common tool is curl, which is available in many languages and supports several internet protocols, including HTTPS. The following example illustrates use of curl from a command line to GET all of the Capacity Configuration Sets (/diameter/capacityconfigurationsets) configured at the target DSR (here represented by 'localhost'):

**`curl --header 'X-Auth-Token:EFEFC54B7F19EE5B75DF' --request GET  'https://localhost/mmi/dsr/v1.0/diameter/capacityconfigurationsets'`**

The structured response returned by the DSR contains the following JSON data structure:

  `
  {
    "data": [
        {
            "configurationLevel": "0",
            "convergenceTime": 1000,
            "ingressMpsMajorAlarmThreshold": 80,
            "ingressMpsMinorAlarmThreshold": 50,
            "maxIngressMps": 10000,
            "name": "Default",
            "reservedIngressMps": 0,
            "reservedIngressMpsAbatementTime": 2000
        }
    ],
    "links": {},
    "messages": [],
    "status": true
  }
  `

The value of true for "status" indicates that the request was successfully processed, without any errors. In this case, there is only a single Capacity Configuration Set present in the DSR configuration, so only one instance appears in the array in the "data" section of the response.

### Inserting a Resource Instance: POST

When inserting a new resource instance into the DSR configuration, the client must supply a JSON data structure, in accordance with the schema defined for the resource being inserted. In the following example, a Capacity Configuration Set (/diameter/capacityconfigurationsets) is added to the DSR represented by 'localhost' using curl from a command line:

**`curl --header 'X-Auth-Token:D2D588AE818739218A33' --request POST --data '{"name": "CapacityConfigurationSet1", "ingressMpsMajorAlarmThreshold": 80, "maxIngressMps": 10000, "reservedIngressMpsAbatementTime": 2000, "ingressMpsMinorAlarmThreshold": 50, "convergenceTime": 1000, "reservedIngressMps": 0}' 'https://localhost/mmi/dsr/v1.0/diameter/capacityconfigurationsets'`**

Assuming all supplied data is valid and the Capacity Configuration Set is successfully added to the configuration, the response from the DSR is:

  `
  {
    "data":
       {
         "id": "CapacityConfigurationSet1",
       },
    "links": {},
    "messages": [],
    "status": true
  }
  `
