This section contains the export XSD schema that is used to validate the XML file generated by a Bulk Configurator (/bulk/configurator) GET request.

```xml
<?xml version="1.0" encoding="UTF-8"?>
<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema">
  <!-- Connection Group Object -->
  <xsd:complexType name="ComagentConnectionGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="assignedServers" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Remote Servers Object -->
  <xsd:complexType name="ComagentRemoteServer">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipAddressPreference" type="ipAddressPreferenceType"/>
      <xsd:element maxOccurs="unbounded" minOccurs="1" name="localServerGroup" type="localServerGroupType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="remoteServerIPv4Address" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="remoteServerIPv6Address" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteServerMode" type="remoteServerModeType"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- END LOADGEN ATTRIBUTE DEFINITIONS -->
  <xsd:complexType name="connectionGroupStat">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="priority" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="ipAddressPreferenceType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="GlobalConfig"/>
      <xsd:enumeration value="Ipv4"/>
      <xsd:enumeration value="Ipv6"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="remoteServerModeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Client"/>
      <xsd:enumeration value="Server"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="localServerGroupType">
    <xsd:restriction base="xsd:string"></xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="requiredString">
    <xsd:restriction base="xsd:string">
      <xsd:minLength value="1"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="IPv4">
    <xsd:restriction base="xsd:string">
      <xsd:pattern value="(([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5]).){3}([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5])"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="IPv4orIPv6">
    <xsd:restriction base="xsd:string">
      <xsd:pattern value="((([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5]).){3}([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5]))|([0-9A-Fa-f:]){1,46}|([0-9A-Fa-f]*[:]{1,2}[0-9A-Fa-f\.]*[0-9A-Fa-f]){0,46}"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="IPv4orIPv6NetMask">
    <xsd:restriction base="xsd:string">
      <xsd:pattern value="((([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5]).){3}([01]?[0-9]?[0-9]|2[0-4][0-9]|25[0-5]))|/[0-9]{1,3}"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="yesNo">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="yes"/>
      <xsd:enumeration value="no"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Peer Node Object -->
  <xsd:complexType name="PeerNode">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="aaaProtocol" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="actionOnVerificationFailure" type="verificationFailureActions"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="altRouteName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="altRtOnAnswerResultCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="altRtOnAnswerTimeout" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="altRtOnConnFailure" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="answerOnAnyEnabledConnection" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="appRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="avpRemovalListName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ca_cert" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dtlsPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dessEnable" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dess_algorithm" type="dessAlgoType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ignorePriorityFromPeer" type="xsd:boolean"/>
      <xsd:element maxOccurs="128" minOccurs="0" name="ip" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="isDynamic" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="maxAltRouteAttempts" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="minConnCapacity" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgPriorityCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgPrioritySetting" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerNodeGroupName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendingAnswerTimerName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="public_cert" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="replaceDestHost" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="replaceDestRealm" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingOptionSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sctpPort" type="xsd:integer"/>
      <xsd:element maxOccurs="10" minOccurs="0" name="serverPort" type="Port"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tcpPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tlsPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="topologyHidingEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="transactionCfgSetName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="Port">
    <xsd:restriction base="xsd:integer"></xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="IPAddress">
    <xsd:restriction base="xsd:string"></xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="yesNoType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Yes"/>
      <xsd:enumeration value="No"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="dessAlgoType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="RSA_SHA_256"/>
      <xsd:enumeration value="EC_DSA_SHA_256"/>
      <xsd:enumeration value="DSA_SHA_256"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="verificationFailureActions">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="SendError"/>
      <xsd:enumeration value="SilentlyDiscardError"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Local Node Object -->
  <xsd:complexType name="LocalNode">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="ca_cert" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="certName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="certType" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="certVerifyMode" type="VerifyMode"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cexCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dessEnable" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dess_algorithm" type="dessAlgoType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dtlsPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="endClientPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="128" minOccurs="1" name="ip" type="LocalNodeIp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="private_key" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="public_cert" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusClientPortEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sctpPort" type="xsd:integer"/>
      <xsd:element maxOccurs="10" minOccurs="0" name="serverPort" type="Port"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="startClientPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tcpPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tlsPort" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="LocalNodeIp">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="ipAddr" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ipType" type="localIPType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="localIPType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="LocalIp"/>
      <xsd:enumeration value="IpfeTsa"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="VerifyMode">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="SslVerifyNone"/>
      <xsd:enumeration value="SslVerifyPeer"/>
      <xsd:enumeration value="SslVerifyPeerFailIfNoPeerCert"/>
      <xsd:enumeration value="SslVerifyPeerVerifyClientOnce"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Connection Object -->
  <xsd:complexType name="Connection">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="aaaProtocol" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="altLocalIp" type="ipAddressType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="altPeerIp" type="ipAddressType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="capacityCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cexCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionMode" type="connectionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipfeInitiatorDampIp" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="isDynamic" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="localInitiatorPort" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="localIp" type="ipAddressType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="localIpOwner" type="ipAddressType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgAuthCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgConvCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgPriorityCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgPrioritySetting" type="connMsgPrioritySetting"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgThrottlingCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerIdentification" type="connectionPeerIdent"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerIp" type="ipAddressType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="remoteBusyTimeout" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="remoteBusyUsage" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sharedSecretCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="statusServerCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="suppressConnAttempt" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="suppressConnUnavailableAlarm" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="testMode" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="transportCongTimeout" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="transportFqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="transportProtocol" type="connectionProtocol"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="udpPort" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="ipAddressType">
    <xsd:restriction base="xsd:string"></xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="enabledDisabledType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Enabled"/>
      <xsd:enumeration value="Disabled"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="connectionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="FullySpecified"/>
      <xsd:enumeration value="LocalMpInitiator"/>
      <xsd:enumeration value="LocalMpResponder"/>
      <xsd:enumeration value="RadiusServer"/>
      <xsd:enumeration value="RadiusClient"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="connectionProtocol">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Sctp"/>
      <xsd:enumeration value="Dtls"/>
      <xsd:enumeration value="Tcp"/>
      <xsd:enumeration value="Tls"/>
      <xsd:enumeration value="Udp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="connectionPeerIdent">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ip"/>
      <xsd:enumeration value="TransportFqdn"/>
      <xsd:enumeration value="PeerFqdn"/>
      <xsd:enumeration value="None"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="connMsgPrioritySetting">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="None"/>
      <xsd:enumeration value="RequestMessage"/>
      <xsd:enumeration value="UserConfigured"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Peer Route Table -->
  <xsd:complexType name="PeerRouteTable">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Route Group Object -->
  <xsd:complexType name="RouteGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="512" minOccurs="0" name="connection" type="ConnRouteGroup"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="isDynamic" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="isTrafficMeasuringEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="512" minOccurs="0" name="peerNode" type="PeerRouteGroup"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="type" type="RouteGroupType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="RouteGroupType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Peer"/>
      <xsd:enumeration value="Connection"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="PeerRouteGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerNodeWeight" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="ConnRouteGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionWeight" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Connection Alarm Group -->
  <xsd:complexType name="ConnectionAlarmGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="200" minOccurs="1" name="connectionName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleMinorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleMajorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleCriticalThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementMinorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementMajorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementCriticalThreshold" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Peer Routing Rules -->
  <xsd:complexType name="PeerRouteRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="peerRouteRuleAction"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="conditions" type="RuleConditions"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="diamAnsCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errorMessage" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgCpyCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msgPriority" type="peerRouteRuleMsgPriority"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="priority" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routeListName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="targetPrtName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="RuleConditions">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="IntegerValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCode" type="StringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destHost" type="StringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destRealm" type="StringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="origHost" type="StringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="origRealm" type="StringValueRuleCondition"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="IntegerValueRuleCondition">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="operator" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="value" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="StringValueRuleCondition">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="operator" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="value" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="peerRouteRuleAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="RouteToPeer"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="AbandonWithNoAns"/>
      <xsd:enumeration value="RouteToPrt"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="peerRouteRuleMsgPriority">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Nc"/>
      <xsd:enumeration value="Pr0"/>
      <xsd:enumeration value="Pr1"/>
      <xsd:enumeration value="Pr2"/>
      <xsd:enumeration value="Pr3"/>
      <xsd:enumeration value="Pr4"/>
      <xsd:enumeration value="Pr5"/>
      <xsd:enumeration value="Pr6"/>
      <xsd:enumeration value="Pr7"/>
      <xsd:enumeration value="Pr8"/>
      <xsd:enumeration value="Pr9"/>
      <xsd:enumeration value="Pr10"/>
      <xsd:enumeration value="Pr11"/>
      <xsd:enumeration value="Pr12"/>
      <xsd:enumeration value="Pr13"/>
      <xsd:enumeration value="Pr14"/>
      <xsd:enumeration value="Pr15"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- DPD Realms -->
  <xsd:complexType name="DpdRealm">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realmDesc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realmName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- DPD DNS Sets -->
  <xsd:complexType name="DpdDnsSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="dnsSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="numRetries" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryIp" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="queryTimeOut" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryIp" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- DPD Attribute Sets -->
  <xsd:complexType name="DpdAttributeSet">
    <xsd:sequence>
      <xsd:element maxOccurs="10" minOccurs="1" name="applications" type="DpdAttributeApplications"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="capacityCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionMode" type="DpdConnectionMode"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="dnsSet" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="followProtoPref" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipfeInitiatorDAMPIp" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localIp" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localNode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realmPrefix" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="DpdAttributeApplications">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="addSuppVendorID" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cexParameter" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="dtlsPreference" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxConn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxPeers" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpPreference" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpPreference" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tlsPreference" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="DpdConnectionMode">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Initiator"/>
      <xsd:enumeration value="InitiatorResponder"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Traffic Throttle Point -->
  <xsd:complexType name="TrafficThrottlePoint">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="altImplicitRouteListName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxEtr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxLossPercentThresh" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ttpConfigurationSetName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Traffic Throttle Group -->
  <xsd:complexType name="TrafficThrottleGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="shared" type="xsd:boolean"/>
      <xsd:element maxOccurs="20" minOccurs="1" name="trafficThrottlePointName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Connection Configuration Set -->
  <xsd:complexType name="ConnCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="cl1MinPriorityAllowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cl2MinPriorityAllowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cl3MinPriorityAllowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterCexHostIpValidationEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterCexTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterDisconnectTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterPendingTransactionsPerConnection" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterProvingDeviceWatchdogRequestsToSend" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterProvingMode" type="provingMode"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterProvingTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterTransportConnectionTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="diameterWatchdogTimerInitValue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusCachedResponseDuration" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusPendingTransactionsPerConnection" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusPreventDuplicateEgressRetransmission" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusPreventDuplicateIngressRetransmission" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpDatagramBundlingEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpFragmentationEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpHeartbeatInterval" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpMaximumBurst" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpMaximumSegmentSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpNumberInboundStreams" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpNumberOutboundStreams" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpOrderedDelivery" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionAssociationFailure" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionInitFailure" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionInitTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionMaximumTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionMaximumTimeoutInit" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionMinimumTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionPathFailure" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpSackDelay" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpSocketReceiveSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpSocketSendSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpKeepAliveEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpKeepAliveIdleTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpKeepAliveMaximumCount" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpKeepAliveProbeInterval" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpMaximumSegmentSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpNagleEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpSocketReceiveSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpSocketSendSize" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="provingMode">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Always"/>
      <xsd:enumeration value="Suspect"/>
      <xsd:enumeration value="Never"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Capacity Configuration Set -->
  <xsd:complexType name="CapCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="convergenceTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ingressMpsMajorAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ingressMpsMinorAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxIngressMps" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="reservedIngressMps" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="reservedIngressMpsAbatementTime" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Egress Message Throttling Configuration Set -->
  <xsd:complexType name="MsgThrottlingCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementThresh1" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="abatementThresh2" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="abatementThresh3" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="convergenceTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxEgressMessageRate" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleThresh1" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="throttleThresh2" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="throttleThresh3" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Message Copy Configuration Set -->
  <xsd:complexType name="MessageCopyCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="answerIncluded" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="dasAnswerResultCode" type="MCCSDasAnswerResultCodeType"/>
      <xsd:element maxOccurs="4" minOccurs="1" name="maxRetryAttempts" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="originalAnswerResultCode" type="MCCSOriginalAnswerType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="requestType" type="MCCSRequestTypeType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routeListName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="MCCSDasAnswerResultCodeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="2xxx"/>
      <xsd:enumeration value="Any"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MCCSOriginalAnswerType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="2xxx"/>
      <xsd:enumeration value="Any"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MCCSRequestTypeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ingress"/>
      <xsd:enumeration value="Egress"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Rate Limiting Configuration Set -->
  <xsd:complexType name="RateCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxRate" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateAbateThresh1" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="rateAbateThresh2" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="rateAbateThresh3" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateAbateTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateConvergenceTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateOnsetThresh1" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="rateOnsetThresh2" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="rateOnsetThresh3" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Pending Transaction Rate Limiting Configuration Set -->
  <xsd:complexType name="PendTransCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxPendTrans" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendConvergenceTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pendTransAbateThresh1" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendTransAbateThresh2" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendTransAbateThresh3" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pendTransAbateTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pendTransOnsetThresh1" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendTransOnsetThresh2" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendTransOnsetThresh3" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Traffic Throttle Point Configurarion Set -->
  <xsd:complexType name="TrafficThrPointCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementRecoveryRate" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defaultReductionPercentage" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="defaultValidityDuration" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="overrideMessagePriorityThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateConvergenceTime" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Transaction Configuration Set -->
  <xsd:complexType name="TransactionCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1000" minOccurs="0" name="transactionRule" type="TransactionCfgRule"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Transaction Configuration Rule -->
  <xsd:complexType name="TransactionCfgRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="applicationRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cmdCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendingAnswerTimerName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingOptionSetName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Message Priority Configuration Set -->
  <xsd:complexType name="MsgPriorityCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="50" minOccurs="1" name="messagePriorityRule" type="MessagePriorityRule"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="MessagePriorityRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="priority" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ruleAppliesToAllAppIds" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Capabilities Exchange Configuration Set -->
  <xsd:complexType name="CexCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="20" minOccurs="0" name="clientMustIncludeAppIds" type="CexParameterCexCfgSet"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="20" minOccurs="0" name="dsrSupportedAppIds" type="CexParameterCexCfgSet"/>
      <xsd:element maxOccurs="20" minOccurs="0" name="dsrSupportedVendorIds" type="DsrSupportedVendorId"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="includeDsrFeatureStatusAvp" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="isDynamic" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="CexParameterCexCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="appIdType" type="CexParameterAppIdType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="CexParameterAppIdType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Authentication"/>
      <xsd:enumeration value="Accounting"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="DsrSupportedVendorId">
    <xsd:restriction base="xsd:integer"></xsd:restriction>
  </xsd:simpleType>
  <!-- MCC MNC Mapping -->
  <xsd:complexType name="MccMncMapping">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccndc" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="country" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="description" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mcc" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mnc" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="networkname" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="prefix" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Egress Throttle List -->
  <xsd:complexType name="Etl">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="3" minOccurs="2" name="etg" type="siteEtgNameGrp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pendingTransLimitingCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateLimitingCfgSetName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="siteEtgNameGrp">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionFailurePercentReduction" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="egressThrottleGroupName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="siteName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- MP Profile -->
  <xsd:complexType name="MpProfile">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="MpProfiles" type="mpProfilesRule"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="mpProfilesRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="DAMPElements" type="attributeValueMpProfilesRule"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="SS7MPElements" type="attributeValueSSsevMpProfilesRule"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="attributeValueMpProfilesRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="G6_Relay" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G8G9_Relay" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G7_Relay" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G6_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G8G9_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G7_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G6_Session" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G8G9_Session" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G7_Session" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G6_Session_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G8G9_Session_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="G7_Session_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_Relay" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_10K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_6K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_8K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_12K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_14K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_16K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_18K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_21K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_24K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_27K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_30K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="Gen9V2_Relay" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="Gen9V2_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="Gen9V2_Session" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_40K_MPS_FABR" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_45K_MPS_RBAR" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_35K_MPS" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="XLVM_Relay" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="XLVM_Database" type="profileValueMpProfileDamp"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="XLVM_Session" type="profileValueMpProfileDamp"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="profileValueMpProfileDamp">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="AvgHoldTimeCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="AvgHoldTimeCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="AvgHoldTimeMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="AvgHoldTimeMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="AvgHoldTimeMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="AvgHoldTimeMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="CL1DiscardPercent" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="CL2DiscardPercent" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="CL3DiscardPercent" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ConvergenceTime" type="mpProfileRuleConvergenceTime"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="DOCMsgDiscardPercent" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="DclEventTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="DrlAnswerTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="DrlMsgCopyTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="DrlRequestTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="DrlRerouteTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="FabrDpRspTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="FabrDpStatusTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="FabrReqTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="LongTimeoutPtrList" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MaxConnsThisMp" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MaxPendingTransactions" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpEngIngressMps" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpMaxIngressMps" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxAllRateCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxAllRateCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxAllRateMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxAllRateMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxAllRateMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxAllRateMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxDiamAllLenCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxDiamAllLenCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxDiamAllLenMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxDiamAllLenMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxDiamAllLenMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="MpRxDiamAllLenMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="PdraAnswerTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="PdraRequestTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="PdraSbrEventTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RbarApplTaskThr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RoutingMsgRateCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RoutingMsgRateCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RoutingMsgRateMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RoutingMsgRateMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RoutingMsgRateMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RoutingMsgRateMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxBatchSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxDmiwfMsgRateCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxDmiwfMsgRateCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxDmiwfMsgRateMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxDmiwfMsgRateMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxDmiwfMsgRateMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxDmiwfMsgRateMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrDpResponseMsgQueue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrMsgRateCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrMsgRateCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrMsgRateMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrMsgRateMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrMsgRateMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrMsgRateMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxFabrRequestMsgQueue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarMsgRateCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarMsgRateCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarMsgRateMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarMsgRateMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarMsgRateMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarMsgRateMinorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxRbarRequestMsgQueue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="RxThreadPool" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="TxBatchSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="TxThreadPool" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="mpProfileRuleConvergenceTime">
    <xsd:restriction base="xsd:integer">
      <xsd:enumeration value="250"/>
      <xsd:enumeration value="500"/>
      <xsd:enumeration value="1000"/>
      <xsd:enumeration value="2000"/>
      <xsd:enumeration value="4000"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="attributeValueSSsevMpProfilesRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="G8G9_MDIWF" type="profileValueMpProfileSSsev"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="VM_MDIWF" type="profileValueMpProfileSSsev"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="profileValueMpProfileSSsev">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="RxMdIwfIngressMsgRateCriticalClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="RxMdIwfIngressMsgRateCriticalSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="RxMdIwfIngressMsgRateMajorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="RxMdIwfIngressMsgRateMajorSet" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="RxMdIwfIngressMsgRateMinorClear" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="RxMdIwfIngressMsgRateMinorSet" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- MP Profile Assignment -->
  <xsd:complexType name="MpProfileAssignment">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="hostname" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="profileName" type="ProfileType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="ProfileType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Unassigned"/>
      <xsd:enumeration value="G6_Relay"/>
      <xsd:enumeration value="G8G9_Relay"/>
      <xsd:enumeration value="G7_Relay"/>
      <xsd:enumeration value="G6_Database"/>
      <xsd:enumeration value="G8G9_Database"/>
      <xsd:enumeration value="G7_Database"/>
      <xsd:enumeration value="G6_Session"/>
      <xsd:enumeration value="G8G9_Session"/>
      <xsd:enumeration value="G7_Session"/>
      <xsd:enumeration value="G6_Session_Database"/>
      <xsd:enumeration value="G8G9_Session_Database"/>
      <xsd:enumeration value="G7_Session_Database"/>
      <xsd:enumeration value="VM_Relay"/>
      <xsd:enumeration value="VM_Database"/>
      <xsd:enumeration value="VM_6K_Mps"/>
      <xsd:enumeration value="VM_8K_Mps"/>
      <xsd:enumeration value="VM_10K_Mps"/>
      <xsd:enumeration value="VM_12K_Mps"/>
      <xsd:enumeration value="VM_14K_Mps"/>
      <xsd:enumeration value="VM_16K_Mps"/>
      <xsd:enumeration value="VM_18K_Mps"/>
      <xsd:enumeration value="VM_21K_Mps"/>
      <xsd:enumeration value="VM_24K_Mps"/>
      <xsd:enumeration value="VM_27K_Mps"/>
      <xsd:enumeration value="VM_30K_Mps"/>
      <xsd:enumeration value="G8G9_MDIWF"/>
      <xsd:enumeration value="VM_MDIWF"/>
      <xsd:enumeration value="VM_40K_Mps_FABR"/>
      <xsd:enumeration value="VM_45K_Mps_RBAR"/>
      <xsd:enumeration value="VM_35K_Mps"/>
      <xsd:enumeration value="XLVM_Relay"/>
      <xsd:enumeration value="XLVM_Database"/>
      <xsd:enumeration value="XLVM_Session"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Route List Object -->
  <xsd:complexType name="RouteList">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destinationHost" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destinationRealm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="isDynamic" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="minCapacity" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="originHost" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="originRealm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rarg" type="xsd:boolean"/>
      <xsd:element maxOccurs="5" minOccurs="1" name="routeListRouteGroup" type="RouteListRouteGroup"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="RouteListRouteGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="priority" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routeGroupName" type="xsd:string"/>
      <xsd:element maxOccurs="10" minOccurs="0" name="routeListRouteGroupTtg" type="RouteListRouteGroupTtg"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="RouteListRouteGroupTtg">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="lossPercentThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="siteName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ttgName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- IPFE Options -->
  <xsd:complexType name="IpfeOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="clusterRebalancingAndAccounting" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="globalPacketRateLimit" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="gratuitousArpType" type="GratuitousArpType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="imbalanceDetectionThroughputMinimum" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipfeA1IpAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipfeA2IpAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipfeB1IpAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipfeB2IpAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="leastLoadThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="monitoringConnectionTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="monitoringConnectionTryInterval" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="monitoringPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="monitoringProtocol" type="MonitoringProtocolType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRejectOption" type="SctpRejectOptionType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="stateSyncReconnectInterval" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="stateSyncTcpPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tcpRejectOption" type="TcpRejectOptionType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="GratuitousArpType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ArpRequest"/>
      <xsd:enumeration value="ArpReply"/>
      <xsd:enumeration value="ArpBoth"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MonitoringProtocolType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Heartbeat"/>
      <xsd:enumeration value="None"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="SctpRejectOptionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Drop"/>
      <xsd:enumeration value="IcmpAdminProhibited"/>
      <xsd:enumeration value="IcmpHostUnreachable"/>
      <xsd:enumeration value="IcmpPortUnreachable"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="TcpRejectOptionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Drop"/>
      <xsd:enumeration value="IcmpAdminProhibited"/>
      <xsd:enumeration value="IcmpHostUnreachable"/>
      <xsd:enumeration value="IcmpPortUnreachable"/>
      <xsd:enumeration value="TcpReset"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- IPFE Target Sets -->
  <xsd:complexType name="IpfeTargetSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="allowedDeviation" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="alternateIpAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="alternatePreferredIpfeServer" type="PreferredIpfeServerType"/>
      <xsd:element maxOccurs="16" minOccurs="1" name="applicationServerIp" type="ApplicationServerIp"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="deleteAge" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="disabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ipAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="loadBalanceAlgorithm" type="LoadBalanceAlgorithmType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="loadFactorConnectionCount" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="loadFactorMps" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="number" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerNodeAwareEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerNodeGroupDistributionThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="preferredIpfeServer" type="PreferredIpfeServerType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="protocols" type="ProtocolsType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="ApplicationServerIp">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="alternateIpAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ipAddress" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="networkName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverDescription" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="weight" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="LoadBalanceAlgorithmType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Hash"/>
      <xsd:enumeration value="LeastLoad"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="PreferredIpfeServerType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="IpfeA1"/>
      <xsd:enumeration value="IpfeA2"/>
      <xsd:enumeration value="IpfeB1"/>
      <xsd:enumeration value="IpfeB2"/>
      <xsd:enumeration value="IpfeC1"/>
      <xsd:enumeration value="IpfeC2"/>
      <xsd:enumeration value="IpfeD1"/>
      <xsd:enumeration value="IpfeD2"/>
      <xsd:enumeration value="IpfeE1"/>
      <xsd:enumeration value="IpfeE2"/>
      <xsd:enumeration value="IpfeF1"/>
      <xsd:enumeration value="IpfeF2"/>
      <xsd:enumeration value="IpfeG1"/>
      <xsd:enumeration value="IpfeG2"/>
      <xsd:enumeration value="IpfeH1"/>
      <xsd:enumeration value="IpfeH2"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="ProtocolsType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Sctp"/>
      <xsd:enumeration value="Tcp"/>
      <xsd:enumeration value="SctpAndTcp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- DNS Options -->
  <xsd:complexType name="DnsOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="primaryIp" type="IPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="queryDuration" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryIp" type="IPAddress"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Routing Option Sets -->
  <xsd:complexType name="RoutingOptionSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connCongestionAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connCongestionErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connCongestionResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connCongestionVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connFailureAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connFailureErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connFailureResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connFailureVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destRealmNotServedAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destRealmNotServedErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destRealmNotServedResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destRealmNotServedVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxPerMsgFwdAllowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedArtPrtErrorAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedArtPrtErrorErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedArtPrtErrorResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedArtPrtErrorVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="noPeerResponseAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="noPeerResponseErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="noPeerResponseResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="noPeerResponseVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerRptCongestionAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerRptCongestionErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerRptCongestionResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="peerRptCongestionVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pendingAnswerTimerName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="resExhAction" type="ActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="transactionLifetime" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="ActionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Abandon"/>
      <xsd:enumeration value="SendAnswer"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Options -->
  <xsd:complexType name="Option">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="InterfaceAndResultCodeLevelMeasurement" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="alarmBudget" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="alarmGroupFeatureEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="congestionDiscardPolicy" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connMajorAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connReservedIngressMpsScaling" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="diameterEngMessageSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="dpdRealmExpiryMajAlarmThresholdHrs" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="dpdRealmExpiryMinAlarmThresholdHrs" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="encodeFqdnInLowerCase" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="etgMode" type="etgModeType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="excessiveRerouteAbateThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="excessiveRerouteOnsetThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ipfeConnCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ipfeConnMajorAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxNumOfRetryWithinSameRG" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mccsForRfMsgCopy" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="msgCopyDisableCongLevel" type="congLevelType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="msgCopyFeatureEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPs16PriorityAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ngnPsAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsAnswerPriorityMode" type="answerPriorityModeType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsCxAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsDhAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsGxAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsGxAdvancedPriority" type="gxAdvancedPriorityType"/>
      <xsd:element maxOccurs="5" minOccurs="0" name="ngnPsGxArp" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ngnPsMaxMessageRatePercentage" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsMaxNormalRequestPriority" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsMaxPriority0Allowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsMaxPriority1Allowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsMaxPriority2Allowed" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsMinimumAnswerPriority" type="answerPriorityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsMinimumInviolablePriority" type="inviolablePriorityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsRxAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsRxMpsAvpValue" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerNodeCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="peerPingFeatureEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="radiusAAARouteList" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="radiusMPNRouteList" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="radiusUMFRouteList" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusUdpClientSockRecvSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusUdpClientSockSendSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusUdpServerSockRecvSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusUdpServerSockSendSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="redirectAnsProcessingEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="redirectApplicationRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="redirectPeerRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rfMsgCopyFeatureEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routeListCriticalAggAlarmThreshold" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Application Priority Option -->
  <xsd:complexType name="ApplicationPriorityOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="answerDrmpAvpAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPs3gppAvpAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ngnPsDrmpAvpAdminStateEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="requestDrmpAvpAdminStateEnabled" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="congLevelType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Cl1"/>
      <xsd:enumeration value="Cl2"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="gxAdvancedPriorityType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Hss"/>
      <xsd:enumeration value="None"/>
      <xsd:enumeration value="Spr"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="answerPriorityType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="P0"/>
      <xsd:enumeration value="P3"/>
      <xsd:enumeration value="P14"/>
      <xsd:enumeration value="P15"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="inviolablePriorityType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="P3"/>
      <xsd:enumeration value="P4"/>
      <xsd:enumeration value="P15"/>
      <xsd:enumeration value="P99"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="etgModeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Threshold"/>
      <xsd:enumeration value="Limit"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="answerPriorityModeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="HighestPriority"/>
      <xsd:enumeration value="RequestPriority"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Application Ids -->
  <xsd:complexType name="ApplicationId">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Application Route Table -->
  <xsd:complexType name="ApplicationRouteTable">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Peer Node Alarm Group -->
  <xsd:complexType name="PeerNodeAlarmGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementCriticalThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementMajorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="abatementMinorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="200" minOccurs="1" name="peerNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleCriticalThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleMajorThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="throttleMinorThreshold" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Peer Node Group -->
  <xsd:complexType name="PeerNodeGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="32" minOccurs="0" name="peerNode" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Pending Answer Timer -->
  <xsd:complexType name="PendingAnswerTimer">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="value" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Command Code -->
  <xsd:complexType name="CommandCode">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="appIdType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Accounting"/>
      <xsd:enumeration value="Authentication"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Reserved MCC Range -->
  <xsd:complexType name="ReservedMccRange">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="endMccRange" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="startMccRange" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- AVP Removal List -->
  <xsd:complexType name="AvpRemovalList">
    <xsd:sequence>
      <xsd:element maxOccurs="10" minOccurs="1" name="avp" type="AvpRemovalListType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="direction" type="RemovalDirectionType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="messageType" type="RemovalType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="AvpRemovalListType">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="avpCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="avpName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="vendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="RemovalDirectionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Egress"/>
      <xsd:enumeration value="Ingress"/>
      <xsd:enumeration value="IngressAndEgress"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="RemovalType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="AnswerOnly"/>
      <xsd:enumeration value="RequestOnly"/>
      <xsd:enumeration value="RequestAndAnswer"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Reroute On Answer -->
  <xsd:complexType name="RerouteOnAnswer">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="ansResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ruleAppliesToAllAppIds" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Application Route Rule -->
  <xsd:complexType name="ApplicationRouteRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="action" type="appRouteRuleAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ansErrorMessage" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ansResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="appName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="appRouteTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="conditions" type="RuleConditions"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="forwardToTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="gxPrimeRequest" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="priority" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="appRouteRuleAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="AbandonWithNoAns"/>
      <xsd:enumeration value="ForwardToEgressRouting"/>
      <xsd:enumeration value="RouteToAppl"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="ForwardToArt"/>
      <xsd:enumeration value="ForwardToPrt"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Egress Throttle Group -->
  <xsd:complexType name="EgressThrottleGroup">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="128" minOccurs="0" name="connectionName" type="xsd:string"/>
      <xsd:element minOccurs="1" name="etgControlScope" type="etgControlScopeType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="128" minOccurs="0" name="peerNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pendingTransLimitingCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rateLimitingCfgSetName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="etgControlScopeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Etg"/>
      <xsd:enumeration value="Etl"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- CEX Parameter -->
  <xsd:complexType name="CexParameter">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="appIdType" type="CexParameterAppIdType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Trusted Network Lists -->
  <xsd:complexType name="TrustedNetworkList">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="100" minOccurs="1" name="trustedRealm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Path Topology Hiding Configuration Sets -->
  <xsd:complexType name="PathTopologyHidingCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="encryptionKey" type="xsd:string"/>
      <xsd:element maxOccurs="10" minOccurs="1" name="hostnameSuffix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pseudoProxy" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pseudoRouteRecord" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Hss Topology Hiding Configuration Sets -->
  <xsd:complexType name="HssTopologyHidingCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="topologyHidingAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="autoGenerate" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="count" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errMsg" type="xsd:string"/>
      <xsd:element maxOccurs="300" minOccurs="0" name="hostnames" type="hostName"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="length" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="prefix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="randomizeCount" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="singlePseudoHosts" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="suffix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="useSinglePseudoHost" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Mme Topology Hiding Configuration Sets -->
  <xsd:complexType name="MmeTopologyHidingCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="topologyHidingAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="autoGenerate" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="count" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errMsg" type="xsd:string"/>
      <xsd:element maxOccurs="300" minOccurs="1" name="hostnames" type="hostName"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="length" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="prefix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="randomizeCount" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="suffix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Pcrf Topology Hiding Configuration Sets -->
  <xsd:complexType name="PcrfTopologyHidingCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="topologyHidingAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="autoGenerate" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="count" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errMsg" type="xsd:string"/>
      <xsd:element maxOccurs="600" minOccurs="1" name="hostnames" type="hostName"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="length" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="prefix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="randomizeCount" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="suffix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Af Topology Hiding Configuration Sets -->
  <xsd:complexType name="AfTopologyHidingCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="topologyHidingAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="autoGenerate" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="count" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1200" minOccurs="1" name="hostnames" type="hostName"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="length" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="prefix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="randomizeCount" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="suffix" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="topologyHidingAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="Abandon"/>
      <xsd:enumeration value="Forward"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="hostName">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="actualHostname" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pseudoHostname1" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pseudoHostname2" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pseudoHostname3" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Topology Hiding: Protected Networks -->
  <xsd:complexType name="ProtectedNetwork">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="afTopologyHidingCfgSet" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="hssTopologyHidingCfgSet" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mmeTopologyHidingCfgSet" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pathTopologyHidingCfgSet" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pcrfTopologyHidingCfgSet" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="protectedRealm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="trustedNetList" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rf Message Copy -->
  <xsd:complexType name="RfMessageCopy">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="apn" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- FABR Address Resolution Object -->
  <xsd:complexType name="AddressResolution">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="applIdCmdCodeId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryRoutingEntity" type="routingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="primaryRoutingEntityBlacklistSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryRoutingEntityDestinationType" type="resolutionDestinationType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="primaryRoutingEntityFallBackSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="primaryRoutingEntityPrefixSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryRoutingEntityPrimaryAvp" type="AVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="primaryRoutingEntitySecondaryAvp" type="secondaryAvp"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntity" type="routingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityBlacklistSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityDestinationType" type="resolutionDestinationType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityFallBackSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityPrefixSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityPrimaryAvp" type="AVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntitySecondaryAvp" type="secondaryAvp"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntity" type="routingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityBlacklistSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityDestinationType" type="resolutionDestinationType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityFallBackSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityPrefixSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityPrimaryAvp" type="AVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntitySecondaryAvp" type="secondaryAvp"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- FABR Default Destination Object -->
  <xsd:complexType name="DefaultDestination">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- FABR System Options -->
  <xsd:complexType name="FabrOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="DataBaseType" type="dataBaseType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="allowSubsequentDSRAppInvoc" type="xsd:boolean"/>
      <xsd:element maxOccurs="10" minOccurs="0" name="asciiExcludedList" type="asciiDigit"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="blacklistSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="bundlingEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="excludeSpace" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="fallbackSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maximumBundleSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="prefixSearchEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="removeDestHost" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhaustionErrCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhaustionErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhaustionVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="5" minOccurs="0" name="tbcdExcludedList" type="tbcdExcluded"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppAction" type="unvApplication"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppRouteList" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppVendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="asciiDigit">
    <xsd:restriction base="xsd:string"/>
  </xsd:simpleType>
  <!-- FABR Routing Exception Object -->
  <xsd:complexType name="RoutingException">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="exceptionAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ansResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="exceptionType" type="routingExceptionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- FABR Supported Application Object -->
  <xsd:complexType name="SupportedApplication">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingMode" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- END LOADGEN ATTRIBUTE DEFINITIONS -->
  <xsd:simpleType name="routingEntityType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Imsi"/>
      <xsd:enumeration value="Impi"/>
      <xsd:enumeration value="Impu"/>
      <xsd:enumeration value="Msisdn"/>
      <xsd:enumeration value="ExternalId"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="resolutionDestinationType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Aaa"/>
      <xsd:enumeration value="Ocs"/>
      <xsd:enumeration value="Ofcs"/>
      <xsd:enumeration value="Pcrf"/>
      <xsd:enumeration value="ImsHss"/>
      <xsd:enumeration value="LteHss"/>
      <xsd:enumeration value="MtcHss"/>
      <xsd:enumeration value="UserDefined1"/>
      <xsd:enumeration value="UserDefined2"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="AVP">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Msisdn"/>
      <xsd:enumeration value="UserName"/>
      <xsd:enumeration value="PublicIdentity"/>
      <xsd:enumeration value="SubscriptionId0"/>
      <xsd:enumeration value="SubscriptionId1"/>
      <xsd:enumeration value="SubscriptionId2"/>
      <xsd:enumeration value="SubscriptionId3"/>
      <xsd:enumeration value="SubscriptionId4"/>
      <xsd:enumeration value="SvcInfoSubscrId0"/>
      <xsd:enumeration value="SvcInfoSubscrId1"/>
      <xsd:enumeration value="SvcInfoSubscrId2"/>
      <xsd:enumeration value="SvcInfoSubscrId3"/>
      <xsd:enumeration value="SvcInfoSubscrId4"/>
      <xsd:enumeration value="UserIdentityMsisdn"/>
      <xsd:enumeration value="UserIdentityPublic"/>
      <xsd:enumeration value="UserIdentifierMsisdn"/>
      <xsd:enumeration value="UserIdentifierUserName"/>
      <xsd:enumeration value="DeviceActionExternalId"/>
      <xsd:enumeration value="UserIdentifierExternalId"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="secondaryAvp">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Msisdn"/>
      <xsd:enumeration value="UserName"/>
      <xsd:enumeration value="PublicIdentity"/>
      <xsd:enumeration value="SubscriptionId0"/>
      <xsd:enumeration value="SubscriptionId1"/>
      <xsd:enumeration value="SubscriptionId2"/>
      <xsd:enumeration value="SubscriptionId3"/>
      <xsd:enumeration value="SubscriptionId4"/>
      <xsd:enumeration value="SvcInfoSubscrId0"/>
      <xsd:enumeration value="SvcInfoSubscrId1"/>
      <xsd:enumeration value="SvcInfoSubscrId2"/>
      <xsd:enumeration value="SvcInfoSubscrId3"/>
      <xsd:enumeration value="SvcInfoSubscrId4"/>
      <xsd:enumeration value="UserIdentityMsisdn"/>
      <xsd:enumeration value="UserIdentityPublic"/>
      <xsd:enumeration value="UserIdentifierMsisdn"/>
      <xsd:enumeration value="UserIdentifierUserName"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="unvApplication">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ContinueRouting"/>
      <xsd:enumeration value="DefaultRoute"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="SendAnsExp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="tbcdExcluded">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="*"/>
      <xsd:enumeration value="#"/>
      <xsd:enumeration value="a"/>
      <xsd:enumeration value="b"/>
      <xsd:enumeration value="c"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="dataBaseType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="UDR"/>
      <xsd:enumeration value="SDS"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="routingExceptionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="DpErrors"/>
      <xsd:enumeration value="NoAddrMatch"/>
      <xsd:enumeration value="DpCongestion"/>
      <xsd:enumeration value="UnknownCmdCode"/>
      <xsd:enumeration value="BlacklistedSubscriber"/>
      <xsd:enumeration value="NoRoutingEntityAddress"/>
      <xsd:enumeration value="NoDrtEntry"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="exceptionAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="AbandonRequest"/>
      <xsd:enumeration value="FwdUnchanged"/>
      <xsd:enumeration value="FwdToDest"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="SendAnsExp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Map Diameter IWF Ccndc Mapping Object -->
  <xsd:complexType name="CcndcMapping">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="ccndc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="description" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF Diameter Exception Object -->
  <xsd:complexType name="DiameterException">
    <xsd:sequence>
      <xsd:element maxOccurs="3" minOccurs="1" name="name" type="DiamExcep"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="DiamExcep">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="action" type="ExcepAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errorString" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="exceptionType" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="exceptionName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF Diameter Realm Object -->
  <xsd:complexType name="DiameterRealm">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="conversion" type="RealmConversion"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="network" type="RealmNetwork"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF Diameter Identity Gta Object -->
  <xsd:complexType name="DiameterIdentityGta">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gta" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF DMIWF Option Object -->
  <xsd:complexType name="DmiwfOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="avpInsertion" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingArt" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingPrt" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routeListName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="shutdownMode" type="DmiwfMode"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="shutdownTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uaErrStr" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uaResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uaVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="unavailableAction" type="DmiwfAction"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF GTA Range To PC Object -->
  <xsd:complexType name="GtaRangeToPc">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="defaultconfig" type="GtaConfig"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gtaend" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gtastart" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gtatopcId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="loadshare" type="GtaLoadshare"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="network" type="GtaNetwork"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primarypc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondarypc" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF Map Exception Object -->
  <xsd:complexType name="MapException">
    <xsd:sequence>
      <xsd:element maxOccurs="4" minOccurs="1" name="name" type="MapExcep"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="MapExcep">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="abortChoice" type="MapAbortChoice"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="abortReason" type="MapAbortReason"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="action" type="MapExcepAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errorCause" type="MapErrorCause"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="exceptionName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="exceptionType" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resUnavailReason" type="MapResUnavailReason"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Map Diameter IWF MDIWF Option Object -->
  <xsd:complexType name="MdiwfOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="diamTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dsrNodeGta" type="MdDsrNodeGta"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ecrHostAction" type="MdiwfecrAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecrHostErrString" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecrHostResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecrHostVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ecrNoDestHostAction" type="MdiwfecrAction"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecrNoHostErrString" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecrNoHostResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecrNoHostVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="eirDestHost" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="eirDestGta" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="eirDestRealm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="iwfHssDestHost" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="iwfHssDestRealm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mapTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="shutdownMode" type="DmiwfMode"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="shutdownTimer" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="MdDsrNodeGta">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="entityId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gta" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- END LOADGEN ATTRIBUTE DEFINITIONS -->
  <xsd:simpleType name="ExcepAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Discard"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="ApplyUnavailAction"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="RealmConversion">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="No"/>
      <xsd:enumeration value="Yes"/>
      <xsd:enumeration value="NA"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="RealmNetwork">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ITUI"/>
      <xsd:enumeration value="ANSI"/>
      <xsd:enumeration value="ITUN"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="DmiwfAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="ContinueRouting"/>
      <xsd:enumeration value="DefaultRoute"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="DmiwfMode">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Graceful"/>
      <xsd:enumeration value="Forced"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="GtaConfig">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Yes"/>
      <xsd:enumeration value="No"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="GtaNetwork">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ITUI"/>
      <xsd:enumeration value="ITUN"/>
      <xsd:enumeration value="ANSI"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="GtaLoadshare">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Solitary"/>
      <xsd:enumeration value="ActiveActive"/>
      <xsd:enumeration value="ActiveStandby"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MapExcepAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Discard"/>
      <xsd:enumeration value="SendAnswer"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MapAbortChoice">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="SpecificReason"/>
      <xsd:enumeration value="ResourceLimitation"/>
      <xsd:enumeration value="ResourceUnavailable"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MapAbortReason">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ContextNotSupported"/>
      <xsd:enumeration value="DialogRefused"/>
      <xsd:enumeration value="UserDefined"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MapErrorCause">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="DataMissing"/>
      <xsd:enumeration value="FacilityNotSupported"/>
      <xsd:enumeration value="IncompatibleTerminal"/>
      <xsd:enumeration value="SystemFailure"/>
      <xsd:enumeration value="ResourceLimitation"/>
      <xsd:enumeration value="UnexpectedDataValue"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MapResUnavailReason">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ShortTermLimitation"/>
      <xsd:enumeration value="LongTermLimitation"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="MdiwfecrAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Discard"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="TranslateUsingEir"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- MDS Streams -->
  <xsd:complexType name="ArrayOfStreams">
    <xsd:sequence>
      <xsd:element maxOccurs="unbounded" minOccurs="0" name="Streams" type="Streams"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="Streams">
    <xsd:sequence>
      <xsd:element minOccurs="1" name="measurementName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="MdsEnabledStreams">
    <xsd:sequence>
      <xsd:element minOccurs="1" name="measurementName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- MDS Stream Options -->
  <xsd:complexType name="StreamOptions">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryIpPort" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="backupIpPort" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="topic" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="clientId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="compressionCodec" type="compressionCodecType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="compressionLevel" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="batchSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linger" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="numOfAcks" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="securityProtocol" type="securityProtocolType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sslProtocol" type="sslProtocolType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="maxRecordSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="deliveryTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="requestTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="retries" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sslCa" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sslCertificate" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sslKey" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sslKeyPassword" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslMechanisms" type="saslMechanismsType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslKerberosServiceName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslKerberosPrincipal" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslKerberosKinitCmd" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslKerberosKeytab" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslKerberosMinTimeBeforeRelogin" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslUsername" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="saslPassword" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="intervalSize" type="intervalSizeType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="maxRetentionTime" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="outputFormat" type="outputFormatType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="compressionCodecType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="nocompression"/>
      <xsd:enumeration value="gzip"/>
      <xsd:enumeration value="snappy"/>
      <xsd:enumeration value="lz4"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="securityProtocolType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="PLAINTEXT"/>
      <xsd:enumeration value="SASL_PLAINTEXT"/>
      <xsd:enumeration value="SASL_SSL"/>
      <xsd:enumeration value="SSL"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="sslProtocolType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="TLSv1.3"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="saslMechanismsType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="GSSAPI"/>
      <xsd:enumeration value="PLAIN"/>
      <xsd:enumeration value="SCRAM_SHA_256"/>
      <xsd:enumeration value="SCRAM_SHA_512"/>
      <xsd:enumeration value="OAUTHBEARER"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="intervalSizeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="5min"/>
      <xsd:enumeration value="15min"/>
      <xsd:enumeration value="30min"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="outputFormatType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="JSON"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- RADIUS Ingress Status Server Configuration Set Object -->
  <xsd:complexType name="IngressStatusServerConfigurationSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="ingressStatusServerSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sendResponseToStatusServer" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="statusServerResponseMessageType" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- RADIUS Message Authenticator Configuration Set Object -->
  <xsd:complexType name="MessageAuthenticatorConfigurationSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="clientEncodeMessageAuthenticatorInEgressAccessRequest" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="clientEncodeMessageAuthenticatorInEgressCoARequest" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="clientEncodeMessageAuthenticatorInEgressDisconnectRequest" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="messageAuthenticatorConfigurationSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressAccessAccept" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressAccessChallenge" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressAccessReject" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressCoAACK" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressCoANACK" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressDisconnectACK" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressDisconnectNACK" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverEncodeMessageAuthenticatorInEgressStatusServer" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- RADIUS Message Conversion Configuration Set Object -->
  <xsd:complexType name="MessageConversionConfigurationSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="msgConvCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="10" minOccurs="1" name="msgConvCfgSetRules" type="CfgSetRules"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="CfgSetRules">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:string"/>
      <xsd:element maxOccurs="5" minOccurs="0" name="applName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCodes" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="convType" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="radiusCode" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- RADIUS NAS Node Object -->
  <xsd:complexType name="NasNode">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nasIdentifier" type="xsd:string"/>
      <xsd:element maxOccurs="4" minOccurs="0" name="nasIPAddresses" type="NASIPAddress"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="nasNodeName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="NASIPAddress">
    <xsd:restriction base="xsd:string"></xsd:restriction>
  </xsd:simpleType>
  <!-- RADIUS Network Option Object -->
  <xsd:complexType name="NetworkOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="networkScopedSharedSecret" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- RADIUS Routing Table Object -->
  <xsd:complexType name="RadiusRoutingTable">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="apn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="authMpn" type="yesNoOption"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="keyAvp" type="KeyAvp"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vrfId" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="yesNoOption">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Yes"/>
      <xsd:enumeration value="No"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- RADIUS Shared Secret Configuration Set Object -->
  <xsd:complexType name="SharedSecretConfigurationSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sharedSecret" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- END LOADGEN ATTRIBUTE DEFINITIONS -->
  <xsd:simpleType name="KeyAvp">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Apn"/>
      <xsd:enumeration value="VrfId"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Rbar Address Range Object -->
  <xsd:complexType name="RbarAddressRange">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="destination" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="endAddr" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipv6PfxLength" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingEntityComp" type="routingEntityCompType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="startAddr" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tableName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Address Resolution Object -->
  <xsd:complexType name="RbarAddressResolution">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryRoutingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryRoutingEntityAddrTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryRoutingEntityPrimaryAvp" type="rbarAVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="primaryRoutingEntitySecondaryAvp" type="rbarAVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityAddrTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntityPrimaryAvp" type="rbarAVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryRoutingEntitySecondaryAvp" type="rbarAVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityAddrTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntityPrimaryAvp" type="rbarAVP"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="tertiaryRoutingEntitySecondaryAvp" type="rbarAVP"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Enhanced Address Resolution Object -->
  <xsd:complexType name="RbarAddressResolutionEnh">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="addrTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="cmdCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="conditions" type="rbarResolutionEnhConditions"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="primaryAvp" type="rbarAVP"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="priority" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="secondaryAvp" type="rbarAVP"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="rbarResolutionEnhConditions">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="apn" type="rbarStringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destHost" type="rbarStringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destRealm" type="rbarStringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="origHost" type="rbarStringValueRuleCondition"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="origRealm" type="rbarStringValueRuleCondition"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="rbarStringValueRuleCondition">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="operator" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="value" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Address Table Object -->
  <xsd:complexType name="RbarAddressTable">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="comment" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingEntityComp" type="routingEntityCompType"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Destination Object -->
  <xsd:complexType name="RbarDestination">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="avpInsertion" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Domain Address Object -->
  <xsd:complexType name="RbarDomainAddress">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="address" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destination" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipv6PfxLength" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingEntityComp" type="routingEntityCompType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tableName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Individual Address Object -->
  <xsd:complexType name="RbarIndividualAddress">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="address" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="destination" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ipv6PfxLength" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nestedTableName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routingEntity" type="rbarRoutingEntityType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingEntityComp" type="routingEntityCompType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tableName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Options Definition -->
  <xsd:complexType name="RbarOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="allowSubsequentDSRAppInvoc" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="apnCaseSensitiveMatch" type="xsd:boolean"/>
      <xsd:element maxOccurs="10" minOccurs="0" name="asciiExcludedList" type="rbarAsciiDigit"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="excludeSpace" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="fqdn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="realm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="removeDestHost" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="resExhaustionErrCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhaustionErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resExhaustionVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="splitMergeSupported" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="resolutionEnhSupported" type="xsd:boolean"/>
      <xsd:element maxOccurs="5" minOccurs="0" name="tbcdExcludedList" type="tbcdExcludedRbar"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppAction" type="unvApplicationRbar"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppErrMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppRouteList" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unavailableAppVendorId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uriSupported" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="rbarAsciiDigit">
    <xsd:restriction base="xsd:string"/>
  </xsd:simpleType>
  <!-- Rbar Routing Exception Definition -->
  <xsd:complexType name="RbarRoutingException">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="action" type="exceptionActionRbar"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ansResultCode" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="destName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="errMsg" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="exceptionType" type="rbarRoutingExceptionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="id" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="vendorId" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Rbar Supported Applications Definition -->
  <xsd:complexType name="RbarSupportedApplication">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="applId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingMode" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- END LOADGEN ATTRIBUTE DEFINITIONS -->
  <xsd:simpleType name="rbarRoutingEntityType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Imsi"/>
      <xsd:enumeration value="Msisdn"/>
      <xsd:enumeration value="Impi"/>
      <xsd:enumeration value="Impu"/>
      <xsd:enumeration value="Ipv4"/>
      <xsd:enumeration value="Ipv6PfxAddr"/>
      <xsd:enumeration value="Unsigned16"/>
      <xsd:enumeration value="ExternalId"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="routingEntityCompType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="LocalIdentifier"/>
      <xsd:enumeration value="DomainIdentifier"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="rbarAVP">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="PublicIdentity"/>
      <xsd:enumeration value="SvcInfoSubscrId0"/>
      <xsd:enumeration value="SvcInfoSubscrId1"/>
      <xsd:enumeration value="SvcInfoSubscrId2"/>
      <xsd:enumeration value="SvcInfoSubscrId3"/>
      <xsd:enumeration value="SvcInfoSubscrId4"/>
      <xsd:enumeration value="SubscriptionId0"/>
      <xsd:enumeration value="SubscriptionId1"/>
      <xsd:enumeration value="SubscriptionId2"/>
      <xsd:enumeration value="SubscriptionId3"/>
      <xsd:enumeration value="SubscriptionId4"/>
      <xsd:enumeration value="UserIdentityMsisdn"/>
      <xsd:enumeration value="UserIdentityPublic"/>
      <xsd:enumeration value="UserName"/>
      <xsd:enumeration value="FramedIpAddress"/>
      <xsd:enumeration value="FramedIpv6Prefix"/>
      <xsd:enumeration value="SvcInfoPsInfo3gppcc"/>
      <xsd:enumeration value="Msisdn"/>
      <xsd:enumeration value="UserIdentifierMsisdn"/>
      <xsd:enumeration value="UserIdentifierUserName"/>
      <xsd:enumeration value="UserIdentifierExternalId"/>
      <xsd:enumeration value="DeviceActionExternalId"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="unvApplicationRbar">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ContinueRouting"/>
      <xsd:enumeration value="DefaultRoute"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="SendAnsExp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="tbcdExcludedRbar">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="*"/>
      <xsd:enumeration value="#"/>
      <xsd:enumeration value="a"/>
      <xsd:enumeration value="b"/>
      <xsd:enumeration value="c"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="rbarRoutingExceptionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="UnknownCmdCode"/>
      <xsd:enumeration value="NoRoutingEntityAddress"/>
      <xsd:enumeration value="NoDrtEntry"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="exceptionActionRbar">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="AbandonRequest"/>
      <xsd:enumeration value="FwdUnchanged"/>
      <xsd:enumeration value="FwdToDest"/>
      <xsd:enumeration value="SendAnswer"/>
      <xsd:enumeration value="SendAnsExp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Database Options Object -->
  <xsd:complexType name="DatabaseOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="auditOperationRate" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Database Resizing Plans Object -->
  <xsd:complexType name="DatabaseResizingPlan">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="databaseType" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="initialNumOfServerGroups" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="initialResourceDomainName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="planName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sbrDatabaseName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="targetNumOfServerGroups" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="targetResourceDomainName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- Sbr Databases Object -->
  <xsd:complexType name="SbrDatabase">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="databaseType" type="sbrDatabaseType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="numberOfServerGroups" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ownerAppName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="placeAssociationName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="resourceDomainName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sbrDatabaseName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="sbrDatabaseType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Binding"/>
      <xsd:enumeration value="Session"/>
      <xsd:enumeration value="Usbr"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- Data Migration Plans Object -->
  <xsd:complexType name="DataMigrationPlan">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="initDatabase" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="initPlaceAssociation" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="migrationType" type="MigrationPlanType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="planName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="targetDatabase" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="targetPlaceAssociation" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="MigrationPlanType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Mating"/>
      <xsd:enumeration value="ReMating"/>
      <xsd:enumeration value="UnMating"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- VSTP Connection Object -->
  <xsd:complexType name="VstpConnection">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connCfgSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="connectionMode" type="connectionModeType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionType" type="connType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localHostName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteHostName" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Connection Configuration Set Object -->
  <xsd:complexType name="VstpConnCfgSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpFragmentationEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sctpHeartbeatInterval" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpMaximumBurst" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpMaximumSegmentSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpNumberInboundStreams" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpNumberOutboundStreams" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpOrderedDelivery" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionAssociationFailure" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionInitFailure" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionInitTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionMaximumTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionMaximumTimeoutInit" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionMinimumTimeout" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpRetransmissionPathFailure" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpSackDelay" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpSocketReceiveSize" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sctpSocketSendSize" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Default Conversion Object -->
  <xsd:complexType name="VstpDefaultConversion">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="dir" type="dirType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="gtixlat" type="gtixlatType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nai" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="np" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="npdd" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="npds" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nsdd" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nsds" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tta" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tti" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Feature Admin State Object -->
  <xsd:complexType name="VstpFeatureAdminState">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="adminState" type="adminStateType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Gtt Action Object -->
  <xsd:complexType name="VstpGttAction">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="act" type="actType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="actid" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atcaperr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cdGtmodName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgGtmodName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgpc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgpcogmsg" type="cgpcogmsgType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defactid" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="domain" type="domainType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="itcaperr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="loopSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mapSetId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mrnSetId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ri" type="riType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="rspName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="udtserr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uimreqd" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="useicmsg" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Gtt Title Address Object -->
  <xsd:complexType name="VstpGttTitleAddress">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="acn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="actsn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccgt" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cdselid" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cdssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgGtmod" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgcnvsn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgpc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgpcaction" type="cgpcactionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgselid" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defmapvr" type="defmapvrType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="domain" type="domainType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecdssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ecgssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="emapaddr" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="endAddress" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="fallback" type="fallbackType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="family" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gtmodName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="gttSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="loopSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="lspName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mapSetId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mrnSetId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="opc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="opcode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="opcsn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="optsn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pkgtype" type="pkgType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingIndicator" type="riType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="rspName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="smapaddr" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="splitAction" type="splitActionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="startAddress" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="subsystem" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="translateIndicator" type="translateIndicatorType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uniqueIdentifier" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Gtt Modifications Object -->
  <xsd:complexType name="VstpGttMod">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgpaSsn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gtZeroFill" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gtmodId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="newGTI" type="newGTIType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="newNAI" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="newNP" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="newTT" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="npdd" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="npds" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nsdd" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nsds" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sfxFirst" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Gtt Selector Object -->
  <xsd:complexType name="VstpGttSelector">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="cdgttsn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cggttsn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="domain" type="domainType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="globalTitleIndicator" type="globalTitleIndicatorType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gttSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="linksetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="natureOfAddressIndicator" type="natureOfAddressIndicatorType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="natureOfAddressIndicatorValue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="numberingPlan" type="numberingPlanType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="numberingPlanValue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="selid" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="translationType" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Gtt Set Object -->
  <xsd:complexType name="VstpGttSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="domain" type="domType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gttSetType" type="gttSETType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="npsn" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Gtt Action Set Object -->
  <xsd:complexType name="VstpGttActionSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="actid1" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="actid2" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="actsn" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Home Entity Object -->
  <xsd:complexType name="VstpHomeEntity">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="entityAddress" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="entityType" type="entType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpDelPfx" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Link Object -->
  <xsd:complexType name="VstpLink">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="connectionName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linksetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="signalingLinkCode" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Link Set Object -->
  <xsd:complexType name="VstpLinkSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="asNotification" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cgGtmod" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="enableBroadcastException" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gttmode" type="gttmodeType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ituTransferRestricted" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linkTransactionsPerSecond" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localSignalingPointName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtpScrEventLog" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtpScrSetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtpScrTestMode" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="numberSignalingLinkAllowedThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="numberSignalingLinkProhibitedThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteSignalingPointName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="routingContext" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="type" type="connType"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Local Host Object -->
  <xsd:complexType name="VstpLocalHost">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localHostName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localHostPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="localHostPriIPAddress" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="localHostSecIPAddress" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Local Signaling Point Object -->
  <xsd:complexType name="VstpLocalSignalingPoint">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cpcType" type="cpcsType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mtpPointCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="pcType" type="pcsType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ss7DomainType" type="domainType"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP M2pa Option Object -->
  <xsd:complexType name="VstpM2paOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="t16Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t17Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t1Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t2Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t3Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t4EmergencyTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t4NormalTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t5Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t6Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t7Timer" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP M3rl Option Object -->
  <xsd:complexType name="VstpM3rlOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="cnvAInat" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cnvCgda" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cnvCgdi" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cnvCgdn" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cnvCgdn24" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="cnvClgItu" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="gtCnvDflt" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="lsOnHoldTimer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="slsRotation" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sltT1Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sltT2Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="sparePCSupportEnabled" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t10Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t11Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t15Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t16Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t17Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t18Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t1Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t2Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t3Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t4Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t5Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="t6Timer" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="t8Timer" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Map Set Object -->
  <xsd:complexType name="VstpMapSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mapSetId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="messageRouteCongestion" type="messageRouteCongestionType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="relativeCost" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rspName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ssn" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="subsystemRoutingMessage" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="subsystemStatusOption" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="threshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uniqueIdentifier" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="weight" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Mrn Set Object -->
  <xsd:complexType name="VstpMrnSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mrnSetId" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="relativeCost" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rspName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="threshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="uniqueIdentifier" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="weight" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Mtp Screen Set Object -->
  <xsd:complexType name="VstpMtpScreenSet">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="nextScrRuleGroupName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="nsfi" type="nsfiType"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Mtp Screening Rule Object -->
  <xsd:complexType name="VstpMtpScreeningRule">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="area" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="h0Code" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="h1Code" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mainNumberArea" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mainSignalingArea" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nationalPointCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="networkCluster" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="networkClusterMember" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="networkIndicator" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="networkIndicatorCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="nextScrRuleGroupName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="nsfi" type="nsfiMtpScreeningRuleType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="priority" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ruleName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="scrRuleGroupName" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="scrRuleGroupType" type="scrRuleGrpType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serviceIndicator" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="signalingPoint" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="signalingPointId" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="subNumberArea" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="subSignalingArea" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="unitNumber" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="zone" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Remote Host Object -->
  <xsd:complexType name="VstpRemoteHost">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteHostName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteHostPort" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteHostPriIPAddress" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="remoteHostSecIPAddress" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Remote Signaling Point Object -->
  <xsd:complexType name="VstpRemoteSignalingPoint">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="aliasPointCode1" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="aliasPointCode1DomainType" type="domainType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="aliasPointCode2" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="aliasPointCode2DomainType" type="domainType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="enableBroadcastException" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="mtpPointCode" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ss7DomainType" type="domainType"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Route Object -->
  <xsd:complexType name="VstpRoute">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linksetName" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="remoteSignalingPointName" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routeCost" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Sccp Application Object -->
  <xsd:complexType name="VstpSccpApplication">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="appType" type="appsccpType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="ssn" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Sccp Loopset Object -->
  <xsd:complexType name="VstpSccpLoopset">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="action" type="actionType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="domain" type="domainType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="pointCodeList" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Sccp Option Object -->
  <xsd:complexType name="VstpSccpOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="1" name="class1seq" type="adminStateType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dfltfallback" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dfltgttmode" type="dfltgttmodeType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtprgtt" type="mtprgttType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtprgttfallback" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tgtt0" type="tgttType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tgtt1" type="tgttType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tgttudtkey" type="tgttudtkeyType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="tgttxudtkey" type="tgttxudtkeyType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="mtprgttType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="On"/>
      <xsd:enumeration value="Off"/>
    </xsd:restriction>
  </xsd:simpleType>
  <!-- VSTP Sccp Service Selector Object -->
  <xsd:complexType name="VstpSccpServiceSelector">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="configurationLevel" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="domain" type="sccpserseldomainType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="globalTitleIndicator" type="newGTIType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="gttRequired" type="xsd:boolean"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="name" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="natureOfAddressIndicator" type="natureOfAddressIndicatorType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="natureOfAddressIndicatorValue" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="numberingPlan" type="numberingPlanType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serviceNP" type="serviceNPType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serviceNai" type="serviceNaiType"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="serviceName" type="serviceNameType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="snn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="translationType" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Sccp Mnp Option Object -->
  <xsd:complexType name="VstpSccpMnpOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="atiackimsi" type="atiackimsiType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atiackmsisdn" type="atiackmsisdnType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atiackrn" type="atiackrnType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atiackvlrnum" type="atiackvlrnumType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atidfltrn" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atidlm" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atientitylen" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atinptype" type="atinpType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atisnai" type="atisnaiType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="atisupplocinfo" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ativlrnumlen" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc1-mccmnc1" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc10-mccmnc10" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc2-mccmnc2" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc3-mccmnc3" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc4-mccmnc4" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc5-mccmnc5" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc6-mccmnc6" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc7-mccmnc7" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc8-mccmnc8" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="ccnc9-mccmnc9" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="crptt" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defcc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defmapvr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defmcc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defmnc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="defndc" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="delccprefix" type="delccprefixType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="dngtzerofill" type="dngtzerofillType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="encdnpsdnnotfound" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="encdnpsptnone" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="encodecug" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="encodenps" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpcutnpaste" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpdra" type="inpdraType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpdranai" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpdranp" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpnec" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inprelcause" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpsnai1-cdpanai1" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpsnai2-cdpanai2" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpsnai3-cdpanai3" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpsnai4-cdpanai4" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpsnai5-cdpanai5" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="inpsprestype" type="inpspresType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mnpcrp" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mnpnpdbunavl" type="mnpnpdbunavlType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msisdntrunc" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msrndig" type="msrndigType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msrnlen" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msrnnai" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="msrnnp" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtmmsackn" type="mtsmsacknType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtmmsentylen" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtmmsgta" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtmmslen" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtmmstype" type="mtsmsType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsackn" type="mtsmsacknType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmschksrc" type="dngtzerofillType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsdltr" type="mtsmsdltrType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsdltrv" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsimsi" type="mtsmsimsiType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsnakerr" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsnni" type="mtsmsnniType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmsnp" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="mtsmstype" type="mtsmsType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc1" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc10" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc2" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc3" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc4" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc5" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc6" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc7" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc8" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="multcc9" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="serverpfx" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="srfaddr" type="xsd:string"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="srfnai" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="srfnp" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sridn" type="sridnType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="sridnnotfound" type="sridnnotfoundType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="srismdn" type="sridnType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="srismgttrtg" type="cnvClgItuType"/>
      <xsd:element maxOccurs="1" minOccurs="0" name="srvcrelaymapset" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- VSTP Alarm Aggregation Option Object -->
  <xsd:complexType name="VstpAlarmAggregationOption">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="alarmBudget" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="associationCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="associationMajorAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linkCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linkMajorAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="linksetCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="routeCriticalAggAlarmThreshold" type="xsd:integer"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="rspCriticalAggAlarmThreshold" type="xsd:integer"/>
    </xsd:sequence>
  </xsd:complexType>
  <!-- END LOADGEN ATTRIBUTE DEFINITIONS -->
  <xsd:simpleType name="connectionModeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Client"/>
      <xsd:enumeration value="Server"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="connType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="M2pa"/>
      <xsd:enumeration value="M3ua"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="dirType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Atoi"/>
      <xsd:enumeration value="Both"/>
      <xsd:enumeration value="Itoa"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="gtixlatType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="22"/>
      <xsd:enumeration value="24"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="adminStateType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Disabled"/>
      <xsd:enumeration value="Enabled"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="actType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Disc"/>
      <xsd:enumeration value="Dup"/>
      <xsd:enumeration value="Fwd"/>
      <xsd:enumeration value="Tcaperr"/>
      <xsd:enumeration value="Udts"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="cgpcogmsgType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Cgpcicmsg"/>
      <xsd:enumeration value="Dflt"/>
      <xsd:enumeration value="Opcicmsg"/>
      <xsd:enumeration value="Provcgpc"/>
      <xsd:enumeration value="Remove"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="cpcsType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Atinp"/>
      <xsd:enumeration value="Eir"/>
      <xsd:enumeration value="Gport"/>
      <xsd:enumeration value="Inpq"/>
      <xsd:enumeration value="Stp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="pcsType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Cpc"/>
      <xsd:enumeration value="Spc"/>
      <xsd:enumeration value="Tpc"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="domainType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ansi"/>
      <xsd:enumeration value="Itui"/>
      <xsd:enumeration value="Itui_s"/>
      <xsd:enumeration value="Itun"/>
      <xsd:enumeration value="Itun24"/>
      <xsd:enumeration value="Itun_s"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="riType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Gt"/>
      <xsd:enumeration value="Ssn"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="cgpcactionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Dflt"/>
      <xsd:enumeration value="Ignore"/>
      <xsd:enumeration value="Remove"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="defmapvrType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="V1"/>
      <xsd:enumeration value="V2"/>
      <xsd:enumeration value="V3"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="fallbackType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="No"/>
      <xsd:enumeration value="Sysdflt"/>
      <xsd:enumeration value="Yes"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="pkgType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ansiabort"/>
      <xsd:enumeration value="Ansiuni"/>
      <xsd:enumeration value="Any"/>
      <xsd:enumeration value="Bgn"/>
      <xsd:enumeration value="Cnt"/>
      <xsd:enumeration value="Cwop"/>
      <xsd:enumeration value="Cwp"/>
      <xsd:enumeration value="End"/>
      <xsd:enumeration value="Ituabort"/>
      <xsd:enumeration value="Ituuni"/>
      <xsd:enumeration value="Qwop"/>
      <xsd:enumeration value="Qwp"/>
      <xsd:enumeration value="Resp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="splitActionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="None"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="translateIndicatorType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Dpc"/>
      <xsd:enumeration value="Dpcngt"/>
      <xsd:enumeration value="Dpcssn"/>
      <xsd:enumeration value="None"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="newGTIType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="TtNumEncodingNature"/>
      <xsd:enumeration value="TtOnly"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="globalTitleIndicatorType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="NoGlobal"/>
      <xsd:enumeration value="TtNumEncodingNature"/>
      <xsd:enumeration value="TtOnly"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="natureOfAddressIndicatorType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="International"/>
      <xsd:enumeration value="National"/>
      <xsd:enumeration value="Reserved"/>
      <xsd:enumeration value="Subscriber"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="numberingPlanType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="E164"/>
      <xsd:enumeration value="E210"/>
      <xsd:enumeration value="E212"/>
      <xsd:enumeration value="E214"/>
      <xsd:enumeration value="F69"/>
      <xsd:enumeration value="Generic"/>
      <xsd:enumeration value="Private"/>
      <xsd:enumeration value="X121"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="domType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ansi"/>
      <xsd:enumeration value="Cross"/>
      <xsd:enumeration value="Itu"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="gttSETType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Cdgta"/>
      <xsd:enumeration value="Cdssn"/>
      <xsd:enumeration value="Cggta"/>
      <xsd:enumeration value="Cgpc"/>
      <xsd:enumeration value="Cgssn"/>
      <xsd:enumeration value="Imsi"/>
      <xsd:enumeration value="Msisdn"/>
      <xsd:enumeration value="Opc"/>
      <xsd:enumeration value="Opcode"/>
      <xsd:enumeration value="Smrpda"/>
      <xsd:enumeration value="Smrpoa"/>
      <xsd:enumeration value="Vlrnb"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="entType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="HomeRn"/>
      <xsd:enumeration value="HomeSmsc"/>
      <xsd:enumeration value="CdpnPfx"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="gttmodeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Cd"/>
      <xsd:enumeration value="Fcd"/>
      <xsd:enumeration value="Fcg"/>
      <xsd:enumeration value="Fcgfcd"/>
      <xsd:enumeration value="Fcdfcg"/>
      <xsd:enumeration value="Sysdflt"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="adapType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="HomeRn"/>
      <xsd:enumeration value="HomeSmsc"/>
      <xsd:enumeration value="CdpnPfx"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="cnvClgItuType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="On"/>
      <xsd:enumeration value="Off"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="messageRouteCongestionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Default"/>
      <xsd:enumeration value="Yes"/>
      <xsd:enumeration value="No"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="nsfiType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="BlkDpc"/>
      <xsd:enumeration value="BlkOpc"/>
      <xsd:enumeration value="Dpc"/>
      <xsd:enumeration value="Opc"/>
      <xsd:enumeration value="Sio"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="nsfiMtpScreeningRuleType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="AftDstn"/>
      <xsd:enumeration value="BlkDpc"/>
      <xsd:enumeration value="BlkOpc"/>
      <xsd:enumeration value="Dpc"/>
      <xsd:enumeration value="Fail"/>
      <xsd:enumeration value="Opc"/>
      <xsd:enumeration value="Sio"/>
      <xsd:enumeration value="Stop"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="scrRuleGrpType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="AftDstn"/>
      <xsd:enumeration value="BlkDpc"/>
      <xsd:enumeration value="BlkOpc"/>
      <xsd:enumeration value="Dpc"/>
      <xsd:enumeration value="Opc"/>
      <xsd:enumeration value="Sio"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="appsccpType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Eir"/>
      <xsd:enumeration value="Atinp"/>
      <xsd:enumeration value="Inpq"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="actionType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="discardOnly"/>
      <xsd:enumeration value="notifyOnly"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="dfltgttmodeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Cd"/>
      <xsd:enumeration value="Fcd"/>
      <xsd:enumeration value="Fcg"/>
      <xsd:enumeration value="Fcgfcd"/>
      <xsd:enumeration value="Fcdfcg"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="tgttType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Both"/>
      <xsd:enumeration value="None"/>
      <xsd:enumeration value="Udt"/>
      <xsd:enumeration value="Xudt"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="tgttudtkeyType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Enhmtp"/>
      <xsd:enumeration value="Mtp"/>
      <xsd:enumeration value="Sccp"/>
      <xsd:enumeration value="Tcap"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="tgttxudtkeyType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Enhmtp"/>
      <xsd:enumeration value="Mtp"/>
      <xsd:enumeration value="Sccp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="sccpserseldomainType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ansi"/>
      <xsd:enumeration value="Intui"/>
      <xsd:enumeration value="Itun"/>
      <xsd:enumeration value="Itun24"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="serviceNameType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Eir"/>
      <xsd:enumeration value="Atinp"/>
      <xsd:enumeration value="Gport"/>
      <xsd:enumeration value="Idpr"/>
      <xsd:enumeration value="Mosms"/>
      <xsd:enumeration value="Gflex"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="serviceNaiType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Ccrndn"/>
      <xsd:enumeration value="Intl"/>
      <xsd:enumeration value="Natl"/>
      <xsd:enumeration value="Rnidn"/>
      <xsd:enumeration value="Rnndn"/>
      <xsd:enumeration value="Rnsdn"/>
      <xsd:enumeration value="Sub"/>
      <xsd:enumeration value="Unknown"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="serviceNPType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="E164"/>
      <xsd:enumeration value="E212"/>
      <xsd:enumeration value="E214"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="msrndigType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="asdrn"/>
      <xsd:enumeration value="asdrnccdn"/>
      <xsd:enumeration value="asdrndn"/>
      <xsd:enumeration value="ccrnasddn"/>
      <xsd:enumeration value="ccasdrndn"/>
      <xsd:enumeration value="ccgrnrndn"/>
      <xsd:enumeration value="ccrngrndn"/>
      <xsd:enumeration value="ccrndn"/>
      <xsd:enumeration value="grnrn"/>
      <xsd:enumeration value="grnrnccdn"/>
      <xsd:enumeration value="grnrndn"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="rnasd"/>
      <xsd:enumeration value="rnasddn"/>
      <xsd:enumeration value="rnasdccdn"/>
      <xsd:enumeration value="rnccdn"/>
      <xsd:enumeration value="rndn"/>
      <xsd:enumeration value="rngrn"/>
      <xsd:enumeration value="rngrnccdn"/>
      <xsd:enumeration value="rngrndn"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="sridnType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="sccp"/>
      <xsd:enumeration value="tcap"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="sridnnotfoundType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="gtt"/>
      <xsd:enumeration value="srinack"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="dngtzerofillType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="No"/>
      <xsd:enumeration value="Yes"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="delccprefixType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="pfxwcc"/>
      <xsd:enumeration value="pfx4all"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="mtsmsimsiType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ccrndn"/>
      <xsd:enumeration value="dn"/>
      <xsd:enumeration value="mccrndn"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="rndn"/>
      <xsd:enumeration value="srfimsi"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="mtsmsnniType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ccrndn"/>
      <xsd:enumeration value="dn"/>
      <xsd:enumeration value="mccrndn"/>
      <xsd:enumeration value="none"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="rndn"/>
      <xsd:enumeration value="srfimsi"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="mtsmsType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="all"/>
      <xsd:enumeration value="nonsp"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="sp"/>
      <xsd:enumeration value="sprn"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="mtsmsacknType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="ack"/>
      <xsd:enumeration value="nack"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="mtsmsdltrType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="no"/>
      <xsd:enumeration value="postrn"/>
      <xsd:enumeration value="prern"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="mnpnpdbunavlType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="discard"/>
      <xsd:enumeration value="dnnotfound"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="atiackimsiType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="srfimisi"/>
      <xsd:enumeration value="asd"/>
      <xsd:enumeration value="grn"/>
      <xsd:enumeration value="none"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="atiackmsisdnType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="asd"/>
      <xsd:enumeration value="asddlmmsisdn"/>
      <xsd:enumeration value="grn"/>
      <xsd:enumeration value="grndlmmsisdn"/>
      <xsd:enumeration value="msisdn"/>
      <xsd:enumeration value="none"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="atiackrnType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="asddlmrnsp"/>
      <xsd:enumeration value="asddlmsrfimsi"/>
      <xsd:enumeration value="grndlmrnsp"/>
      <xsd:enumeration value="grndlmsrfimsi"/>
      <xsd:enumeration value="none"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="rnsp"/>
      <xsd:enumeration value="rnspdlmasd"/>
      <xsd:enumeration value="rnspdlmgrn"/>
      <xsd:enumeration value="srfimsi"/>
      <xsd:enumeration value="srfimsidlmasd"/>
      <xsd:enumeration value="srfimsidlmgrn"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="atiackvlrnumType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="asd"/>
      <xsd:enumeration value="asddlmrnsp"/>
      <xsd:enumeration value="asddlmsrfimsi"/>
      <xsd:enumeration value="asdmsisdn"/>
      <xsd:enumeration value="grndlmrnsp"/>
      <xsd:enumeration value="grndlmsrfimsi"/>
      <xsd:enumeration value="msisdn"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="rnmsisdn"/>
      <xsd:enumeration value="rnsp"/>
      <xsd:enumeration value="rnspmsisdn"/>
      <xsd:enumeration value="rnspdlmasd"/>
      <xsd:enumeration value="rnspdlmgrn"/>
      <xsd:enumeration value="srfimsi"/>
      <xsd:enumeration value="srfimsidlmasd"/>
      <xsd:enumeration value="srfimsidlmgrn"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="atinpType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="always"/>
      <xsd:enumeration value="any"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="atisnaiType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="intl"/>
      <xsd:enumeration value="nat"/>
      <xsd:enumeration value="nai"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="inpdraType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="asdrn"/>
      <xsd:enumeration value="asdrnccdn"/>
      <xsd:enumeration value="asdrnnecdn"/>
      <xsd:enumeration value="ccasdrndn"/>
      <xsd:enumeration value="ccdrdn"/>
      <xsd:enumeration value="ccgrndn"/>
      <xsd:enumeration value="ccgrnrndn"/>
      <xsd:enumeration value="ccrngrndn"/>
      <xsd:enumeration value="ccrnasddn"/>
      <xsd:enumeration value="grn"/>
      <xsd:enumeration value="grndn"/>
      <xsd:enumeration value="grnrn"/>
      <xsd:enumeration value="grnrndn"/>
      <xsd:enumeration value="grnrnccdn"/>
      <xsd:enumeration value="grnrnnecdn"/>
      <xsd:enumeration value="homerndn"/>
      <xsd:enumeration value="rn"/>
      <xsd:enumeration value="rnasd"/>
      <xsd:enumeration value="rnasdccdn"/>
      <xsd:enumeration value="rnasdnecdn"/>
      <xsd:enumeration value="rndn"/>
      <xsd:enumeration value="rnnecdn"/>
      <xsd:enumeration value="rngrn"/>
      <xsd:enumeration value="rngrndn"/>
      <xsd:enumeration value="rngrnccdn"/>
      <xsd:enumeration value="rngrnnecdn"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="inpspresType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="connect"/>
      <xsd:enumeration value="continue"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="comagentArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="connectiongroup" type="ComagentConnectionGroup"/>
      <xsd:element name="remoteserver" type="ComagentRemoteServer"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2018, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="diameterArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="afTopologyHidingCfgSet" type="AfTopologyHidingCfgSet"/>
      <xsd:element name="applicationId" type="ApplicationId"/>
      <xsd:element name="applicationPriorityOption" type="ApplicationPriorityOption"/>
      <xsd:element name="applicationRouteRule" type="ApplicationRouteRule"/>
      <xsd:element name="applicationRouteTable" type="ApplicationRouteTable"/>
      <xsd:element name="avpRemovalList" type="AvpRemovalList"/>
      <xsd:element name="cexConfigurationSet" type="CexCfgSet"/>
      <xsd:element name="capacityConfigurationSet" type="CapCfgSet"/>
      <xsd:element name="cexParameter" type="CexParameter"/>
      <xsd:element name="commandCode" type="CommandCode"/>
      <xsd:element name="connection" type="Connection"/>
      <xsd:element name="connectionAlarmGroup" type="ConnectionAlarmGroup"/>
      <xsd:element name="connectionConfigurationSet" type="ConnCfgSet"/>
      <xsd:element name="dnsOption" type="DnsOption"/>
      <xsd:element name="dpdAttributeSet" type="DpdAttributeSet"/>
      <xsd:element name="dpdDnsSet" type="DpdDnsSet"/>
      <xsd:element name="dpdRealm" type="DpdRealm"/>
      <xsd:element name="egressMessageThrottlingConfigurationSet" type="MsgThrottlingCfgSet"/>
      <xsd:element name="egressThrottleGroup" type="EgressThrottleGroup"/>
      <xsd:element name="etl" type="Etl"/>
      <xsd:element name="hssTopologyHidingCfgSet" type="HssTopologyHidingCfgSet"/>
      <xsd:element name="ipfeOption" type="IpfeOption"/>
      <xsd:element name="ipfeTargetSet" type="IpfeTargetSet"/>
      <xsd:element name="localNode" type="LocalNode"/>
      <xsd:element name="mccMncMapping" type="MccMncMapping"/>
      <xsd:element name="messageCopyConfigurationSet" type="MessageCopyCfgSet"/>
      <xsd:element name="messagePriorityConfigurationSet" type="MsgPriorityCfgSet"/>
      <xsd:element name="mmeTopologyHidingCfgSet" type="MmeTopologyHidingCfgSet"/>
      <xsd:element name="mpProfile" type="MpProfile"/>
      <xsd:element name="mpProfileAssignment" type="MpProfileAssignment"/>
      <xsd:element name="option" type="Option"/>
      <xsd:element name="pathTopologyHidingCfgSet" type="PathTopologyHidingCfgSet"/>
      <xsd:element name="pcrfTopologyHidingCfgSet" type="PcrfTopologyHidingCfgSet"/>
      <xsd:element name="peerNode" type="PeerNode"/>
      <xsd:element name="peerNodeAlarmGroup" type="PeerNodeAlarmGroup"/>
      <xsd:element name="peerNodeGroup" type="PeerNodeGroup"/>
      <xsd:element name="peerRouteRule" type="PeerRouteRule"/>
      <xsd:element name="peerRouteTable" type="PeerRouteTable"/>
      <xsd:element name="pendingAnswerTimer" type="PendingAnswerTimer"/>
      <xsd:element name="pendingTransactionLimitingConfigurationSet" type="PendTransCfgSet"/>
      <xsd:element name="protectedNetwork" type="ProtectedNetwork"/>
      <xsd:element name="rateLimitingConfigurationSet" type="RateCfgSet"/>
      <xsd:element name="rerouteOnAnswer" type="RerouteOnAnswer"/>
      <xsd:element name="rfMessageCopy" type="RfMessageCopy"/>
      <xsd:element name="routeGroup" type="RouteGroup"/>
      <xsd:element name="routeList" type="RouteList"/>
      <xsd:element name="routingOptionSet" type="RoutingOptionSet"/>
      <xsd:element name="trafficThrottleGroup" type="TrafficThrottleGroup"/>
      <xsd:element name="trafficThrottlePoint" type="TrafficThrottlePoint"/>
      <xsd:element name="trafficThrottlePointConfigurationSet" type="TrafficThrPointCfgSet"/>
      <xsd:element name="transactionConfigurationSet" type="TransactionCfgSet"/>
      <xsd:element name="trustedNetworkList" type="TrustedNetworkList"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2019, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="fabrArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="addressResolution" type="AddressResolution"/>
      <xsd:element name="defaultDestination" type="DefaultDestination"/>
      <xsd:element name="option" type="FabrOption"/>
      <xsd:element name="routingException" type="RoutingException"/>
      <xsd:element name="supportedApplication" type="SupportedApplication"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2023, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="mapiwfArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="ccndcMapping" type="CcndcMapping"/>
      <xsd:element name="diameterException" type="DiameterException"/>
      <xsd:element name="diameterIdentityGta" type="DiameterIdentityGta"/>
      <xsd:element name="diameterRealm" type="DiameterRealm"/>
      <xsd:element name="dmiwfOption" type="DmiwfOption"/>
      <xsd:element name="gtaRangeToPc" type="GtaRangeToPc"/>
      <xsd:element name="mapException" type="MapException"/>
      <xsd:element name="mdiwfOption" type="MdiwfOption"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2023, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="mdsArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="streams" type="Streams"/>
      <xsd:element name="streamoption" type="StreamOptions"/>
      <xsd:element name="mdsenabledstreams" type="MdsEnabledStreams"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2020, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="radiusArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="ingressStatusServerConfigurationSet" type="IngressStatusServerConfigurationSet"/>
      <xsd:element name="messageAuthenticatorConfigurationSet" type="MessageAuthenticatorConfigurationSet"/>
      <xsd:element name="messageConversionConfigurationSet" type="MessageConversionConfigurationSet"/>
      <xsd:element name="nasNode" type="NasNode"/>
      <xsd:element name="networkOption" type="NetworkOption"/>
      <xsd:element name="radiusRoutingTable" type="RadiusRoutingTable"/>
      <xsd:element name="sharedSecretConfigurationSet" type="SharedSecretConfigurationSet"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2019, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="rbarArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="addressRange" type="RbarAddressRange"/>
      <xsd:element name="addressResolution" type="RbarAddressResolution"/>
      <xsd:element name="addressResolutionEnh" type="RbarAddressResolutionEnh"/>
      <xsd:element name="addressTable" type="RbarAddressTable"/>
      <xsd:element name="destination" type="RbarDestination"/>
      <xsd:element name="domainAddress" type="RbarDomainAddress"/>
      <xsd:element name="individualAddress" type="RbarIndividualAddress"/>
      <xsd:element name="option" type="RbarOption"/>
      <xsd:element name="routingException" type="RbarRoutingException"/>
      <xsd:element name="supportedApplication" type="RbarSupportedApplication"/>
    </xsd:choice>
  </xsd:complexType>
  <!--
- Copyright (C) 2013, 2018, Oracle and/or its affiliates. All rights reserved.
-->
  <xsd:complexType name="sbrArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="databaseResizingPlan" type="DatabaseResizingPlan"/>
      <xsd:element name="databaseOption" type="DatabaseOption"/>
      <xsd:element name="sbrDatabase" type="SbrDatabase"/>
      <xsd:element name="dataMigrationPlan" type="DataMigrationPlan"/>
    </xsd:choice>
  </xsd:complexType>
  <xsd:simpleType name="sgLevel">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="A"/>
      <xsd:enumeration value="B"/>
      <xsd:enumeration value="C"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="serverRole">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Noam"/>
      <xsd:enumeration value="Soam"/>
      <xsd:enumeration value="Mp"/>
      <xsd:enumeration value="QueryServer"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="deviceType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Bonding"/>
      <xsd:enumeration value="Vlan"/>
      <xsd:enumeration value="Alias"/>
      <xsd:enumeration value="Ethernet"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="deviceInterface">
    <xsd:sequence>
      <xsd:element minOccurs="0" name="ipAddress" type="IPv4orIPv6"/>
      <xsd:element name="networkName" type="requiredString"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="routeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Net"/>
      <xsd:enumeration value="Host"/>
      <xsd:enumeration value="Default"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="bootProtoType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="None"/>
      <xsd:enumeration value="Dhcp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="monitorType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Mii"/>
      <xsd:enumeration value="Arp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="arpValidationType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="None"/>
      <xsd:enumeration value="Active"/>
      <xsd:enumeration value="Backup"/>
      <xsd:enumeration value="All"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="svcAction">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="insert"/>
      <xsd:enumeration value="update"/>
      <xsd:enumeration value="delete"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="scopeType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Server"/>
      <xsd:enumeration value="ServerGroup"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:simpleType name="rolePref">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Default"/>
      <xsd:enumeration value="Active"/>
      <xsd:enumeration value="Standby"/>
      <xsd:enumeration value="Spare"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="ntpServer">
    <xsd:sequence>
      <xsd:element name="ipAddress" type="IPv4orIPv6"/>
      <xsd:element name="prefer" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="networkElement">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="configHostname">
    <xsd:sequence>
      <xsd:element name="hostname" type="requiredString"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="network">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
      <xsd:element minOccurs="0" name="UUID" type="xsd:string"/>
      <xsd:element minOccurs="0" name="neName" type="xsd:string"/>
      <xsd:element minOccurs="0" name="type" type="xsd:string"/>
      <xsd:element name="vlanId" type="xsd:string"/>
      <xsd:element name="ipAddress" type="IPv4orIPv6"/>
      <xsd:element name="subnetMask" type="IPv4orIPv6NetMask"/>
      <xsd:element minOccurs="0" name="gatewayAddress" type="IPv4orIPv6"/>
      <xsd:element name="isDefault" type="xsd:boolean"/>
      <xsd:element name="isRoutable" type="xsd:boolean"/>
      <xsd:element name="locked" type="xsd:boolean"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="ntpref">
    <xsd:sequence>
      <xsd:element name="NTP_Reference" type="IPv4"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="servicePath">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
      <xsd:element name="intraSitePath" type="requiredString"/>
      <xsd:element name="interSitePath" type="requiredString"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="server">
    <xsd:sequence>
      <xsd:element name="hostname" type="requiredString"/>
      <xsd:element name="networkElementName" type="requiredString"/>
      <xsd:element minOccurs="0" name="serverGroupName" type="xsd:string"/>
      <xsd:element name="profileName" type="requiredString"/>
      <xsd:element name="location" type="xsd:string"/>
      <xsd:element name="role" type="serverRole"/>
      <xsd:element name="systemId" type="xsd:string"/>
      <xsd:element name="ntpServers">
        <xsd:complexType>
          <xsd:sequence>
            <xsd:element maxOccurs="unbounded" name="ntpServer" type="ntpServer"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:element>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="serverGroup">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
      <xsd:element name="level" type="sgLevel"/>
      <xsd:element name="parentSgName" type="xsd:string"/>
      <xsd:element name="functionName" type="xsd:string"/>
      <xsd:element minOccurs="0" name="numWanRepConn" type="xsd:positiveInteger"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="networkDevice">
    <xsd:sequence>
      <xsd:element minOccurs="0" name="port" type="xsd:string"/>
      <xsd:element name="type" type="deviceType"/>
      <xsd:element minOccurs="0" name="status" type="xsd:string"/>
      <xsd:element minOccurs="0" name="UUID" type="xsd:string"/>
      <xsd:element name="hostname" type="requiredString"/>
      <xsd:element minOccurs="0" name="interfaces">
        <xsd:complexType>
          <xsd:sequence>
            <xsd:element maxOccurs="unbounded" minOccurs="0" name="interface" type="deviceInterface"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:element>
      <xsd:element name="options">
        <xsd:complexType>
          <xsd:all>
            <xsd:element minOccurs="1" name="onboot" type="xsd:boolean"/>
            <xsd:element minOccurs="1" name="bootProto" type="bootProtoType"/>
            <xsd:element minOccurs="0" name="mtu" type="xsd:integer"/>
            <xsd:element minOccurs="0" name="baseDevice">
              <xsd:complexType>
                <xsd:sequence>
                  <xsd:element maxOccurs="unbounded" minOccurs="1" name="baseDeviceItem" type="requiredString"/>
                </xsd:sequence>
              </xsd:complexType>
            </xsd:element>
            <xsd:element maxOccurs="1" minOccurs="0" name="monitorType" type="monitorType"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="primary" type="xsd:string"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="miimon" type="xsd:integer"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="updelay" type="xsd:integer"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="downdelay" type="xsd:integer"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="arpInterval" type="xsd:integer"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="arpValidate" type="arpValidationType"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="arpIpTarget" type="xsd:string"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="hwAddr" type="xsd:string"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="persistentDhclient" type="xsd:string"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="ethtoolOpts" type="xsd:string"/>
            <xsd:element maxOccurs="1" minOccurs="0" name="ethtoolAccelOpts" type="xsd:string"/>
          </xsd:all>
        </xsd:complexType>
      </xsd:element>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="networkRoute">
    <xsd:sequence>
      <xsd:element name="hostname" type="xsd:string"/>
      <xsd:element minOccurs="0" name="UUID" type="xsd:string"/>
      <xsd:element name="type" type="routeType"/>
      <xsd:element name="port" type="xsd:string"/>
      <xsd:element minOccurs="0" name="networkAddress" type="IPv4orIPv6"/>
      <xsd:element minOccurs="0" name="subnetMask" type="IPv4orIPv6NetMask"/>
      <xsd:element name="gatewayAddress" type="IPv4orIPv6"/>
      <xsd:element name="scope" type="xsd:string"/>
      <xsd:element name="scopeType" type="scopeType"/>
      <xsd:element minOccurs="0" name="status" type="xsd:string"/>
      <xsd:element minOccurs="0" name="statusDetails" type="xsd:string"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="resourceDomain">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
      <xsd:element name="profileName" type="xsd:string"/>
      <xsd:element minOccurs="0" name="sgNames">
        <xsd:complexType>
          <xsd:sequence>
            <xsd:element maxOccurs="unbounded" name="sgName" type="requiredString"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:element>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="place">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
      <xsd:element minOccurs="0" name="parentPlaceName" type="xsd:string"/>
      <xsd:element name="typeName" type="requiredString"/>
      <xsd:element minOccurs="0" name="serverList">
        <xsd:complexType>
          <xsd:sequence>
            <xsd:element maxOccurs="unbounded" name="serverListItem" type="requiredString"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:element>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="placeAssociation">
    <xsd:sequence>
      <xsd:element name="name" type="requiredString"/>
      <xsd:element name="typeName" type="requiredString"/>
      <xsd:element minOccurs="0" name="placeList">
        <xsd:complexType>
          <xsd:sequence>
            <xsd:element maxOccurs="unbounded" name="placeListItem" type="requiredString"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:element>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="dscpInterfaceRule">
    <xsd:sequence>
      <xsd:element minOccurs="0" name="UUID" type="xsd:string"/>
      <xsd:element name="interface" type="requiredString"/>
      <xsd:element name="dscp" type="xsd:integer"/>
      <xsd:element name="protocol" type="protocolType"/>
      <xsd:element name="scope" type="xsd:string"/>
      <xsd:element name="scopeType" type="scopeType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:simpleType name="protocolType">
    <xsd:restriction base="xsd:string">
      <xsd:enumeration value="Tcp"/>
      <xsd:enumeration value="Sctp"/>
    </xsd:restriction>
  </xsd:simpleType>
  <xsd:complexType name="dscpPortRule">
    <xsd:sequence>
      <xsd:element minOccurs="0" name="UUID" type="xsd:string"/>
      <xsd:element name="port" type="xsd:integer"/>
      <xsd:element name="dscp" type="xsd:integer"/>
      <xsd:element name="protocol" type="protocolType"/>
      <xsd:element name="scope" type="xsd:string"/>
      <xsd:element name="scopeType" type="scopeType"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="vip">
    <xsd:sequence>
      <xsd:element minOccurs="0" name="UUID" type="xsd:string"/>
      <xsd:element name="serverGroupName" type="requiredString"/>
      <xsd:element name="ipAddress" type="IPv4orIPv6"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="member">
    <xsd:sequence>
      <xsd:element maxOccurs="1" minOccurs="0" name="haRolePreference" type="rolePref"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="hostname" type="requiredString"/>
      <xsd:element maxOccurs="1" minOccurs="1" name="serverGroupName" type="requiredString"/>
    </xsd:sequence>
  </xsd:complexType>
  <xsd:complexType name="topoArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="configHostname" type="configHostname"/>
      <xsd:element name="networkElement" type="networkElement"/>
      <xsd:element name="network" type="network"/>
      <xsd:element name="servicePath" type="servicePath"/>
      <xsd:element name="server" type="server"/>
      <xsd:element name="serverGroup" type="serverGroup"/>
      <xsd:element name="networkDevice" type="networkDevice"/>
      <xsd:element name="networkRoute" type="networkRoute"/>
      <xsd:element name="resourceDomain" type="resourceDomain"/>
      <xsd:element name="place" type="place"/>
      <xsd:element name="placeAssociation" type="placeAssociation"/>
      <xsd:element name="dscpInterfaceRule" type="dscpInterfaceRule"/>
      <xsd:element name="dscpPortRule" type="dscpPortRule"/>
      <xsd:element name="member" type="member"/>
      <xsd:element name="vip" type="vip"/>
    </xsd:choice>
  </xsd:complexType>
  <xsd:complexType name="vstpArea">
    <xsd:choice maxOccurs="unbounded" minOccurs="0">
      <xsd:element name="connection" type="VstpConnection"/>
      <xsd:element name="connectionconfigurationset" type="VstpConnCfgSet"/>
      <xsd:element name="defaultconversion" type="VstpDefaultConversion"/>
      <xsd:element name="featureadminstate" type="VstpFeatureAdminState"/>
      <xsd:element name="gttaction" type="VstpGttAction"/>
      <xsd:element name="gttaddress" type="VstpGttTitleAddress"/>
      <xsd:element name="gttmod" type="VstpGttMod"/>
      <xsd:element name="gttselector" type="VstpGttSelector"/>
      <xsd:element name="gttset" type="VstpGttSet"/>
      <xsd:element name="gttactionset" type="VstpGttActionSet"/>
      <xsd:element name="homeentity" type="VstpHomeEntity"/>
      <xsd:element name="link" type="VstpLink"/>
      <xsd:element name="linkset" type="VstpLinkSet"/>
      <xsd:element name="localhost" type="VstpLocalHost"/>
      <xsd:element name="localsignalingpoint" type="VstpLocalSignalingPoint"/>
      <xsd:element name="m2paoption" type="VstpM2paOption"/>
      <xsd:element name="m3rloption" type="VstpM3rlOption"/>
      <xsd:element name="mapset" type="VstpMapSet"/>
      <xsd:element name="mrnset" type="VstpMrnSet"/>
      <xsd:element name="mtpscreenset" type="VstpMtpScreenSet"/>
      <xsd:element name="mtpscreeningrule" type="VstpMtpScreeningRule"/>
      <xsd:element name="remotehost" type="VstpRemoteHost"/>
      <xsd:element name="remotesignalingpoint" type="VstpRemoteSignalingPoint"/>
      <xsd:element name="route" type="VstpRoute"/>
      <xsd:element name="sccpapplication" type="VstpSccpApplication"/>
      <xsd:element name="sccploopset" type="VstpSccpLoopset"/>
      <xsd:element name="sccpoption" type="VstpSccpOption"/>
      <xsd:element name="sccpserviceselector" type="VstpSccpServiceSelector"/>
      <xsd:element name="sccpmnpoption" type="VstpSccpMnpOption"/>
      <xsd:element name="vstpalarmaggregationoption" type="VstpAlarmAggregationOption"/>
    </xsd:choice>
  </xsd:complexType>
  <xsd:element name="configuration">
    <xsd:complexType>
      <xsd:all>
        <xsd:element minOccurs="0" name="comagent" type="comagentArea"/>
        <xsd:element minOccurs="0" name="diameter" type="diameterArea"/>
        <xsd:element minOccurs="0" name="fabr" type="fabrArea"/>
        <xsd:element minOccurs="0" name="mapiwf" type="mapiwfArea"/>
        <xsd:element minOccurs="0" name="mds" type="mdsArea"/>
        <xsd:element minOccurs="0" name="radius" type="radiusArea"/>
        <xsd:element minOccurs="0" name="rbar" type="rbarArea"/>
        <xsd:element minOccurs="0" name="sbr" type="sbrArea"/>
        <xsd:element minOccurs="0" name="topo" type="topoArea"/>
        <xsd:element minOccurs="0" name="vstp" type="vstpArea"/>
      </xsd:all>
    </xsd:complexType>
  </xsd:element>
</xsd:schema>
```
