This section defines general behaviors of the DSR Machine to Machine Interface.

1. Read-only attributes - Most resources have one or more read-only attributes, and these are identified in the JavaScript Object Notation (JSON) schemas by the readOnly property. Read-only attributes are always returned in any GET response. Clients should not include read-only attributes in the JSON data accompanying a POST or PUT request, as the presence of read-only values never results in a DSR state change. If a POST or PUT request does include a read-only attribute value that has the correct data type (per the JSON schema), the DSR ignores the value and processes the request as if the read-only attribute were not present. If, however, a POST or PUT request includes a read-only attribute value whose data type is not correct, the DSR returns an error response. The client should fix the data type - or remove the attribute from the JSON data entirely - and re-send the request.

2. Simultaneous client interactions - If two or more DSR clients attempt to modify the same resource at the same time, the last-in-time request received by the DSR is the one with final impact on the state of the DSR. No error response is sent to the other clients, but the changes requested by those clients are overwritten as a result of the request received from the last-in-time client, if there is any overlap between the requests. For example, if client #1 updates the configuration of a resource instance, but client #2 subsequently deletes that same resource instance, the instance is deleted and client #1 receives no notification that the instance it just updated has been deleted.

3. Filtering and sorting -  Generally speaking, query parameters for a collection GET operation can be used to tailor the returned results to a select subset of the collection. In this version of the API, the only tailoring somewhat widely supported is paging - returning N items beginning at a specified offset into the collection. In general, the following are not supported operations: 1) filtering results by an arbitrary named attribute, and 2) sorting the results by any arbitrary attribute. There are a few APIs - namely, for status sub-resources - that support this kind of attribute-based filtering. These are so indicated in the individual resource documentation.

4. Paging - Paging parameters for a collection GET operation are used to return a client-defined number of resource instances, beginning at a specified offset. In this version of the API, only resources in the [*Core Diameter*](#The-Core-Diameter-Area) (/diameter) area support paging. For the Core Diameter area, if paging query parameters are not supplied in the request, the number of records returned is limited to a default page size, and always begins with the first record in the configuration. If paging query parameters are supplied in the request, a success response is returned only if the requested number of instances is less than or equal to the default page size. The success response contains links for the next and previous set of records, and a message indicating the count of remaining records, when applicable. The default page size - the number of resources returned by the DSR in a GETALL request when the client does not specify a desired count in the request - is defined by the DSR and is currently set to 1000.

5. Default attribute values - In general, DSR provides no default value for an attribute when POSTing a new instance to the configuration. If no value is provided in the client request for an attribute that is required, the POST fails and a specific error message is returned. If no value is supplied by the client for an attribute that is not required, that attribute may or may not have a value in the configuration, depending on the specific behavior of the resource being configured.

6. Data validation - The data for all PUT and POST operations is validated both for syntactic and semantic correctness before the operation is allowed to proceed. If any validation errors occur, the response has a status of false, and the messages portion of the response contains one or more messages documenting the specific error details. Any unexpected operation failures also result in a status of false being returned, along with details in the messages portion of the response.

7. Attempting to delete a resource instance that doesn't exist - If a client attempts to delete a resource instance whose unique identifier is not present in the DSR's configuration, the DSR responds with either a 400 or 409 HTTP status code, depending on the resource type.

8. Handling of invalid query parameters - In this release of the DSR software, the error handling capability for invalid query parameters is limited. If a client sends a query string with one or more invalid query parameter values, the DSR's response to the request is not guaranteed to be expected.
