## The Oracle Communications Diameter Signaling Router Machine to Machine Interface

This Application Programming Interface (API) document describes the Machine to Machine Interface (MMI) for the Oracle Communications Diameter Signaling Router (OC-DSR, often shortened to simply DSR). The DSR MMI is a RESTful (Representational State Transfer) interface providing access to a broad range of Operations, Administration, and Maintenance (OAM) services that clients use to configure and manage the DSR. This document is the comprehensive API reference guide to the RESTful services the DSR makes available to clients through the DSR MMI.

### General URI Format for DSR MMI Requests
The general format of a Uniform Resource Identifier (URI) used to send an MMI request to the DSR is:

    https://{target}/mmi/dsr/{version}/{area}/{resource}[/{instance}][/{sub-resource}[/{sub-instance}]]*[/{attribute or action}]

where
  * {target} is the IP address or FQDN (Fully Qualified Domain Name) of the OAM server receiving the MMI request.
  * {version} is the MMI API version number. If the MMI client specifies a version that is not supported by the DSR, HTTP status code 404 is returned in the response.
  * {area} is the functional area that includes the desired MMI API (areas are defined in the next paragraph).
  * {resource} is the specific DSR resource being accessed - with DSR, the resource generally equates to a Managed Object (MO).
  * {instance} is necessary when the client is accessing a specific instance of a resource; {instance} is the unique identifier for the resource record, and is often the instance's name attribute (although some resources use a different attribute as the unique identifier, particularly when the resource's instances don't have names).
  * {sub-resource} is the specific sub-resource within the resource associated with the requested operation. It could consist of one or more tokens (e.g., **/db/backup**).
  * {sub-instance} is only necessary when the client is accessing a specific sub-instance of a sub-resource; typically the {sub-instance} value is the name of a specific sub-resource; {sub-instance} should only appear when following a {sub-resource}.
  * {attribute or action} is only necessary when the client is performing an action on a specific instance. {attribute or action} could be name of an attribute being read or updated (e.g., the administrative state) of an instance or sub-instance. Note: in this context, {action} is not one of the standard HTTP actions, but is instead one of the specific actions supported by the resource or sub-resource.

DSR MMI clients use Secure Sockets Layer (SSL) connections (HTTPS) to communicate with the target DSR.

### APIs are Grouped by Functional Area
DSR MMI APIs are grouped by functional area and, as shown in section [*General URI Format for DSR MMI Requests*](#general-uri-format-for-dsr-mmi-requests), the area is one segment of the URI sent to the DSR. MMI APIs are available for the following areas of DSR functionality:

  * [*Client Authentication*](#The-Client-Authentication-Area) (area: auth) - MMI security - authentication, authorization, and audit
  * [*Bulk Configuration*](#The-Bulk-Configuration-Area) (area: bulk) - bulk export and import of system configuration
  * [*System Administration*](#The-System-Administration-Area) (area: admin) - DSR network administration functions
  * [*System Monitoring*](#The-System-Monitoring-Area) (area: mon) - access to system processes, logs, statistics, and measurements
  * [*Topology Configuration and Management*](#The-Topology-Configuration-and-Management-Area) (area: topo) - insert, edit, delete, retrieval, and management of system topology resources; note that the topo area only covers management of server and network resources; application-specific resources are part of other areas (e.g., diameter)
  * [*Core Diameter*](#The-Core-Diameter-Area) (area: diameter) - configuration establishing the DSR as a Diameter Relay Agent, including IP Front End (IPFE) behavior
  * [*Non-Specific*](#The-All-Area) (area: all) - general APIs that span multiple areas of functionality

Within this API documentation, resource descriptions are organized by area, then alphabetically by the individual resource name within each area. A few resources do not have a _Request_ block for a particular action (e.g., /diameter/mpprofileassignments GET; /mon/measurements/budget GET). This is not a mistake or oversight. In these cases, there are no valid query parameters for the API, and the _Request_ block is simply omitted.

### Both Network and Site OAM Servers Provide MMI Access

A DSR is a collection of cooperating servers arranged in a three-tiered hierarchical topology. MMI functionality is available at the top two levels of the hierarchy:

* **Network** - the administrative domain consisting of all DSR Sites, managed using highly available (HA) clusters of Network Operations, Administration, and Maintenance (NOAM) servers. Network-scoped functionality is hosted in this top level of the topology hierarchy and is referred to as the **A-Level**.
* **Site** - a site-level administrative domain, managed using clusters of HA Site Operations, Administration, and Maintenance (SOAM) servers. Operations performed at the SOAM are scoped to the specific SOAM (all SOAM servers in the HA cluster, plus all sub-tending C-level servers - note that these servers may not all reside at the same physical location). Site-scoped functionality is hosted in the middle layer of the topology hierarchy and is referred to as the **B-Level**.

The bottom level of the topology hierarchy, the **C-Level**, is reserved for application-level servers (DA-MPs, IPFEs, SBRs, SS7-MPs), which do not provide any administrative access. DSR MMI functionality is only available on the OAM servers.

Adding or editing a resource instance is done at either the NOAM or the SOAM, but not both. The documentation for each resource identifies whether the NOAM or SOAM is the target of an MMI request for that resource. Note that, for some resources configured at the NOAM, it is possible to retrieve the configuration - but not change it - at an SOAM. Also, status/monitoring resources like measurements, KPIs, and alarms can be retrieved at both the NOAM and SOAM. The data returned by the target OAM server is scoped to that server.

### MMI Requests Are Sent to Active OAM Servers

Whenever OAM servers are deployed in High-Availability (HA) clusters, it is the server holding the HA role of active that must receive an MMI request. If a Virtual IP (VIP) is configured for the OAM cluster, requests sent to that VIP are automatically handled by the active OAM server. If an OAM server is standing alone (not part of an HA cluster), it is by default considered the active server and should be the target of client MMI requests.

### RESTful Operation Overview

The DSR configuration is managed through Create, Retrieve, Update, and Delete (CRUD) actions on instances of the various resource types built into the DSR. A particular type of resource (e.g., Server, Network Element, Peer Node, Traffic Throttle Group) is also known as a Managed Object (MO), and a specific instance of a resource is known as an MO instance. Throughout this document, the term _MO_ is used to refer either to the type or to a particular instance of a type. The intended usage should be clear from the context.

The CRUD operations are implemented using standard HTTP verbs:
  * HTTP POST is used to Create a new resource instance.
  * HTTP GET is used to Retrieve one or more resource instances.
  * HTTP PUT is used to Update a resource instance.
  * HTTP DELETE is used to Delete a resource instance.

The following sections provide a brief overview of how the CRUD operations work through the MMI using simple examples. In these examples, a simplified version of the RESTful result structure is used for illustration purposes. Refer to the schema definition in the API description for a particular resource for a complete response definition specific to that resource.

### Create Pattern

To create a new instance of a resource, **POST** it to the collection. POST returns a response populated with the identifier of the newly created resource instance. In most cases, the resource instance identifier is simply the client-provided name of the resource. For resources that do not have a simple name field, or for which the name field is not required to be unique, a unique identifier is constructed and returned.

For example:

  **`POST /resource/ + BODY { "name":"newInstance", "description":"an example" }`**

Returns the new resource ID:

  `
  "data":"newInstance",
  "messages":[],
  "links":[],
  "status":true
  `

### Update and Delete Patterns

To update an instance of a resource, the **PUT** operation is used. To delete an instance, the **DELETE** operation is used.

There are a few common reasons why an update operation might fail:

  1. System updates have been disabled.
  2. The update data is incomplete or is some other way invalid.
  3. The MMI user account does not have permission to perform the requested operation for the specified resource.
  4. The server is currently overloaded and cannot handle a new request.

Any failure explanation(s) are returned in the messages portion of the response.

### Use of Natural Identifiers

Most of the DSR MMI resource APIs use the *natural* identifier (typically the name field) for a resource instance. For example, the **/topo/servers** resource uses the server name as its natural identifier. However, in certain cases, where there is no natural identifier, a unique identifier is generated. The **/route** resource, for example, has no natural identifier, so one is generated at the time a new route is created.

The documentation for each resource defines what property is used as the identifier (as returned in a POST response).

### Idempotent GET/PUT

A GET of a resource instance, followed by a PUT of the same resource instance, leaves the resource essentially unchanged.

Note that occasionally there are fields in a resource schema that are described as *computed*. These fields are always ignored on PUT. Computed fields are also ignored on initial creation requests using POST.

Some fields are read-only, and are identified as such in the JSON schemas. If included by the client in a PUT request, read-only field values are ignored by the DSR.

Some fields are *not updatable*. These fields must be set on initial creation via POST, and are ignored on subsequent updates.

### Structured Response

Unless stated otherwise, operations place returned results in a structured container of the form: 

  * **data** (optional) - If the operation returns data, the data is placed in the **data** portion of the result.
  * **messages** (optional) - If the operation returns any warnings, errors, status, or other informational data, they are placed in the **messages** portion of the result.
  * **links** (optional) - If the operation returns links supporting or suggesting follow-up resources or actions, they are placed in the **links** portion of the result.
  * **status** - true on success, false on failure. If false, the **messages** portion of the response provides details.

### HTTP Status Codes

DSR operations available through the MMI API are atomic, unless stated otherwise for a specific resource. If a configuration operation does not complete successfully, the DSR is left in its original state. The RESTful operations generally available for resources, and possible return codes for each, are:

  * **GET** - retrieve one or more items from a collection, or retrieve just a single item identified by a unique name/id
    * 200 - operation successful
    * 400 - bad request
    * 401 - not authenticated
    * 403 - not authorized
    * 404 - item not found/API version not supported
    * 429 - too many requests
  * **POST** - insert a new item into a collection
    * 201 - operation successful - item created
    * 202 - request accepted - operation in progress
    * 400 - bad request
    * 401 - not authenticated
    * 403 - not authorized
    * 404 - API version not supported
    * 500 - internal server error
  * **PUT** - update a specific, existing item in a collection 
    * 200 - operation successful
    * 202 - request accepted - operation in progress
    * 400 - bad request
    * 401 - not authenticated
    * 403 - not authorized
    * 404 - API version not supported
    * 409 - resource state conflict
    * 500 - internal server error
  * **DELETE** - delete a specific item from a collection
    * 204 - operation successful (no content is returned from a delete operation)
    * 400 - bad request
    * 401 - not authenticated
    * 403 - not authorized
    * 404 - API version not supported
    * 409 - resource state conflict
    * 500 - internal server error

