## (area: "mon")

The system monitoring (_mon_) area provides access to:

* Measurements - Historical store of system counters
* Key Performance Indicators - Point in time indicators of system health
* Alarms - Currently active alarms
* Processes - System Process resource impacts
* Tasks - Recently run or running background tasks
* Periodic Tasks - The schedule of regularly executing tasks

The system monitoring interfaces are primarily read-only, and are used to obtain status information about the system.

### Scoped Data

In general, when data is requested via MMI from an OAM server, the data received is scoped to that OAM server. Therefore, a request made to the NOAM, which is at the top (A) level of the hierarchy, returns data for all servers in the DSR topology, while a request made to an SOAM (B-level) only returns data scoped to that SOAM Server Group - all SOAM servers in the HA cluster, plus all sub-tending C-level servers.

Some data (notably some measurements and alarms) is scoped to an SOAM, and is not available at the network (NOAM) level. Requests to retrieve SOAM-scoped data must be made to the specific SOAM.

### Time-Ordered Data

The **/measurements** and **/alarms** services provide access to time-ordered datasets. Requests can be restricted to a specific time range (often useful in post-mortem problem analysis). If no time range is specified, the **/measurements** resource returns the most current measurements data set, while the alarms service returns all the currently active alarms.

### Rate-Limited Data

The **/measurements** resource is rate-limited. To ensure that the processing costs associated with creating a measurement report do not exceed the available OAM server resources, each query of measurement data counts against a budget allocated for the request interval.

  1. At the start of each interval (an even 5 minute boundary), the request budget is reset.
  2. Each measurement query in the request interval subtracts from the budget.
  3. If a request is made while the budget is empty, the request is rejected.

The **/measurements/budget** resource can be used to determine the remaining available budget for the current request interval. Each measurement request returns the remaining budget and the cost of the request.

A measurement report cost is calculated based on the following rules:

 * Each cell of reported data has a cost of one unit.
 * An arrayed measurement with N populated subindexes has a cost of N units.
 * Each reported time-interval multiplies the cost by the number of intervals.
 * Each reported server multiplies the cost by the number of servers.

Applying these rules, a hypothetical measurement report has a report cost of 15,000,000 if it 1) has arrayed measurements with 15,000 subindexes; 2) spans 100 servers; and 3) includes 10 time-intervals.

Clients typically do not need to keep track of the measurement report budget. Each OAM server should be configured with a budget large enough to support most typical measurement report requests. If a request is submitted after the budget for an interval has been exhausted, the client receives an HTTP response of 429 - too many requests. The measurement report request should be re-submitted later.
