## (area: "topo")

The _topo_ area provides RESTful interfaces enabling topology configuration and management for:

* Servers
* Server Groups
* Resource Domains
* Places
* Place Associations
* Network Elements
* Networks
* Network Routes
* Network Devices
* Network Service Paths
* DSCP Port Rules
* DSCP Interface Rules

The topo area covers general server/network/DSR topology configuration - the higher-level configuration that is necessary to support the mission of a DSR. Diameter-specific configuration is not part of the topo area - that is covered by the diameter area for core routing configuration, and several of the other areas, which are specific to the various applications DSR supports.

### Management Services

The /topo/servers and /topo/networkelements resources provide the following management and control facilities:

  * **Server Status** - A general summary status report for a server
  * **Server Management** - Server management - reboot and ntpsync
  * **Server DB Status and Management** - Database status and management (backup/restore) for a server
  * **Server HA Status and Management** - High Availability status and management (roles) for a server
  * **Server Provisioning Status and Management** - Data Provisioning status and management for a server
  * **Server Replication Status and Management** - Data Replication status and management for a server
  * **Server Application Status and Management** - Application status and management for a server
  * **Router Monitoring Status and Management** - Gateway Router monitoring management for a network element

In general, a status request returns the current state of the resource (using GET), while a management request updates the resource (using PUT) to change its status.
