/**
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 */
var jsLibs = 'libs';
"use strict";

requirejs.config(
{
  // Path mappings for the logical module names
  paths:
  //injector:mainReleasePaths
  {
 'ojs': jsLibs + '/oj/v18.0.2/min',
            'ojL10n': jsLibs + '/oj/v18.0.2/ojL10n',
            'ojtranslations': jsLibs + '/oj/v18.0.2/resources',
            'knockout': jsLibs + '/knockout/knockout-3.5.1',
             'jquery': jsLibs + '/jquery/jquery-3.6.4.min',
            'jqueryui-amd': jsLibs + '/jquery/jqueryui-amd-1.13.2.min',
            'text': jsLibs + '/require/text',
            'hammerjs': jsLibs + '/hammer/hammer-2.0.8.min',
            'signals': jsLibs + '/js-signals/signals.min',
            'ojdnd': jsLibs + '/dnd-polyfill/dnd-polyfill-1.0.2.min',
            'css': jsLibs + '/require-css/css.min',
            'css-builder': jsLibs + '/require-css/css-builder',
            'normalize': jsLibs + '/require-css/normalize',
            '@oracle/oraclejet-preact': jsLibs + '/oraclejet-preact/amd',
            'preact': jsLibs + '/preact/dist/preact.umd',
            'preact/hooks': jsLibs + '/preact/hooks/dist/hooks.umd',
            'preact/compat': jsLibs + '/preact/compat/dist/compat.umd',
            'preact/jsx-runtime': jsLibs + '/preact/jsx-runtime/dist/jsxRuntime.umd',
            'proj4': jsLibs + '/proj4js/dist/proj4-src',
            'touchr': jsLibs + '/touchr/touchr',
            'persist': jsLibs + '/persist/min',
            'chai': jsLibs + '/chai/chai-4.3.10.min'

  }
  //endinjector
  ,
  // Shim configurations for modules that do not expose AMD
  shim:
  {
    "jquery":
    {
      exports: ["jQuery", "$"]
    }
  }
}
);

require(["ojs/ojcore", "knockout", "jquery", "ojs/ojknockout", "ojs/ojnavigationlist", "ojs/ojcollapsible", "ojs/ojoffcanvas"],
  function(oj, ko, $)
  {
    function MainViewModel()
    {
      var self = this;

      self.toggleDrawer = function() {
        oj.OffcanvasUtils.open({"selector": "#sidebar"});
      }
    };

    $(document).ready(function()
    {
      console.log("loaded!");
      ko.applyBindings(new MainViewModel(), document.getElementById("mainContent"));
    });
  }
);
