#!/usr/bin/env python
from __future__ import print_function
from flask import Flask, jsonify, abort, request
from flask_cors import CORS, cross_origin

import logging
import os
import requests

app = Flask(__name__)
CORS(app)
cors = CORS(app, resources={r"/api/*": {"origins": "*","methods":"POST,DELETE,PUT,GET,OPTIONS"}})

#Read the cache environment variables
CCSHOST  = os.environ.get('CACHING_INTERNAL_CACHE_URL', ''); 
cacheName = 'ccstest';
#Create the cache URL
url = 'http://' + CCSHOST  + ':8080/ccs/'+cacheName;

@app.route('/')
def index():
    return 'The application is running!'
    
    
@app.route('/employees')
def employees():
   
    return jsonify( results)    

@app.route('/employees/<int:employee_id>', methods=['GET'])
def get_employee(employee_id):
    logging.info('GET METHOD')
    response = requests.get(url+'/'+str(employee_id), headers={"Content-Type": "application/json"})
    return response.content

@app.route('/employees', methods=['POST'])
def create_employee():
    logging.info('CREATE METHOD')
    data = request.json
    response = requests.put(url+'/'+str(request.json['id']), json=data,headers={"Content-Type": "application/json"})
    if (response.status_code == 204):
	    message = {'status': 'Successful'}
    else:
	    message = {'status': 'Create returned error'}
    return jsonify(message)

@app.route('/employees/<int:employee_id>', methods=['PUT'])
def update_employee(employee_id):
    logging.info('UPDATE METHOD')
    data = request.json
    response = requests.post(url+'/'+str(employee_id), json=data, headers={"Content-Type" : "application/octet-stream", "X-Method" : "replace"})
    if (response.status_code==204):
	    message = {'status': 'Successful'}
    else:
	    message = {'status': 'PUT returned error '}
    return jsonify(message)

@app.route('/employees/<int:employee_id>', methods=['DELETE'])
def delete_employee(employee_id):
    logging.info('DELETE METHOD')
    response = requests.delete(url+'/'+str(employee_id),headers={"Content-Type": "application/json"})
    if (response.ok):
       message = {'status': 'Successful'}
    else:
       message = {'status': 'Employee delete failed'}
    return jsonify(message)

if __name__ == '__main__':
      app.run(host='0.0.0.0', port=int(os.environ.get('PORT', '8080')))