define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Examples",
                    "href":"loe.html"
                },
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-B52F36FB-0912-46E3-8A9B-C0728E7016D1"
                },
                {
                    "title":"Part I JSON Data and Oracle AI Database",
                    "href":"json-data-and-oracle-ai-database.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1 </span> JSON Data (Standard)",
                            "href":"json-data-standard.html#GUID-615A4146-6DC0-4E66-9AD0-CD74C90D208A"
                        },
                        {
                            "title":"<span class=\"secnum\">2 </span> JSON in Oracle AI Database",
                            "href":"json-oracle-ai-database.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">2.1 </span> Overview of JSON in Oracle AI Database",
                                    "href":"overview-json-oracle-ai-database.html#GUID-D7BCE045-EF6D-47E9-9BB2-30C01933248E"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.2 </span> JSON Data Type",
                                    "href":"json-data-type.html#GUID-CBEDC779-39A3-43C9-AF38-861AE3FC0AEC"
                                },
                                {
                                    "title":"<span class=\"secnum\">2.3 </span> Oracle AI Database Support for JSON",
                                    "href":"oracle-ai-database-support-json.html#GUID-A2BC5593-7F70-482E-89D1-B32C3798E0E4"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part II Store and Manage JSON Data",
                    "href":"store-and-manage-json-data.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3 </span> Overview of Storing and Managing JSON Data",
                            "href":"overview-storing-and-managing-json-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4 </span> Tables With JSON Columns",
                            "href":"tables-json-columns.html#GUID-B38676E8-F5FD-4347-84DB-DE13E08657D9"
                        },
                        {
                            "title":"<span class=\"secnum\">5 </span> SQL/JSON Conditions IS JSON and IS NOT JSON",
                            "href":"sql-json-conditions-is-json-and-is-not-json.html#GUID-8F897ED9-791B-4F53-AFAE-690DE38111D1"
                        },
                        {
                            "title":"<span class=\"secnum\">6 </span> JSON Collections",
                            "href":"json-collections.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7 </span> JSON Schema",
                            "href":"json-schema.html#GUID-980BD95E-D0EF-4E22-8E67-08CD419EE7A2"
                        },
                        {
                            "title":"<span class=\"secnum\">8 </span> Character Sets and Character Encoding for JSON Data",
                            "href":"character-sets-and-character-encoding-json-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9 </span> Considerations When Using LOB Storage for JSON Data",
                            "href":"considerations-when-using-lob-storage-json-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10 </span> Partitioning JSON Data",
                            "href":"partitioning-json-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11 </span> Replication of JSON Data",
                            "href":"replication-json-data.html"
                        }
                    ]
                },
                {
                    "title":"Part III Insert, Update, and Load JSON Data",
                    "href":"insert-update-and-load-json-data.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12 </span> Overview of Inserting, Updating, and Loading JSON Data",
                            "href":"overview-inserting-updating-and-loading-json-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13 </span> Oracle SQL Function JSON_TRANSFORM",
                            "href":"oracle-sql-function-json_transform.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.1 </span> Use Bind Variables With JSON_TRANSFORM",
                                    "href":"use-bind-variables-json_transform.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2 </span> JSON_TRANSFORM Operations, Including Assignments",
                                    "href":"json_transform-operations-including-assignments.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.3 </span> JSON_TRANSFORM Operator ADD_SET",
                                    "href":"json_transform-operator-add_set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.4 </span> JSON_TRANSFORM Operator APPEND",
                                    "href":"json_transform-operator-append.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.5 </span> JSON_TRANSFORM Operator CASE",
                                    "href":"json_transform-operator-case.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.6 </span> JSON_TRANSFORM Operator COPY",
                                    "href":"json_transform-operator-copy.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.7 </span> JSON_TRANSFORM Operator INSERT",
                                    "href":"json_transform-operator-insert.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.8 </span> JSON_TRANSFORM Operator INTERSECT",
                                    "href":"json_transform-operator-intersect.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.9 </span> JSON_TRANSFORM Operator KEEP",
                                    "href":"json_transform-operator-keep.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.10 </span> JSON_TRANSFORM Operator MERGE",
                                    "href":"json_transform-operator-merge.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.11 </span> JSON_TRANSFORM Operator MINUS",
                                    "href":"json_transform-operator.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.12 </span> JSON_TRANSFORM Operator NESTED PATH",
                                    "href":"json_transform-operator-nested-path.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.13 </span> JSON_TRANSFORM Operator PREPEND",
                                    "href":"json_transform-operator-prepend.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.14 </span> JSON_TRANSFORM Operator REMOVE",
                                    "href":"json_transform-operator-remove.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.15 </span> JSON_TRANSFORM Operator REMOVE_SET",
                                    "href":"json_transform-operator-remove_set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.16 </span> JSON_TRANSFORM Operator RENAME",
                                    "href":"json_transform-operator-rename.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.17 </span> JSON_TRANSFORM Operator REPLACE",
                                    "href":"json_transform-operator-replace.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.18 </span> JSON_TRANSFORM Operator SET",
                                    "href":"json_transform-operator-set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.19 </span> JSON_TRANSFORM Operator SORT",
                                    "href":"json_transform-operator-sort.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.20 </span> JSON_TRANSFORM Operator UNION",
                                    "href":"json_transform-operator-union.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.21 </span> JSON_TRANSFORM Right-Hand-Side (RHS) Path Expressions",
                                    "href":"json_transform-right-hand-side-rhs-path-expressions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.22 </span> JSON_TRANSFORM Operation Handlers",
                                    "href":"json_transform-operation-handlers.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">14 </span> Oracle SQL Function JSON_MERGEPATCH",
                            "href":"oracle-sql-function-json_mergepatch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">15 </span> Loading External JSON Data",
                            "href":"loading-external-json-data.html"
                        }
                    ]
                },
                {
                    "title":"Part IV Query JSON Data",
                    "href":"query-json-data.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16 </span> Simple Dot-Notation Access to JSON Data",
                            "href":"simple-dot-notation-access-json-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">17 </span> SQL/JSON Path Expressions",
                            "href":"sql-json-path-expressions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">17.1 </span> Overview of SQL/JSON Path Expressions",
                                    "href":"overview-sql-json-path-expressions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.2 </span> SQL/JSON Path Expression Syntax",
                                    "href":"sql-json-path-expression-syntax.html#GUID-7B610884-39CD-4910-85E7-C251D342D879"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.3 </span> SQL/JSON Path Expression Item Methods",
                                    "href":"sql-json-path-expression-item-methods.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">17.4 </span> Types in Filter-Condition Comparisons",
                                    "href":"types-filter-condition-comparisons.html#GUID-D951D27D-6918-40E8-8A0D-8D60AB83FD4A"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">18 </span> Clauses Used in SQL Functions and Conditions for JSON",
                            "href":"clauses-used-sql-functions-and-conditions-json.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">18.1 </span> PASSING Clause for SQL Functions and Conditions",
                                    "href":"passing-clause-sql-functions-and-conditions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.2 </span> RETURNING Clause for SQL Functions",
                                    "href":"returning-clause-sql-query-functions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.3 </span> Wrapper Clause for SQL/JSON Query Functions JSON_QUERY and JSON_TABLE",
                                    "href":"wrapper-clause-sql-json-functions-json_query-and-json_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.4 </span> Error Clause for SQL Functions and Conditions",
                                    "href":"error-clause-sql-query-functions-and-conditions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.5 </span> Empty-Field Clause for SQL/JSON Query Functions",
                                    "href":"empty-field-clause-sql-json-query-functions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.6 </span> ON MISMATCH Clause for SQL/JSON Query Functions",
                                    "href":"mismatch-clause-sql-json-query-functions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">18.7 </span> TYPE Clause for SQL Functions and Conditions",
                                    "href":"type-clause-sql-functions-and-conditions.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">19 </span> SQL/JSON Condition JSON_EXISTS",
                            "href":"sql-json-condition-json_exists.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">19.1 </span> Using Filters with JSON_EXISTS",
                                    "href":"using-filters-json_exists.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">19.2 </span> JSON_EXISTS as JSON_TABLE",
                                    "href":"json_exists-json_table.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">20 </span> SQL/JSON Function JSON_QUERY",
                            "href":"sql-json-function-json_query.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">20.1 </span> JSON_QUERY as JSON_TABLE",
                                    "href":"json_query-json_table.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">21 </span> SQL/JSON Function JSON_TABLE",
                            "href":"sql-json-function-json_table.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">21.1 </span> SQL NESTED Clause Instead of JSON_TABLE",
                                    "href":"sql-nested-clause-instead-json_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.2 </span> COLUMNS Clause of SQL/JSON Function JSON_TABLE",
                                    "href":"columns-clause-sql-json-function-json_table.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.3 </span> JSON_TABLE Generalizes SQL/JSON Query Functions and Conditions",
                                    "href":"json_table-generalizes-sql-json-query-functions-and-conditions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.4 </span> Using JSON_TABLE with JSON Arrays",
                                    "href":"using-json_table-json-arrays.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">21.5 </span> Creating a View Over JSON Data Using JSON_TABLE",
                                    "href":"creating-view-json-data-using-json_table.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">22 </span> SQL/JSON Function JSON_VALUE",
                            "href":"sql-json-function-json_value.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">22.1 </span> Using SQL/JSON Function JSON_VALUE With a Boolean JSON Value",
                                    "href":"using-sql-json-function-json_value-boolean-json-value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.2 </span> Using JSON_VALUE To Instantiate a User-Defined Object-Type or Collection-Type Instance",
                                    "href":"using-json_value-instantiate-user-defined-object-type-or-collection-type-instance.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">22.3 </span> JSON_VALUE as JSON_TABLE",
                                    "href":"json_value-json_table.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">23 </span> Full-Text Search Queries",
                            "href":"full-text-search-queries.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">23.1 </span> Oracle SQL Condition JSON_TEXTCONTAINS",
                                    "href":"oracle-sql-condition-json_textcontains.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">23.2 </span> JSON Facet Search with PL/SQL Procedure CTX_QUERY.RESULT_SET",
                                    "href":"json-facet-search-pl-sql-procedure-ctx_query-result_set.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">24 </span> JSON Data Guide",
                            "href":"json-data-guide.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">24.1 </span> Overview of JSON Data Guide",
                                    "href":"overview-json-data-guide.html#GUID-8A431168-E23B-493D-8190-8A26A8D0BCF1"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.2 </span> Persistent Data-Guide Information as Part of a JSON Search Index",
                                    "href":"persistent-data-guide-information-part-json-search-index.html#GUID-E77948CB-DCA0-4733-8832-4B5F00C01A2E"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.3 </span> Data-Guide Formats and Ways of Creating a Data Guide",
                                    "href":"data-guide-formats-and-ways-creating-data-guide.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.4 </span> JSON Data-Guide Fields",
                                    "href":"json-data-guide-fields.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.5 </span> Data-Dictionary Views For Persistent Data-Guide Information",
                                    "href":"data-dictionary-views-persistent-data-guide-information.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.6 </span> Specifying a Preferred Name for a Field Column",
                                    "href":"specifying-preferred-name-field-column.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.7 </span> Creating a View Over JSON Data Based on Data-Guide Information",
                                    "href":"creating-view-json-data-based-data-guide-information.html#GUID-394009D2-F829-49B0-B6EF-DB24606FEF75"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.8 </span> Adding and Dropping Virtual Columns For JSON Fields Based on Data-Guide Information",
                                    "href":"adding-and-dropping-virtual-columns-json-fields-based-data-guide-information.html#GUID-7AEF436C-B743-4BA1-B6D4-1F1B98E26DB1"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.9 </span> Change Triggers For Data Guide-Enabled Search Index",
                                    "href":"change-triggers-data-guide-enabled-search-index.html#GUID-2F4C6F52-0D96-4405-8F85-CDA0B234D0D5"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.10 </span> Multiple Data Guides Per Document Set",
                                    "href":"multiple-data-guides-document-set.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.11 </span> Querying a Data Guide",
                                    "href":"querying-data-guide.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.12 </span> A Flat Data Guide For Purchase-Order Documents",
                                    "href":"flat-data-guide-purchase-order-documents.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.13 </span> A Hierarchical Data Guide For Purchase-Order Documents",
                                    "href":"hierarchical-data-guide-purchase-order-documents.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">24.14 </span> A Schema Data Guide For Purchase-Order Documents",
                                    "href":"schema-data-guide-purchase-order-documents.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part V Generation of JSON Data",
                    "href":"generation-json-data.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">25 </span> Generation of JSON Data Using SQL",
                            "href":"generation-json-data-sql-json-functions.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">25.1 </span> Overview of JSON Generation",
                                    "href":"overview-json-generation.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.2 </span> Handling of Input Values For SQL/JSON Generation Functions",
                                    "href":"handling-input-values-sql-json-generation-functions.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.3 </span> SQL/JSON Function JSON_OBJECT",
                                    "href":"sql-json-function-json_object.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.4 </span> SQL/JSON Function JSON_ARRAY",
                                    "href":"sql-json-function-json_array.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.5 </span> SQL/JSON Function JSON_OBJECTAGG",
                                    "href":"sql-json-function-json_objectagg.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.6 </span> SQL/JSON Function JSON_ARRAYAGG",
                                    "href":"sql-json-function-json_arrayagg.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">25.7 </span> Read-Only Views Based On JSON Generation",
                                    "href":"read-only-views-based-json-generation.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Part VI PL/SQL Object Types for JSON",
                    "href":"pl-sql-object-types-json.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">26 </span> Overview of PL/SQL Object Types for JSON",
                            "href":"overview-pl-sql-object-types-json.html"
                        },
                        {
                            "title":"<span class=\"secnum\">27 </span> Using PL/SQL Object Types for JSON",
                            "href":"using-pl-sql-object-types-json.html"
                        }
                    ]
                },
                {
                    "title":"Part VII GeoJSON Geographic Data",
                    "href":"geojson-geographic-data.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">28 </span> Using GeoJSON Geographic Data",
                            "href":"using-geojson-geographic-data.html"
                        }
                    ]
                },
                {
                    "title":"Part VIII Performance Tuning for JSON",
                    "href":"performance-tuning-json.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">29 </span> Overview of Performance Tuning for JSON",
                            "href":"overview-performance-tuning-json.html"
                        },
                        {
                            "title":"<span class=\"secnum\">30 </span> Indexes for JSON Data",
                            "href":"indexes-json-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">30.1 </span> Overview of Indexing JSON Data",
                                    "href":"overview-indexing-json-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.2 </span> How To Tell Whether a Function-Based Index for JSON Data Is Picked Up",
                                    "href":"how-tell-whether-function-based-index-json-data-is-picked.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.3 </span> Creating Bitmap Indexes for JSON_VALUE",
                                    "href":"creating-bitmap-indexes-json_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.4 </span> Creating B-Tree Indexes for JSON_VALUE",
                                    "href":"creating-b-tree-indexes-json_value.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.5 </span> Using a JSON_VALUE Function-Based Index with JSON_TABLE Queries",
                                    "href":"using-json_value-function-based-index-json_table-queries.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.6 </span> Using a JSON_VALUE Function-Based Index with JSON_EXISTS Queries",
                                    "href":"using-json_value-function-based-index-json_exists-queries.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.7 </span> Data Type Considerations for JSON_VALUE Indexing and Querying",
                                    "href":"data-type-considerations-json_value-indexing-and-querying.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.8 </span> Creating Multivalue Function-Based Indexes for JSON_EXISTS",
                                    "href":"creating-multivalue-function-based-indexes-json_exists.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.9 </span> Using a Multivalue Function-Based Index",
                                    "href":"using-multivalue-function-based-index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.10 </span> Indexing Multiple JSON Fields Using a Composite B-Tree Index",
                                    "href":"indexing-multiple-json-fields-using-composite-b-tree-index.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">30.11 </span> JSON Search Index for Ad Hoc Queries and Full-Text Search",
                                    "href":"json-search-index-ad-hoc-queries-and-full-text-search.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">31 </span> In-Memory JSON Data",
                            "href":"memory-json-data.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">31.1 </span> Overview of In-Memory JSON Data",
                                    "href":"overview-memory-json-data.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.2 </span> Populating JSON Data Into the In-Memory Column Store",
                                    "href":"populating-json-data-memory-column-store.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">31.3 </span> Upgrading Tables With JSON Data For Use With the In-Memory Column Store",
                                    "href":"upgrading-tables-json-data-use-memory-column-store.html"
                                }
                            ]
                        },
                        {
                            "title":"<span class=\"secnum\">32 </span> JSON Query Rewrite To Use a Materialized View Over JSON_TABLE",
                            "href":"json-query-rewrite-use-materialized-view-json_table.html"
                        }
                    ]
                },
                {
                    "title":"Appendixes",
                    "href":"appendixes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">A </span> ISO 8601 Date, Time, and Duration Support",
                            "href":"iso-8601-date-time-and-duration-support.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B </span> Oracle AI Database JSON Capabilities Specification",
                            "href":"oracle-ai-database-json-capabilities-specification.html"
                        },
                        {
                            "title":"<span class=\"secnum\">C </span> Diagrams for Basic SQL/JSON Path Expression Syntax",
                            "href":"diagrams-basic-sql-json-path-expression-syntax.html"
                        },
                        {
                            "title":"<span class=\"secnum\">D </span> Migrating Textual JSON Data to JSON Data Type",
                            "href":"migrating-textual-json-data-json-data-type.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">D.1 </span> Performing a Pre-Migration Check",
                                    "href":"performing-migration-check.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.2 </span> Populate JSON-Type Column By Querying Textual JSON",
                                    "href":"populate-json-type-column-querying-textual-json.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.3 </span> Using Oracle Data Pump to Migrate to JSON Data Type",
                                    "href":"using-oracle-data-pump-migrate-json-data-type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.4 </span> Using Online Redefinition to Migrate to JSON Data Type",
                                    "href":"using-online-redefinition-migrate-json-data-type.html"
                                },
                                {
                                    "title":"<span class=\"secnum\">D.5 </span> Handling Dependent Objects",
                                    "href":"handling-dependent-objects.html"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});