define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-1B1902CC-DDA6-499B-92FE-C88CCF69C686"
                },
                {
                    "title":"Changes in Oracle AI Database",
                    "href":"changes-oracle-database.html#GUID-7AE9554F-79C8-4508-8DF5-14DCFB7BFA62"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to Large Objects and SecureFiles",
                    "href":"introduction-to-large-objects.html#GUID-1A2B0023-9EE8-48AF-AA76-171D1FC5C241",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> What Are Large Objects?",
                            "href":"what-are-large-objects.html#GUID-087DAC51-6DDB-41CB-B7FB-0CA8F76C80FF"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Where Should We Use LOBs?",
                            "href":"where-to-use-LOBs.html#GUID-EF55494E-BC8C-454C-AF89-4ADFC723D01A"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> LOB Classifications",
                            "href":"LOB-classifications.html#GUID-5043EBAC-2695-4B01-92DF-E163C275C7AE"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> LOB Locator and LOB Value",
                            "href":"LOB-locator-and-LOB-value.html#GUID-A823D2F7-EDBA-45AE-A16A-08CB2307DE37"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> LOB Restrictions",
                            "href":"LOB-restrictions.html#GUID-BA662EA5-4955-4582-B12E-3312FE4B1D6A"
                        },
                        {
                            "title":"<span class=\"secnum\">1.6 </span> How to Navigate This Book",
                            "href":"how-to-navigate-this-book.html#GUID-ED23E53E-0FBD-4CCE-A21D-A918492FADEF"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Persistent LOBs",
                    "href":"using-oracle-LOBs-storage.html#GUID-EC76077B-3EE9-491E-AC6D-171DA919B84C",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Creating a Table with LOB Columns",
                            "href":"creating-a-table-with-LOB-columns.html#GUID-317788D7-4F90-4C86-BF66-36943F329CE9"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Inserting and Updating LOB Values in Tables",
                            "href":"inserting-and-updating-LOB-values-in-tables.html#GUID-9B66B5BD-8765-4163-BF1E-22FFFA0E6218"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Selecting LOB Values from Tables",
                            "href":"selecting-LOB-values-from-tables.html#GUID-BE992F0C-888C-48A0-9719-2D6A072206E3"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Performing DML and Query Operations on LOBs in Nested Tables",
                            "href":"performing-DML-and-query-operations.html#GUID-2AA42D2A-20D6-4C81-9E42-8998ED7ED94D"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Performing Parallel DDL, Parallel DML (PDML), and Parallel Query (PQ) Operations on LOBs",
                            "href":"performing-parallel-DDL-DML-query-operations.html#GUID-6011EE96-FE71-46C1-9914-70412A98C2E2"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Sharding with LOBs",
                            "href":"sharding-with-LOBs.html#GUID-24BD076D-3EC8-4A4D-8D9F-70960EB6C7AE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Temporary LOBs",
                    "href":"operations-specific-to-persistent-and-temporary-LOBs.html#GUID-7B3D15D3-A182-4ED1-A265-8EE15E793C46",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Before You Begin",
                            "href":"before-you-begin.html#GUID-698C7D8E-0BCC-4465-95FD-2C44A258CBE3"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Temporary LOB APIs in Different Programmatic Interfaces",
                            "href":"temporary-LOB-APIs-in-different-programmatic-interfaces.html#GUID-CE55570B-733F-475F-920D-13ED4424A009"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Value LOBs",
                    "href":"value-based-LOBs.html#GUID-59800DAF-2A27-4E19-B9CB-30B580ADB2CE"
                },
                {
                    "title":"<span class=\"secnum\">5 </span> BFILEs",
                    "href":"BFILEs.html#GUID-D4642C92-F343-4700-9F1F-486F82249FB8",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> DIRECTORY Objects",
                            "href":"directory-objects.html#GUID-F7440C27-C7F0-4874-8C3C-F3BC1534CBE0"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> BFILE Locators",
                            "href":"BFILE-locators.html#GUID-35A2BEFA-E677-4C0B-947B-B3212BE8AA1D"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> BFILE APIs",
                            "href":"BFILE-APIs.html#GUID-35D69B5E-D51D-4603-BA03-137E66716F42"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> BFILE APIs in Different Programmatic Interfaces",
                            "href":"BFILE-APIs-in-different-programmatic-interfaces.html#GUID-905D128A-930B-4B8F-B0B3-AB265886FCF9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> SQL Semantics for LOBs",
                    "href":"SQL-semantics-and-LOBs.html#GUID-47B94072-7782-40DD-BFD7-7D3D8A65B502",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> SQL Functions and Operators Supported for Use with LOBs",
                            "href":"supported-functions-and-operators.html#GUID-10C6706D-CE73-4E21-A2B1-55F11A27A6EF"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Detailed Semantics of SQL Operations on LOBs",
                            "href":"detailed-semantics-of-SQL-operations.html#GUID-439C1F7A-D1D6-4FB4-9425-914CCFA19DB0"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Restrictions on SQL Operations on LOBs",
                            "href":"restrictions-on-SQL-operations-on-LOBs.html#GUID-8287AF94-2E69-4BB7-B4EB-0584D10DD144"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> PL/SQL Semantics for LOBs",
                    "href":"PLSQL-semantics-for-LOBs.html#GUID-4147D9E6-173B-4D62-AC0A-C440CCE8A63D",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Implicit Conversion with LOBs",
                            "href":"implicit-conversion-with-LOBs.html#GUID-AF0A6CE4-2217-489A-AFB4-F66729227A59"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Explicit Data Type Conversion Functions",
                            "href":"explicit-data-type-conversion-functions.html#GUID-AFFA69B0-088E-4327-8B41-7295CFB914E6"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Temporary LOBs Created by SQL and PL/SQL Built-in Functions",
                            "href":"temporary-LOBs-created-by-SQL-and-PLSQL-builtin-functions.html#GUID-46F77A28-E24F-486C-A556-652E671DA513"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Data Interface for LOBs",
                    "href":"data-interface-for-persistent-LOBs.html#GUID-4BFDD493-F3FE-451C-9B03-21669D635586",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Overview of the Data Interface for LOBs",
                            "href":"overview-of-data-interface-for-LOBs.html#GUID-E6A304F3-8A56-44EA-8ADE-1E785BE0E7AC"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Benefits of Using the Data Interface for LOBs",
                            "href":"benefits-of-using-data-interface-for-LOBs.html#GUID-4810EB6F-A51E-49B5-92C1-DFF47F22167F"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Data Interface for LOBs in Java",
                            "href":"data-interface-for-LOBs-in-Java.html#GUID-0DA4D3D4-3E2B-4E21-AB08-6308253DF339"
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Data Interface for LOBs in OCI",
                            "href":"data-interface-for-LOBs-in-OCI.html#GUID-FC81B19E-F282-4F46-8F81-E111D5F7CE26"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Locator Interface for LOBs",
                    "href":"overview-of-supplied-LOB-APIs.html#GUID-54BD371D-4486-48FD-BBCE-6374D03E5697",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Before You Begin",
                            "href":"programmatic-environments-that-support-LOBs.html#GUID-95AD6D66-6C1D-4C83-B58B-9BF608C7331E"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> PL/SQL API for LOBs",
                            "href":"PLSQL-API-for-LOBs.html#GUID-22DA74D4-5534-4B8F-A1FE-622E4190FE25"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> JDBC API for LOBs",
                            "href":"JDBC-API-for-LOBs.html#GUID-8BE98F84-4B77-4E38-B4DE-48C8C282BA34"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> OCI API for LOBs",
                            "href":"OCI-API-for-LOBs.html#GUID-3AE5A5FE-7A93-4E70-9AEE-BF4517DB088F"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> ODP.NET API for LOBs",
                            "href":"ODP_NET-API-for-LOBs.html#GUID-D013DD75-C225-44DF-BE64-E098965B54CE"
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> OCCI API for LOBs",
                            "href":"OCCI-API-for-LOBs.html#GUID-9A07168A-91E3-4383-B248-E9423D2F31D1"
                        },
                        {
                            "title":"<span class=\"secnum\">9.7 </span> Pro*C/C++ and Pro*COBOL API for LOBs",
                            "href":"pro-CC-and-pro-COBOL-API-for-LOBs.html#GUID-33496C4B-6A62-4F41-BDAC-D529694A8703"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Distributed LOBs",
                    "href":"distributed-LOBs.html#GUID-7E450E86-3E4E-4714-A164-FD36B93722F6",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Working with Remote LOBs in SQL and PL/SQL",
                            "href":"functions-on-remote-LOBs-returning-scalars.html#GUID-BD5EB0E6-FAA0-42A0-A25B-FC8C64867A40"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Using the Data Interface on Remote LOBs",
                            "href":"data-interface-used-with-remote-LOBs.html#GUID-8EC0212A-BFB6-441B-AEAE-976FDDD11EAB"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Working with Remote Locators",
                            "href":"working-with-remote-locators.html#GUID-B6956FD3-20E0-45D7-8E3D-C415324C49C4"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Performance Guidelines",
                    "href":"performance-guidelines.html#GUID-0EA0E7B7-96E6-4393-B2DA-1F2CA72A72B7",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> LOB Performance Guidelines",
                            "href":"LOB-performance-guidelines.html#GUID-8505852E-936B-477F-B958-14574BB6EDA4"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Moving Data to LOBs in a Threaded Environment",
                            "href":"moving-data-to-LOBs-in-threaded-environment.html#GUID-40E8C7B6-701A-44B2-9295-B9108BF8F61F"
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> LOB Access Statistics",
                            "href":"LOB-access-statistics.html#GUID-5B66CF22-D22C-4218-A8E5-0D97D88A30EE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Persistent LOBs: Advanced DDL",
                    "href":"Persistent_LOBs_Advanced_DDL.html#GUID-D4937403-C28D-4801-8E88-27DC8E428E6D",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Creating a New LOB Column",
                            "href":"creating-new-LOB-column.html#GUID-8A0F9C7A-D1BE-4805-95D4-68849A3AC833"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> Altering an Existing LOB Column",
                            "href":"altering-existing-LOB-column.html#GUID-D5402DFC-7CE0-43C7-82DE-F1E649A6B21C"
                        },
                        {
                            "title":"<span class=\"secnum\">12.3 </span> Creating an Index on LOB Column",
                            "href":"creating-index-on-LOB-column.html#GUID-14FC8C0A-4085-4FCA-80CE-2FE6136681E6"
                        },
                        {
                            "title":"<span class=\"secnum\">12.4 </span> LOBs in Partitioned Tables",
                            "href":"LOBs-in-partitioned-tables.html#GUID-48A8158E-348A-44C7-8E85-C05EE0F0A6EF"
                        },
                        {
                            "title":"<span class=\"secnum\">12.5 </span> LOBs in Index Organized Tables",
                            "href":"LOBs-in-iindex-organized-tables.html#GUID-5E0E0772-C5CE-458A-AD07-E8DB32C24231"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Advanced Design Considerations",
                    "href":"advanced-design-considerations.html#GUID-1153755A-C4F4-4462-B592-6EE520F1C6A7",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Read-Consistent Locators",
                            "href":"read-consistent-locators.html#GUID-B1E476A2-F3FE-4D13-BC2B-FFB809698ED3"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> LOB Locators and Transaction Boundaries",
                            "href":"LOB-locators-and-transaction-boundaries.html#GUID-4DDA92CE-8C94-4DD1-9BA3-C6FC5ED7CAE0"
                        },
                        {
                            "title":"<span class=\"secnum\">13.3 </span> LOBs in the Object Cache",
                            "href":"LOBs-in-object-cache.html#GUID-4AA63439-3BCD-41A8-98D0-40923BFE0309"
                        },
                        {
                            "title":"<span class=\"secnum\">13.4 </span> Guidelines for Creating Terabyte sized LOBs",
                            "href":"guidelines-for-creating-terabyte-sized-LOBs.html#GUID-B8E82069-4847-4116-9DA1-BFE6F99288C2"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Managing LOBs: Database Administration",
                    "href":"managing-LOBs.html#GUID-10997841-B144-447E-B558-2F19E65A42F9",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> Initialization Parameter for SecureFiles LOBs",
                            "href":"initialization-parameter-for-securefiles-LOBs.html#GUID-AD240DE1-392F-41EC-864D-2D892CF7D45A"
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> Database Character Set Considerations",
                            "href":"database-character-set-considerations.html#GUID-380B58C5-7558-400F-9F02-BBD4C5D21B6F"
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> Database Utilities for Loading Data into LOBs",
                            "href":"database-utilities-for-loading-data-into-LOBs.html#GUID-BBEE2D3E-909B-4FBE-B6CE-3F3970ED051E"
                        },
                        {
                            "title":"<span class=\"secnum\">14.5 </span> BFILEs Management",
                            "href":"BFILEs-management.html#GUID-34B4515A-B3D6-4E3A-89A7-BC17531B7C96"
                        },
                        {
                            "title":"<span class=\"secnum\">14.6 </span> Managing LOB Signatures",
                            "href":"managing-LOB-signatures.html#GUID-CD7FCDA4-AFCC-4F91-9179-601DC4CF03F8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Migrating Columns to SecureFile LOBs",
                    "href":"migrating_columns_to_securefile_lobs.html#GUID-4795CB2E-7BA0-4341-BAE3-199F885030D2",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> Migration Considerations",
                            "href":"migration-considerations.html#GUID-6943BBD3-56F0-49C6-9E3F-9E762A158814"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> Migration Methods",
                            "href":"migration-methods.html#GUID-88E445CD-DDE0-4DEB-B611-3CBB9B1CA1D5"
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> Other Considerations While Migrating LONG Columns to LOBs",
                            "href":"other-considerations-while-migrating-LONG-columns-to-LOBs.html#GUID-BF028217-E4DD-4FBE-B14A-46C774BFD5D8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Automatic SecureFiles Shrink",
                    "href":"automatic-securefiles-shrink1.html#GUID-2B9227B2-4946-4F60-88A4-3BA95C4EC3AB"
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Introducing the Database File System",
                    "href":"introducing-database-file-system.html#GUID-B7A83817-F0D6-4A09-AE98-DFC966783109",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> Why a Database File System?",
                            "href":"why-a-database-file-system.html#GUID-6CB9F457-01AA-438D-9DE2-99F297319A66"
                        },
                        {
                            "title":"<span class=\"secnum\">17.2 </span> What Is Database File System (DBFS)?",
                            "href":"what-is-database-file-system.html#GUID-B0D12A6F-88EF-41D5-A15A-722D12F7123A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Using DBFS",
                    "href":"using-DBFS.html#GUID-817DFDC2-7729-4CB6-BAE7-598E9B021DD8",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">18.2 </span> Installing DBFS",
                            "href":"DBFS-installation.html#GUID-E0712718-FD3F-40DF-8B5A-EC689B1C65DA"
                        },
                        {
                            "title":"<span class=\"secnum\">18.3 </span> Creating a DBFS File System",
                            "href":"creating-DBFS-file-system.html#GUID-A4B1B3D5-7080-47EF-86C4-67D6E8F0FC37"
                        },
                        {
                            "title":"<span class=\"secnum\">18.4 </span> Accessing DBFS File System",
                            "href":"DBFS-file-system-access.html#GUID-B03D476F-934D-4AD8-B4D7-493B1C0D7513"
                        },
                        {
                            "title":"<span class=\"secnum\">18.5 </span> Maintaining DBFS",
                            "href":"DBFS-administration.html#GUID-8665C1E7-C96A-4B17-A8F7-1889858EEF18"
                        },
                        {
                            "title":"<span class=\"secnum\">18.6 </span> Shrinking and Reorganizing DBFS Filesystems",
                            "href":"shrinking-reorganizing-DBFS-file-systems.html#GUID-68FE78C8-798C-40DB-8566-F09EB27F4CC9"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> DBFS SecureFiles Store",
                    "href":"DBFS-securefiles-store.html#GUID-F71C0B85-F08D-4CD0-9EB3-AB84C9B355AE",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">19.1 </span> Setting Up a SecureFiles Store",
                            "href":"setting-up-securefiles-store.html#GUID-8DC871AC-95D6-496B-A277-AA47DA94BF64"
                        },
                        {
                            "title":"<span class=\"secnum\">19.2 </span> Using a DBFS SecureFiles Store File System",
                            "href":"using-DBFS-securefiles-store-file-system.html#GUID-D25B94D8-8B78-443D-9167-45B0F9EFC378"
                        },
                        {
                            "title":"<span class=\"secnum\">19.3 </span> About DBFS SecureFiles Store Package, DBMS_DBFS_SFS",
                            "href":"about-DBMS_DBFS_SFS.html#GUID-CE03355D-56C2-4497-9BD7-AD170EFD9615"
                        },
                        {
                            "title":"<span class=\"secnum\">19.4 </span> Database File System (DBFS)— POSIX File Locking",
                            "href":"DBFS-POSIX-file-locking.html#GUID-90F97F5A-8163-4634-813F-7EE372032479"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">20 </span> DBFS Hierarchical Store",
                    "href":"DBFS-hierarchical-store.html#GUID-375BEA1D-F37C-4647-B3CF-03A4FDCF7161",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">20.1 </span> About the Hierarchical Store Package DBMS_DBFS_HS",
                            "href":"about-DBMS_DBFS_HS.html#GUID-5FE7399B-878E-4308-A22E-7C4D270C64D3"
                        },
                        {
                            "title":"<span class=\"secnum\">20.2 </span> Setting up the Store",
                            "href":"setting-up-store.html#GUID-858DB4D4-3CBD-4761-8813-DE075E8ABFB8"
                        },
                        {
                            "title":"<span class=\"secnum\">20.3 </span> Using the Hierarchical Store",
                            "href":"using-hierarchical-store.html#GUID-92FCE08F-B9EA-4A96-BE9D-866327422A76"
                        },
                        {
                            "title":"<span class=\"secnum\">20.4 </span> The DBMS_DBFS_HS Package",
                            "href":"the-DBMS_DBFS_HS-package.html#GUID-09F628B0-1448-4364-A9BE-5E2385D4F6C3"
                        },
                        {
                            "title":"<span class=\"secnum\">20.5 </span> Views for DBFS Hierarchical Store",
                            "href":"views-for-DBFS-hierarchical-store.html#GUID-B1824096-15BC-4BA4-8F9B-18E21ABBBF1C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">21 </span> Database File System Links",
                    "href":"DBMS_FileSystem_Links.html#GUID-3BE7F481-16AB-4584-8339-220D9EAC8684",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">21.1 </span> About Database File System Links",
                            "href":"about-database-file-system-links.html#GUID-9B7775D5-ED13-4156-8655-E955D0D7BC2F"
                        },
                        {
                            "title":"<span class=\"secnum\">21.2 </span> Ways to Create Database File System Links",
                            "href":"ways-to-create-database-file-system-links.html#GUID-4817D6E3-DF45-482B-A5A8-FB6792CEC505"
                        },
                        {
                            "title":"<span class=\"secnum\">21.3 </span> Database File System Links Copy",
                            "href":"database-file-system-links-copy.html#GUID-147629A9-FCC4-481E-B46B-DE0D4366B797"
                        },
                        {
                            "title":"<span class=\"secnum\">21.4 </span> The DBMS_LOB Package Used with DBFS",
                            "href":"DBMS_LOB-used-with-DBFS.html#GUID-0D34EA09-7A58-4EB4-9D87-9A4D5501C840"
                        },
                        {
                            "title":"<span class=\"secnum\">21.5 </span> DBMS_LOB Constants Used with DBFS",
                            "href":"DBMS_LOB-constants-used-with-DBFS.html#GUID-D91EC383-D41F-4744-9144-14B045622507"
                        },
                        {
                            "title":"<span class=\"secnum\">21.6 </span> DBMS_LOB Subprograms Used with DBFS",
                            "href":"DBMS_LOB-subprograms-used-with-DBFS.html#GUID-FD35FE2A-7990-45CB-846A-79ACA2075AC8"
                        },
                        {
                            "title":"<span class=\"secnum\">21.7 </span> Copying a Linked LOB Between Tables",
                            "href":"copy-linked-LOB-between-tables.html#GUID-92F203A6-5A72-4775-AC57-BFA8012A4D2D"
                        },
                        {
                            "title":"<span class=\"secnum\">21.8 </span> Online Redefinition and DBFS Links",
                            "href":"online-redefinition-and-DBFS-links.html#GUID-71728CBF-089E-43FD-BAC9-1BCC1227E7D4"
                        },
                        {
                            "title":"<span class=\"secnum\">21.9 </span> Transparent Read",
                            "href":"transparent-read.html#GUID-67FBF9BD-3FCC-40E3-8E5F-C895F985F7A7"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">22 </span> DBFS Content API",
                    "href":"DBFS-content-API.html#GUID-630BE6DB-0178-4EE4-8D7D-824BA886F68E",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">22.1 </span> Overview of DBFS Content API",
                            "href":"overview-DBFS-content-API.html#GUID-32E99100-7B83-4EF1-AEB1-93FDDB086F28"
                        },
                        {
                            "title":"<span class=\"secnum\">22.2 </span> Stores and DBFS Content API",
                            "href":"stores-and-DBFS-content-API.html#GUID-CCFD63C0-B389-4808-B9D9-B5DAD818ED78"
                        },
                        {
                            "title":"<span class=\"secnum\">22.3 </span> Getting Started with DBMS_DBFS_CONTENT Package",
                            "href":"get-start-DBMS_DBFS_CONTENT.html#GUID-04A5AC11-BDFD-4EAE-9625-3C23B11BA533"
                        },
                        {
                            "title":"<span class=\"secnum\">22.4 </span> Administrative and Query APIs",
                            "href":"administrative-and-query-APIs.html#GUID-13FDE7B4-9F40-4172-A28C-4B73DF16B121"
                        },
                        {
                            "title":"<span class=\"secnum\">22.5 </span> Querying DBFS Content API Space Usage",
                            "href":"query-DBFS-content-API-space-usage.html#GUID-090D55B7-8403-4FC5-9477-50D0BB84CD37"
                        },
                        {
                            "title":"<span class=\"secnum\">22.6 </span> DBFS Content API Session Defaults",
                            "href":"DBFS-content-API-session-defaults.html#GUID-641FCE10-2300-48E2-B98F-CF22B379E2ED"
                        },
                        {
                            "title":"<span class=\"secnum\">22.7 </span> DBFS Content API Interface Versioning",
                            "href":"DBFS-content-API-interface-versioning.html#GUID-B0D5EBFA-B03F-4005-BBD4-759D683B503E"
                        },
                        {
                            "title":"<span class=\"secnum\">22.8 </span> DBFS Content API Creation Operations",
                            "href":"DBFS-content-API-creation-operations.html#GUID-8D11AC41-15D8-4F7C-82C5-699D624B47BE"
                        },
                        {
                            "title":"<span class=\"secnum\">22.9 </span> DBFS Content API Deletion Operations",
                            "href":"DBFS-content-API-deletion-operations.html#GUID-3F79EA24-6F98-41BD-9367-D60C64AC445B"
                        },
                        {
                            "title":"<span class=\"secnum\">22.10 </span> DBFS Content API Path Get and Put Operations",
                            "href":"DBFS-content-API-path-get-put-operations.html#GUID-D45372A1-96F4-488D-BBC9-A45366555CCD"
                        },
                        {
                            "title":"<span class=\"secnum\">22.11 </span> DBFS Content API Rename and Move Operations",
                            "href":"DBFS-content-API-rename-move-operations.html#GUID-A310544A-BAE7-47B6-A429-45CE672A6F05"
                        },
                        {
                            "title":"<span class=\"secnum\">22.12 </span> Directory Listings",
                            "href":"directory-listings.html#GUID-FCD27252-EB21-4B4F-AAFB-6C71BD800A51"
                        },
                        {
                            "title":"<span class=\"secnum\">22.13 </span> DBFS Content API Directory Navigation and Search",
                            "href":"DBFS-content-API-directory-navigation-search.html#GUID-6450F078-E6BD-44F0-ADB0-EDD497288549"
                        },
                        {
                            "title":"<span class=\"secnum\">22.14 </span> DBFS Content API Locking Operations",
                            "href":"DBFS-content-API-locking-operations.html#GUID-C29F67F2-2A97-473A-8F4D-802B9CCE5673"
                        },
                        {
                            "title":"<span class=\"secnum\">22.15 </span> DBFS Content API Access Checks",
                            "href":"DBFS-content-API-access-checks.html#GUID-3F740654-1B47-4C40-A4D9-35C2C02ECE9C"
                        },
                        {
                            "title":"<span class=\"secnum\">22.16 </span> DBFS Content API Abstract Operations",
                            "href":"DBFS-content-API-abstract-operations.html#GUID-E6865364-8DCE-4656-BC7D-F55390F1B659"
                        },
                        {
                            "title":"<span class=\"secnum\">22.17 </span> DBFS Content API Path Normalization",
                            "href":"DBFS-content-API-path-normalization.html#GUID-5F818AA3-CC9A-44A1-AD36-1F77702EE64B"
                        },
                        {
                            "title":"<span class=\"secnum\">22.18 </span> DBFS Content API Statistics Support",
                            "href":"DBFS-content-API-statistics-support.html#GUID-D2E2A1A8-00DF-4C3D-9420-639BB48ACE61"
                        },
                        {
                            "title":"<span class=\"secnum\">22.19 </span> DBFS Content API Tracing Support",
                            "href":"DBFS-content-API-tracing-support.html#GUID-26A3B8BF-30AE-4219-B10F-7AF0BC64024B"
                        },
                        {
                            "title":"<span class=\"secnum\">22.20 </span> Resource and Property Views",
                            "href":"resource-and-property-views.html#GUID-D8F52D59-874D-47DC-99B1-D8E20B46AABB"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">23 </span> Creating Your Own DBFS Store",
                    "href":"creating-your-own-DBFS-store.html#GUID-01819696-9FE0-41AB-9388-A0ECA1F72E52",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">23.1 </span> Overview of DBFS Store Creation and Use",
                            "href":"overview-DBFS-store-creation-and-use.html#GUID-15A25729-A83D-4B0B-8858-E9DEDA9C4554"
                        },
                        {
                            "title":"<span class=\"secnum\">23.2 </span> DBFS Content Store Provider Interface (DBFS Content SPI)",
                            "href":"DBFS-content-store-provider-interface.html#GUID-5EA68AD7-404E-47CC-86DE-EDB2EBA68119"
                        },
                        {
                            "title":"<span class=\"secnum\">23.3 </span> Creating a Custom Store Provider",
                            "href":"creating-custom-store-provider.html#GUID-FC7FD421-751A-4D8C-927C-A046AFDFD492"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">24 </span> DBFS Access Using OFS",
                    "href":"dbfs_access_using_ofs.html#GUID-034FC394-AE15-4D16-8AA0-45CC0A70CACC"
                },
                {
                    "title":"<span class=\"secnum\">A </span> Comparing the LOB Interfaces",
                    "href":"comparing-LOB-interfaces.html#GUID-0DAF0BF6-589C-48A8-B278-02776E86B77E"
                }
            ]
        }
    ]
});