define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-5CC9B2C2-D699-45B2-B9C7-798442489ADD"
                },
                {
                    "title":"Changes in This Release",
                    "href":"changes-in-this-release-for-oracle-database-object-relational-developers-guide.html#GUID-1A0FF8C6-75E9-4614-83CD-92C2C53A15DE"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to Oracle Objects",
                    "href":"introduction-to-oracle-objects.html#GUID-7667A5B4-22E3-465F-9F7B-7043A9525DD2",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> About Oracle Objects",
                            "href":"about-oracle-objects.html#GUID-8F0BA083-FA6D-4373-B440-50FDDA4D6E90"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Advantages of Objects",
                            "href":"advantages-of-objects.html#GUID-6ECF2EC2-98DB-40E6-A799-0B66CA88AD09"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Key Features of the Object-Relational Model",
                            "href":"key-features-object-relational-model.html#GUID-8A38BA82-CCD5-4424-AE19-10A994E25B0E"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Basic Components of Oracle Objects",
                    "href":"basic-components-of-oracle-objects.html#GUID-E2DD59A0-3FFC-4AC2-9A1B-4E457275BE0B",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> SQL Object Types and References",
                            "href":"Sql-object-types-and-references.html#GUID-A3B2A9BB-CFC7-43D6-AAA1-185D6C99F37E"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Object Methods",
                            "href":"object-methods.html#GUID-06384723-F483-484B-A0D0-18CE41810392"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Inheritance in SQL Object Types",
                            "href":"inheritance-in-sql-object-types.html#GUID-D6D92FB6-7BC4-4EE6-A9EC-BC69C5BA5A56"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Functions and Operators Useful with Objects",
                            "href":"functions-and-operators-useful-with-objects.html#GUID-502C8BA5-8B2F-4E57-B526-0C857DD3FA77"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Using PL/SQL With Object Types",
                    "href":"using-pl-sql-with--object-types.html#GUID-C70ACBDE-FFCC-495C-931D-07E0D59C92E5",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Declaring and Initializing Objects in PL/SQL",
                            "href":"declaring-initializing-objects-in-plsql.html#GUID-AA6DEB60-3D57-44CE-B0F6-D1AEC0B47AE0"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Object Manipulation in PL/SQL",
                            "href":"object-manipulation-in-plsql.html#GUID-958F01EE-38E4-490D-BAC3-23FBE6023C2E"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Use of Overloading in PL/SQL with Inheritance",
                            "href":"use-of-overloading-in-plsql-with-inheritance.html#GUID-B6212BB9-3314-4EE4-B587-AADFC72F1166"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Using Dynamic SQL With Objects",
                            "href":"using-dynamic-sql-with-objects.html#GUID-A71791C6-4DE8-479B-B7A7-5F3C33E9E959"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Object Support in Oracle Programming Environments",
                    "href":"object-support-in-oracle-programming-environments.html#GUID-C14303C9-1119-4177-86D3-42EEF90F6D9E",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> SQL and Object Types",
                            "href":"sql-and-object-types.html#GUID-FCEF8F2D-E25A-43E9-A94F-CD82D67DC50C"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> SQL Developer",
                            "href":"sql-developer.html#GUID-1F5DA2D3-B7F3-470B-BD10-130963AB0B7E"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> PL/SQL",
                            "href":"plsql.html#GUID-5463A7B8-ED36-4060-A356-3EA6875576EA"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Oracle Call Interface (OCI)",
                            "href":"oracle-call-interface-oci.html#GUID-D3515120-813C-480B-93BC-6C9027FE14E1"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Pro*C/C++",
                            "href":"pro-c-cpp.html#GUID-FE0C72ED-302A-4D93-A33A-2A17F48C3AD4"
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Oracle C++ Call Interface (OCCI)",
                            "href":"oracle-c-cpp-call-interface-odci.html#GUID-5B8FDC66-51A0-425C-9666-E7D72C89E3DD"
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> Java Tools for Accessing Oracle Objects",
                            "href":"java-tools-for-accessing-oracle-objects.html#GUID-B0A2A1D8-0330-4DD9-B107-AAAE4F47FEE6"
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> XML",
                            "href":"xml.html#GUID-9D9CC289-4B35-45A5-BECB-0B6975089B6A"
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Utilities Providing Support for Objects",
                            "href":"utilities-providing-support-for-objects.html#GUID-256C1C97-EB5A-420F-8DBC-0D516E631654"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Support for Collection Data Types",
                    "href":"support-for-collection-data-types.html#GUID-0EF7C6B0-B68A-4671-A7B6-857D8F6F3DA8",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Collection Data Types",
                            "href":"collection-data-types.html#GUID-1200DD46-95C0-4776-90BB-0ED0CD61267E"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Multilevel Collection Types",
                            "href":"multilevel-collection-types.html#GUID-579BF1AB-5A19-4226-8D47-3FADC21D748B"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Operations on Collection Data Types",
                            "href":"operations-on-collection-data-types.html#GUID-0240B84A-0691-49E2-8DBB-BDBF69C9FABA"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Partitioning Tables That Contain Oracle Objects",
                            "href":"partitioning-table-that-contain-oracle-objects.html#GUID-D5039963-EBC7-4B07-B4FE-3ACC7EC452F4"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Applying an Object Model to Relational Data",
                    "href":"applying-an-object-model-to-relational-data.html#GUID-5D527C3A-6B6F-4C8E-A3F5-93340737F8B0",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Why Use Object Views",
                            "href":"why-use-object-views.html#GUID-9EAD997A-1DB7-48F7-A90E-323A91E86B39"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Defining Object Views",
                            "href":"defining-object-views.html#GUID-DFA84FAC-62CB-4C96-BB2F-8399F2BBC934"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Object Views Used in Applications",
                            "href":"object-views-used-in-applications.html#GUID-6D94F623-B532-48F0-A0F7-48B40C3D752C"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Objects Nested in Object Views",
                            "href":"objects-nested-in-object-views.html#GUID-7C3344B1-6838-4D96-85E6-44A484AD7E7C"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Identifying Null Objects in Object Views",
                            "href":"identifying-null-objects-in-object-views.html#GUID-14CBA56D-4508-4206-AD9C-5781500B6722"
                        },
                        {
                            "title":"<span class=\"secnum\">6.6 </span> Nested Tables and Varrays Used in Object Views",
                            "href":"nested-tables-and-varrays-used-in-object-views.html#GUID-6FB06D04-D8AE-4D4E-82DA-27062056BBC3"
                        },
                        {
                            "title":"<span class=\"secnum\">6.7 </span> Object Identifiers for Object Views",
                            "href":"object-identifiers-for-object-views.html#GUID-0B1D36EC-1C2A-4402-820B-7C1279DAB878"
                        },
                        {
                            "title":"<span class=\"secnum\">6.8 </span> References Created to View Objects",
                            "href":"references-created-to-view-objects.html#GUID-8E2FB6E0-E79D-43BC-B159-292DCCA75D4C"
                        },
                        {
                            "title":"<span class=\"secnum\">6.9 </span> Creating References to Objects with REF",
                            "href":"creating-references-to-objects-with-REF.html#GUID-AE1FF829-0F35-4219-BD2C-812E82A37405"
                        },
                        {
                            "title":"<span class=\"secnum\">6.10 </span> Inverse Relationships Modelled with Object Views",
                            "href":"inverse-relationships-modelled-with-object-views.html#GUID-1C3DBB15-EA84-49EA-9D1C-3C57EE858A25"
                        },
                        {
                            "title":"<span class=\"secnum\">6.11 </span> Object View Manipulations",
                            "href":"object-view-manipulations.html#GUID-4B07D83E-888F-44D2-BC56-8769ECE9159E"
                        },
                        {
                            "title":"<span class=\"secnum\">6.12 </span> Applying the Object Model to Remote Tables",
                            "href":"applying-the-object-model-to-remote-tables.html#GUID-C27D3835-40B5-4CEA-ACF5-FC77C0A660CF"
                        },
                        {
                            "title":"<span class=\"secnum\">6.13 </span> Defining Complex Relationships in Object Views",
                            "href":"defining-complex-relationships-in-object-views.html#GUID-6F53BC3E-7EF9-4AB1-8E09-154A4A72DD3B"
                        },
                        {
                            "title":"<span class=\"secnum\">6.14 </span> Object View Hierarchies",
                            "href":"object-vew-hierarchies.html#GUID-02606831-2C41-4C51-8E18-36191EBDDD05"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Managing Oracle Objects",
                    "href":"managing-oracle-objects.html#GUID-22097AF1-7EB6-4B42-86F2-047A0A2E6633",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Privileges on Object Types and Their Methods",
                            "href":"privileges-on-object-types-and-their-methods.html#GUID-73B9AFB8-FE49-4177-AC8B-3C74000943F8"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Type Dependencies",
                            "href":"type-dependencies.html#GUID-7A7391E8-494A-4FEC-8954-B0FDBE8CC9AB"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Synonyms for Object Types",
                            "href":"synonyms-for-object-types.html#GUID-863F7925-55CE-453C-98FF-EF247441ACE5"
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> Performance Tuning",
                            "href":"performance-tuning.html#GUID-E14F1D6A-7824-4CF0-8A3F-23E360183F47"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Advanced Topics for Oracle Objects",
                    "href":"advanced-topics-for-oracle-objects.html#GUID-0EA3684A-E7E1-4F18-9433-8D64D63A73C4",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Storage of Objects",
                            "href":"storage-of-objects.html#GUID-F4FCDD3D-31A2-413C-9BB9-D7AB01328BA6"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Creating Indexes on Typeids or Attributes",
                            "href":"creating-indexes-on-typeids-or-attributes.html#GUID-E69D6B19-7B41-4046-A621-B80C67736AA0"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Type Evolution",
                            "href":"type-evolution.html#GUID-AD083363-701A-4CE4-8795-C55D7EBCCB47"
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Storing XMLTypes and LOBs in an ANYDATA Column",
                            "href":"storing-XMLTypes-and-LOBs-in-an-ANYDATA-column.html#GUID-3F1BA18F-9057-49C6-8275-2B5139634457"
                        },
                        {
                            "title":"<span class=\"secnum\">8.5 </span> System-Defined and User-Defined Constructors",
                            "href":"system-defined-and-user-defined-constructors.html#GUID-0D6FA836-9ACB-4CC3-9355-298E49DA73E1"
                        },
                        {
                            "title":"<span class=\"secnum\">8.6 </span> Transient and Generic Types",
                            "href":"transient-and-generic-types.html#GUID-346184F1-EDED-4D6E-87D2-B044CBF2C06F"
                        },
                        {
                            "title":"<span class=\"secnum\">8.7 </span> User-Defined Aggregate Functions",
                            "href":"user-defined-aggregate-functions.html#GUID-3235F722-33A4-4E67-802F-3969D6634E3C"
                        },
                        {
                            "title":"<span class=\"secnum\">8.8 </span> How Locators Improve the Performance of Nested Tables",
                            "href":"how-locators-improve-the-performance-of-nested-tables.html#GUID-CB163123-7692-4D8A-AA5C-D9A799B4EB5A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Design Considerations for Oracle Objects",
                    "href":"design-considerations-for-oracle-objects.html#GUID-1AC30ADB-AD24-4401-9183-AB7778635760",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> General Storage Considerations for Objects",
                            "href":"general-storage-considerations-for-objects.html#GUID-268817C7-AA8C-41E8-8830-DA1FF699450F"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Performance of Object Comparisons",
                            "href":"performance-of-object-comparisons.html#GUID-AED31F4F-5049-4BD3-BEB7-694682DC414F"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> Design Considerations for REFs",
                            "href":"design-considerations-for-REFs.html#GUID-79DD95A2-3080-47BC-95FB-7FD42D1E1BBF"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> Design Considerations for Collections",
                            "href":"design-considerations-for-collections.html#GUID-F3904AFE-E6E3-48E9-9482-5DB98D1CD03F"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> Design Considerations for Methods",
                            "href":"design-considerations-for-methods.html#GUID-5ED85C90-3B2D-446A-979E-3B3C2CFC254E"
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> Reusable Code Using Invoker Rights",
                            "href":"reusable-code-using-invoker-rights.html#GUID-8500EC72-3783-4B9B-8645-53FE505C1F35"
                        },
                        {
                            "title":"<span class=\"secnum\">9.7 </span> Roles with Invoker's Rights Subprograms",
                            "href":"roles-with-invokers-rights-subprograms.html#GUID-A02FEDA1-A864-4F90-A6B2-DAD3900F150B"
                        },
                        {
                            "title":"<span class=\"secnum\">9.8 </span> Replication Support for Objects",
                            "href":"replication-support-for-objects.html#GUID-90C879B8-3216-4B5A-BBCC-6AFFF1CDF573"
                        },
                        {
                            "title":"<span class=\"secnum\">9.9 </span> Materialized View Support for Objects",
                            "href":"materialized-view-support-for-objects.html#GUID-9CC262CF-7398-400B-8428-E27EF0A0A14A"
                        },
                        {
                            "title":"<span class=\"secnum\">9.10 </span> Constraints on Objects",
                            "href":"constraints-on-objects.html#GUID-7191723A-4956-406B-A527-E2A4C288AE04"
                        },
                        {
                            "title":"<span class=\"secnum\">9.11 </span> Considerations Related to Type Evolution",
                            "href":"considerations-related-to-type-evolution.html#GUID-EB0F9D77-B4C7-4BEE-B44B-7B03D3CC5B73"
                        },
                        {
                            "title":"<span class=\"secnum\">9.12 </span> Parallel Queries with Oracle Objects",
                            "href":"parallel-queries-with-oracle-objects.html#GUID-00299A11-1EDF-4E1D-A389-D383C2D7D923"
                        },
                        {
                            "title":"<span class=\"secnum\">9.13 </span> Design Consideration Tips and Techniques",
                            "href":"design-consideration-tips-and-techniques.html#GUID-4DBA36C1-2766-49E8-8975-CA4D7376A969"
                        }
                    ]
                }
            ]
        }
    ]
});