define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-E5C73DEC-3340-4FD7-A7A9-E7A8E6FECE27"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Understanding Oracle Text Application Development",
                    "href":"understanding-oracle-text-application-development.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Introduction to Oracle Text",
                            "href":"introduction-oracle-text.html#GUID-425F55BD-4AE3-4CCE-9FE4-3B94A4AF599E"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Document Collection Applications",
                            "href":"document-collection-applications.html#GUID-F4C4D9F8-3F4F-414D-A0E3-497C6EE5CD8E"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Catalog Information Applications",
                            "href":"catalog-information-applications1.html#GUID-6BEABDBB-330E-433F-8A0E-3139CE86523C"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Document Classification Applications",
                            "href":"document-classification-applications.html#GUID-DFE15FDF-C43D-4DB9-AB0E-4D2FF6E98FB0"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> XML Search Applications",
                            "href":"xml-search-applications.html#GUID-6AC2A6CE-CC85-4916-8A45-F400A28776E3"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Getting Started with Oracle Text",
                    "href":"getting-started-with-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Overview of Getting Started with Oracle Text",
                            "href":"overview-getting-started-oracle-text.html#GUID-2F586496-2F56-49D5-B61E-4344E4A6577C"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Creating an Oracle Text User",
                            "href":"creating-oracle-text-user.html#GUID-2654C316-2C70-4CD1-AFA4-5FD601D8624F"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Query Application Quick Tour",
                            "href":"query-application-quick-tour.html#GUID-8D1FF789-F5F2-4C0A-9D8E-978DADBBC4F2"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Catalog Application Quick Tour",
                            "href":"catalog-application-quick-tour.html#GUID-7648841D-DE6D-441D-8C1B-5883675C236F"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Classification Application Quick Tour",
                            "href":"classification-application-quick-tour.html#GUID-0AA9ED63-E6F8-4123-A3A9-7BB5676BC040"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Indexing with Oracle Text",
                    "href":"indexing-with-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> About Oracle Text Indexes",
                            "href":"oracle-text-indexes.html#GUID-7D326900-046C-44AF-A370-BF72CDCE7AC4"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Considerations for Oracle Text Indexing",
                            "href":"considerations-oracle-text-indexing.html#GUID-7BAD1BF9-999F-4B2E-AC7B-511D57071B93"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Document Language",
                            "href":"document-language.html#GUID-C00A748E-A5FC-4AD2-8E3F-007DFF5C2915"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Special Characters",
                            "href":"indexing-special-characters.html#GUID-4A543C4D-83B6-4CF0-8426-974B2CB9DAD8"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Case-Sensitive Indexing and Querying",
                            "href":"case-sensitive-indexing-and-querying.html#GUID-CE2F1CF0-1A95-4369-BEFD-B9AFC0B6341F"
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> Improved Document Services Performance with a Forward Index",
                            "href":"document-services-procedures-performance-and-forward-index.html#GUID-09B3C84C-D3AF-402D-9EE4-5C4761CF2AC4"
                        },
                        {
                            "title":"<span class=\"secnum\">3.7 </span> Language-Specific Features",
                            "href":"language-specific-features.html#GUID-8E940196-F32C-4DF6-853C-2ED0FFC5DED6"
                        },
                        {
                            "title":"<span class=\"secnum\">3.8 </span> About Entity Extraction and CTX_ENTITY",
                            "href":"entity-extraction-and-ctx_entity.html#GUID-2561448A-5526-45DD-A21A-52B894D4861E"
                        },
                        {
                            "title":"<span class=\"secnum\">3.9 </span> About Fuzzy Matching and Stemming",
                            "href":"fuzzy-matching-and-stemming.html#GUID-098F287A-DD02-42E1-B685-B1E4ED108FBA"
                        },
                        {
                            "title":"<span class=\"secnum\">3.10 </span> Better Wildcard Query Performance",
                            "href":"better-wildcard-query-performance.html#GUID-77B6DAF7-2945-4C6E-A81C-ED6C564FBE81"
                        },
                        {
                            "title":"<span class=\"secnum\">3.11 </span> Document Section Searches",
                            "href":"document-section-searching1.html#GUID-A90411C2-2CAD-40B1-AE40-20BFAA2AD03F"
                        },
                        {
                            "title":"<span class=\"secnum\">3.12 </span> Stopwords and Stopthemes",
                            "href":"stopwords-and-stopthemes.html#GUID-D1B73A4D-B3C3-4ACE-9CFD-43A112FABAAE"
                        },
                        {
                            "title":"<span class=\"secnum\">3.13 </span> Index Performance",
                            "href":"index-performance.html#GUID-BE3F8E42-90F5-4423-9EB3-7BEFC3766C13"
                        },
                        {
                            "title":"<span class=\"secnum\">3.14 </span> Query Performance and Storage of Large Object (LOB) Columns",
                            "href":"query-performance-and-storage-large-object-lob-columns.html#GUID-66290B96-C5E8-4A95-8331-CDE4ECAB922C"
                        },
                        {
                            "title":"<span class=\"secnum\">3.15 </span> Mixed Query Performance",
                            "href":"mixed-query-performance.html#GUID-46930C81-6BCD-44CA-9844-D3FAAB7CB367"
                        },
                        {
                            "title":"<span class=\"secnum\">3.16 </span> In-Memory Full Text Search and JSON Full Text Search",
                            "href":"memory-full-text-search-and-json-full-text-search.html#GUID-F2DFFCF3-48EB-4B02-92FF-43D36680D5F6"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Creating Oracle Text Indexes",
                    "href":"creating-oracle-text-indexes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Summary of the Procedure for Creating an Oracle Text Index",
                            "href":"summary-procedure-creating-text-index.html#GUID-D1C75D15-761D-455D-B837-52549B2172C6"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Creating Preferences",
                            "href":"creating-preferences.html#GUID-FE6A5B95-759E-478C-BCAB-C453738FAE5E"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Section Searching Example: Creating HTML Sections",
                            "href":"creating-section-groups-section-searching.html#GUID-301331BA-16EE-4DEE-BAD3-38ACB238CCED"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Using Stopwords and Stoplists",
                            "href":"using-stopwords-and-stoplists.html#GUID-71087894-0C0B-42CF-B37E-064401C54545"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Creating a CONTEXT Index",
                            "href":"creating-context-index.html#GUID-11480023-8177-4971-8BA6-9C1526D56943"
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Creating a CTXCAT Index",
                            "href":"creating-ctxcat-index.html#GUID-210F00C9-8866-466F-909F-71C672CF469B"
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> Creating a CTXRULE Index",
                            "href":"creating-ctxrule-index.html#GUID-32E664C4-0379-4CC0-8040-67B2CFED020C"
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> Creating a JSON Search Index",
                            "href":"creating-json-search-index.html#GUID-237C250A-4215-424B-8AAD-D3EA73F216B7"
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Creating an Oracle Text Search Index",
                            "href":"creating-oracle-text-search-index.html#GUID-53BE6726-3CA4-405B-A13F-84C2CAC2D9AB"
                        },
                        {
                            "title":"<span class=\"secnum\">4.10 </span> Creating a Hybrid Vector Index",
                            "href":"creating-hybrid-vector-index.html#GUID-716988EC-5DC5-4C8C-A5DF-35D9C5F2BC29"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Maintaining Oracle Text Indexes",
                    "href":"maintaining-oracle-text-indexes.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Viewing Index Errors",
                            "href":"viewing-index-errors.html#GUID-9C9B8E82-EF57-452F-B8FF-3BF728B56DEF"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Dropping an Index",
                            "href":"dropping-index.html#GUID-6C7E2AC5-6933-4C89-A63C-19D45D63BB46"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Resuming a Failed Index",
                            "href":"resuming-failed-index.html#GUID-8BC1BF13-762C-4A03-8BB9-F3198909EFF0"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Re-creating an Index",
                            "href":"creating-index.html#GUID-BA511205-6725-4DE1-A990-EE936ABF7A22"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Rebuilding an Index",
                            "href":"rebuilding-index.html#GUID-10365262-8B48-40AA-B1F3-DE3268EA9B39"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> Dropping a Preference",
                            "href":"dropping-preference.html#GUID-2F50B8D4-106C-4BC7-BBAE-CC4E9B890B62"
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> Managing DML Operations for a CONTEXT Index",
                            "href":"managing-dml-operations-context-index.html#GUID-4313B6A6-510F-41E8-9B5C-3559F42742D4"
                        },
                        {
                            "title":"<span class=\"secnum\">5.8 </span> Using Automatic Maintenance for an Index",
                            "href":"using-automatic-maintenance-index.html#GUID-30443CEC-E5C1-4DEB-8A49-7B3242FC190B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Querying with Oracle Text",
                    "href":"querying-with-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Overview of Queries",
                            "href":"overview-queries.html#GUID-3EAE4D7D-C73B-4E19-BBF2-5EBE05C21D9C"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Oracle Text Query Features",
                            "href":"oracle-text-query-features.html#GUID-D0633C95-0A90-47B8-8A7B-B134C0226B93"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Working with CONTEXT and CTXCAT Grammars in Oracle Text",
                    "href":"working-with-CONTEXT-and-CTXCAT-grammars-in-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> The CONTEXT Grammar",
                            "href":"context-grammar.html#GUID-7070C025-54E1-4FBB-8585-1FCBD525927D"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> The CTXCAT Grammar",
                            "href":"ctxcat-grammar.html#GUID-6920E017-A76E-4911-A7C3-CFF7A3CF1016"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Presenting Documents in Oracle Text",
                    "href":"presenting-documents-in-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> Highlighting Query Terms",
                            "href":"highlighting-query-terms.html#GUID-30DA7E8C-A718-4F17-AFC1-286B208C5E86"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Obtaining Part-of-Speech Information for a Document",
                            "href":"obtaining-part-speech-information-document.html#GUID-CFB27531-DF84-4E28-9D19-BDC148B0F6C5"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Obtaining Lists of Themes, Gists, and Theme Summaries",
                            "href":"obtaining-lists-themes-gists-and-theme-summaries.html#GUID-7E4094C7-2835-400E-B13D-830D39C4C8AD"
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Presenting and Highlighting Documents",
                            "href":"document-presentation-and-highlighting.html#GUID-9D0E630D-8AA7-4DCD-9D99-10BB71E76B7A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Classifying Documents in Oracle Text",
                    "href":"classifying-documents-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Overview of Document Classification",
                            "href":"overview-document-classification.html#GUID-69EAD761-8C53-455D-91F3-C85E84F27A70"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> Classification Applications",
                            "href":"classification-applications.html#GUID-78D0D7EE-4D60-49C0-B481-4D20A4F3246D"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> Classification Solutions",
                            "href":"classification-solutions.html#GUID-0F765E2D-A7B2-48C5-A6A0-49EBBBD0E39F"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> Rule-Based Classification",
                            "href":"rule-based-classification.html#GUID-8D624E54-C32A-42A8-A6AF-DF64237242F2"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> Supervised Classification",
                            "href":"supervised-classification.html#GUID-D1458643-CD73-4092-B821-44BCFB85CAE6"
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> Unsupervised Classification (Clustering)",
                            "href":"unsupervised-classification-clustering.html#GUID-9318FD70-869D-4465-A51E-58FB7803AB4C"
                        },
                        {
                            "title":"<span class=\"secnum\">9.7 </span> Unsupervised Classification (Clustering) Example",
                            "href":"unsupervised-classification-clustering-example.html#GUID-BB043FA2-B89C-4D89-9C9B-E410D85629CC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Tuning Oracle Text",
                    "href":"tuning-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Optimizing Queries with Statistics",
                            "href":"optimizing-queries-statistics.html#GUID-6F920664-89E8-4CF5-A974-225F51E276EF"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Optimizing Queries for Response Time",
                            "href":"optimizing-queries-response-time.html#GUID-3B8371B5-F7AC-4A94-80EE-510B7820EE6D"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Optimizing Queries for Throughput",
                            "href":"optimizing-queries-throughput.html#GUID-21432876-BCE4-4250-A67F-C6E76017B872"
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> Composite Domain Index in Oracle Text",
                            "href":"composite-domain-index-cdi-oracle-text.html#GUID-0A82CB4D-A252-4838-ACA1-8EF10FCD9A29"
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> Performance Tuning with CDI",
                            "href":"performance-tuning-cdi.html#GUID-F315BDEC-F569-4A1C-939F-99B3B64726FA"
                        },
                        {
                            "title":"<span class=\"secnum\">10.6 </span> Solving Index and Query Bottlenecks by Using Tracing",
                            "href":"solving-index-and-query-bottlenecks-using-tracing.html#GUID-E282E4C7-6F64-46AB-909D-1E2F07A563CF"
                        },
                        {
                            "title":"<span class=\"secnum\">10.7 </span> Using Parallel Queries",
                            "href":"using-parallel-queries.html#GUID-51F4ABF4-83A1-44EA-80FB-EF72430D3A1A"
                        },
                        {
                            "title":"<span class=\"secnum\">10.8 </span> Tuning Queries with Blocking Operations",
                            "href":"tuning-queries-blocking-operations.html#GUID-45AA18EF-710D-4A32-8A6C-3522054B10A8"
                        },
                        {
                            "title":"<span class=\"secnum\">10.9 </span> Frequently Asked Questions About Query Performance",
                            "href":"frequently-asked-questions-query-performance.html#GUID-90312BBE-00D7-4200-B6AF-77CAFAA5D2F3"
                        },
                        {
                            "title":"<span class=\"secnum\">10.10 </span> Frequently Asked Questions About Indexing Performance",
                            "href":"frequently-asked-questions-indexing-performance.html#GUID-82000645-74B9-407E-A9C0-C1ACEE319BD9"
                        },
                        {
                            "title":"<span class=\"secnum\">10.11 </span> Frequently Asked Questions About Updating the Index",
                            "href":"frequently-asked-questions-updating-index.html#GUID-45D2A9BB-17BC-4B68-A3F1-A0C01B4ACDA3"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Searching Document Sections in Oracle Text",
                    "href":"searching-document-sections-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> About Oracle Text Document Section Searching",
                            "href":"oracle-text-document-section-searching.html#GUID-C9161012-F942-46BD-A9D6-68CF554F3D6D"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> HTML Section Searching with Oracle Text",
                            "href":"html-section-searching-oracle-text.html#GUID-2F7B1652-42FB-4A0A-A37F-652DDCB82182"
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> XML Section Searching with Oracle Text",
                            "href":"xml-section-searching-oracle-text.html#GUID-8D535B14-B377-4766-A062-1DA912438E23"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Using Oracle Text Name Search",
                    "href":"using-oracle-text-name-search.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Overview of Name Search",
                            "href":"overview-name-search.html#GUID-D3E9CF36-BB4A-4C66-8E62-CD723A2399F4"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> Name Search Examples",
                            "href":"examples-using-name-search.html#GUID-41C7CABC-597C-499D-BD29-326A65A0B65A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Performing Ubiquitous Search with DBMS_SEARCH APIs",
                    "href":"performing-ubiquitous-search-dbms_search-apis.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> About Ubiquitous Search and Ubiquitous Search Indexes",
                            "href":"ubiquitous-search-and-ubiquitous-search-indexes.html#GUID-57225FA6-BC7A-4A41-B677-FF2817B06BBA"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> Perform Ubiquitous Search: End-to-End Examples",
                            "href":"perform-ubiquitous-search-end-end-examples.html",
                            "topics":[
                                {
                                    "title":"<span class=\"secnum\">13.2.1 </span> Create and Query DBMS_SEARCH Indexes Using Multiple Tables and Views",
                                    "href":"create-and-query-dbms_search-indexes-using-multiple-tables-and-views.html#GUID-088EB0DF-9233-4772-B8B4-639377C0518D"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2.2 </span> Use JSON Duality Views with DBMS_SEARCH Indexes",
                                    "href":"use-json-duality-views-dbms_search-indexes.html#GUID-994212D6-395F-4BB4-BB87-6B87A55443FB"
                                },
                                {
                                    "title":"<span class=\"secnum\">13.2.3 </span> Examine DBMS_SEARCH Indexes Using Dictionary Views",
                                    "href":"examine-dbms_search-indexes-using-dictionary-views.html#GUID-1BD1C0B1-2EB2-4074-B4D2-568BFC883590"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">14 </span> Working with a Thesaurus in Oracle Text",
                    "href":"working-thesaurus-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">14.1 </span> Overview of Oracle Text Thesaurus Features",
                            "href":"overview-oracle-text-thesaurus-features.html#GUID-977262E7-D52B-4E4C-AF59-0EB36446F975"
                        },
                        {
                            "title":"<span class=\"secnum\">14.2 </span> Defining Terms in a Thesaurus",
                            "href":"defining-terms-thesaurus.html#GUID-241A1449-F84B-4C47-97C0-376EA68DCC88"
                        },
                        {
                            "title":"<span class=\"secnum\">14.3 </span> Using a Thesaurus in a Query Application",
                            "href":"using-thesaurus-query-application.html#GUID-C17963C5-1201-4243-952A-91C0C9EE4B15"
                        },
                        {
                            "title":"<span class=\"secnum\">14.4 </span> Loading a Custom Thesaurus and Issuing Thesaurus-Based Queries",
                            "href":"loading-custom-thesaurus-and-issuing-thesaurus-based-queries.html#GUID-8251B968-DB73-4125-9A2E-E19F1FA03EDD"
                        },
                        {
                            "title":"<span class=\"secnum\">14.5 </span> Augmenting the Knowledge Base with a Custom Thesaurus",
                            "href":"augmenting-knowledge-base-custom-thesaurus.html#GUID-63336C63-95D9-45FB-8824-A166A44E1370"
                        },
                        {
                            "title":"<span class=\"secnum\">14.6 </span> Linking New Terms to Existing Terms",
                            "href":"linking-new-terms-existing-terms.html#GUID-45C350FA-B73A-468C-9727-E4EE8A40244D"
                        },
                        {
                            "title":"<span class=\"secnum\">14.7 </span> Example of Loading a Thesaurus with ctxload",
                            "href":"loading-thesaurus-ctxload.html#GUID-2AC136CB-E0D9-4DC9-B3DD-95D8CAEB1D3A"
                        },
                        {
                            "title":"<span class=\"secnum\">14.8 </span> Example of Loading a Thesaurus with the CTX_THES.IMPORT_THESAURUS PL/SQL procedure",
                            "href":"loading-thesaurus-pl-sql-procedure-ctx_thes-import_thesaurus.html#GUID-D9CB1033-F36E-480F-9A31-A1B26A9B9C76"
                        },
                        {
                            "title":"<span class=\"secnum\">14.9 </span> Compiling a Loaded Thesaurus",
                            "href":"compiling-loaded-thesaurus.html#GUID-7E518BD6-F58A-45CB-A311-FDA14093D7A3"
                        },
                        {
                            "title":"<span class=\"secnum\">14.10 </span> About the Supplied Knowledge Base",
                            "href":"supplied-knowledge-base.html#GUID-F35BEFA4-494B-4DD4-AD5E-836C5C1E29B5"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">15 </span> Using Faceted Navigation",
                    "href":"using-faceted-navigation.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">15.1 </span> About Faceted Navigation",
                            "href":"faceted-navigation.html#GUID-C9FFB438-2643-4F75-9B5B-1210632DBE51"
                        },
                        {
                            "title":"<span class=\"secnum\">15.2 </span> Defining Sections As Facets",
                            "href":"defining-sections-facets.html#GUID-9E0500AD-B0C2-4C6F-96EA-4C1FEFB6EC39"
                        },
                        {
                            "title":"<span class=\"secnum\">15.3 </span> Querying Facets by Using the Result Set Interface",
                            "href":"querying-facets-using-result-set-interface.html#GUID-AF478B58-15ED-4067-9E5C-D936002D7491"
                        },
                        {
                            "title":"<span class=\"secnum\">15.4 </span> Refining Queries by Using Facets As Filters",
                            "href":"refining-queries-using-facets-filters.html#GUID-189E71B5-6499-4E49-A2D1-A21482860172"
                        },
                        {
                            "title":"<span class=\"secnum\">15.5 </span> Multivalued Facets",
                            "href":"multivalued-facets.html#GUID-60EE2521-7ED4-45B2-9296-296EACB61792"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">16 </span> Using Result Set Interface",
                    "href":"using-result-set-interface.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">16.1 </span> Overview of the XML Query Result Set Interface",
                            "href":"overview-xml-query-result-set-interface.html#GUID-90801444-4F35-4884-8B50-95B8D85C63C1"
                        },
                        {
                            "title":"<span class=\"secnum\">16.2 </span> Using the XML Query Result Set Interface",
                            "href":"using-xml-query-result-set-interface1.html#GUID-49CDD0A1-17FD-460B-93AC-C8671BFAE9C4"
                        },
                        {
                            "title":"<span class=\"secnum\">16.3 </span> Creating XML-Only Applications with Oracle Text",
                            "href":"creating-xml-only-applications-oracle-text.html#GUID-234790B2-1812-4987-A656-5D5066B11907"
                        },
                        {
                            "title":"<span class=\"secnum\">16.4 </span> Example of a Result Set Descriptor",
                            "href":"example-result-set-descriptor.html#GUID-B41F2061-4914-4A73-A245-488C8A77F4C1"
                        },
                        {
                            "title":"<span class=\"secnum\">16.5 </span> Identifying Collocates",
                            "href":"identifying-collocates-using-oracle-text.html#GUID-0CC6DBA1-D068-46B5-887F-C7ECEC26F30C"
                        },
                        {
                            "title":"<span class=\"secnum\">16.6 </span> Overview of the JSON Result Set Interface",
                            "href":"overview-json-result-set-interface.html#GUID-6C78E088-F210-4855-A9AA-0BE1FB110119"
                        },
                        {
                            "title":"<span class=\"secnum\">16.7 </span> Using the JSON Result Set Interface",
                            "href":"using-json-result-set-interface.html#GUID-78D1D487-1E58-45C2-BEA9-66FF3661A071"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">17 </span> Performing Sentiment Analysis Using Oracle Text",
                    "href":"performing-sentiment-analysis-using-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">17.1 </span> Overview of Sentiment Analysis",
                            "href":"overview-sentiment-analysis.html#GUID-3E08A4C1-D50A-49FE-AEAE-50F487BFD935"
                        },
                        {
                            "title":"<span class=\"secnum\">17.2 </span> Creating a Sentiment Classifier Preference",
                            "href":"creating-sentiment-classifier-preference.html#GUID-28A9255E-38A0-422F-B97B-4D518DAA1B7C"
                        },
                        {
                            "title":"<span class=\"secnum\">17.3 </span> Training Sentiment Classifiers",
                            "href":"training-sentiment-classifiers.html#GUID-7F1B2D64-7F7F-436F-81D3-7C8D18E956BE"
                        },
                        {
                            "title":"<span class=\"secnum\">17.4 </span> Performing Sentiment Analysis with the CTX_DOC Package",
                            "href":"performing-sentiment-analysis-using-ctx_doc-package.html#GUID-B18361E3-7A3E-4AA7-B96E-80F99247986D"
                        },
                        {
                            "title":"<span class=\"secnum\">17.5 </span> Performing Sentiment Analysis with the RSI",
                            "href":"performing-sentiment-analysis-using-result-set-interface.html#GUID-0573BE5F-5D3D-41CB-B991-F209345B67E8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">18 </span> Working with Sharded Databases",
                    "href":"working-sharded-databases.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">18.1 </span> Running Oracle Text PL/SQL APIs in a Sharded Database",
                            "href":"running-oracle-text-pl-sql-apis-sharded-database.html#GUID-F6AEC6C1-12A3-46CF-B713-6F8CF852879D"
                        },
                        {
                            "title":"<span class=\"secnum\">18.2 </span> Supported APIs in a Sharded Database",
                            "href":"supported-apis-sharded-database.html#GUID-461355FE-8BC6-4DDE-B01B-DDF0723D19D2"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">19 </span> Administering Oracle Text",
                    "href":"administering-oracle-text.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">19.1 </span> Oracle Text Users and Roles",
                            "href":"oracle-text-users-and-roles.html#GUID-D32B5593-383D-42DC-86CA-DCCD57549B01"
                        },
                        {
                            "title":"<span class=\"secnum\">19.2 </span> DML Queue",
                            "href":"dml-queue.html#GUID-555E1A0F-ABE3-493A-9C1F-AC55C31417D7"
                        },
                        {
                            "title":"<span class=\"secnum\">19.3 </span> CTX_OUTPUT Package",
                            "href":"ctx_output-package.html#GUID-096E9A77-2BDC-4543-A689-9D574A05F199"
                        },
                        {
                            "title":"<span class=\"secnum\">19.4 </span> CTX_REPORT Package",
                            "href":"ctx_report-package.html#GUID-CAFF9517-E0FA-4097-81A2-D0367168B1AB"
                        },
                        {
                            "title":"<span class=\"secnum\">19.5 </span> Text Manager in Oracle Enterprise Manager",
                            "href":"text-manager-oracle-enterprise-manager.html#GUID-C8C62D18-695A-4F78-9126-90FBCD75BBB6"
                        },
                        {
                            "title":"<span class=\"secnum\">19.6 </span> Servers and Indexing",
                            "href":"servers-and-indexing.html#GUID-DEB5A161-B932-402A-AB24-D871722938B7"
                        },
                        {
                            "title":"<span class=\"secnum\">19.7 </span> Tracking Database Feature Usage in Oracle Enterprise Manager",
                            "href":"database-feature-usage-tracking-oracle-enterprise-manager.html#GUID-F403633C-6CC3-485A-B092-7463D6830123"
                        },
                        {
                            "title":"<span class=\"secnum\">19.8 </span> Oracle Text on Oracle Real Application Clusters",
                            "href":"oracle-text-oracle-real-application-clusters.html#GUID-5B691F84-D04E-4309-A2D9-0E7FDFCE56B5"
                        },
                        {
                            "title":"<span class=\"secnum\">19.9 </span> Configuring Oracle Text in Oracle Database Vault Environment",
                            "href":"configuring-oracle-text-oracle-database-vault-environment.html#GUID-AED02059-54CF-4498-9321-EFFA504CE5A6"
                        },
                        {
                            "title":"<span class=\"secnum\">19.10 </span> Unsupported Oracle Text Operations in Oracle Database Vault Realm",
                            "href":"unsupported-oracle-text-operations-oracle-database-vault-realm.html#GUID-B7F4E24B-5294-404F-AC8D-47FD55B33D63"
                        },
                        {
                            "title":"<span class=\"secnum\">19.11 </span> Export and Import of Schemas Containing Oracle Text Settings",
                            "href":"export-and-import-schemas-containing-oracle-text-settings.html#GUID-BF987BC5-B410-44A6-9810-E2CCB2DA7E5B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">20 </span> Migrating Oracle Text Applications",
                    "href":"migrating-oracle-text-applications.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">20.1 </span> Performing a Rolling Upgrade with a Logical Standby Database",
                            "href":"oracle-text-and-rolling-upgrade-logical-standby.html#GUID-1AE2D629-E0B1-49DB-96B3-2758B69E0219"
                        },
                        {
                            "title":"<span class=\"secnum\">20.2 </span> Identifying and Copying Oracle Text Files to a New Oracle Home",
                            "href":"identifying-and-copying-oracle-text-files-new-oracle-home.html#GUID-AB687163-AD3B-4AED-B1F3-342E1C980CC8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> CONTEXT Query Application",
                    "href":"CONTEXT-query-application.html#GUID-1F1B44E8-ACCA-446A-84EA-67FA692476BA",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">A.1 </span> Web Query Application Overview",
                            "href":"web-query-application-overview.html#GUID-D58C935C-301F-44F4-BF28-050B83EA2ACE"
                        },
                        {
                            "title":"<span class=\"secnum\">A.2 </span> The PL/SQL Server Pages (PSP) Web Application",
                            "href":"pl-sql-server-pages-psp-web-application.html#GUID-02600A05-F136-464F-A683-0504F6809388"
                        },
                        {
                            "title":"<span class=\"secnum\">A.3 </span> The Java Server Pages (JSP) Web Application",
                            "href":"java-server-pages-jsp-web-application.html#GUID-DEABF1DC-7C2E-436D-A83F-D036260B0B32"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> CATSEARCH Query Application",
                    "href":"CATSEARCH-query-application.html#GUID-72F18A97-92D7-411D-871A-27AD749D6141",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">B.1 </span> CATSEARCH Web Query Application Overview",
                            "href":"catsearch-web-query-application-overview.html#GUID-D7B36466-FD0E-49FB-9677-0342B6F9931C"
                        },
                        {
                            "title":"<span class=\"secnum\">B.2 </span> The JSP Web Application",
                            "href":"jsp-web-application.html#GUID-24D14B20-AA64-4192-AABB-98CEA4744B82"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> Custom Index Preference Examples",
                    "href":"custom-index-preference-examples.html#GUID-53BE8540-EBF3-4787-8A7D-86A6CF75BC39",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">C.1 </span> Datastore Examples",
                            "href":"datastore-examples.html#GUID-F488EE16-1E0A-445C-8424-499CE6317B2B"
                        },
                        {
                            "title":"<span class=\"secnum\">C.2 </span> NULL_FILTER Example: Indexing HTML Documents",
                            "href":"null_filter-example-indexing-html-documents.html#GUID-4C7C8277-BF9B-49CF-B394-20E131CC729B"
                        },
                        {
                            "title":"<span class=\"secnum\">C.3 </span> PROCEDURE_FILTER Example",
                            "href":"procedure_filter-example.html#GUID-8EFE1A5F-BAD2-45A9-AB6F-90379EBD97A9"
                        },
                        {
                            "title":"<span class=\"secnum\">C.4 </span> BASIC_LEXER Example: Setting Printjoin Characters",
                            "href":"basic_lexer-example-setting-printjoin-characters.html#GUID-F335465D-592B-4D74-8E58-1891600298B3"
                        },
                        {
                            "title":"<span class=\"secnum\">C.5 </span> MULTI_LEXER Example: Indexing a Multilanguage Table",
                            "href":"multi_lexer-example-indexing-multi-language-table.html#GUID-8680F1FC-0CCE-4E26-806A-08048896B5CE"
                        },
                        {
                            "title":"<span class=\"secnum\">C.6 </span> BASIC_WORDLIST Example: Enabling Substring and Prefix Indexing",
                            "href":"basic_wordlist-example-enabling-substring-and-prefix-indexing.html#GUID-6FDF4DA0-11A6-48B2-A1A7-2D08D0E81D2A"
                        },
                        {
                            "title":"<span class=\"secnum\">C.7 </span> BASIC_WORDLIST Example: Enabling Wildcard Index",
                            "href":"basic_wordlist-example-enabling-wildcard-index.html#GUID-67A2ACB4-FB50-4EEB-9DC0-58BDA85014BA"
                        }
                    ]
                }
            ]
        }
    ]
});