define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-69C6312A-43D6-4982-8C8E-611C3F9A91A5"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Oracle Grid Infrastructure Installation Checklist",
                    "href":"oracle-grid-infrastructure-installation-checklist.html#GUID-71A93E07-7E50-449C-B425-02F04A2EA8E6",
                    "topics":[
                        {
                            "title":"Server Hardware Checklist for Oracle Grid Infrastructure",
                            "href":"server-hardware-checklist-for-oracle-grid-infrastructure.html#GUID-D964EF96-9C9C-4173-A919-F3CAA72180B1"
                        },
                        {
                            "title":"Operating System Checklist for Oracle Grid Infrastructure and Oracle RAC",
                            "href":"operating-system-checklist-for-oracle-grid-infrastructure-and-oracle-rac.html#GUID-DB8F63FD-F4CA-4FBD-B54E-1C58AEF6F7D9"
                        },
                        {
                            "title":"Server Configuration Checklist for Oracle Grid Infrastructure",
                            "href":"server-configuration-checklist-for-oracle-grid-infrastructure.html#GUID-A7E9141D-1AFC-4CBF-846B-CD579FCFD9C0"
                        },
                        {
                            "title":"Network Checklist for Oracle Grid Infrastructure",
                            "href":"network-checklist-for-oracle-grid-infrastructure.html#GUID-B3B4F89A-7588-4F5A-80CF-BB84D9DF60D2"
                        },
                        {
                            "title":"User Environment Configuration Checklist for Oracle Grid Infrastructure",
                            "href":"user-environment-configuration-checklist-for-oracle-grid-infrastructure.html#GUID-664D1880-84C3-4DF7-BD34-53FB74180495"
                        },
                        {
                            "title":"Storage Checklist for Oracle Grid Infrastructure",
                            "href":"storage-checklist-for-oracle-grid-infrastructure.html#GUID-19C837B9-F64B-4594-9AD9-A5610289375D"
                        },
                        {
                            "title":"Cluster Deployment Checklist for Oracle Grid Infrastructure",
                            "href":"cluster-deployment-checklist.html#GUID-0C651B89-D62E-4A24-9229-152A8DD3908D"
                        },
                        {
                            "title":"Installer Planning Checklist for Oracle Grid Infrastructure",
                            "href":"installer-planning-checklist-for-oracle-grid-infrastructure.html#GUID-21A6CD8B-BA9F-444F-8C8D-C635CA7451E5"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Checking and Configuring Server Hardware for Oracle Grid Infrastructure",
                    "href":"checking-and-configuring-server-hardware-for-oracle-grid-infrastructure.html#GUID-8E15118D-A000-4B13-B7E0-ED1FAE6B120B",
                    "topics":[
                        {
                            "title":"Logging In to a Remote System Using X Window System",
                            "href":"logging-in-to-a-remote-system-using-x-window-system.html#GUID-6503D6FD-F784-4115-86D1-B9C78B3C1B92"
                        },
                        {
                            "title":"Checking Server Hardware and Memory Configuration",
                            "href":"checking-server-hardware-and-memory-configuration.html#GUID-DC04ABB6-1822-444A-AB1B-8C306079439C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Automatically Configuring Oracle Linux with Oracle AI Database Preinstallation RPM",
                    "href":"automatically-configuring-oracle-linux-with-oracle-preinstallation-rpm.html#GUID-22846194-58EF-4552-AAC3-6F6D0A1DF794",
                    "topics":[
                        {
                            "title":"About the Oracle AI Database Preinstallation RPM",
                            "href":"about-the-oracle-preinstallation-rpm.html#GUID-C15A642B-534D-4E4A-BDE8-6DC7772AA9C8"
                        },
                        {
                            "title":"Overview of Oracle Linux Configuration with Oracle AI Database Preinstallation RPM",
                            "href":"overview-of-oracle-linux-configuration-with-oracle-rpms.html#GUID-693599D4-BD32-4E6A-9689-FA7D1CD75653"
                        },
                        {
                            "title":"Installing the Oracle AI Database Preinstallation RPM Using ULN",
                            "href":"installing-the-oracle-preinstallation-rpm-with-uln-support.html#GUID-AF94713E-97AF-4F20-8DBC-36BC383D0301"
                        },
                        {
                            "title":"Installing Oracle AI Database Preinstallation RPM During an Oracle Linux Installation",
                            "href":"installing-a-new-oracle-linux-installation-from-dvds-or-images.html#GUID-A686DF5E-8F3D-4697-88F5-DFA4C2B7DB07"
                        },
                        {
                            "title":"Installing Oracle Oracle AI Database Preinstallation RPM Using the Oracle Linux yum Server",
                            "href":"installing-oracle-linux-with-public-yum-repository-support.html#GUID-190BAEE2-2B77-4AA2-AA6B-5D6AF73A4005"
                        },
                        {
                            "title":"Configure Additional Operating System Features",
                            "href":"configure-additional-operating-system-features.html#GUID-65F1AAB7-4624-43C8-BAB2-6FABF05F05BE"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Configuring Operating Systems for Oracle Grid Infrastructure on Linux",
                    "href":"configuring-operating-systems-for-oracle-grid-infrastructure-on-linux.html#GUID-B8649E42-4918-49EA-A608-446F864EB7A0",
                    "topics":[
                        {
                            "title":"Guidelines for Linux Operating System Installation",
                            "href":"guidelines-for-linux-operating-system-installation.html#GUID-11991892-6B97-4283-B042-E894BBF9B3BF",
                            "topics":[
                                {
                                    "title":"Completing a Minimal or Default Linux Installation",
                                    "href":"about-minimal-linux-installations.html#GUID-59C92547-8AB3-4334-8D82-1B797A29D199"
                                },
                                {
                                    "title":"About Oracle Linux with the Unbreakable Enterprise Kernel",
                                    "href":"about-oracle-linux-and-the-unbreakable-enterprise-kernel.html#GUID-EC62F856-B9AA-4BC5-BC81-B41A5C6A24F5"
                                },
                                {
                                    "title":"Configuring HugePages on Linux",
                                    "href":"configure-hugepages.html#GUID-19BFCC60-BA4C-4750-85EB-7432282A9556"
                                },
                                {
                                    "title":"Restrictions for HugePages and Transparent HugePages Configurations",
                                    "href":"restrictions-for-hugepages-and-transparent-hugepages-configurations.html#GUID-D8178896-D00F-4F02-82A7-A44F89D8F103"
                                }
                            ]
                        },
                        {
                            "title":"Reviewing Operating System and Software Upgrade Best Practices",
                            "href":"reviewing-operating-system-and-software-upgrade-best-practices.html#GUID-5E1F8A88-1AD8-4CF5-8EDC-A83DAB77C5C3",
                            "topics":[
                                {
                                    "title":"General Upgrade Best Practices",
                                    "href":"general-upgrade-best-practices.html#GUID-D8D171F1-B3B0-490D-8647-AB1493EE611A"
                                },
                                {
                                    "title":"New Server Operating System Upgrade Option",
                                    "href":"new-server-operating-system-upgrade-option.html#GUID-50906E76-AE1A-488B-B1F9-3FE7D736F7AB"
                                },
                                {
                                    "title":"Upgrading Operating System for an Oracle Grid Infrastructure Server",
                                    "href":"upgrading-os-on-oracle-grid-infrastructure-server.html#GUID-1C720BC5-583D-4943-A867-669941762FF1"
                                },
                                {
                                    "title":"Oracle ASM Upgrade Notifications",
                                    "href":"oracle-asm-upgrade-notifications.html#GUID-91594E29-B34A-4173-BAD5-14EF080202EF"
                                }
                            ]
                        },
                        {
                            "title":"Reviewing Operating System Security Common Practices",
                            "href":"reviewing-operating-system-security-common-practices.html#GUID-1EFB7388-75D9-4718-BFF2-69437B24B120"
                        },
                        {
                            "title":"About Installation Fixup Scripts",
                            "href":"about-installation-fixup-scripts.html#GUID-B427B3F7-BFE3-4ACF-89FD-A79A5774C7AA"
                        },
                        {
                            "title":"About Automatic Self Correction",
                            "href":"about-automatic-self-correction.html#GUID-81BF6A33-5003-4DAF-88C2-FFB89AB86141"
                        },
                        {
                            "title":"About Operating System Requirements",
                            "href":"about-operating-system-requirements.html#GUID-9758581C-6925-4A0E-B321-9E424575E7F2"
                        },
                        {
                            "title":"Operating System Requirements for x86-64 Linux Platforms",
                            "href":"operating-system-requirements-for-x86-64-linux-platforms.html#GUID-3F647617-7FF5-4EE4-BBA8-9A5E3EEC888F",
                            "topics":[
                                {
                                    "title":"General Guidelines for Operating System Packages",
                                    "href":"guidelines-for-os-packages.html#GUID-DC3C9BC6-2F5F-4EFA-AFD6-9D4F5FEFFB7D"
                                },
                                {
                                    "title":"Supported Oracle Linux 9 Distributions for x86-64",
                                    "href":"supported-oracle-linux-9-distributions-for-x86-64.html#GUID-C3D652E3-9593-4B4F-A63F-D20AB31C9EC8"
                                },
                                {
                                    "title":"Supported Oracle Linux 8 Distributions for x86-64",
                                    "href":"supported-oracle-linux-8-distributions-for-x86-64.html#GUID-F4902762-325B-4C89-B85B-F52BA482190F"
                                },
                                {
                                    "title":"Supported Red Hat Enterprise Linux 9 Distributions for x86-64",
                                    "href":"supported-red-hat-enterprise-linux-9-distributions-for-x86-64.html#GUID-088A9B4A-959F-47E1-8120-A00D464C9D13"
                                },
                                {
                                    "title":"Supported Red Hat Enterprise Linux 8 Distributions for x86-64",
                                    "href":"supported-red-hat-enterprise-linux-8-distributions-for-x86-64.html#GUID-B1487167-84F8-4F8D-AC31-A4E8F592374B"
                                },
                                {
                                    "title":"Supported SUSE Linux Enterprise Server 15 Distributions for x86-64",
                                    "href":"supported-suse-15-distributions-for-x86-64.html#GUID-58F12FC2-7F98-49F9-BDBB-A88AFD710B08"
                                },
                                {
                                    "title":"Installing Operating System Packages",
                                    "href":"installing-os-packages.html#GUID-1AE7031F-AABD-4049-87DC-99112C9D82EE"
                                }
                            ]
                        },
                        {
                            "title":"Additional Drivers and Software Packages for Linux",
                            "href":"additional-drivers-and-software-packages-for-linux.html#GUID-F09C1AE2-FEE2-42A6-BEEF-289251413841",
                            "topics":[
                                {
                                    "title":"Installing PAM for Login Authentication on Linux",
                                    "href":"installing-pam-for-login-authentication-on-linux.html#GUID-9C7ACF0E-44BB-4CBF-B426-E254E3A1EF82"
                                },
                                {
                                    "title":"Installing OCFS2",
                                    "href":"installing-ofcs2.html#GUID-D3BE83F2-3F7A-4D07-8BC5-127CA0C82550"
                                },
                                {
                                    "title":"Installation Requirements for ODBC and LDAP",
                                    "href":"installation-requirements-for-odbc-and-ldap.html#GUID-A87B2D38-6BCD-48F5-980B-B34CCEDE0545",
                                    "topics":[
                                        {
                                            "title":"About ODBC Drivers and Oracle AI Database",
                                            "href":"about-odbc-drivers-and-oracle-database.html#GUID-6A7E02AB-7DA5-4EF2-9A7C-94FF44570711"
                                        },
                                        {
                                            "title":"Installing ODBC Drivers for Linux x86-64",
                                            "href":"installing-odbc-drivers-for-linux-x86-64.html#GUID-494A764B-22A6-4DB4-AB45-AE4B467650D2"
                                        },
                                        {
                                            "title":"About LDAP and Oracle Plug-ins",
                                            "href":"about-ldap-and-oracle-plug-ins.html#GUID-01A4C3C8-7CDC-4CBC-A6B2-B7D2B19EF7E9"
                                        },
                                        {
                                            "title":"Installing the LDAP Package",
                                            "href":"installing-the-ldap-package.html#GUID-BEA80866-7BAD-4717-828B-C0DDB4C1CAEE"
                                        }
                                    ]
                                },
                                {
                                    "title":"Installing Oracle Messaging Gateway",
                                    "href":"installing-oracle-messaging-gateway.html#GUID-1891C1FC-E870-4EE7-9A94-17AB800741E0"
                                },
                                {
                                    "title":"Installation Requirements for Programming Environments for Linux",
                                    "href":"installation-requirements-for-programming-environments-for-linux.html#GUID-2E32042E-15FE-4951-BD71-5C040ED87944",
                                    "topics":[
                                        {
                                            "title":"Installation Requirements for Programming Environments for Linux x86-64",
                                            "href":"installation-requirements-for-programming-environments-for-linux-x86-64.html#GUID-BFD716A4-6235-49F6-8259-A534E2D96A8D"
                                        }
                                    ]
                                },
                                {
                                    "title":"Installation Requirements for Web Browsers",
                                    "href":"installation-requirements-for-web-browsers.html#GUID-28DE4328-8EC8-4462-AC70-95DC07766F4E"
                                }
                            ]
                        },
                        {
                            "title":"Checking Kernel and Package Requirements for Linux",
                            "href":"checking-kernel-and-package-requirements-for-linux.html#GUID-7065A86D-C2AB-4731-953B-12AC25C94156"
                        },
                        {
                            "title":"Setting Clock Source for VMs on Linux x86-64",
                            "href":"setting-clock-source-for-virtual-machine-on-linux.html#GUID-E55821AE-E001-4490-9545-DBAB652D896E"
                        },
                        {
                            "title":"Installing the cvuqdisk RPM for Linux",
                            "href":"installing-the-cvuqdisk-rpm-for-linux.html#GUID-8A74CA97-D2FA-4016-8B61-99D6CB52A40E"
                        },
                        {
                            "title":"Reviewing HugePages Memory Allocation",
                            "href":"reviewing-hugespages-memory-allocation.html#GUID-C042125D-9BE1-48D0-8C70-74251A0AF60C"
                        },
                        {
                            "title":"Setting Transparent HugePages to madvise",
                            "href":"disabling-transparent-hugepages.html#GUID-02E9147D-D565-4AF8-B12A-8E6E9F74BEEA"
                        },
                        {
                            "title":"Enabling the Name Service Cache Daemon",
                            "href":"enabling-the-name-service-cache-daemon.html#GUID-2578FE34-E846-4D0D-85AC-E2A191915578"
                        },
                        {
                            "title":"Verifying the Disk I/O Scheduler on Linux 8 and Later Systems",
                            "href":"setting-the-disk-io-scheduler-on-linux-8.html#GUID-AB706834-3DEB-4278-8872-96961C7379A8"
                        },
                        {
                            "title":"Using Automatic SSH Configuration During Installation",
                            "href":"using-automatic-ssh-configuration-during-installation.html#GUID-51280BE9-4B2A-4BE3-9DA3-68B795D9FBA2"
                        },
                        {
                            "title":"Setting Network Time Protocol for Cluster Time Synchronization",
                            "href":"setting-network-time-protocol-for-cluster-time-synchronization.html#GUID-441F7937-11CC-4C76-93EC-88DA51BE5EBA"
                        },
                        {
                            "title":"Verifying Digital Signature and Integrity of Installation Archive Files",
                            "href":"verify-signature.html#GUID-1AA115AE-56E1-421A-82C3-7FF0E56C5B73"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Configuring Networks for Oracle Grid Infrastructure and Oracle RAC",
                    "href":"configuring-networks-for-oracle-grid-infrastructure-and-oracle-rac.html#GUID-F1518C41-9D3C-45AB-9F6D-65896C1D09A0",
                    "topics":[
                        {
                            "title":"About Oracle Grid Infrastructure Network Configuration Options",
                            "href":"about-oracle-grid-infrastructure-network-configuration-options.html#GUID-70947D47-8F4A-43C6-8A0D-5D50161EF6C7"
                        },
                        {
                            "title":"Understanding Network Addresses",
                            "href":"understanding-network-addresses.html#GUID-8E81B3AA-B807-4BE0-90AB-925BAA332CF6",
                            "topics":[
                                {
                                    "title":"About the Public IP Address",
                                    "href":"about-the-public-address.html#GUID-43ABDAD1-9A73-43B1-8999-02AF2B9CC925"
                                },
                                {
                                    "title":"About the Private IP Address",
                                    "href":"about-the-private-ip-address.html#GUID-39513396-6974-4CEE-BC62-467E9D2ECD4B"
                                },
                                {
                                    "title":"About the Virtual IP Address",
                                    "href":"about-virtual-ip-address.html#GUID-68278D03-E1EA-4F08-8206-BCBD7C323DAE"
                                },
                                {
                                    "title":"About the Grid Naming Service (GNS) Virtual IP Address",
                                    "href":"about-grid-naming-service-virtual-ip-address.html#GUID-A4EE0CC6-A5F1-4507-82D6-D5C43E0F1584"
                                },
                                {
                                    "title":"About the SCAN",
                                    "href":"about-the-scan.html#GUID-87529AE0-046C-4F52-A4C5-B69369CC04EA"
                                },
                                {
                                    "title":"About Shared SCAN",
                                    "href":"about-shared-scan.html#GUID-A2BD8386-C245-4268-A4E6-664EDAC5B4FD"
                                }
                            ]
                        },
                        {
                            "title":"Network Interface Hardware Minimum Requirements",
                            "href":"network-interface-hardware-minimum-requirements.html#GUID-AB40D8C9-153E-4E9E-A7F6-701D6009048F"
                        },
                        {
                            "title":"Private IP Interface Configuration Requirements",
                            "href":"private-ip-interface-configuration-requirements.html#GUID-F74C2164-16E0-4CFA-9B0E-CAC14B176249"
                        },
                        {
                            "title":"IPv4 and IPv6 Protocol Requirements",
                            "href":"ipv4-and-ipv6-protocol-requirements.html#GUID-F0786BE3-D3D1-4B77-90DB-9B10167E6FAA"
                        },
                        {
                            "title":"Oracle Grid Infrastructure IP Name and Address Requirements",
                            "href":"oracle-grid-infrastructure-ip-name-and-address-requirements.html#GUID-B2067229-E8F6-49E0-97D4-C9482479BB65",
                            "topics":[
                                {
                                    "title":"About Oracle Grid Infrastructure Name Resolution Options",
                                    "href":"about-oracle-grid-infrastructure-name-resolution-options.html#GUID-08C31403-6E91-49C7-AB5A-A0C6A6B2A986"
                                },
                                {
                                    "title":"Cluster Name and SCAN Requirements",
                                    "href":"cluster-name-and-scan-requirements.html#GUID-4045D63F-0CBF-49A1-8405-3D745122AAA3"
                                },
                                {
                                    "title":"IP Name and Address Requirements For Grid Naming Service (GNS)",
                                    "href":"ip-name-and-address-requirements-for-grid-naming-service-gns.html#GUID-B3769D0B-E0AB-4AF8-B1C5-AFC6DF93F3B0"
                                },
                                {
                                    "title":"IP Name and Address Requirements for Manual Configuration of Cluster",
                                    "href":"ip-name-and-address-requirements-for-manual-configuration-of-cluster.html#GUID-C7CE80F9-BDE0-42A6-8398-3479501F0E95"
                                },
                                {
                                    "title":"Confirming the DNS Configuration for SCAN",
                                    "href":"confirming-the-dns-configuration-for-scan.html#GUID-C3996E82-9FE3-488F-A191-680E6454B73B"
                                }
                            ]
                        },
                        {
                            "title":"Broadcast Requirements for Networks Used by Oracle Grid Infrastructure",
                            "href":"broadcast-requirements-for-networks-used-by-oracle-grid-infrastructure.html#GUID-4BC37EAD-FFFB-4CD9-9C94-030CD4443FFA"
                        },
                        {
                            "title":"Multicast Requirements for Networks Used by Oracle Grid Infrastructure",
                            "href":"multicast-requirements-for-networks-used-by-oracle-grid-infrastructure.html#GUID-09DA3502-5880-4E72-88C0-CBE8E4893DF7"
                        },
                        {
                            "title":"Domain Delegation to Grid Naming Service",
                            "href":"domain-delegation-to-grid-naming-service.html#GUID-72E376ED-2B12-4449-8AE0-2747707052A4",
                            "topics":[
                                {
                                    "title":"Choosing a Subdomain Name for Use with Grid Naming Service",
                                    "href":"choosing-a-subdomain-name-for-use-with-grid-naming-service.html#GUID-96AB5A9E-C54B-4996-B386-9E78AEC847EE"
                                }
                            ]
                        },
                        {
                            "title":"Configuration Requirements for Oracle Flex Clusters",
                            "href":"configuration-requirements-for-oracle-flex-clusters.html#GUID-C04702A6-C7B9-440F-A8BC-30404DC3A9FB",
                            "topics":[
                                {
                                    "title":"Understanding Oracle Flex Clusters",
                                    "href":"understanding-oracle-flex-cluster-and-oracle-asm-flex-clusters.html#GUID-26BBAAB0-765B-40D2-B59C-642AE69A64DF"
                                },
                                {
                                    "title":"About Oracle Flex ASM Clusters Networks",
                                    "href":"about-oracle-flex-asm-clusters-networks.html#GUID-89E22376-9140-4F03-AD29-13429A5D5D63"
                                },
                                {
                                    "title":"General Requirements for Oracle Flex Cluster Configuration",
                                    "href":"general-requirements-for-oracle-flex-cluster-configuration.html#GUID-53433196-1EEF-4618-BE97-593D749B217B"
                                },
                                {
                                    "title":"Oracle Flex Cluster DHCP-Assigned Virtual IP (VIP) Addresses",
                                    "href":"oracle-flex-cluster-dhcp-assigned-virtual-ip-vip-addresses.html#GUID-55466D14-2E11-4293-9810-4081A5046B54"
                                },
                                {
                                    "title":"Oracle Flex Cluster Manually-Assigned Addresses",
                                    "href":"oracle-flex-cluster-manually-assigned-addresses.html#GUID-193F6070-2350-4CBD-8FC5-0C7E9CC85FCA"
                                }
                            ]
                        },
                        {
                            "title":"Grid Naming Service Cluster Configuration Example",
                            "href":"grid-naming-service-cluster-configuration-example.html#GUID-26F96D11-2B5E-4AD6-9127-BABEBC7E8C64"
                        },
                        {
                            "title":"Manual IP Address Configuration Example",
                            "href":"manual-ip-address-configuration-example.html#GUID-2B3803C2-DACF-4689-BA0A-7620EAF75989"
                        },
                        {
                            "title":"Network Interface Configuration Options",
                            "href":"network-interface-configuration-options.html#GUID-92E0BA24-7880-40F6-8CA5-D1B6834F865A"
                        },
                        {
                            "title":"Multiple Private Interconnects and Oracle Linux",
                            "href":"multiple-private-interconnects-and-oracle-linux.html#GUID-B9508AD5-AFD6-4D34-9DA9-773D44FD43A0"
                        },
                        {
                            "title":"Creating SCAN Client Data File",
                            "href":"creating-scan-client-data-file.html#GUID-70A5F895-A9CF-485A-8A90-C15AB8EE59A3"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Configuring Users, Groups and Environments for Oracle Grid Infrastructure and Oracle AI Database",
                    "href":"configuring-users-groups-and-environments-for-oracle-grid-infrastructure-and-oracle-database.html#GUID-524B84D2-A789-4416-98C4-55A7238CE94E",
                    "topics":[
                        {
                            "title":"Creating Groups, Users and Paths for Oracle Grid Infrastructure",
                            "href":"creating-users-groups-paths-for-grid-infrastructure.html#GUID-3D41DE23-ED6B-4AF1-BC7F-4EFA1D25E86C",
                            "topics":[
                                {
                                    "title":"Determining If an Oracle Inventory and Oracle Inventory Group Exist",
                                    "href":"determining-if-an-oracle-inventory-and-oracle-inventory-group-exist.html#GUID-63920FC2-410E-437D-8897-FB40AD828AD4"
                                },
                                {
                                    "title":"Creating the Oracle Inventory Group If an Oracle Inventory Does Not Exist",
                                    "href":"creating-the-oracle-inventory-group-if-an-oracle-inventory-does-not-exist.html#GUID-66E269E0-203B-4429-968C-5F22242D1FBB"
                                },
                                {
                                    "title":"About Oracle Installation Owner Accounts",
                                    "href":"about-oracle-installation-owner-accounts.html#GUID-39A48A63-E41F-4034-8C54-08D8E11A4F4C"
                                },
                                {
                                    "title":"Restrictions for Oracle Software Installation Owners",
                                    "href":"restrictions-for-oracle-software-installation-owners.html#GUID-D848D711-FF45-45F6-BCAB-4F648BA2705F"
                                },
                                {
                                    "title":"Identifying an Oracle Software Owner User Account",
                                    "href":"identifying-an-oracle-software-owner-user-account.html#GUID-0A95F4B1-1045-455D-9897-A23012E4E27F"
                                },
                                {
                                    "title":"About the Oracle Base Directory for the grid User",
                                    "href":"about-the-oracle-base-directory-for-the-grid-user.html#GUID-A36535B4-EB3C-44C9-A973-8BAFCAA2F2D6"
                                },
                                {
                                    "title":"About the Oracle Home Directory for Oracle Grid Infrastructure Software",
                                    "href":"about-the-oracle-home-directory-for-oracle-grid-infrastructure.html#GUID-C07AF84D-F2E4-41F0-9205-64BAA61C0111"
                                },
                                {
                                    "title":"About Creating the Oracle Home and Oracle Base Directory",
                                    "href":"about-creating-oracle-base-oracle-home-directories.html#GUID-E704B28B-8925-441F-88B8-0B70485AD6B6"
                                }
                            ]
                        },
                        {
                            "title":"Oracle Installations with Standard and Job Role Separation Groups and Users",
                            "href":"oracle-installations-with-standard-and-job-role-separation-groups-and-users.html#GUID-67A7AC8E-1736-4D53-A529-EB96FCDBA516",
                            "topics":[
                                {
                                    "title":"About Oracle Installations with Job Role Separation",
                                    "href":"about-oracle-installations-with-job-role-separation.html#GUID-E5EA50C5-8187-4B63-ACF2-88EBF414AF08"
                                },
                                {
                                    "title":"Standard Oracle AI Database Groups for Database Administrators",
                                    "href":"standard-oracle-database-groups-for-database-administrators.html#GUID-0A789F28-169A-43D6-9E48-AAE20D7B0C44"
                                },
                                {
                                    "title":"Extended Oracle AI Database Groups for Job Role Separation",
                                    "href":"extended-oracle-database-groups-for-job-role-separation.html#GUID-4F9A7AE7-BB13-4D87-A372-22CE5CE4DE60"
                                },
                                {
                                    "title":"Creating an ASMSNMP User",
                                    "href":"creating-an-asmsnmp-user.html#GUID-B4374E0A-D10D-4223-B8C9-4E7C063728F8"
                                },
                                {
                                    "title":"Oracle Automatic Storage Management Groups for Job Role Separation",
                                    "href":"oracle-automatic-storage-management-groups-for-job-role-separation.html#GUID-FBCCD803-1675-4D4B-90E5-7D1085D57576"
                                }
                            ]
                        },
                        {
                            "title":"Creating Operating System Privileges Groups",
                            "href":"creating-operating-system-privileges-groups.html#GUID-164A7218-166D-4B58-9A86-88149E8FCB83",
                            "topics":[
                                {
                                    "title":"Creating the OSASM Group",
                                    "href":"creating-the-osasm-group.html#GUID-B4857E6B-C760-4899-B699-BF66350BE0F7"
                                },
                                {
                                    "title":"Creating the OSDBA for ASM Group",
                                    "href":"creating-the-osdba-for-asm-group.html#GUID-4BF9EC56-CC88-47F6-949E-03602076E2CD"
                                },
                                {
                                    "title":"Creating the OSOPER for ASM Group",
                                    "href":"creating-the-osoper-for-asm-group.html#GUID-7B731763-8960-4EDD-B6FE-5AE61633282F"
                                },
                                {
                                    "title":"Creating the OSDBA Group for Database Installations",
                                    "href":"creating-the-osdba-group-for-database-installations.html#GUID-F1A111BE-9DC8-4E61-9713-8D41D97984FA"
                                },
                                {
                                    "title":"Creating an OSOPER Group for Database Installations",
                                    "href":"creating-an-osoper-group-for-database-installations.html#GUID-92D641D8-496F-4176-B268-12B59E1E726A"
                                },
                                {
                                    "title":"Creating the OSBACKUPDBA Group for Database Installations",
                                    "href":"creating-the-osbackupdba-group-for-database-installations.html#GUID-427709CA-F169-4357-9992-75A19826DDAF"
                                },
                                {
                                    "title":"Creating the OSDGDBA Group for Database Installations",
                                    "href":"creating-the-osdgdba-group-for-database-installations.html#GUID-D27ADF83-7A9B-4CCE-A07C-C35C84778AEE"
                                },
                                {
                                    "title":"Creating the OSKMDBA Group for Database Installations",
                                    "href":"creating-the-oskmdba-group-for-database-installations.html#GUID-62FC41B0-0CCE-4788-9BBC-2131258ED59F"
                                },
                                {
                                    "title":"Creating the OSRACDBA Group for Database Installations",
                                    "href":"creating-the-racdba-group-for-database-installations.html#GUID-3A3C9191-4187-41D4-98C4-400746023F6B"
                                }
                            ]
                        },
                        {
                            "title":"Creating Operating System Oracle Installation User Accounts",
                            "href":"creating-operating-system-oracle-installation-user-accounts.html#GUID-4DA71FFA-AB5B-49AA-B21D-92C952C8A3FC",
                            "topics":[
                                {
                                    "title":"Creating an Oracle Software Owner User",
                                    "href":"creating-an-oracle-software-owner-user.html#GUID-C1E5CEA8-741A-4500-B03E-B4A6BC1E87BB"
                                },
                                {
                                    "title":"Modifying Oracle Owner User Groups",
                                    "href":"modifying-oracle-owner-user-groups.html#GUID-2DD4A4F8-4A87-4188-BA08-35095373FA72"
                                },
                                {
                                    "title":"Identifying Existing User and Group IDs",
                                    "href":"identifying-existing-user-ids-group-ids.html#GUID-8AA197E4-8699-4B12-B843-1C3363E75DE8"
                                },
                                {
                                    "title":"Creating Identical Database Users and Groups on Other Cluster Nodes",
                                    "href":"creating-users-groups-on-other-cluster-nodes.html#GUID-3F1C9069-66F6-4C60-B162-24BA1116F683"
                                },
                                {
                                    "title":"Example of Creating Minimal Groups, Users, and Paths",
                                    "href":"example-of-creating-minimal-users-roles-groups.html#GUID-103186A1-74E0-42A8-AC3D-15AF833DCB40"
                                },
                                {
                                    "title":"Example of Creating Role-allocated Groups, Users, and Paths",
                                    "href":"example-of-creating-role-allocated-groups-users-paths.html#GUID-A4DAFF84-F691-474C-AE60-F1694DDBB509"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Grid Infrastructure Software Owner User Environments",
                            "href":"configuring-software-users-environments.html#GUID-291669F1-2269-4842-AB77-1801A4A40ACD",
                            "topics":[
                                {
                                    "title":"Environment Requirements for Oracle Software Owners",
                                    "href":"environment-requirements-for-oracle-software-owners.html#GUID-074B2A02-8079-4459-A05A-F4B77AE25915"
                                },
                                {
                                    "title":"Procedure for Configuring Oracle Software Owner Environments",
                                    "href":"procedure-for-configuring-oracle-software-owner-environments.html#GUID-9390F139-EA37-4C57-BF1F-E1991ACE528E"
                                },
                                {
                                    "title":"Checking Resource Limits for Oracle Software Installation Users",
                                    "href":"checking-resource-limits-for-oracle-software-installation-users.html#GUID-293874BD-8069-470F-BEBF-A77C06618D5A"
                                },
                                {
                                    "title":"Setting Remote Display and X11 Forwarding Configuration",
                                    "href":"setting-remote-display-and-x11-forwarding-configuration.html#GUID-D524603D-F3F9-4BDA-A374-CAC20EA6D5C6"
                                },
                                {
                                    "title":"Preventing Installation Errors Caused by Terminal Output Commands",
                                    "href":"preventing-installation-errors-caused-by-terminal-output-commands.html#GUID-D394E4D3-E08E-4694-BE81-1D47FE539F4B"
                                }
                            ]
                        },
                        {
                            "title":"Enabling Intelligent Platform Management Interface (IPMI)",
                            "href":"enabling-intelligent-platform-management-interface-ipmi.html#GUID-96249852-936C-480C-A166-6926A654F014",
                            "topics":[
                                {
                                    "title":"Requirements for Enabling IPMI",
                                    "href":"requirements-for-enabling-ipmi.html#GUID-B3EFBDD9-C5FF-4158-8375-F568EF4F4CB6"
                                },
                                {
                                    "title":"Configuring the IPMI Management Network",
                                    "href":"configuring-the-ipmi-management-network.html#GUID-27A5A4A4-B97D-40D3-9956-1B771420A164"
                                },
                                {
                                    "title":"Configuring the Open IPMI Driver",
                                    "href":"configuring-the-open-ipmi-driver.html#GUID-BD943D46-0AAA-44E2-AD07-0651526DB13B"
                                },
                                {
                                    "title":"Configuring the BMC",
                                    "href":"configuring-the-bmc.html#GUID-51DD98FB-33FB-4918-80FF-2EF85A2BA6F1"
                                },
                                {
                                    "title":"Configuring BMC Using IPMItool",
                                    "href":"example-of-bmc-configuration-using-ipmitool.html#GUID-E3EBB12A-BDB5-4BD0-884D-20DE501D81DC"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Supported Storage Options for Oracle AI Database and Oracle Grid Infrastructure",
                    "href":"supported-storage-options-for-oracle-database-and-oracle-grid-infrastructure.html#GUID-D5A3B718-FB00-420F-BE8B-FA111B1482E6",
                    "topics":[
                        {
                            "title":"Supported Storage Options for Oracle Grid Infrastructure",
                            "href":"supported-storage-options-for-oracle-grid-infrastructure.html#GUID-1022FFAD-7441-44BB-807D-C87B2DBCD015"
                        },
                        {
                            "title":"Oracle ACFS and Oracle ADVM",
                            "href":"oracle-acfs-and-oracle-advm.html#GUID-63DAB520-38DD-4D62-A241-433270FE8755",
                            "topics":[
                                {
                                    "title":"Oracle ACFS and Oracle ADVM Support on Linux x86–64",
                                    "href":"oracle-acfs-and-oracle-advm-support-on-linux.html#GUID-4290DF00-C4DB-40AE-85D3-97C4F29994A6"
                                },
                                {
                                    "title":"Restrictions and Guidelines for Oracle ACFS",
                                    "href":"restrictions-and-guidelines-for-oracle-acfs.html#GUID-C16763D5-F309-488A-8281-1E062242822A"
                                }
                            ]
                        },
                        {
                            "title":"Storage Considerations for Oracle Grid Infrastructure and Oracle RAC",
                            "href":"storage-considerations-for-oracle-grid-infrastructure-and-oracle-rac.html#GUID-02B594C9-9D80-4E17-B4F6-30F40D9D38E4"
                        },
                        {
                            "title":"Guidelines for Using Oracle ASM Disk Groups for Storage",
                            "href":"guidelines-for-using-oracle-asm-disk-groups-for-storage.html#GUID-AE229093-A315-4AE7-AD10-CB21BE5B253F"
                        },
                        {
                            "title":"Guidelines for Configuring Oracle ASM Disk Groups on NFS",
                            "href":"guidelines-for-using-oracle-asm-with-nfs-filesystems.html#GUID-5739AFA8-37B1-43C0-B337-58B2FDE2D09F"
                        },
                        {
                            "title":"Using Logical Volume Managers with Oracle Grid Infrastructure and Oracle RAC",
                            "href":"using-logical-volume-managers-with-oracle-grid-infrastructure-and-oracle-rac.html#GUID-C366E337-4A90-42FC-AFD9-26638CF4E540"
                        },
                        {
                            "title":"Using a Cluster File System for Oracle Clusterware Files",
                            "href":"using-a-cluster-file-system-for-oracle-clusterware-files.html#GUID-B91CAB65-2B3D-440C-A5A4-87E38FBE93EF"
                        },
                        {
                            "title":"About NFS Storage for Data Files",
                            "href":"about-nfs-storage-for-data-files.html#GUID-CF1F1C17-0548-4DE5-A5BD-7E3752ECF101"
                        },
                        {
                            "title":"About Direct NFS Client Mounts to NFS Storage Devices",
                            "href":"about-direct-nfs-client-mounts-to-nfs-storage-devices.html#GUID-31591084-74BD-4B66-8C5B-68BF0FEE8750"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Configuring Storage for Oracle Grid Infrastructure",
                    "href":"configuring-storage-for-oracle-grid-infrastructure-for-a-cluster.html#GUID-B1F7D6D9-C3FC-4EB1-B50D-3FDA8537C8B1",
                    "topics":[
                        {
                            "title":"Configuring Storage for Oracle Automatic Storage Management",
                            "href":"configuring-storage-for-oracle-automatic-storage-management.html#GUID-CBDF7400-9A35-4548-A3F2-52BA6871F130",
                            "topics":[
                                {
                                    "title":"Identifying Storage Requirements for Oracle Automatic Storage Management",
                                    "href":"identifying-storage-requirements-for-oracle-automatic-storage-management.html#GUID-82B9A93B-185F-4DE8-8D90-606192004EAD"
                                },
                                {
                                    "title":"Oracle Clusterware Storage Space Requirements",
                                    "href":"oracle-clusterware-storage-space-requirements.html#GUID-97FD5D40-A65B-4575-AD12-06C491AF3F41"
                                },
                                {
                                    "title":"Using an Existing Oracle ASM Disk Group",
                                    "href":"using-an-existing-oracle-asm-disk-group.html#GUID-6921527A-0919-4DE8-BF88-FA343B7B2B31"
                                },
                                {
                                    "title":"About Upgrading Existing Oracle Automatic Storage Management Instances",
                                    "href":"upgrading-existing-asm-instances.html#GUID-CC22577F-EB20-48CB-84EF-9B72C94AB31E"
                                },
                                {
                                    "title":"Selecting Disks to use with Oracle ASM Disk Groups",
                                    "href":"selecting-disks-to-use-with-oracle-asm.html#GUID-1DBFD7CF-57CF-4ED1-AEDD-9A4053B04E9F"
                                },
                                {
                                    "title":"Specifying the Oracle ASM Disk Discovery String",
                                    "href":"specifying-the-oracle-asm-disk-discovery-string.html#GUID-573F1774-C532-4ADD-87DC-45892A07152D"
                                },
                                {
                                    "title":"Creating Files on a NAS Device for Use with Oracle Automatic Storage Management",
                                    "href":"creating-files-on-a-nas-device-for-use-with-oracle-automatic-storage-management.html#GUID-D1F279EF-2D7D-4F70-9AC3-3078FF6E5649"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Storage Device Path Persistence Using Oracle ASMLIB",
                            "href":"configuring-storage-device-path-persistence-using-oracle-asmlib.html#GUID-BBD347D1-17D2-422A-879F-07FD189A4A2D",
                            "topics":[
                                {
                                    "title":"About Oracle ASM with Oracle ASMLIB",
                                    "href":"about-oracle-asm-with-oracle-asmlib.html#GUID-2DC2078C-9A79-4876-8BD4-3B56FF3FB7C9"
                                },
                                {
                                    "title":"Installing and Configuring Oracle ASMLIB Software",
                                    "href":"installing-and-configuring-oracle-asmlib-software.html#GUID-6C3F9E52-4E28-4912-B3A0-4E52570778C7"
                                },
                                {
                                    "title":"Deinstalling Oracle ASMLIB On Oracle Grid Infrastructure",
                                    "href":"deinstalling-oracle-asmlib-on-oracle-grid-infrastructure.html#GUID-AAC3291D-BEAF-4567-A0A0-CA834C1A73EA"
                                }
                            ]
                        },
                        {
                            "title":"Migrating from Oracle ASM Filter Driver to Oracle ASMLib",
                            "href":"migrating-from-asmfd-to-asmlib.html#GUID-61A10CF1-637D-45E6-B799-5BAFF11AD348"
                        },
                        {
                            "title":"Deconfiguring Oracle ASM Filter Driver",
                            "href":"deconfiguring-oracle-asmfd.html#GUID-4F366BFC-5435-4D92-AE65-B62F0AA04D60"
                        },
                        {
                            "title":"Configuring NVMe Over Fabrics Storage Devices with Oracle ASM",
                            "href":"configure-nvme-with-asm.html#GUID-FD2EC9F8-49EC-406C-B201-C43D177946BF",
                            "topics":[
                                {
                                    "title":"About Using NVMe Over Fabrics Devices for Data Files",
                                    "href":"about-nvme-devices-for-data-files.html#GUID-13A5516C-C0BA-41B3-9EEE-D1E67EC370E6"
                                },
                                {
                                    "title":"Requirements and Guidelines for NVMe Over Fabrics Storage",
                                    "href":"requirements-for-nvme-storage.html#GUID-4A010886-161C-4F69-B858-3CEC0C4BE891"
                                },
                                {
                                    "title":"Creating an NVMe-oF Storage Target",
                                    "href":"creating-nvme-storage-target.html#GUID-D4CB8CEC-FE2A-4543-A4E4-D8D2C145A04E"
                                },
                                {
                                    "title":"Creating an NVMe Configuration File and Using NVMe-oF Devices",
                                    "href":"creating-nvme-config-file.html#GUID-404B9885-0C58-4DEA-9B74-2D779F609726"
                                }
                            ]
                        },
                        {
                            "title":"Using Disk Groups with Oracle AI Database Files on Oracle ASM",
                            "href":"using-diskgroups-with-oracle-database-file-on-oracle-asm.html#GUID-8D929971-C1EF-4961-A317-00F067AD020D",
                            "topics":[
                                {
                                    "title":"Identifying and Using Existing Oracle AI Database Disk Groups on Oracle ASM",
                                    "href":"identifying-and-using-existing-oracle-database-disk-groups-on-oracle-asm.html#GUID-B2D27C0D-B07E-43AD-9A4A-95F9687E7B6D"
                                },
                                {
                                    "title":"Guidelines for Creating Disk Groups for Oracle AI Database Data Files",
                                    "href":"creating-disk-groups-for-oracle-database-data-files.html#GUID-30EE4E69-1B7A-4E04-A3F8-A33CBA328DC3"
                                },
                                {
                                    "title":"Creating Directories for Oracle AI Database Files",
                                    "href":"creating-directories-for-oracle-database-files.html#GUID-BAA48B85-7B6D-4482-B2CB-CE3CFC82ABBD"
                                }
                            ]
                        },
                        {
                            "title":"Configuring File System Storage for Oracle AI Database",
                            "href":"configuring-file-system-storage-for-oracle-grid-infrastructure.html#GUID-70594502-E92B-4F6F-A1A7-3EF57AB74A85",
                            "topics":[
                                {
                                    "title":"Configuring NFS Buffer Size Parameters for Oracle AI Database",
                                    "href":"configuring-nfs-buffer-size-parameters-for-oracle-database.html#GUID-5F14F816-445B-4EBB-BBA2-E9DFD7E5EF96"
                                },
                                {
                                    "title":"Checking TCP Network Protocol Buffer for Direct NFS Client",
                                    "href":"checking-tcp-network-protocol-buffer-for-direct-nfs-client.html#GUID-EEE6EF7D-2532-486E-B1D8-192F6E877492"
                                },
                                {
                                    "title":"Creating an oranfstab File for Direct NFS Client",
                                    "href":"creating-an-oranfstab-file-for-direct-nfs-client.html#GUID-C16A1AF8-CCC5-46C2-875E-4276C2CCCF22"
                                },
                                {
                                    "title":"Enabling and Disabling Direct NFS Client Control of NFS",
                                    "href":"enabling-and-disabling-direct-nfs-client-control-of-nfs.html#GUID-ECFA9545-58A3-45D3-893F-3DDA381FCDBA"
                                },
                                {
                                    "title":"Enabling Hybrid Columnar Compression on Direct NFS Client",
                                    "href":"enabling-hcc-on-direct-nfs-client.html#GUID-6F8D47F3-D4E1-4022-9DE5-6D054D93B02A"
                                }
                            ]
                        },
                        {
                            "title":"Creating Oracle ASM Client Data File",
                            "href":"creating-oracle-asm-client-data-file.html#GUID-11036F6E-C8DE-4DFA-AB2F-9A916725E84E"
                        },
                        {
                            "title":"Configuring Oracle Advanced Cluster File System",
                            "href":"configuring-oracle-automatic-storage-management-cluster-file-system.html#GUID-70FD3C8B-E4BD-4D58-A095-FDD44013262B"
                        },
                        {
                            "title":"Checking OCFS2 Version Manually",
                            "href":"checking-ocfs2-version-manually.html#GUID-780D15C7-804F-48E8-BC4E-AE6B53BEA92F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Installing Oracle Grid Infrastructure",
                    "href":"installing-oracle-grid-infrastructure.html#GUID-D4E3FADF-360E-49EB-89A2-E4CBBB9CC61F",
                    "topics":[
                        {
                            "title":"About Image-Based Oracle Grid Infrastructure Installation",
                            "href":"about-image-based-oracle-grid-infastructure-installation.html#GUID-D991F940-7626-4615-908D-231D79740A5F"
                        },
                        {
                            "title":"Setup Wizard Installation Options for Creating Images",
                            "href":"setup-wizard-installation-options.html#GUID-30C45B5F-58A3-4D4C-8475-40093C51650B"
                        },
                        {
                            "title":"Downloading the Software from Oracle Software Delivery Cloud Portal",
                            "href":"downloading-software-from-oracle-software-delivery-cloud.html#GUID-34A70DC4-170F-41CD-8C7A-F4EE75B0EDAB"
                        },
                        {
                            "title":"Understanding Cluster Configuration Options",
                            "href":"understanding-cluster-configuration-options.html#GUID-4D6C2B52-9845-48E2-AD68-F0586AA20F48",
                            "topics":[
                                {
                                    "title":"About Oracle Grid Infrastructure to Manage Oracle RAC Databases",
                                    "href":"about-oracle-standalone-clusters.html#GUID-12E32722-A6F1-49A0-BA14-A40CF1736CC2"
                                },
                                {
                                    "title":"About Oracle Grid Infrastructure to Manage Generic Applications",
                                    "href":"about-grid-to-manage-generic-applications.html#GUID-AA2019EA-5EE0-419E-B08A-F5DBC027735D"
                                },
                                {
                                    "title":"About Oracle Extended Clusters",
                                    "href":"about-oracle-extended-clusters.html#GUID-C12A6024-A46D-48F5-A443-E08C28AFC716"
                                }
                            ]
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure for a New Cluster",
                            "href":"installing-oracle-grid-infrastructure-for-new-cluster.html#GUID-AB816BA7-EDC0-4D23-B24F-436B502F73A1",
                            "topics":[
                                {
                                    "title":"About Oracle Grid Infrastructure Installation",
                                    "href":"about-oracle-grid-infrastructure-installation.html#GUID-4E9260F0-E054-416A-9DF1-31E7FCF6CCA0"
                                },
                                {
                                    "title":"Installing Oracle Grid Infrastructure to Manage Oracle RAC Databases",
                                    "href":"installing-oracle-standalone-cluster.html#GUID-7BAE8D62-4D26-424C-BBB4-B993F248C163"
                                },
                                {
                                    "title":"Installing Oracle Grid Infrastructure to Manage Generic Applications",
                                    "href":"installing-grid-to-manage-generic-applications.html#GUID-81654E96-212A-4F8D-9724-1D223146D033"
                                }
                            ]
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure Using Command-Line Interface",
                            "href":"installing-grid-using-command-line-interface.html#GUID-A9205E30-B4DF-4D5A-AD37-E84441CF351E"
                        },
                        {
                            "title":"Installing Oracle Grid Infrastructure Using a Cluster Configuration File",
                            "href":"installing-oracle-grid-infrastructure-using-a-cluster-configuration-file.html#GUID-6CDAEFE7-50BD-430F-867B-82AAE86C94B4"
                        },
                        {
                            "title":"Installing Only the Oracle Grid Infrastructure Software",
                            "href":"installing-only-the-oracle-grid-infrastructure-software.html#GUID-99AC758D-AAE0-4BCF-BB3D-1983F15A4710",
                            "topics":[
                                {
                                    "title":"Installing Software Binaries for Oracle Grid Infrastructure for a Cluster",
                                    "href":"installing-software-binaries-for-oracle-grid-infrastructure-for-a-cluster.html#GUID-1B3AA675-1685-4BEE-84AB-052CB4967EB6"
                                },
                                {
                                    "title":"Configuring Software Binaries for Oracle Grid Infrastructure for a Cluster",
                                    "href":"configuring-software-binaries-for-oracle-grid-infrastructure-for-a-cluster.html#GUID-FF4D5679-0B89-4F14-BD80-C5FB1C918368"
                                },
                                {
                                    "title":"Configuring the Software Binaries Using a Response File",
                                    "href":"configuring-the-software-binaries-using-a-response-file.html#GUID-C92B290C-8510-4EE5-A65B-F283AEC014E1"
                                },
                                {
                                    "title":"Setting Ping Targets for Network Checks",
                                    "href":"setting-ping-targets-for-network-checks.html#GUID-FF1B01FF-7233-4F80-A482-C78D1FB8FA45"
                                }
                            ]
                        },
                        {
                            "title":"About Deploying Oracle Grid Infrastructure Using Oracle Fleet Patching and Provisioning",
                            "href":"about-deploying-oracle-grid-infrastructure-using-fleet-patching-and-provisioning.html#GUID-31A09C7F-CC05-4343-8C1A-C99E33B7AFC7"
                        },
                        {
                            "title":"Confirming Oracle Clusterware Function",
                            "href":"confirming-oracle-clusterware-function.html#GUID-6C70DC7E-1585-4F2A-B9BF-B94B014A27D2"
                        },
                        {
                            "title":"Confirming Oracle ASM Function for Oracle Clusterware Files",
                            "href":"confirming-oracle-asm-function-for-oracle-clusterware-files.html#GUID-523BCF8A-0427-43DF-8582-13C4F036302A"
                        },
                        {
                            "title":"Understanding Offline Processes in Oracle Grid Infrastructure",
                            "href":"understanding-offline-processes-in-oracle-grid-infrastructure.html#GUID-263DC73E-8A17-42F4-A6C7-E7DD1B92BE03"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Patching Oracle Grid Infrastructure",
                    "href":"applying-patches-to-oracle-asm.html#GUID-FE981E6C-C517-406B-B66E-8323E3C4B6DC",
                    "topics":[
                        {
                            "title":"About Individual Oracle Grid Infrastructure Patches",
                            "href":"about-individual-one-off-oracle-asm-patches.html#GUID-7187788E-3733-4DE7-9D7F-A2DFB0125159"
                        },
                        {
                            "title":"About Oracle Grid Infrastructure Software Patch Levels",
                            "href":"about-oracle-asm-software-patch-levels.html#GUID-98DA247B-67C8-4E3E-AF51-BA9F224D4921"
                        },
                        {
                            "title":"About Zero-Downtime Oracle Grid Infrastructure Patching",
                            "href":"about-zero-downtime-gi-patching.html#GUID-253CF841-DAAD-4B13-A1F2-6F83EF3FDE47"
                        },
                        {
                            "title":"Applying Patches to Oracle Grid Infrastructure",
                            "href":"patching-oracle-grid-infrastructure.html#GUID-7168797A-41EB-4EAD-AF1B-0E2893059CA5",
                            "topics":[
                                {
                                    "title":"Applying Patches Using Zero-Downtime Oracle Grid Infrastructure Patching",
                                    "href":"zero-downtime-oracle-grid-infrastructure-patching.html#GUID-471B87BF-3457-47BD-8858-316F4921EEE6"
                                },
                                {
                                    "title":"Applying Patches During an Oracle Grid Infrastructure Installation or Upgrade",
                                    "href":"applying-patches-during-oracle-grid-infrastructure-install-or-upgrade.html#GUID-D10C7B8D-A120-48A2-8237-36809D0DB21E"
                                },
                                {
                                    "title":"Applying Patches After an Oracle Grid Infrastructure Installation or Upgrade",
                                    "href":"applying-patching-after-grid-install-or-upgrade.html#GUID-5C600305-50EA-485E-9D7C-C1C99094B497"
                                },
                                {
                                    "title":"Applying Patches when Oracle Clusterware Fails to Start",
                                    "href":"applying-patches-when-oracle-clusterware-fails-to-start.html#GUID-404FB2D0-90E8-4502-B59A-70C7709E4306"
                                }
                            ]
                        },
                        {
                            "title":"Patching and Switching Oracle Grid Infrastructure Homes",
                            "href":"switching-oracle-grid-infrastructure-home-after-patching.html#GUID-6AC5B276-6AC7-4D1B-8CA7-27C6449414EA"
                        },
                        {
                            "title":"Patching Oracle Grid Infrastructure Using Oracle FPP Local Mode",
                            "href":"patching-oracle-grid-infrastructure-using-oracle-fpp-lite.html#GUID-D47593D5-E693-4C88-A3F9-F2EDCF034E3F"
                        },
                        {
                            "title":"Using Oracle Update Advisor in Oracle FPP Local Mode",
                            "href":"using-oracle-update-advisor-in-oracle-fpp-local-mode.html#GUID-52EAB47C-477B-4686-A4B0-FC953346A101"
                        },
                        {
                            "title":"Changing the Oracle Grid Infrastructure Base Path",
                            "href":"changing-gi-base-path.html#GUID-37A2D915-224F-47AB-8AC6-12353565E79C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Upgrading Oracle Grid Infrastructure",
                    "href":"upgrading-oracle-grid-infrastructure.html#GUID-DF76F201-3374-486F-9D19-06276764569F",
                    "topics":[
                        {
                            "title":"Understanding Out-of-Place Upgrade",
                            "href":"understanding-out-of-place-upgrades.html#GUID-88AB25ED-D20C-41A4-92BC-05A88EB76BC7"
                        },
                        {
                            "title":"About Oracle Grid Infrastructure Upgrade and Downgrade",
                            "href":"about-oracle-grid-infrastructure-upgrade.html#GUID-1EF71D22-9885-4A1C-BC78-7C288AEA74EA"
                        },
                        {
                            "title":"Options for Oracle Grid Infrastructure Upgrades",
                            "href":"options-for-oracle-grid-infrastructure-upgrades-and-downgrades.html#GUID-3A23AD2C-91DB-4E10-A0BA-A913BF73AB60"
                        },
                        {
                            "title":"Restrictions for Oracle Grid Infrastructure Upgrades",
                            "href":"restrictions-for-oracle-grid-infrastructure-upgrades.html#GUID-35B2433E-F462-45F0-8745-79EF644C7E86"
                        },
                        {
                            "title":"Preparing to Upgrade an Existing Oracle Clusterware Installation",
                            "href":"preparing-to-upgrade-an-existing-oracle-clusterware-installation.html#GUID-583D2090-3E02-48DC-8FA1-B162540D592F",
                            "topics":[
                                {
                                    "title":"Upgrade Checklist for Oracle Grid Infrastructure",
                                    "href":"preugrade-oracle-grid-infrastructure-checklist.html#GUID-1FA85454-69E7-4376-833F-7BB3F015388B"
                                },
                                {
                                    "title":"Checks to Complete Before Upgrading Oracle Grid Infrastructure",
                                    "href":"checks-to-complete-before-upgrading-oracle-clusterware.html#GUID-11FA548B-8E63-4133-878A-FF824196508E"
                                },
                                {
                                    "title":"Removing Grid Infrastructure Management Repository",
                                    "href":"removing-gimr.html#GUID-3FDF376F-3E5F-4005-BDFD-46DE3BA16D86"
                                },
                                {
                                    "title":"Moving Oracle Clusterware Files from NFS to Oracle ASM",
                                    "href":"moving-oracle-clusterware-files-from-nfs-to-oracle-asm.html#GUID-1B7C9EF9-9143-494A-BE33-95A7FCE92EEC"
                                },
                                {
                                    "title":"Running the Oracle ORAchk Upgrade Readiness Assessment",
                                    "href":"running-the-oracle-raccheck-upgrade-readiness-assessment.html#GUID-4906FDDD-54E5-461F-BC62-822B0AE59CFE"
                                },
                                {
                                    "title":"Using CVU to Validate Readiness for Oracle Clusterware Upgrades",
                                    "href":"using-cvu-to-validate-readiness-for-oracle-clusterware-upgrades.html#GUID-F79F7810-02FB-471D-A44D-F04360082D22",
                                    "topics":[
                                        {
                                            "title":"About the CVU Upgrade Validation Command Options",
                                            "href":"about-the-cvu-upgrade-validation-command-options.html#GUID-1B64EAC5-387B-4E38-97F6-4E4802A90BD1"
                                        },
                                        {
                                            "title":"Standalone CVU Home",
                                            "href":"standalone-cvu-home.html#GUID-05E88D7E-9527-430A-9C23-ADA324DF74B8"
                                        },
                                        {
                                            "title":"Example of Verifying System Upgrade Readiness for Grid Infrastructure",
                                            "href":"example-of-verifying-system-upgrade-readiness-for-grid-infrastructure.html#GUID-E11D4830-CDA2-49A9-A959-9D7011B32F60"
                                        }
                                    ]
                                },
                                {
                                    "title":"Using Dry-Run Upgrade Mode to Check System Upgrade Readiness",
                                    "href":"using-dry-run-upgrade-mode-to-validate-readiness-for-oracle-grid-infrastructure.html#GUID-F3614E4E-2934-4F9E-8BFA-52F2D87A38CA",
                                    "topics":[
                                        {
                                            "title":"About Oracle Grid Infrastructure Dry-Run Upgrade Mode",
                                            "href":"about-oracle-clusterware-dry-run-upgrade-mode.html#GUID-C7219D16-AE81-4F2B-933E-D4C2094ABA81"
                                        },
                                        {
                                            "title":"Performing Dry-Run Upgrade Using Oracle Universal Installer",
                                            "href":"running-oui-in-dry-run-upgrade-mode.html#GUID-D967E9F6-0215-4DC5-A709-32EB0D8BC578"
                                        }
                                    ]
                                }
                            ]
                        },
                        {
                            "title":"Understanding Rolling Upgrades Using Batches",
                            "href":"understanding-rolling-upgrades-using-batches.html#GUID-13B6B9B1-1EEB-4F0C-BC93-5A651CEB9709"
                        },
                        {
                            "title":"Performing Rolling Upgrade of Oracle Grid Infrastructure",
                            "href":"performing-rolling-upgrade-of-oracle-grid-infrastructure.html#GUID-38AB019F-4CFD-4B5C-B2E9-C75639BEF58D",
                            "topics":[
                                {
                                    "title":"Upgrading Oracle Grid Infrastructure Using Setup Wizard",
                                    "href":"running-oui-to-upgrade-grid-infrastructure-from-an-earlier-release.html#GUID-3BE36DF3-EB62-4CD1-B53A-850A3E2129E3"
                                },
                                {
                                    "title":"Upgrading Oracle Grid Infrastructure Using Command-Line Interface",
                                    "href":"upgrding-oracle-grid-infrastructure-using-cli.html#GUID-C0EAD097-1779-4FFC-AAA9-0C5F077C3380"
                                },
                                {
                                    "title":"Completing an Oracle Clusterware Upgrade when Nodes Become Unreachable",
                                    "href":"completing-an-oracle-clusterware-upgrade-when-nodes-become-unreachable.html#GUID-69FBCA85-5AB7-47F2-A199-0B3609993E6F"
                                },
                                {
                                    "title":"Joining Inaccessible Nodes After Forcing an Upgrade",
                                    "href":"joining-inaccessible-nodes-after-forcing-an-upgrade.html#GUID-41FCF961-7567-4A65-AE27-984459465626"
                                },
                                {
                                    "title":"Changing the First Node for Install and Upgrade",
                                    "href":"changing-the-first-node-for-install-and-upgrade.html#GUID-79F68385-DC40-4D9E-80CE-1EF42C1393A8"
                                }
                            ]
                        },
                        {
                            "title":"About Upgrading Oracle Grid Infrastructure Using Oracle Fleet Patching and Provisioning",
                            "href":"about-upgrading-grid-infrastructure-using-fleet-patching-and-provisioning.html#GUID-FC0B8E52-D6F4-42A8-94BF-734C95A412C7"
                        },
                        {
                            "title":"Updating Oracle Enterprise Manager Cloud Control Target Parameters",
                            "href":"updating-oracle-enterprise-manager-cloud-control-target-parameters.html#GUID-F2304CD1-DDDB-42A0-B84A-F4890BD87A9C",
                            "topics":[
                                {
                                    "title":"Updating the Enterprise Manager Cloud Control Target After Upgrades",
                                    "href":"updating-the-enterprise-manager-cloud-control-target-after-upgrades.html#GUID-845594A1-A466-4AEF-B83A-16D0079567C0"
                                },
                                {
                                    "title":"Updating the Enterprise Manager Agent Base Script After Upgrades",
                                    "href":"updating-the-enterprise-manager-agent-base-directory-after-upgrades.html#GUID-49220E0B-0A88-4ECC-8B25-6AAC1CBD6EAD"
                                },
                                {
                                    "title":"Registering Resources with Oracle Enterprise Manager After Upgrades",
                                    "href":"registering-listener-with-em-after-gi-upgrade.html#GUID-E7F5E326-FC1B-40F6-877C-D853F91F576E"
                                }
                            ]
                        },
                        {
                            "title":"Unlocking and Deinstalling the Previous Release Grid Home",
                            "href":"unlocking-the-existing-oracle-clusterware-installation.html#GUID-119E09C5-34A3-4832-A9D2-E4280A8A07AF"
                        },
                        {
                            "title":"Checking Cluster Health Monitor Repository Size After Upgrading",
                            "href":"checking-cluster-health-monitor-repository-size-after-upgrading.html#GUID-D088CC2A-F91D-4EF6-981F-DB751E92ED49"
                        },
                        {
                            "title":"Downgrading Oracle Clusterware to an Earlier Release",
                            "href":"downgrading-oracle-clusterware-after-an-upgrade.html#GUID-ACE6E5EB-5583-4DD9-8BA5-AD3F382B629A",
                            "topics":[
                                {
                                    "title":"About Oracle Grid Infrastructure Downgrades",
                                    "href":"about-oracle-grid-infrastructure-downgrades.html#GUID-AC72E438-76D2-4BBB-9B47-C9CAF415C964"
                                },
                                {
                                    "title":"Options for Oracle Grid Infrastructure Downgrades",
                                    "href":"options-for-oracle-grid-infrastructure-downgrades.html#GUID-ED15C3ED-F6B5-4452-BEB6-E3854E423E0E"
                                },
                                {
                                    "title":"Restrictions for Oracle Grid Infrastructure Downgrades",
                                    "href":"restrictions-for-oracle-grid-infrastructure-downgrades.html#GUID-7CFDE197-FCC1-4B14-AFEA-244D9346321C"
                                },
                                {
                                    "title":"Downgrading Oracle Grid Infrastructure",
                                    "href":"downgrading-oracle-standalone-cluster-19c.html#GUID-C2C44B93-BAF1-4C16-BD77-014CB67C67A7"
                                },
                                {
                                    "title":"Downgrading Oracle Grid Infrastructure when Upgrade Fails",
                                    "href":"downgrading-oracle-grid-infrastructure-19c-when-upgrade-fails.html#GUID-5F08A712-C6C1-4C18-A10D-24F4A076A80C"
                                },
                                {
                                    "title":"Downgrading Oracle Grid Infrastructure Using Online Terminate Upgrade",
                                    "href":"downgrading-oracle-grid-infrastructure-after-failed-upgrade-on-first-node.html#GUID-99F9160A-6999-47EE-8410-C64FDED95A97"
                                }
                            ]
                        },
                        {
                            "title":"Completing Failed or Interrupted Installations and Upgrades",
                            "href":"completing-failed-or-interrupted-installations-and-upgrades.html#GUID-A30DD2BD-8131-40C5-B47E-1B67DC99F75F",
                            "topics":[
                                {
                                    "title":"Completing Failed Installations and Upgrades",
                                    "href":"completing-failed-installation-upgrade.html#GUID-12EFC26A-1978-4AE8-90F5-6EED57B87BBD"
                                },
                                {
                                    "title":"Continuing Incomplete Upgrade of First Node",
                                    "href":"continuing-incomplete-upgrades-of-first-nodes.html#GUID-539608FB-0DB6-4478-B89F-BE52AC635B24"
                                },
                                {
                                    "title":"Continuing Incomplete Upgrades on Remote Nodes",
                                    "href":"continuing-incomplete-upgrades-on-remote-nodes.html#GUID-F72449AF-4354-4140-8712-668A18373DFC"
                                },
                                {
                                    "title":"Continuing Incomplete Installation on First Node",
                                    "href":"continuing-incomplete-installations-of-first-nodes.html#GUID-64068F73-D022-44AB-BDC7-FBE0662438B1"
                                },
                                {
                                    "title":"Continuing Incomplete Installation on Remote Nodes",
                                    "href":"continuing-incomplete-installation-on-remote-nodes.html#GUID-B32B32D9-CF8F-41C9-9A09-88FFF2E03649"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Oracle Grid Infrastructure Postinstallation Tasks",
                    "href":"oracle-grid-infrastructure-postinstallation-tasks.html#GUID-2591D0B9-2618-42F0-945F-83F9E34460AF",
                    "topics":[
                        {
                            "title":"Required Postinstallation Tasks",
                            "href":"required-postinstallation-tasks.html#GUID-57C27D5D-7C92-4919-A430-690B89C57665",
                            "topics":[
                                {
                                    "title":"Downloading Release Update Patches",
                                    "href":"downloading-and-installing-patch-updates.html#GUID-A2FD0257-D074-444D-8007-A21EBEC10358"
                                }
                            ]
                        },
                        {
                            "title":"Recommended Postinstallation Tasks",
                            "href":"recommended-postinstallation-tasks.html#GUID-01E7E498-DC11-411E-ADA2-02C2B8F358F0",
                            "topics":[
                                {
                                    "title":"About Installing Oracle Autonomous Health Framework",
                                    "href":"downloading-and-installing-the-orachk-health-check-tool.html#GUID-19914928-49B2-444A-8F1B-D4398C264AAD"
                                },
                                {
                                    "title":"Creating a Fast Recovery Area",
                                    "href":"creating-a-fast-recovery-area.html#GUID-C56FFC39-923E-4A94-961D-B6785FB83C8A",
                                    "topics":[
                                        {
                                            "title":"About the Fast Recovery Area and the Fast Recovery Area Disk Group",
                                            "href":"about-the-fast-recovery-area-and-the-fast-recovery-area-disk-group.html#GUID-05343E2B-24CF-427E-A068-9AC2104BEF81"
                                        },
                                        {
                                            "title":"Creating the Fast Recovery Area Disk Group",
                                            "href":"creating-the-fast-recovery-area-disk-group.html#GUID-5D87E773-BEAA-4C7E-BE25-B970E15633D7"
                                        }
                                    ]
                                },
                                {
                                    "title":"Checking the SCAN Configuration",
                                    "href":"checking-the-scan-configuration.html#GUID-E64C1906-50F7-47B5-BD37-0E41729EDFAE"
                                },
                                {
                                    "title":"Setting Resource Limits for Oracle Clusterware and Associated Databases and Applications",
                                    "href":"setting-resource-limits-for-oracle-clusterware-and-associated-databases-and-applications.html#GUID-24811C82-E56C-491B-8326-9D237CD83F11"
                                }
                            ]
                        },
                        {
                            "title":"About Changes in Default SGA Permissions for Oracle AI Database",
                            "href":"about-changes-in-default-sga-of-databases.html#GUID-B588A924-1F76-4536-A476-E8AC9FCB977B"
                        },
                        {
                            "title":"Using Earlier Oracle AI Database Releases with Oracle Grid Infrastructure",
                            "href":"using-earlier-oracle-database-releases-with-oracle-grid-infrastructure.html#GUID-17B7D297-1788-4597-ABE4-1EE0DA94F84A",
                            "topics":[
                                {
                                    "title":"General Restrictions for Using Earlier Oracle AI Database Releases",
                                    "href":"general-restrictions-for-using-earlier-oracle-database-releases.html#GUID-9AA7448D-5D03-4B74-8A07-20B27F2CAED2"
                                },
                                {
                                    "title":"Using ASMCA to Administer Disk Groups for Earlier Database Releases",
                                    "href":"using-asmca-to-administer-disk-groups-for-earlier-database-releases.html#GUID-0B8700AF-EFA6-4EC3-8939-B48E681D9C0E"
                                },
                                {
                                    "title":"Using the Correct LSNRCTL Commands",
                                    "href":"using-the-correct-lsnrctl-commands.html#GUID-3DC53A16-B0FD-49CB-A3A6-4309110A9812"
                                }
                            ]
                        },
                        {
                            "title":"Relinking Oracle Grid Infrastructure for a Cluster Binaries",
                            "href":"relinking-oracle-grid-infrastructure-for-a-cluster-binaries.html#GUID-58A1E45E-3A9F-487E-AF8A-B4A34A53888D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Removing Oracle AI Database Software",
                    "href":"removing-oracle-database-software.html#GUID-5619EBF0-C89E-4349-AE6F-A8F8B3B06BD1",
                    "topics":[
                        {
                            "title":"About Oracle Deinstallation Options",
                            "href":"about-oracle-deinstallation-options.html#GUID-DF4E3D18-163A-4014-B24F-AAC4EBD9955F"
                        },
                        {
                            "title":"Oracle Deinstallation (Deinstall)",
                            "href":"oracle-deinstallation-tool-deinstall.html#GUID-71E860C5-4E1E-4D2F-AFD1-141709A172C0"
                        },
                        {
                            "title":"Unlocking and Deinstalling the Previous Release Grid Home",
                            "href":"Chunk1395791323.html#GUID-119E09C5-34A3-4832-A9D2-E4280A8A07AF"
                        },
                        {
                            "title":"Deinstallation Examples for Oracle AI Database",
                            "href":"deinstallation-examples-for-oracle-database.html#GUID-05452B1D-E034-4547-B9C6-9E8BCA1BD4EF"
                        },
                        {
                            "title":"Deinstallation Response File Example for Oracle Grid Infrastructure for a Cluster",
                            "href":"deinstallation-response-file-example-for-oracle-grid-infrastructure-for-a-cluster.html#GUID-C6E38067-1ACB-4577-BC36-869A24CB50D8"
                        },
                        {
                            "title":"Migrating Standalone Oracle Grid Infrastructure Servers to a Cluster",
                            "href":"migrating-standalone-oracle-grid-infrastructure-servers-to-a-cluster.html#GUID-D11B1056-5936-430C-AA36-4BFA880DFE0D"
                        },
                        {
                            "title":"Changing the Oracle Grid Infrastructure Home Path",
                            "href":"changing-the-oracle-grid-infrastructure-home-path.html#GUID-E86C40DC-3C47-47C4-BCEA-AB243391B7FC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Oracle Grid Infrastructure Command-Line Options",
                    "href":"grid-command-line-options.html#GUID-24AE3D52-39B5-4361-B5DF-3E6D0334029D",
                    "topics":[
                        {
                            "title":"gridSetup.sh Command",
                            "href":"gridsetup-command-options.html#GUID-C9C5B44A-4541-4869-8829-8A540476CF07"
                        },
                        {
                            "title":"gridSetup.sh -setupHome",
                            "href":"gridsetup-setuphome-command.html#GUID-8A135DED-1768-4185-BF20-7EA0019BD262"
                        },
                        {
                            "title":"gridSetup.sh -setupHomeAs",
                            "href":"gridsetup-setuphomeas-command.html#GUID-8A094193-0DE0-4352-BB66-E3001715E42F"
                        },
                        {
                            "title":"gridSetup.sh -configureCluster",
                            "href":"gridsetup-configurecluster-command.html#GUID-8B8EAC21-F810-4D87-90EE-26EE5FEB9D69"
                        },
                        {
                            "title":"gridSetup.sh -switchGridhome",
                            "href":"gridsetup-switchgridhome-command.html#GUID-383FA93F-BA10-4131-9BFA-1A99E6807D6A"
                        },
                        {
                            "title":"gridSetup.sh -upgrade",
                            "href":"gridsetup-upgradegridinfrastructure-command.html#GUID-2CDDA644-F691-4B7D-A882-81FC5F740FC3"
                        },
                        {
                            "title":"gridSetup.sh -downgrade",
                            "href":"gridsetup-sh-downgrade.html#GUID-E6BEE552-3325-452A-ADC4-DE1E8C1505CC"
                        },
                        {
                            "title":"gridSetup.sh -createGoldImage",
                            "href":"gridsetup-creategoldimage-command.html#GUID-9ADE23AB-FB22-49EF-9628-7FFF59DDD109"
                        },
                        {
                            "title":"gridSetup.sh -addNode",
                            "href":"gridsetup-addnode-command.html#GUID-908F0562-4460-4CED-B28A-E4B851F12992"
                        },
                        {
                            "title":"gridSetup.sh -deleteNode",
                            "href":"gridsetup-deletenode-command.html#GUID-2789C00B-45F5-42DF-8DCB-CF8B269AAC5C"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Response Files",
                    "href":"installing-and-configuring-oracle-database-using-response-files.html#GUID-D53355E9-E901-4224-9A2A-B882070EDDF7",
                    "topics":[
                        {
                            "title":"Reasons for Using Silent Mode or Response File Mode",
                            "href":"reasons-for-using-silent-mode-or-response-file-mode.html#GUID-62D156C6-8CB4-491E-A7DD-ED3DB7D1D82B"
                        },
                        {
                            "title":"Using Response Files",
                            "href":"using-response-files.html#GUID-9EDC0547-4BCC-4349-A0F7-CBDD0039F3EF"
                        },
                        {
                            "title":"Preparing Response Files",
                            "href":"preparing-response-files.html#GUID-90A09F65-ADD1-43EB-B545-324749E3282E",
                            "topics":[
                                {
                                    "title":"Editing a Response File Template",
                                    "href":"editing-a-response-file-template.html#GUID-662F8635-947B-4774-B9BB-3752B47C3F91"
                                },
                                {
                                    "title":"Recording Response Files",
                                    "href":"recording-response-files.html#GUID-5F75A411-6DD8-43C8-9BC7-294AE82204FE"
                                }
                            ]
                        },
                        {
                            "title":"Running Oracle Universal Installer Using a Response File",
                            "href":"running-oracle-universal-installer-using-a-response-file.html#GUID-C8B6ED11-4486-45E0-8365-E1A9695FB27C"
                        },
                        {
                            "title":"Postinstallation Configuration Using Response File Created During Installation",
                            "href":"postinstallation-configuration-using-response-file-created-during-installation.html#GUID-855D3F72-D2F9-4263-8BC6-37641F2C4251",
                            "topics":[
                                {
                                    "title":"Using the Installation Response File for Postinstallation Configuration",
                                    "href":"using-the-installation-response-file-for-postinstallation-configuration.html#GUID-25DFB0D0-FC1A-432B-919C-6FB9B7F9E447"
                                },
                                {
                                    "title":"Running Postinstallation Configuration Using Response File",
                                    "href":"running-postinstallation-configuration-using-response-file.html#GUID-F8AE183A-872E-43FC-AE9A-74407530C1E2"
                                }
                            ]
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> Completing Preinstallation Tasks Manually",
                    "href":"completing-preinstallation-tasks-manually.html#GUID-54959149-E611-48EC-BDDF-F379E8B35C97",
                    "topics":[
                        {
                            "title":"Configuring SSH Manually on All Cluster Nodes",
                            "href":"configuring-ssh-manually-on-all-cluster-nodes.html#GUID-6147C3B4-2B41-4F2B-808F-74B2D0F39E4D",
                            "topics":[
                                {
                                    "title":"About Passwordless SSH Configuration",
                                    "href":"about-ssh-configuration.html#GUID-514C8263-5AF9-4B58-9F94-93243D6C9BF0"
                                },
                                {
                                    "title":"Checking Existing SSH Configuration on the System",
                                    "href":"checking-existing-ssh-configuration-on-the-system.html#GUID-F67FD2C2-95E1-4FE9-B3AC-3167824952DB"
                                },
                                {
                                    "title":"Configuring SSH on Cluster Nodes",
                                    "href":"configuring-ssh-on-cluster-nodes.html#GUID-1325EB95-021A-4E8C-83BF-23F5CB5625DC",
                                    "topics":[
                                        {
                                            "title":"Create SSH Directory and Create SSH Keys On Each Node",
                                            "href":"create-ssh-directory-and-create-ssh-keys-on-each-node.html#GUID-BF4A8B11-B7C1-439C-8100-7FB45536DC93"
                                        },
                                        {
                                            "title":"Add All Keys to a Common authorized_keys File",
                                            "href":"add-all-keys-to-a-common-authorized_keys-file.html#GUID-6187332B-691C-4221-8B50-E8B46364AD2F"
                                        }
                                    ]
                                },
                                {
                                    "title":"Enabling SSH User Equivalency on Cluster Nodes",
                                    "href":"enabling-ssh-user-equivalency-on-cluster-nodes.html#GUID-0B5EF138-1D1B-4C1D-8CAF-F2AAA266C526"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Storage Device Path Persistence Manually",
                            "href":"configuring-storage-device-path-persistence-manually.html#GUID-9E4220CB-506E-4792-87B3-EAC4071C1056",
                            "topics":[
                                {
                                    "title":"About Device Path Persistence",
                                    "href":"about-device-path-persistence.html#GUID-13959A3E-196F-417C-8B61-D5C291F7CE84"
                                },
                                {
                                    "title":"Configuring Device Persistence Manually for Oracle ASM",
                                    "href":"configuring-device-persistence-manually-for-oracle-asm.html#GUID-70D50812-CCB2-41E4-AA3B-4689E1DA934E"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Kernel Parameters for Linux",
                            "href":"configuring-kernel-parameters-for-linux.html#GUID-6127884D-FB27-45FA-9498-B2540632CBD5",
                            "topics":[
                                {
                                    "title":"Minimum Parameter Settings for Installation",
                                    "href":"minimum-parameter-settings-for-installation.html#GUID-CDEB89D1-4D48-41D9-9AC2-6AD9B0E944E3"
                                },
                                {
                                    "title":"Changing Kernel Parameter Values",
                                    "href":"changing-kernel-parameter-values.html#GUID-FB0CC366-61C9-4AA2-9BE7-233EB6810A31"
                                },
                                {
                                    "title":"Configuring Additional Kernel Settings for SUSE Linux",
                                    "href":"configuring-additional-kernel-settings-for-suse-linux.html#GUID-7A4DF920-A200-42F1-93CF-EF1D45240092"
                                },
                                {
                                    "title":"Setting UDP and TCP Kernel Parameters Manually",
                                    "href":"setting-udp-and-tcp-kernel-parameters-manually.html#GUID-F94545C8-7695-4866-89B0-F32651CD3658"
                                }
                            ]
                        },
                        {
                            "title":"Configuring Default Thread Limits Value for SUSE Linux",
                            "href":"configuring-defaulttasksmax-for-suse.html#GUID-0815D18D-65E7-46B2-BA89-F54BA02EFCB8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">D </span> Optimal Flexible Architecture",
                    "href":"optimal-flexible-architecture.html#GUID-34434C8B-EBEE-497A-BB92-26B43561B6B1",
                    "topics":[
                        {
                            "title":"About the Optimal Flexible Architecture Standard",
                            "href":"about-the-optimal-flexible-architecture-standard.html#GUID-6619CDB7-9667-426E-8471-5A996707D093"
                        },
                        {
                            "title":"About Multiple Oracle Homes Support",
                            "href":"about-multiple-oracle-homes-support.html#GUID-CFB6CD80-EFE5-4A14-95F4-08291DB594FD"
                        },
                        {
                            "title":"About the Oracle Inventory Directory and Installation",
                            "href":"about-the-oracle-inventory-directory-and-installation.html#GUID-22CB62EF-D5DA-47BF-B4C3-C5D03B059728"
                        },
                        {
                            "title":"Oracle Base Directory Naming Convention",
                            "href":"oracle-base-directory-naming-convention.html#GUID-3B198883-0AD1-4AB2-9007-059AE32240F0"
                        },
                        {
                            "title":"Oracle Home Directory Naming Convention",
                            "href":"oracle-home-directory-naming-convention.html#GUID-8599FF25-C020-4E03-93D2-8D92ADA240A8"
                        },
                        {
                            "title":"Optimal Flexible Architecture File Path Examples",
                            "href":"optimal-flexible-architecture-file-path-examples.html#GUID-BB3EE4F7-50F4-4A2D-8A0D-96B7CC44029B"
                        }
                    ]
                }
            ]
        }
    ]
});