define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-4EBC8E78-73B1-47F6-90A2-901701C2DC91"
                },
                {
                    "title":"Changes in This Release for Oracle AI Database Data Redaction Guide",
                    "href":"changes-this-release-oracle-database-data-redaction-guide.html#GUID-E8571A2A-00B8-4BE3-87A7-4461D53FF298"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to Oracle Data Redaction",
                    "href":"introduction-to-oracle-data-redaction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> What Is Oracle Data Redaction?",
                            "href":"what-is-oracle-data-redaction.html#GUID-57C07734-6D33-497B-A990-1E8F327488B1"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> When to Use Oracle Data Redaction",
                            "href":"when-use-oracle-data-redaction.html#GUID-8D24DFB1-2ED8-46A7-88E0-678541BA76CC"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Benefits of Using Oracle Data Redaction",
                            "href":"benefits-using-oracle-data-redaction.html#GUID-A9989BA7-AE7B-43FA-83D8-8CEA8FFA438B"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Example Use Cases for Oracle Data Redaction",
                            "href":"example-use-cases-oracle-data-redaction.html#GUID-3EEAC5CD-08F6-409D-96FD-65ADED99DAD8"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> Oracle Data Redaction in a Multitenant Environment",
                            "href":"oracle-data-redaction-multitenant-environment.html#GUID-52FA95B1-8823-43F9-9D96-8F801BF16178"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Oracle Data Redaction Features and Capabilities",
                    "href":"oracle-data-redaction-features-and-capabilities.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Getting Started with Oracle Data Redaction",
                            "href":"getting-started-oracle-data-redaction.html#GUID-CE5C1FCA-3292-41A8-8BF4-7576C039321B"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Full Data Redaction to Redact All Data",
                            "href":"full-data-redaction-redact-all-data.html#GUID-6B29C206-3140-43CE-BD44-455F30298769"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Partial Data Redaction to Redact Portions of Data",
                            "href":"partial-data-redaction-redact-portions-data.html#GUID-CAD842A6-3E06-4D6A-801B-CB8C7CA6E417"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> Regular Expressions to Redact Patterns of Data",
                            "href":"regular-expressions-redact-patterns-data.html#GUID-3EBD2772-C1C2-44DF-9D7C-7BA12B5E5374"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Random Data Redaction to Generate Random Values",
                            "href":"random-data-redaction-generate-random-values.html#GUID-65DF80A2-A1C6-49DB-80AD-E7E67A49CC05"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> Redaction Using Null Values",
                            "href":"redaction-using-null-values.html#GUID-5386DE6A-E712-4149-AEEB-67C4ABF31184"
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> No Redaction for Testing Purposes",
                            "href":"no-redaction-testing-purposes.html#GUID-C21DE59C-DB88-4A94-A42E-2EEC4E1D4156"
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> Comparison of Full, Partial, Regexp, Random, and Nullify Redaction Based on Data Types",
                            "href":"comparison-full_-partial_-and-random-redaction-based-data-types.html#GUID-F7E1C148-8C15-4F18-91BA-878A90284D12"
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> Central Management of Data Redaction Named Policy Expressions",
                            "href":"central-management-named-data-redaction-policy-expressions.html#GUID-BB3B8DAC-A367-472B-9968-F756B6D6728D"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Configuring Oracle Data Redaction Policies",
                    "href":"configuring-oracle-data-redaction-policies.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> About Oracle Data Redaction Policies",
                            "href":"oracle-data-redaction-policies.html#GUID-78CBB015-A3C3-42B9-8EFA-315C4789C749"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Privileges for Managing Oracle Data Redaction Policies",
                            "href":"privileges-managing-oracle-data-redaction-policies.html#GUID-29569FAA-E317-4266-A960-7DB92895663F"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> General Syntax of the DBMS_REDACT.ADD_POLICY Procedure",
                            "href":"general-syntax-dbms_redact-add_policy-procedure.html#GUID-D32FC6CA-A3B5-47EE-B288-52F1124F9FBD"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Planning an Oracle Data Redaction Policy",
                            "href":"planning-oracle-data-redaction-policy.html#GUID-D41C508C-0DCC-4A6F-89C0-C85584BF4020"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Using Expressions to Define Conditions for Data Redaction Policies",
                            "href":"using-expressions-define-conditions-data-redaction-policies.html#GUID-CF59A02C-1DE8-439B-BC1C-7235915C6D23"
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> Creating and Managing Multiple Named Policy Expressions",
                            "href":"creating-and-managing-multiple-named-policy-expressions.html#GUID-A251209F-8BC3-4504-8DED-F6B72162A03B"
                        },
                        {
                            "title":"<span class=\"secnum\">3.7 </span> Creating a Full Redaction Policy and Altering the Full Redaction Value",
                            "href":"creating-full-redaction-policy-and-altering-full-redaction-value.html#GUID-E3725E9D-2798-48D5-B87B-BE8A02E73941"
                        },
                        {
                            "title":"<span class=\"secnum\">3.8 </span> Creating a Partial Redaction Policy",
                            "href":"creating-partial-redaction-policy.html#GUID-42B218FF-9082-4149-9D76-961B6D6417BB"
                        },
                        {
                            "title":"<span class=\"secnum\">3.9 </span> Creating a Regular Expression-Based Redaction Policy",
                            "href":"creating-regular-expression-based-redaction-policy.html#GUID-1C20F828-2922-4846-8536-CC667B65FD01"
                        },
                        {
                            "title":"<span class=\"secnum\">3.10 </span> Creating a Random Redaction Policy",
                            "href":"creating-random-redaction-policy.html#GUID-E697C12B-1121-4C3D-B895-1587AF4CA218"
                        },
                        {
                            "title":"<span class=\"secnum\">3.11 </span> Creating a Nullify Redaction Policy",
                            "href":"creating-nullify-redaction-policy.html#GUID-6007FB12-BE1E-4C00-8714-E3CC8D25F0F5"
                        },
                        {
                            "title":"<span class=\"secnum\">3.12 </span> Creating a Policy That Uses No Redaction",
                            "href":"creating-policy-that-uses-no-redaction.html#GUID-1EC4068F-7404-437F-BFFE-87917F2619DB"
                        },
                        {
                            "title":"<span class=\"secnum\">3.13 </span> Exemption of Users from Oracle Data Redaction Policies",
                            "href":"exemption-users-oracle-data-redaction-policies.html#GUID-ADFB7DCD-8543-400D-95A3-AA0976E75084"
                        },
                        {
                            "title":"<span class=\"secnum\">3.14 </span> Redacting Multiple Columns",
                            "href":"redacting-multiple-columns.html#GUID-1E236704-872D-4FCB-A46E-C5014B53E9DE"
                        },
                        {
                            "title":"<span class=\"secnum\">3.15 </span> Altering an Oracle Data Redaction Policy",
                            "href":"altering-oracle-data-redaction-policy.html#GUID-205D50FF-2210-4957-B06B-EF82D734C26A"
                        },
                        {
                            "title":"<span class=\"secnum\">3.16 </span> Disabling and Enabling an Oracle Data Redaction Policy",
                            "href":"disabling-and-enabling-oracle-data-redaction-policy.html#GUID-6DBB6BA3-28C8-499F-A603-4DFAC18E6B41"
                        },
                        {
                            "title":"<span class=\"secnum\">3.17 </span> Dropping an Oracle Data Redaction Policy",
                            "href":"dropping-oracle-data-redaction-policy.html#GUID-F87B88B2-651E-4AF4-8E01-7B8A629A3D8F"
                        },
                        {
                            "title":"<span class=\"secnum\">3.18 </span> Tutorial: SQL Expressions to Build Reports with Redacted Values",
                            "href":"tutorial-sql-expressions-build-reports-redacted-values.html#GUID-DE28EFBA-73F2-416E-BBE6-F22AF080DC74"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Integrating Oracle Data Redaction with Other Oracle Products and Features",
                    "href":"oracle-data-redaction-use-with-oracle-database-features.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Oracle Data Redaction and DML and DDL Operations",
                            "href":"oracle-data-redaction-and-dml-and-ddl-operations.html#GUID-7F507B1B-12C8-4F1A-9C3E-09022D2068FA"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Oracle Data Redaction and Nested Functions, Inline Views, and the WHERE Clause",
                            "href":"oracle-data-redaction-and-nested-functions-inline-views-and-where-clause.html#GUID-8572CDF2-7DD8-4CC7-BCAC-00CD361951DC"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Redaction Results for Queries with SQL Expressions and Set Operation When Using Columns With Redaction Policies",
                            "href":"full-redaction-sql-expressions-and-set-operations.html#GUID-D4FFD2B0-0AD3-42C6-8CEE-4A2D12334F76"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Oracle Data Redaction Policy and Object Transfers with Oracle Data Pump",
                            "href":"oracle-data-redaction-policy-and-object-transfers-oracle-data-pump.html#GUID-DE91C0ED-92E5-40C6-B9B0-EFC710F0C5D1"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Oracle Data Redaction and Oracle Virtual Private Database",
                            "href":"oracle-data-redaction-and-oracle-virtual-private-database.html#GUID-005796B2-304C-47AD-9655-DE200F3CEC99"
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Oracle Data Redaction and Oracle Database Real Application Security",
                            "href":"oracle-data-redaction-and-oracle-database-real-application-security.html#GUID-89F04071-C0C2-423B-BF0C-BECB504984D5"
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> Oracle Data Redaction and Oracle Database Vault",
                            "href":"oracle-data-redaction-and-oracle-database-vault.html#GUID-679EACAA-49D1-410E-B8BD-BF6C3DCDC884"
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> Oracle Data Redaction and Data Masking and Subsetting Pack",
                            "href":"oracle-data-redaction-and-data-masking-and-subsetting-pack.html#GUID-A75CA148-1D47-4012-8849-92AD9265114B"
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Oracle Data Redaction and Transparent Data Encryption",
                            "href":"oracle-data-redaction-and-transparent-data-encryption.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Considerations for Oracle Data Redaction",
                    "href":"security-considerations-for-using-oracle-data-redaction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Oracle Data Redaction General Security Guidelines",
                            "href":"oracle-data-redaction-general-security-guidelines.html#GUID-8AAB65A3-56F7-48A2-8CD6-5D9D556835AA"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Restriction of Administrative Access to Oracle Data Redaction Policies",
                            "href":"restriction-administrative-access-oracle-data-redaction-policies.html#GUID-49898C42-C978-4872-A3B5-EE58AA0698D2"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> How Oracle Data Redaction Affects the SYS, SYSTEM, and Default Schemas",
                            "href":"how-oracle-data-redaction-affects-sys_-system_-and-default-schemas.html#GUID-5DF99B37-7BF1-4ED7-8483-9E293588D772"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Policy Expressions That Use SYS_CONTEXT Attributes",
                            "href":"policy-expressions-that-use-sys_context-attributes.html#GUID-AA3AF99C-7A20-4333-981B-7088B5ECB05A"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Oracle Data Redaction Policies on Materialized Views",
                            "href":"oracle-data-redaction-policies-materialized-views.html#GUID-38318C24-8327-48B4-A5DD-D8382E562FD8"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> Oracle Data Redaction and Object Dependencies",
                            "href":"object-dependencies.html#GUID-26BF07BA-DE74-409D-B165-7F8F5F6A7154"
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> Oracle Data Redaction and Cursor Expression Queries on Columns Protected by Data Redaction Policies",
                            "href":"oracle-data-redaction-and-queries-columns-protected-data-redaction-policies.html#GUID-343A4F89-B5BA-4DB6-B242-7CB3F6EA2075"
                        },
                        {
                            "title":"<span class=\"secnum\">5.8 </span> Redaction Results of a SQL Expression When Using Multiple Columns With Different Policy Expressions",
                            "href":"redaction-results-when-calling-multiple-columns-different-policy-expressions-applied.html#GUID-DC46ACCB-E542-4B88-8FC4-80E43D2A6135"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Limitations of Oracle Data Redaction",
                    "href":"limitation-oracle-data-redaction.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Oracle Data Redaction General Usage Limitations",
                            "href":"oracle-data-redaction-general-usage-guidelines.html#GUID-FFCACD39-626A-4851-B4B2-D38225C91707"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Oracle Data Redaction and Database Links",
                            "href":"oracle-data-redaction-and-database-links.html#GUID-6C639026-0F6D-4F31-BD75-776E90E88550"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Oracle Data Redaction and Object Types",
                            "href":"oracle-data-redaction-and-object-types.html#GUID-528FC7E0-9CA3-4922-AA0F-78BF2B19515D"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Oracle Data Redaction and Editions",
                            "href":"oracle-data-redaction-and-editions.html#GUID-E4D02F00-674D-4C56-89AC-F947C8DA31B7"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Oracle Data Redaction and JSON",
                            "href":"oracle-data-redaction-and-json.html#GUID-923A2EB1-C75F-4629-AD8F-A4726FEFAADC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Frequently Asked Questions",
                    "href":"frequently-asked-questions.html#GUID-8665EF3D-5587-4718-B85B-A45DF2D0E16D"
                },
                {
                    "title":"<span class=\"secnum\">B </span> Using Trace Files to Troubleshoot Oracle Data Redaction Policies",
                    "href":"using-trace-files-troubleshoot-oracle-data-redaction-policies.html#GUID-84B3D18D-FFF2-46BB-9D41-C74D1F969E4A"
                },
                {
                    "title":"<span class=\"secnum\">C </span> Oracle Data Redaction Policy Data Dictionary Views",
                    "href":"oracle-data-redaction-policy-data-dictionary-views.html#GUID-16B2C464-83C6-4341-BE13-12F68695B65C"
                },
                {
                    "title":"<span class=\"secnum\">D </span> DBMS_REDACT",
                    "href":"DBMS_REDACT.html#GUID-3EA1DAA6-CCD3-49D4-A3F9-05F578230AB7"
                },
                {
                    "title":"<span class=\"secnum\">E </span> Managing Oracle Data Redaction Policies in Oracle Enterprise Manager",
                    "href":"using-oracle-data-redaction-in-oracle-enterprise-manager.html#GUID-8267183A-1778-428E-9B6E-AB06D8CC7EAB"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});