define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-FF3F0222-C808-4F5D-88F0-4240AE0415F3"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to the Oracle Database Gateway for DRDA",
                    "href":"database-gateway-drda-introduction.html#GUID-CF0431ED-7F2C-4166-9D64-F83B182CECF9",
                    "topics":[
                        {
                            "title":"Overview of the Oracle Database Gateway for DRDA",
                            "href":"introduction-to-drda.html#GUID-DBF94092-C4F6-43C0-912C-9DF88448F2F1"
                        },
                        {
                            "title":"Gateway Capabilities",
                            "href":"gateway-capabilities.html#GUID-DE579079-52DE-44EE-8718-D81D89E7D14A"
                        },
                        {
                            "title":"Terms",
                            "href":"terms.html#GUID-7E4E3789-FE24-4FE3-8EB3-10A677E15805"
                        },
                        {
                            "title":"Architecture",
                            "href":"architecture.html#GUID-D60F110A-93AC-44D1-9E40-9068FC6BF763"
                        },
                        {
                            "title":"Implementation",
                            "href":"implementation.html#GUID-7875B8F0-80AB-48E7-AF26-2D3B816988A2"
                        },
                        {
                            "title":"How the Gateway Works",
                            "href":"how-the-drda-gateway-works.html#GUID-FECCD306-3240-4307-B9D0-BEC553E393CC"
                        },
                        {
                            "title":"Oracle Tools and the Gateway",
                            "href":"oracle-tools-and-the-gateway.html#GUID-50333960-6FF8-43AE-9000-34DB54C06361"
                        },
                        {
                            "title":"Features",
                            "href":"features.html#GUID-20003DAA-7C19-4B16-9CCE-EFCB3278E059"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Release Information",
                    "href":"database-gateway-drda-release-information.html#GUID-77C68571-FE79-4553-ABC2-C466775912A8",
                    "topics":[
                        {
                            "title":"Product Set",
                            "href":"product-set.html#GUID-3406D964-B91C-4075-BBC8-BE4964C8B2F8"
                        },
                        {
                            "title":"Changes and Enhancements",
                            "href":"changes-and-enhancements.html#GUID-2108C51F-6CD3-43F6-8508-E5FE54601006"
                        },
                        {
                            "title":"Product Migration",
                            "href":"product-migration.html#GUID-1C2C9867-3DA7-4351-BE80-0CA44E0BD549"
                        },
                        {
                            "title":"Known Problems",
                            "href":"drda-known-problems.html#GUID-BDCB6BDA-F48C-445A-9CC4-9AA858D32F24"
                        },
                        {
                            "title":"Known Restrictions",
                            "href":"drda-known-restrictions.html#GUID-394A2B59-3127-45D7-8B3F-6FD61E655A8A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Using the Oracle Database Gateway for DRDA",
                    "href":"using-database-gateway-drda.html#GUID-7C1EA11D-0B32-4BF5-9BA0-D90B6C011307",
                    "topics":[
                        {
                            "title":"DRDA Gateway Features",
                            "href":"drda-gateway-features.html#GUID-CC26958C-89D7-4230-A598-200F135D8987"
                        },
                        {
                            "title":"Processing a Database Link",
                            "href":"processing-database-link.html#GUID-0456C1B9-D99D-4D78-BD5D-C4AEB097AF58"
                        },
                        {
                            "title":"Accessing the Gateway",
                            "href":"accessing-the-drda-gateway.html#GUID-AA0A394C-8E8B-4ECD-8C29-A8763EAC0C0A"
                        },
                        {
                            "title":"Accessing i5/OS File Members",
                            "href":"access-i5os-file-members.html#GUID-E716BE71-7D67-4AA4-8C5E-B8843733B388"
                        },
                        {
                            "title":"Using the Synonym Feature",
                            "href":"using-synonym-feature.html#GUID-ABF1C711-C195-4E65-AB3B-199CB484FB21"
                        },
                        {
                            "title":"Performing Distributed Queries",
                            "href":"performing-distributed-queries.html#GUID-DB4B2396-1F94-4C1E-B47D-D312EEAF4BB2"
                        },
                        {
                            "title":"Replicating in a Heterogeneous Environment",
                            "href":"replicating-in-heterogeneous-environment.html#GUID-3C8C4F0C-49AF-4587-BA69-A1E154EB55C5"
                        },
                        {
                            "title":"Copying Data from Oracle Database to DRDA Server",
                            "href":"copy-data-from-oracle-to-drda.html#GUID-332D7A50-49C1-4CED-90C7-B3A821DDE165"
                        },
                        {
                            "title":"Copying Data from DRDA Server to Oracle Database",
                            "href":"copy-data-from-drda-to-oracle.html#GUID-43ADB851-BBBF-4418-9C57-7D4E3934282F"
                        },
                        {
                            "title":"Tracing SQL Statements",
                            "href":"tracing-sql-statements.html#GUID-D39B98BF-6E54-4606-88CF-4C0993CB1A14"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Developing Applications",
                    "href":"developing-applications.html#GUID-A26938AA-A8D2-443C-94FD-B112BA5C1D87",
                    "topics":[
                        {
                            "title":"Gateway Appearance to Application Programs",
                            "href":"gateway-appearance-to-application-programs.html#GUID-0262C315-7426-4020-A1EC-6CFE82824BCA"
                        },
                        {
                            "title":"Using Oracle Stored Procedures with the Gateway",
                            "href":"using-oracle-stored-procedures-with-gateway.html#GUID-F9D08926-36A9-40B5-AF70-8FA94B003269"
                        },
                        {
                            "title":"Using DRDA Server Stored Procedures with the Gateway",
                            "href":"using-drda-stored-procedures-with-gateway.html#GUID-4D4A0C30-FAA6-43DB-9B80-8EEB6B38CC46"
                        },
                        {
                            "title":"Database Link Behavior",
                            "href":"database-link-behavior.html#GUID-6A9D8020-EFB8-43B4-BCF7-6D4FC4BA446B"
                        },
                        {
                            "title":"Oracle Database SQL Construct Processing",
                            "href":"oracle-database-sql-construct-processing.html#GUID-6F466C7C-E30A-48EF-AEC8-DF51F1F606F2"
                        },
                        {
                            "title":"DB2 UDB for z/OS SQL Compatibility",
                            "href":"db2-udb-for-zos-sql-compatibility.html#GUID-42BD902C-A95E-4957-847E-37213888D950"
                        },
                        {
                            "title":"DB2 UDB for Unix, Linux, and Windows Compatibility",
                            "href":"db2-udb-for-unix-linux-windows.html#GUID-C54FDBF7-A29F-49CE-925D-AEE50D5130C1"
                        },
                        {
                            "title":"DB2 UDB for iSeries Compatibility",
                            "href":"db2-udb-for-iseries-compatibility.html#GUID-281C5DC4-4672-402D-BBD1-4A93D5CD838A"
                        },
                        {
                            "title":"Native Semantics",
                            "href":"native-semantics.html#GUID-16656E2B-6068-4575-853F-251BE8C882E7"
                        },
                        {
                            "title":"DRDA Data Type to Oracle Data Type Conversion",
                            "href":"drda-data-type-to-oracle-data-type-conversion.html#GUID-E8343BEC-D760-4F2B-A412-0F43F992C2BC"
                        },
                        {
                            "title":"Passing Native SQL Statements through the Gateway",
                            "href":"passing-native-sql-through-the-gateway.html#GUID-80504BAD-9074-4817-85DA-FB948FC8D3BA"
                        },
                        {
                            "title":"Oracle Data Dictionary Emulation on a DRDA Server",
                            "href":"oracle-data-dictionary-emulation-on-drda-server.html#GUID-D0DF6F51-DBA2-46E3-B4F0-63E498E4213B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Error Messages, Diagnosis, and Reporting",
                    "href":"database-gateway-drda-error-messages.html#GUID-7C0401EB-B206-4CC0-A4A6-8FB5782B57D7",
                    "topics":[
                        {
                            "title":"Interpreting Gateway Error Messages",
                            "href":"interpreting-gateway-error-messages.html#GUID-682846C7-B32A-4AB1-8E96-CFAC816BD27B"
                        },
                        {
                            "title":"Mapped Errors",
                            "href":"mapped-errors.html#GUID-6F880170-01F9-40D4-AD5C-0CBA3A907B92"
                        },
                        {
                            "title":"SQL Tracing and the Gateway",
                            "href":"sql-tracing-and-gateway.html#GUID-852CD270-E7F8-45AC-BB98-FCB3F2CE37AC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> Oracle DB2 Data Dictionary Views",
                    "href":"db2-data-dictionary.html#GUID-E10DC4BC-CB8A-4BA5-A033-8FDAE03739AC",
                    "topics":[
                        {
                            "title":"ALL_CATALOG",
                            "href":"all_catalog-drda-gateway.html#GUID-69E3CF2E-7AA8-4E70-9DC5-A05C78F717EA"
                        },
                        {
                            "title":"ALL_COL_COMMENTS",
                            "href":"all_col_comments-drda-gateway.html#GUID-EFC51355-291B-4BEC-B039-85F552CADCAB"
                        },
                        {
                            "title":"ALL_CONS_COLUMNS",
                            "href":"all_cons_columns-drda-gateway.html#GUID-28A5049E-279A-4202-A1E2-227B3371ECF2"
                        },
                        {
                            "title":"ALL_CONSTRAINTS",
                            "href":"all_constraints-drda-gateway.html#GUID-6A04C68C-D437-480C-A156-7433423BAF12"
                        },
                        {
                            "title":"ALL_INDEXES",
                            "href":"all_indexes-drda-gateway.html#GUID-04578810-ABDC-4F37-AD2E-7169231BC129"
                        },
                        {
                            "title":"ALL_IND_COLUMNS",
                            "href":"all_ind_columns-drda-gateway.html#GUID-6BDDA4DE-623E-420A-A853-62557A433244"
                        },
                        {
                            "title":"ALL_OBJECTS",
                            "href":"all_objects-drda-gateway.html#GUID-70049880-8A0D-47C2-8675-E669719CD2C0"
                        },
                        {
                            "title":"ALL_SYNONYMS",
                            "href":"all_synonyms-drda-gateway.html#GUID-E814A6AC-5E00-4DB6-8170-DC147F7879F8"
                        },
                        {
                            "title":"ALL_TABLES",
                            "href":"all_tables-drda-gateway.html#GUID-62D85431-D366-4B33-BD82-A49CEC3DE84F"
                        },
                        {
                            "title":"ALL_TAB_COLUMNS",
                            "href":"all_tab_columns-drda-gateway.html#GUID-DE3EF8EE-2E39-4384-95D0-0A51402B4B0C"
                        },
                        {
                            "title":"ALL_TAB_COMMENTS",
                            "href":"all_tab_comments-drda-gateway.html#GUID-C2FE6DED-522F-4E43-8B71-5164A1C3C72D"
                        },
                        {
                            "title":"ALL_USERS",
                            "href":"all_users-drda-gateway.html#GUID-70E2B08B-2938-43D8-817B-22668B7E6A5C"
                        },
                        {
                            "title":"ALL_VIEWS",
                            "href":"all_views-drda-gateway.html#GUID-EC0CFDAF-94C1-42D6-AC7E-C9769CD9B553"
                        },
                        {
                            "title":"COLUMN_PRIVILEGES",
                            "href":"column_privileges-drda-gateway.html#GUID-A419C185-777D-4C06-816A-68BF02977D40"
                        },
                        {
                            "title":"DICTIONARY",
                            "href":"dictionary-drda-gateway.html#GUID-B45D0E58-8672-49DF-9FEC-A6168307BF7D"
                        },
                        {
                            "title":"DUAL",
                            "href":"dual-drda-gateway.html#GUID-0C1683F8-5CB6-43AA-921D-B709517AE619"
                        },
                        {
                            "title":"TABLE_PRIVILEGES",
                            "href":"table_privileges-drda-gateway.html#GUID-8027E3A2-B4A5-421F-AF5E-0AEADEF6A058"
                        },
                        {
                            "title":"USER_CATALOG",
                            "href":"user_catalog-drda-gateway.html#GUID-BC1300ED-3D7A-4A19-89EC-C853465236A9"
                        },
                        {
                            "title":"USER_COL_COMMENTS",
                            "href":"user_col_comments-drda-gateway.html#GUID-18EC1911-E058-4EE6-A6A9-B9159B0C2F88"
                        },
                        {
                            "title":"USER_CONS_COLUMNS",
                            "href":"user_cons_columns-drda-gateway.html#GUID-330632C1-A344-4EB7-80C2-C2127DE97839"
                        },
                        {
                            "title":"USER_CONSTRAINTS",
                            "href":"user_constraints-drda-gateway.html#GUID-5EFEC3C2-DA34-480A-A45C-448336FF9313"
                        },
                        {
                            "title":"USER_INDEXES",
                            "href":"user_indexes-drda-gateway.html#GUID-E2C8E431-4E62-4360-A8EC-0BD9ECBB12B9"
                        },
                        {
                            "title":"USER_OBJECTS",
                            "href":"user_objects-drda-gateway.html#GUID-91ABDADB-E70A-4C6D-A2F1-DD090EBC94D4"
                        },
                        {
                            "title":"USER_SYNONYMS",
                            "href":"user_synonyms-drda-gateway.html#GUID-BD1F8BE4-BDDD-47EE-B40C-0A1AD4594710"
                        },
                        {
                            "title":"USER_TABLES",
                            "href":"user_tables-drda-gateway.html#GUID-0DA041D5-8631-4314-B819-9907640B370B"
                        },
                        {
                            "title":"USER_TAB_COLUMNS",
                            "href":"user_tab_columns-drda-gateway.html#GUID-16DF8BB1-7FAC-4813-91F6-3EC08381B19D"
                        },
                        {
                            "title":"USER_TAB_COMMENTS",
                            "href":"user_tab_comments-drda-gateway.html#GUID-808446AE-D6EB-4081-8BF1-EC627052556C"
                        },
                        {
                            "title":"USER_USERS",
                            "href":"user_users-drda-gateway.html#GUID-87184167-9B84-478E-8471-F07DDEC1D9B4"
                        },
                        {
                            "title":"USER_VIEWS",
                            "href":"user_views-drda-gateway.html#GUID-66D251A6-9456-44BB-A2BD-2202EFE571AC"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">B </span> Initialization Parameters",
                    "href":"database-gateway-drda-initialization-parameters.html#GUID-D5965054-49C8-4D6A-91C3-C33BA2477434",
                    "topics":[
                        {
                            "title":"Initialization Parameter File Syntax",
                            "href":"initialization-parameter-file-syntax.html#GUID-BCDB3471-A8D6-42AE-A946-5F8A7B942779"
                        },
                        {
                            "title":"Oracle Database Gateway for DRDA Initialization Parameters",
                            "href":"drda-gateway-initialization-parameters.html#GUID-74339239-67F9-4384-B598-848AF1E9B607"
                        },
                        {
                            "title":"HS_CALL_NAME",
                            "href":"hs_call_name-drda-gateway.html#GUID-8EC7FA69-CC12-47E9-9AFC-EB650D255708"
                        },
                        {
                            "title":"HS_DB_DOMAIN",
                            "href":"hs_db_domain-drda-gateway.html#GUID-745689D2-4AD8-4DE7-B248-555E66DDC107"
                        },
                        {
                            "title":"HS_DB_INTERNAL_NAME",
                            "href":"hs_db_internal_name-drda-gateway.html#GUID-845B1B16-185D-42BF-B5F8-C68B5ACFCD8C"
                        },
                        {
                            "title":"HS_DB_NAME",
                            "href":"hs_db_name-drda-gateway.html#GUID-E5A94A7F-08F1-43A6-A66E-2BB841E1C9C0"
                        },
                        {
                            "title":"HS_DESCRIBE_CACHE_HWM",
                            "href":"hs_describe_cache_hwm-drda-gateway.html#GUID-397994A3-E67B-4B2E-9B04-8BCB0C31D8A0"
                        },
                        {
                            "title":"HS_FDS_ARRAY_EXEC",
                            "href":"hs_fds_array_exec-drda-gateway.html#GUID-ACC8C9CF-AC62-4351-87ED-5FC3B84C6435"
                        },
                        {
                            "title":"HS_FDS_AUTHENTICATE_USER",
                            "href":"hs_fds_authenticate_user-drda-gateway.html#GUID-CE874080-E13F-4174-ACE5-2D53A7E195C1"
                        },
                        {
                            "title":"HS_FDS_CAPABILITY",
                            "href":"hs_fds_capability-drda-gateway.html#GUID-D725AE78-87E6-4C4B-9347-E60B4299E673"
                        },
                        {
                            "title":"HS_FDS_CONNECT_INFO",
                            "href":"hs_fds_connect_info-drda-gateway.html#GUID-3226C0DA-4599-4335-BA4A-AABBADC2380B"
                        },
                        {
                            "title":"HS_FDS_DATE_MAPPING",
                            "href":"hs_fds_date_mapping-drda-gateway.html#GUID-A16B8C40-16B5-4949-9174-C38999964261"
                        },
                        {
                            "title":"HS_FDS_ENCRYPT_SESSION",
                            "href":"hs_fds_encrypt_session-drda-gateway.html#GUID-7F772D25-52FB-4086-8E3F-9ED435312F4E"
                        },
                        {
                            "title":"HS_FDS_FETCH_ROWS",
                            "href":"hs_fds_fetch_rows-drda-gateway.html#GUID-6A51F1F7-2A83-4B38-9BA3-8D269FB3AAB4"
                        },
                        {
                            "title":"HS_FDS_GRAPHIC_TO_MBCS",
                            "href":"hs_fds_graphic_to_mbcs-drda-gateway.html#GUID-0C3CDAEE-5982-463F-BDC4-FA97D7A7ED36"
                        },
                        {
                            "title":"HS_FDS_MBCS_TO_GRAPHIC",
                            "href":"hs_fds_mbcs_to_graphic-drda-gateway.html#GUID-1CA2EB6E-D3A3-4B2E-A335-9DDADCB8344B"
                        },
                        {
                            "title":"HS_FDS_PACKAGE_COLLID",
                            "href":"hs_fds_package_collid-drda-gateway.html#GUID-090B77C9-0988-4DB2-A82C-E7EA956BEF37"
                        },
                        {
                            "title":"HS_FDS_QUOTE_IDENTIFIER",
                            "href":"hs_fds_quote_identifier-drda-gateway.html#GUID-09DC8E8F-89D1-40B0-BA83-D0E9894E4D4C"
                        },
                        {
                            "title":"HS_FDS_RECOVERY_ACCOUNT",
                            "href":"hs_fds_recovery_account-drda-gateway.html#GUID-AD94316D-09CF-4771-9390-389F6B0B0FF0"
                        },
                        {
                            "title":"HS_FDS_RECOVERY_PWD",
                            "href":"hs_fds_recovery_pwd-drda-gateway.html#GUID-65AFA357-A4BF-43B4-AEF3-65188F61572F"
                        },
                        {
                            "title":"HS_FDS_REMOTE_DB_CHARSET",
                            "href":"hs_fds_remote_db_charset-drda-gateway.html#GUID-0DC47906-E4E2-454B-B0C0-A8DA8CC44AEB"
                        },
                        {
                            "title":"HS_FDS_RESULTSET_SUPPORT",
                            "href":"hs_fds_resultset_support-drda-gateway.html#GUID-01214441-BF61-4939-B0B5-41FA0923B40B"
                        },
                        {
                            "title":"HS_FDS_RSET_RETURN_ROWCOUNT",
                            "href":"hs_fds_rset_return_rowcount-drda-gateway.html#GUID-523DC7E8-E6C3-42E4-BB76-B8038B8EBD46"
                        },
                        {
                            "title":"HS_FDS_SQLLEN_INTERPRETATION",
                            "href":"hs_fds_sqllen_interpretation-drda-gateway.html#GUID-9BD810C1-6069-46E2-9E74-D71CAE6A8B92"
                        },
                        {
                            "title":"HS_FDS_SUPPORT_STATISTICS",
                            "href":"hs_fds_support_statistics-drda-gateway.html#GUID-03C36967-4A20-4613-A593-DCFB03EA5E17"
                        },
                        {
                            "title":"HS_FDS_TIMESTAMP_MAPPING",
                            "href":"hs_fds_timestamp_mapping-drda-gateway.html#GUID-3C1EF78C-75DC-4829-9B8D-9FCD07FC2EF5"
                        },
                        {
                            "title":"HS_FDS_TRACE_LEVEL",
                            "href":"hs_fds_trace_level-drda-gateway.html#GUID-8A213748-7B17-4345-BD90-7EE477748D25"
                        },
                        {
                            "title":"HS_FDS_TRANSACTION_ISOLATION",
                            "href":"hs_fds_isolation_level-drda-gateway.html#GUID-C472E1CA-C253-48D1-A36F-31FD7788316A"
                        },
                        {
                            "title":"HS_FDS_TRANSACTION_LOG",
                            "href":"hs_fds_transaction_log-drda-gateway.html#GUID-BFF68C19-870C-4EAB-AB2B-F2228BE8F161"
                        },
                        {
                            "title":"HS_FDS_TRUSTSTORE_FILE",
                            "href":"hs_fds_truststore_file-drda-gateway.html#GUID-B3096AFF-9484-44D0-8C16-E3106DC32444"
                        },
                        {
                            "title":"HS_FDS_TRUSTSTORE_PASSWORD",
                            "href":"hs_fds_truststore_password-drda-gateway.html#GUID-8E1E6565-2B51-4E40-A038-0D3DD317396C"
                        },
                        {
                            "title":"HS_FDS_VALIDATE_SERVER_CERT",
                            "href":"hs_fds_validate_server_cert-drda-gateway.html#GUID-83BFFA10-8953-4697-BA23-55A8CFE0AF7A"
                        },
                        {
                            "title":"HS_IDLE_TIMEOUT",
                            "href":"hs_idle_timeout-drda-gateway.html#GUID-F8956706-05E2-4368-939E-A1DC32009464"
                        },
                        {
                            "title":"HS_KEEP_REMOTE_COLUMN_SIZE",
                            "href":"hs_keep_remote_column_size-drda-gateway.html#GUID-E3A14F22-F012-4933-A5FB-48AFFA70E2E5"
                        },
                        {
                            "title":"HS_LANGUAGE",
                            "href":"hs_language-drda-gateway.html#GUID-65375111-5FD8-4504-BFC8-6F5296C1F02D"
                        },
                        {
                            "title":"HS_LONG_PIECE_TRANSFER_SIZE",
                            "href":"hs_long_piece_transfer_size-drda-gateway.html#GUID-682005EB-0613-4072-A822-2D3450E23DF7"
                        },
                        {
                            "title":"HS_NLS_LENGTH_SEMANTICS",
                            "href":"hs_nls_length_semantics-drda-gateway.html#GUID-DD412062-270D-4755-B6C6-B6688CFB52C5"
                        },
                        {
                            "title":"HS_OPEN_CURSORS",
                            "href":"hs_open_cursors-drda-gateway.html#GUID-41416F78-4A4C-4181-97F2-B0E69C8FA3EC"
                        },
                        {
                            "title":"HS_RPC_FETCH_REBLOCKING",
                            "href":"hs_rpc_fetch_reblocking-drda-gateway.html#GUID-E4740E63-36C3-4241-B5F4-5F4BCC4C99D3"
                        },
                        {
                            "title":"HS_RPC_FETCH_SIZE",
                            "href":"hs_rpc_fetch_size-drda-gateway.html#GUID-168E698C-817E-4588-83F4-A54FE055D52E"
                        },
                        {
                            "title":"HS_TRANSACTION_MODEL",
                            "href":"hs_transaction_model-drda-gateway.html#GUID-C3DD153B-8C9A-4B43-A336-1F7F0CA4628A"
                        },
                        {
                            "title":"IFILE",
                            "href":"ifile-drda-gateway.html#GUID-C39E96C7-9E7D-4447-8A2F-74525A5F8248"
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});