define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Figures",
                    "href":"lof.html"
                },
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-4C20E22B-D2CC-4DA6-A5EB-849C1AECCC0C"
                },
                {
                    "title":"Changes in This Release for Oracle Spatial GeoRaster Developer's Guide",
                    "href":"georaster-whats-new.html#GUID-2146064C-E3E8-40EB-B519-3EDF527CAC49"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> GeoRaster Overview and Concepts",
                    "href":"georaster-overview-and-concepts.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Vector and Raster Data",
                            "href":"vector-and-raster-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> Raster Data Sources",
                            "href":"raster-data-sources.html#GUID-D62E194B-A02E-4D02-BBE5-3CAF41DE7AEB"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> GeoRaster Data Model",
                            "href":"georaster-data-model.html#GUID-E38F1F16-4272-4CC8-A199-C97B11C634BA"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> GeoRaster Physical Storage",
                            "href":"georaster-physical-storage.html#GUID-DB21CC32-06DC-4E18-A4FB-B15C389C1F72"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> Bands, Layers, and Metadata",
                            "href":"bands-layers-and-metadata.html#GUID-9E5186D8-1206-4619-A260-F689FF724CFC"
                        },
                        {
                            "title":"<span class=\"secnum\">1.6 </span> Georeferencing",
                            "href":"georeferencing.html#GUID-E32BF03B-DB83-422E-B7D0-C0F3073890F9"
                        },
                        {
                            "title":"<span class=\"secnum\">1.7 </span> Resampling and Interpolation",
                            "href":"resampling-and-interpolation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.8 </span> Pyramids",
                            "href":"pyramids.html#GUID-739D74CC-E256-4E89-AB7F-9251054B9E82"
                        },
                        {
                            "title":"<span class=\"secnum\">1.9 </span> Bitmap Masks",
                            "href":"bitmap-masks.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.10 </span> NODATA Values and Value Ranges",
                            "href":"nodata-values-and-value-ranges.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.11 </span> Compression and Decompression",
                            "href":"compression-and-decompression.html#GUID-9BEA34A1-E05E-4E70-B09D-97A0EF1027B8"
                        },
                        {
                            "title":"<span class=\"secnum\">1.12 </span> GeoRaster and Database Management",
                            "href":"georaster-and-database-management.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.13 </span> Parallel Processing in GeoRaster",
                            "href":"parallel-processing-georaster.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.14 </span> Reporting Operation Progress in GeoRaster",
                            "href":"reporting-operation-progress-georaster.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.15 </span> Raster Tiles",
                            "href":"raster-tiles.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.16 </span> GeoRaster PL/SQL API",
                            "href":"georaster-pl-sql-api.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.17 </span> GeoRaster Java API",
                            "href":"georaster-java-api.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.18 </span> GeoRaster REST API",
                            "href":"georaster-rest-api.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.19 </span> GeoRaster and Python",
                            "href":"georaster-and-python.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.20 </span> GeoRaster Spatial Web Services",
                            "href":"georaster-spatial-web-services.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.21 </span> GeoRaster Support in Spatial Studio and Map Visualization Component",
                            "href":"georaster-support-spatial-studio-and-map-visualization-component.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.22 </span> GeoRaster Tools: Viewer, Loader, Exporter",
                            "href":"georaster-tools-viewer-loader-exporter.html#GUID-4813E3BC-2DB8-4310-82E5-3ADC467C0253"
                        },
                        {
                            "title":"<span class=\"secnum\">1.23 </span> GeoRaster PL/SQL, Java, and Python Sample Files",
                            "href":"georaster-pl-sql-java-and-python-sample-files.html"
                        },
                        {
                            "title":"<span class=\"secnum\">1.24 </span> README File for Spatial and Related Features",
                            "href":"readme-file-spatial-and-graph-and-related-features.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> GeoRaster Data Types and Related Structures",
                    "href":"georaster-data-types-and-related-structures.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> SDO_GEORASTER Object Type",
                            "href":"sdo_georaster-object-type.html#GUID-80616475-2A56-43B9-B707-58B369661632"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> SDO_RASTER Object Type and the Raster Data Table",
                            "href":"sdo_raster-object-type-and-raster-data-table.html#GUID-9679F06D-50A0-4EF7-9204-E85CA2F38378"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Other GeoRaster Types",
                            "href":"other-georaster-types.html#GUID-690756C5-5114-47B0-B417-B939BF5FBBA6"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> GeoRaster System Data Views (xxx_SDO_GEOR_SYSDATA)",
                            "href":"georaster-system-data-views-xxx_sdo_geor_sysdata.html#GUID-657BA65F-E8FF-41D7-94B6-BA412993EC52"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> GeoRaster XML Schema",
                            "href":"georaster-xml-schema.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> GeoRaster Database Creation and Management",
                    "href":"georaster-database-creation-and-management.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Enabling GeoRaster at the Schema Level",
                            "href":"enabling-georaster-schema-level.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> Adding Data Files and Temporary Tablespaces for GeoRaster Users",
                            "href":"adding-data-files-and-temporary-tablespaces-georaster-users.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> Creating the GeoRaster Table and Raster Data Tables",
                            "href":"creating-georaster-table-and-raster-data-tables.html#GUID-796CD9B4-27C6-49F5-B374-CB4316ABBE13"
                        },
                        {
                            "title":"<span class=\"secnum\">3.4 </span> Creating New GeoRaster Objects",
                            "href":"creating-new-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.5 </span> Loading Raster Data",
                            "href":"loading-raster-data.html#GUID-FC1E8154-B852-4D5D-A348-45E69785BF81"
                        },
                        {
                            "title":"<span class=\"secnum\">3.6 </span> Validating GeoRaster Objects",
                            "href":"validating-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.7 </span> Georeferencing GeoRaster Objects",
                            "href":"georeferencing-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.8 </span> Generating and Setting Spatial Extents",
                            "href":"generating-and-setting-spatial-extents.html#GUID-004D9CB3-916E-46C3-830B-FA2C88625B88"
                        },
                        {
                            "title":"<span class=\"secnum\">3.9 </span> Indexing GeoRaster Objects",
                            "href":"indexing-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.10 </span> Viewing GeoRaster Objects",
                            "href":"viewing-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.11 </span> Exporting GeoRaster Objects",
                            "href":"exporting-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.12 </span> Using GeoRaster with Workspace Manager and Label Security",
                            "href":"using-georaster-workspace-manager-and-label-security.html#GUID-BBE8942E-96B3-4EBE-ADB9-AA3FC8FFF3DD"
                        },
                        {
                            "title":"<span class=\"secnum\">3.13 </span> Maintaining Efficient Tablespace Use by GeoRaster Objects",
                            "href":"maintaining-efficient-tablespace-use-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.14 </span> Checking GeoRaster Tables and Objects in the Database",
                            "href":"checking-georaster-tables-and-objects-database.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.15 </span> Maintaining GeoRaster Objects and System Data in the Database",
                            "href":"maintaining-georaster-objects-and-system-data-database.html"
                        },
                        {
                            "title":"<span class=\"secnum\">3.16 </span> Transferring GeoRaster Data Between Databases",
                            "href":"transferring-georaster-data-databases.html#GUID-0F77203F-486F-4160-A03C-8E7EA2594DB1"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> GeoRaster Data Query and Manipulation",
                    "href":"georaster-data-query-and-manipulation.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Querying and Searching GeoRaster Objects",
                            "href":"querying-and-searching-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Changing and Optimizing Raster Storage",
                            "href":"changing-and-optimizing-raster-storage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> Copying GeoRaster Objects",
                            "href":"copying-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Subsetting GeoRaster Objects with Polygon Clipping",
                            "href":"subsetting-georaster-objects-polygon-clipping.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Querying and Updating GeoRaster Metadata",
                            "href":"querying-and-updating-georaster-metadata.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> Querying and Updating GeoRaster Cell Data",
                            "href":"querying-and-updating-georaster-cell-data.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.7 </span> Interpolating Cell Values",
                            "href":"interpolating-cell-values.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.8 </span> Processing and Analyzing GeoRaster Objects",
                            "href":"processing-and-analyzing-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.9 </span> Monitoring and Reporting GeoRaster Operation Progress",
                            "href":"monitoring-and-reporting-georaster-operation-progress.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.10 </span> Compressing and Decompressing GeoRaster Objects",
                            "href":"compressing-and-decompressing-georaster-objects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.11 </span> Deleting GeoRaster Objects, and Performing Actions on GeoRaster Tables and RDTs",
                            "href":"deleting-georaster-objects-and-performing-actions-georaster-tables-and-rdts.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.12 </span> Performing Cross-Schema Operations",
                            "href":"performing-cross-schema-operations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.13 </span> Managing Memory to Improve Performance",
                            "href":"managing-memory-improve-performance.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.14 </span> Updating GeoRaster Objects Before Committing",
                            "href":"updating-georaster-objects-committing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.15 </span> Updating GeoRaster Objects in a Loop",
                            "href":"updating-georaster-objects-loop.html"
                        },
                        {
                            "title":"<span class=\"secnum\">4.16 </span> Using Template-Related Subprograms to Develop GeoRaster Applications",
                            "href":"using-template-related-subprograms-develop-georaster-applications.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Raster Algebra and Analytics",
                    "href":"raster-algebra-and-analytics.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Raster Algebra Language",
                            "href":"raster-algebra-language.html#GUID-A6F087DC-1E7E-4426-B778-8554A25B3494"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Cell Value-Based Conditional Queries",
                            "href":"cell-value-based-conditional-queries.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Cell Value-Based Conditional Updates (Edits)",
                            "href":"cell-value-based-conditional-updates-edits.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Mathematical Operations",
                            "href":"mathematical-operations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.5 </span> Classification Operations",
                            "href":"classification-operations.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.6 </span> Statistical Operations",
                            "href":"statistical-operations.html#GUID-B1A7F654-E438-48F1-9EB6-55268FA260B1"
                        },
                        {
                            "title":"<span class=\"secnum\">5.7 </span> Logical Operations",
                            "href":"logical-operations.html#GUID-022F5214-9D1E-44B4-8487-967C93CC2954"
                        },
                        {
                            "title":"<span class=\"secnum\">5.8 </span> Raster Data Scaling and Offsetting",
                            "href":"raster-data-scaling-and-offsetting.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.9 </span> Raster Data Casting",
                            "href":"raster-data-casting.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.10 </span> Cartographic Modeling",
                            "href":"cartographic-modeling.html"
                        },
                        {
                            "title":"<span class=\"secnum\">5.11 </span> Terrain Modeling and Analysis",
                            "href":"terrain-modeling-and-analysis.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Image Processing and Virtual Mosaic",
                    "href":"image-processing-and-virtual-mosaic.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> Advanced Georeferencing",
                            "href":"advanced-georeferencing.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Image Reprojection",
                            "href":"image-reprojection.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Image Rectification",
                            "href":"image-rectification.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Image Orthorectification",
                            "href":"image-orthorectification.html#GUID-1EA97BE8-2B6B-4E0E-B89E-57ECD1C33F95"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Image Warping",
                            "href":"image-warping.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.6 </span> Image Affine Transformation and Scaling",
                            "href":"image-affine-transformation-and-scaling.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.7 </span> Image Stretching, Normalization, Equalization, Histogram Matching, and Dodging",
                            "href":"image-stretching-normalization-equalization-histogram-matching-and-dodging.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.8 </span> Image Filtering",
                            "href":"image-filtering.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.9 </span> Image Segmentation",
                            "href":"image-segmentation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.10 </span> Image Pyramiding: Parallel Generation and Partial Update",
                            "href":"image-pyramiding-parallel-generation-and-partial-update.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.11 </span> Bitmap Pyramiding",
                            "href":"bitmap-pyramiding.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.12 </span> Vegetation Index Computation",
                            "href":"vegetation-index-computation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.13 </span> Tasseled Cap Transformation",
                            "href":"tasseled-cap-transformation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.14 </span> Image Masking",
                            "href":"image-masking.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.15 </span> Band Merging",
                            "href":"band-merging.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.16 </span> Image Appending",
                            "href":"image-appending.html"
                        },
                        {
                            "title":"<span class=\"secnum\">6.17 </span> Large-Scale Image Mosaicking",
                            "href":"large-scale-image-mosaicking.html#GUID-992BAEDB-C6EC-4E0E-97AA-C18A59F960FA"
                        },
                        {
                            "title":"<span class=\"secnum\">6.18 </span> Virtual Mosaic",
                            "href":"virtual-mosaic.html#GUID-16C91449-1E94-4B3F-9403-EEFE483251AD"
                        },
                        {
                            "title":"<span class=\"secnum\">6.19 </span> Image Serving",
                            "href":"image-serving.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> SDO_GEOR Package Reference",
                    "href":"sdo_geor-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> SDO_GEOR.addNODATA",
                            "href":"sdo_geor-addnodata.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> SDO_GEOR.addSourceInfo",
                            "href":"sdo_geor-addsourceinfo.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> SDO_GEOR.affineTransform",
                            "href":"sdo_geor-affinetransform.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> SDO_GEOR.calcCompressionRatio",
                            "href":"sdo_geor-calccompressionratio.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.5 </span> SDO_GEOR.changeCellValue",
                            "href":"sdo_geor-changecellvalue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.6 </span> SDO_GEOR.changeCellValues",
                            "href":"sdo_geor-changecellvalues.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.7 </span> SDO_GEOR.changeFormatCopy",
                            "href":"sdo_geor-changeformatcopy.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.8 </span> SDO_GEOR.compressJP2",
                            "href":"sdo_geor-compressjp2.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.9 </span> SDO_GEOR.copy",
                            "href":"sdo_geor-copy.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.10 </span> SDO_GEOR.createBlank",
                            "href":"sdo_geor-createblank.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.11 </span> SDO_GEOR.createTemplate",
                            "href":"sdo_geor-createtemplate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.12 </span> SDO_GEOR.decompressJP2",
                            "href":"sdo_geor-decompressjp2.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.13 </span> SDO_GEOR.deleteControlPoint",
                            "href":"sdo_geor-deletecontrolpoint.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.14 </span> SDO_GEOR.deleteNODATA",
                            "href":"sdo_geor-deletenodata.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.15 </span> SDO_GEOR.deletePyramid",
                            "href":"sdo_geor-deletepyramid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.16 </span> SDO_GEOR.evaluateDouble",
                            "href":"sdo_geor-evaluatedouble.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.17 </span> SDO_GEOR.evaluateDoubles",
                            "href":"sdo_geor-evaluatedoubles.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.18 </span> SDO_GEOR.exportTo",
                            "href":"sdo_geor-exportto.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.19 </span> SDO_GEOR.generateAreaWeightedMean",
                            "href":"sdo_geor-generateareaweightedmean.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.20 </span> SDO_GEOR.generateBitmapPyramid",
                            "href":"sdo_geor-generatebitmappyramid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.21 </span> SDO_GEOR.generateBlockMBR",
                            "href":"sdo_geor-generateblockmbr.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.22 </span> SDO_GEOR.generatePyramid",
                            "href":"sdo_geor-generatepyramid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.23 </span> SDO_GEOR.generateSpatialExtent",
                            "href":"sdo_geor-generatespatialextent.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.24 </span> SDO_GEOR.generateSpatialResolutions",
                            "href":"sdo_geor-generatespatialresolutions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.25 </span> SDO_GEOR.generateStatistics",
                            "href":"sdo_geor-generatestatistics.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.26 </span> SDO_GEOR.generateStatisticsMax",
                            "href":"sdo_geor-generatestatisticsmax.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.27 </span> SDO_GEOR.generateStatisticsMean",
                            "href":"sdo_geor-generatestatisticsmean.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.28 </span> SDO_GEOR.generateStatisticsMedian",
                            "href":"sdo_geor-generatestatisticsmedian.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.29 </span> SDO_GEOR.generateStatisticsMin",
                            "href":"sdo_geor-generatestatisticsmin.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.30 </span> SDO_GEOR.generateStatisticsMode",
                            "href":"sdo_geor-generatestatisticsmode.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.31 </span> SDO_GEOR.generateStatisticsSTD",
                            "href":"sdo_geor-generatestatisticsstd.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.32 </span> SDO_GEOR.generateStatisticsSum",
                            "href":"sdo_geor-generatestatisticssum.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.33 </span> SDO_GEOR.georeference",
                            "href":"sdo_geor-georeference.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.34 </span> SDO_GEOR.getBandDimSize",
                            "href":"sdo_geor-getbanddimsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.35 </span> SDO_GEOR.getBeginDateTime",
                            "href":"sdo_geor-getbegindatetime.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.36 </span> SDO_GEOR.getBinFunction",
                            "href":"sdo_geor-getbinfunction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.37 </span> SDO_GEOR.getBinTable",
                            "href":"sdo_geor-getbintable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.38 </span> SDO_GEOR.getBinType",
                            "href":"sdo_geor-getbintype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.39 </span> SDO_GEOR.getBitmapMask",
                            "href":"sdo_geor-getbitmapmask.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.40 </span> SDO_GEOR.getBitmapMaskSubset",
                            "href":"sdo_geor-getbitmapmasksubset.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.41 </span> SDO_GEOR.getBitmapMaskValue",
                            "href":"sdo_geor-getbitmapmaskvalue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.42 </span> SDO_GEOR.getBitmapMaskValues",
                            "href":"sdo_geor-getbitmapmaskvalues.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.43 </span> SDO_GEOR.getBlankCellValue",
                            "href":"sdo_geor-getblankcellvalue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.44 </span> SDO_GEOR.getBlockingType",
                            "href":"sdo_geor-getblockingtype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.45 </span> SDO_GEOR.getBlockSize",
                            "href":"sdo_geor-getblocksize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.46 </span> SDO_GEOR.getCellCoordinate",
                            "href":"sdo_geor-getcellcoordinate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.47 </span> SDO_GEOR.getCellDepth",
                            "href":"sdo_geor-getcelldepth.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.48 </span> SDO_GEOR.getCellValue",
                            "href":"sdo_geor-getcellvalue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.49 </span> SDO_GEOR.getCellValues",
                            "href":"sdo_geor-getcellvalues.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.50 </span> SDO_GEOR.getColorMap",
                            "href":"sdo_geor-getcolormap.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.51 </span> SDO_GEOR.getColorMapTable",
                            "href":"sdo_geor-getcolormaptable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.52 </span> SDO_GEOR.getCompressionType",
                            "href":"sdo_geor-getcompressiontype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.53 </span> SDO_GEOR.getControlPoint",
                            "href":"sdo_geor-getcontrolpoint.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.54 </span> SDO_GEOR.getDefaultAlpha",
                            "href":"sdo_geor-getdefaultalpha.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.55 </span> SDO_GEOR.getDefaultBlue",
                            "href":"sdo_geor-getdefaultblue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.56 </span> SDO_GEOR.getDefaultColorLayer",
                            "href":"sdo_geor-getdefaultcolorlayer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.57 </span> SDO_GEOR.getDefaultGreen",
                            "href":"sdo_geor-getdefaultgreen.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.58 </span> SDO_GEOR.getDefaultPyramidLevel",
                            "href":"sdo_geor-getdefaultpyramidlevel.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.59 </span> SDO_GEOR.getDefaultRed",
                            "href":"sdo_geor-getdefaultred.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.60 </span> SDO_GEOR.getEndDateTime",
                            "href":"sdo_geor-getenddatetime.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.61 </span> SDO_GEOR.getGCPGeorefMethod",
                            "href":"sdo_geor-getgcpgeorefmethod.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.62 </span> SDO_GEOR.getGCPGeorefModel",
                            "href":"sdo_geor-getgcpgeorefmodel.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.63 </span> SDO_GEOR.getGeoreferenceType",
                            "href":"sdo_geor-getgeoreferencetype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.64 </span> SDO_GEOR.getGrayScale",
                            "href":"sdo_geor-getgrayscale.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.65 </span> SDO_GEOR.getGrayScaleTable",
                            "href":"sdo_geor-getgrayscaletable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.66 </span> SDO_GEOR.getHistogram",
                            "href":"sdo_geor-gethistogram.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.67 </span> SDO_GEOR.getHistogramTable",
                            "href":"sdo_geor-gethistogramtable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.68 </span> SDO_GEOR.getID",
                            "href":"sdo_geor-getid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.69 </span> SDO_GEOR.getInterleavingType",
                            "href":"sdo_geor-getinterleavingtype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.70 </span> SDO_GEOR.getJP2TileSize",
                            "href":"sdo_geor-getjp2tilesize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.71 </span> SDO_GEOR.getLayerDimension",
                            "href":"sdo_geor-getlayerdimension.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.72 </span> SDO_GEOR.getLayerID",
                            "href":"sdo_geor-getlayerid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.73 </span> SDO_GEOR.getLayerOrdinate",
                            "href":"sdo_geor-getlayerordinate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.74 </span> SDO_GEOR.getModelCoordinate",
                            "href":"sdo_geor-getmodelcoordinate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.75 </span> SDO_GEOR.getModelCoordLocation",
                            "href":"sdo_geor-getmodelcoordlocation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.76 </span> SDO_GEOR.getModelSRID",
                            "href":"sdo_geor-getmodelsrid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.77 </span> SDO_GEOR.getNODATA",
                            "href":"sdo_geor-getnodata.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.78 </span> SDO_GEOR.getPyramidMaxLevel",
                            "href":"sdo_geor-getpyramidmaxlevel.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.79 </span> SDO_GEOR.getPyramidType",
                            "href":"sdo_geor-getpyramidtype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.80 </span> SDO_GEOR.getRasterBlockLocator",
                            "href":"sdo_geor-getrasterblocklocator.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.81 </span> SDO_GEOR.getRasterBlocks",
                            "href":"sdo_geor-getrasterblocks.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.82 </span> SDO_GEOR.getRasterData",
                            "href":"sdo_geor-getrasterdata.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.83 </span> SDO_GEOR.getRasterRange",
                            "href":"sdo_geor-getrasterrange.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.84 </span> SDO_GEOR.getRasterSubset",
                            "href":"sdo_geor-getrastersubset.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.85 </span> SDO_GEOR.getScaling",
                            "href":"sdo_geor-getscaling.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.86 </span> SDO_GEOR.getSourceInfo",
                            "href":"sdo_geor-getsourceinfo.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.87 </span> SDO_GEOR.getSpatialDimNumber",
                            "href":"sdo_geor-getspatialdimnumber.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.88 </span> SDO_GEOR.getSpatialDimSizes",
                            "href":"sdo_geor-getspatialdimsizes.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.89 </span> SDO_GEOR.getSpatialResolutions",
                            "href":"sdo_geor-getspatialresolutions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.90 </span> SDO_GEOR.getSpectralResolution",
                            "href":"sdo_geor-getspectralresolution.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.91 </span> SDO_GEOR.getSpectralUnit",
                            "href":"sdo_geor-getspectralunit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.92 </span> SDO_GEOR.getSRS",
                            "href":"sdo_geor-getsrs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.93 </span> SDO_GEOR.getStatistics",
                            "href":"sdo_geor-getstatistics.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.94 </span> SDO_GEOR.getTotalLayerNumber",
                            "href":"sdo_geor-gettotallayernumber.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.95 </span> SDO_GEOR.getULTCoordinate",
                            "href":"sdo_geor-getultcoordinate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.96 </span> SDO_GEOR.getVAT",
                            "href":"sdo_geor-getvat.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.97 </span> SDO_GEOR.getVersion",
                            "href":"sdo_geor-getversion.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.98 </span> SDO_GEOR.hasBitmapMask",
                            "href":"sdo_geor-hasbitmapmask.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.99 </span> SDO_GEOR.hasGrayScale",
                            "href":"sdo_geor-hasgrayscale.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.100 </span> SDO_GEOR.hasNODATAMask",
                            "href":"sdo_geor-hasnodatamask.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.101 </span> SDO_GEOR.hasPseudoColor",
                            "href":"sdo_geor-haspseudocolor.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.102 </span> SDO_GEOR.importFrom",
                            "href":"sdo_geor-importfrom.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.103 </span> SDO_GEOR.init",
                            "href":"sdo_geor-init.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.104 </span> SDO_GEOR.isBlank",
                            "href":"sdo_geor-isblank.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.105 </span> SDO_GEOR.isOrthoRectified",
                            "href":"sdo_geor-isorthorectified.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.106 </span> SDO_GEOR.isRectified",
                            "href":"sdo_geor-isrectified.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.107 </span> SDO_GEOR.isSpatialReferenced",
                            "href":"sdo_geor-isspatialreferenced.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.108 </span> SDO_GEOR.mask",
                            "href":"sdo_geor-mask.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.109 </span> SDO_GEOR.mergeLayers",
                            "href":"sdo_geor-mergelayers.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.110 </span> SDO_GEOR.mosaic",
                            "href":"sdo_geor-mosaic.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.111 </span> SDO_GEOR.rectify",
                            "href":"sdo_geor-rectify.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.112 </span> SDO_GEOR.reproject",
                            "href":"sdo_geor-reproject.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.113 </span> SDO_GEOR.scaleCopy",
                            "href":"sdo_geor-scalecopy.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.114 </span> SDO_GEOR.schemaValidate",
                            "href":"sdo_geor-schemavalidate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.115 </span> SDO_GEOR.setBeginDateTime",
                            "href":"sdo_geor-setbegindatetime.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.116 </span> SDO_GEOR.setBinFunction",
                            "href":"sdo_geor-setbinfunction.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.117 </span> SDO_GEOR.setBinTable",
                            "href":"sdo_geor-setbintable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.118 </span> SDO_GEOR.setBitmapMask",
                            "href":"sdo_geor-setbitmapmask.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.119 </span> SDO_GEOR.setBlankCellValue",
                            "href":"sdo_geor-setblankcellvalue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.120 </span> SDO_GEOR.setColorMap",
                            "href":"sdo_geor-setcolormap.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.121 </span> SDO_GEOR.setColorMapTable",
                            "href":"sdo_geor-setcolormaptable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.122 </span> SDO_GEOR.setControlPoint",
                            "href":"sdo_geor-setcontrolpoint.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.123 </span> SDO_GEOR.setDefaultAlpha",
                            "href":"sdo_geor-setdefaultalpha.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.124 </span> SDO_GEOR.setDefaultBlue",
                            "href":"sdo_geor-setdefaultblue.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.125 </span> SDO_GEOR.setDefaultColorLayer",
                            "href":"sdo_geor-setdefaultcolorlayer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.126 </span> SDO_GEOR.setDefaultGreen",
                            "href":"sdo_geor-setdefaultgreen.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.127 </span> SDO_GEOR.setDefaultPyramidLevel",
                            "href":"sdo_geor-setdefaultpyramidlevel.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.128 </span> SDO_GEOR.setDefaultRed",
                            "href":"sdo_geor-setdefaultred.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.129 </span> SDO_GEOR.setEndDateTime",
                            "href":"sdo_geor-setenddatetime.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.130 </span> SDO_GEOR.setGCPGeorefMethod",
                            "href":"sdo_geor-setgcpgeorefmethod.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.131 </span> SDO_GEOR.setGCPGeorefModel",
                            "href":"sdo_geor-setgcpgeorefmodel.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.132 </span> SDO_GEOR.setGrayScale",
                            "href":"sdo_geor-setgrayscale.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.133 </span> SDO_GEOR.setGrayScaleTable",
                            "href":"sdo_geor-setgrayscaletable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.134 </span> SDO_GEOR.setHistogramTable",
                            "href":"sdo_geor-sethistogramtable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.135 </span> SDO_GEOR.setID",
                            "href":"sdo_geor-setid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.136 </span> SDO_GEOR.setLayerID",
                            "href":"sdo_geor-setlayerid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.137 </span> SDO_GEOR.setLayerOrdinate",
                            "href":"sdo_geor-setlayerordinate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.138 </span> SDO_GEOR.setModelCoordLocation",
                            "href":"sdo_geor-setmodelcoordlocation.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.139 </span> SDO_GEOR.setModelSRID",
                            "href":"sdo_geor-setmodelsrid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.140 </span> SDO_GEOR.setNODATAMask",
                            "href":"sdo_geor-setnodatamask.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.141 </span> SDO_GEOR.setOrthoRectified",
                            "href":"sdo_geor-setorthorectified.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.142 </span> SDO_GEOR.setRasterType",
                            "href":"sdo_geor-setrastertype.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.143 </span> SDO_GEOR.setRectified",
                            "href":"sdo_geor-setrectified.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.144 </span> SDO_GEOR.setScaling",
                            "href":"sdo_geor-setscaling.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.145 </span> SDO_GEOR.setSourceInfo",
                            "href":"sdo_geor-setsourceinfo.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.146 </span> SDO_GEOR.setSpatialReferenced",
                            "href":"sdo_geor-setspatialreferenced.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.147 </span> SDO_GEOR.setSpatialResolutions",
                            "href":"sdo_geor-setspatialresolutions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.148 </span> SDO_GEOR.setSpectralResolution",
                            "href":"sdo_geor-setspectralresolution.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.149 </span> SDO_GEOR.setSpectralUnit",
                            "href":"sdo_geor-setspectralunit.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.150 </span> SDO_GEOR.setSRS",
                            "href":"sdo_geor-setsrs.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.151 </span> SDO_GEOR.setStatistics",
                            "href":"sdo_geor-setstatistics.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.152 </span> SDO_GEOR.setULTCoordinate",
                            "href":"sdo_geor-setultcoordinate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.153 </span> SDO_GEOR.setVAT",
                            "href":"sdo_geor-setvat.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.154 </span> SDO_GEOR.setVersion",
                            "href":"sdo_geor-setversion.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.155 </span> SDO_GEOR.subset",
                            "href":"sdo_geor-subset.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.156 </span> SDO_GEOR.updateRaster",
                            "href":"sdo_geor-updateraster.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.157 </span> SDO_GEOR.validateBlockMBR",
                            "href":"sdo_geor-validateblockmbr.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.158 </span> SDO_GEOR.validateGeoRaster",
                            "href":"sdo_geor-validategeoraster.html"
                        },
                        {
                            "title":"<span class=\"secnum\">7.159 </span> SDO_GEOR.warp",
                            "href":"sdo_geor-warp.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> SDO_GEOR_ADMIN Package Reference",
                    "href":"sdo_geor_admin-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> SDO_GEOR_ADMIN.checkSysdataEntries",
                            "href":"sdo_geor_admin-checksysdataentries.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> SDO_GEOR_ADMIN.disableGeoRaster",
                            "href":"sdo_geor_admin-disablegeoraster.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> SDO_GEOR_ADMIN.enableGeoRaster",
                            "href":"sdo_geor_admin-enablegeoraster.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> SDO_GEOR_ADMIN.isGeoRasterEnabled",
                            "href":"sdo_geor_admin-isgeorasterenabled.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.5 </span> SDO_GEOR_ADMIN.isRDTNameUnique",
                            "href":"sdo_geor_admin-isrdtnameunique.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.6 </span> SDO_GEOR_ADMIN.isUpgradeNeeded",
                            "href":"sdo_geor_admin-isupgradeneeded.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.7 </span> SDO_GEOR_ADMIN.listGeoRasterColumns",
                            "href":"sdo_geor_admin-listgeorastercolumns.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.8 </span> SDO_GEOR_ADMIN.listGeoRasterObjects",
                            "href":"sdo_geor_admin-listgeorasterobjects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.9 </span> SDO_GEOR_ADMIN.listGeoRasterTables",
                            "href":"sdo_geor_admin-listgeorastertables.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.10 </span> SDO_GEOR_ADMIN.listDanglingRasterData",
                            "href":"sdo_geor_admin-listdanglingrasterdata.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.11 </span> SDO_GEOR_ADMIN.listRDT",
                            "href":"sdo_geor_admin-listrdt.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.12 </span> SDO_GEOR_ADMIN.listRegisteredRDT",
                            "href":"sdo_geor_admin-listregisteredrdt.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.13 </span> SDO_GEOR_ADMIN.listUnregisteredRDT",
                            "href":"sdo_geor_admin-listunregisteredrdt.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.14 </span> SDO_GEOR_ADMIN.maintainSysdataEntries",
                            "href":"sdo_geor_admin-maintainsysdataentries.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.15 </span> SDO_GEOR_ADMIN.registerGeoRasterColumns",
                            "href":"sdo_geor_admin-registergeorastercolumns.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.16 </span> SDO_GEOR_ADMIN.registerGeoRasterObjects",
                            "href":"sdo_geor_admin-registergeorasterobjects.html"
                        },
                        {
                            "title":"<span class=\"secnum\">8.17 </span> SDO_GEOR_ADMIN.upgradeGeoRaster",
                            "href":"sdo_geor_admin-upgradegeoraster.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> SDO_GEOR_AGGR Package Reference",
                    "href":"sdo_geor_aggr-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> SDO_GEOR_AGGR.append",
                            "href":"sdo_geor_aggr-append.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> SDO_GEOR_AGGR.getMosaicExtent",
                            "href":"sdo_geor_aggr-getmosaicextent.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.3 </span> SDO_GEOR_AGGR.getMosaicResolutions",
                            "href":"sdo_geor_aggr-getmosaicresolutions.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.4 </span> SDO_GEOR_AGGR.getMosaicStatistics",
                            "href":"sdo_geor_aggr-getmosaicstatistics.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.5 </span> SDO_GEOR_AGGR.getMosaicSubset",
                            "href":"sdo_geor_aggr-getmosaicsubset.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.6 </span> SDO_GEOR_AGGR.mosaicSubset",
                            "href":"sdo_geor_aggr-mosaicsubset.html"
                        },
                        {
                            "title":"<span class=\"secnum\">9.7 </span> SDO_GEOR_AGGR.validateForMosaicSubset",
                            "href":"sdo_geor_aggr-validateformosaicsubset.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> SDO_GEOR_GDAL Package Reference",
                    "href":"sdo_geor_gdal-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> SDO_GEOR_GDAL.dem",
                            "href":"sdo_geor_gdal-dem.html"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> SDO_GEOR_GDAL.translate",
                            "href":"sdo_geor_gdal-translate.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> SDO_GEOR_IP Package Reference",
                    "href":"sdo_geor_ip-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> SDO_GEOR_IP.dodge",
                            "href":"sdo_geor_ip-dodge.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> SDO_GEOR_IP.equalize",
                            "href":"sdo_geor_ip-equalize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> SDO_GEOR_IP.filter",
                            "href":"sdo_geor_ip-filter.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.4 </span> SDO_GEOR_IP.histogramMatch",
                            "href":"sdo_geor_ip-histogrammatch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.5 </span> SDO_GEOR_IP.normalize",
                            "href":"sdo_geor_ip-normalize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.6 </span> SDO_GEOR_IP.piecewiseStretch",
                            "href":"sdo_geor_ip-piecewisestretch.html"
                        },
                        {
                            "title":"<span class=\"secnum\">11.7 </span> SDO_GEOR_IP.stretch",
                            "href":"sdo_geor_ip-stretch.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> SDO_GEOR_RA Package Reference",
                    "href":"sdo_geor_ra-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> SDO_GEOR_RA.classify",
                            "href":"sdo_geor_ra-classify.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> SDO_GEOR_RA.diff",
                            "href":"sdo_geor_ra-diff.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.3 </span> SDO_GEOR_RA.findCells",
                            "href":"sdo_geor_ra-findcells.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.4 </span> SDO_GEOR_RA.isOverlap",
                            "href":"sdo_geor_ra-isoverlap.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.5 </span> SDO_GEOR_RA.over",
                            "href":"sdo_geor_ra.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.6 </span> SDO_GEOR_RA.rasterMathOp",
                            "href":"sdo_geor_ra-rastermathop.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.7 </span> SDO_GEOR_RA.rasterUpdate",
                            "href":"sdo_geor_ra-rasterupdate.html"
                        },
                        {
                            "title":"<span class=\"secnum\">12.8 </span> SDO_GEOR_RA.stack",
                            "href":"sdo_geor_ra-stack.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> SDO_GEOR_UTL Package Reference",
                    "href":"sdo_geor_utl-package-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> SDO_GEOR_UTL.calcOptimizedBlockSize",
                            "href":"sdo_geor_utl-calcoptimizedblocksize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> SDO_GEOR_UTL.calcRasterNominalSize",
                            "href":"sdo_geor_utl-calcrasternominalsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.3 </span> SDO_GEOR_UTL.calcRasterStorageSize",
                            "href":"sdo_geor_utl-calcrasterstoragesize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.4 </span> SDO_GEOR_UTL.calcSurfaceArea",
                            "href":"sdo_geor_utl-calcsurfacearea.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.5 </span> SDO_GEOR_UTL.clearReportTable",
                            "href":"sdo_geor_utl-clearreporttable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.6 </span> SDO_GEOR_UTL.createDMLTrigger",
                            "href":"sdo_geor_utl-createdmltrigger.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.7 </span> SDO_GEOR_UTL.createImage",
                            "href":"sdo_geor_utl-createimage.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.8 </span> SDO_GEOR_UTL.createReportTable",
                            "href":"sdo_geor_utl-createreporttable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.9 </span> SDO_GEOR_UTL.disableReport",
                            "href":"sdo_geor_utl-disablereport.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.10 </span> SDO_GEOR_UTL.dropReportTable",
                            "href":"sdo_geor_utl-dropreporttable.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.11 </span> SDO_GEOR_UTL.emptyBlocks",
                            "href":"sdo_geor_utl-emptyblocks.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.12 </span> SDO_GEOR_UTL.enableReport",
                            "href":"sdo_geor_utl-enablereport.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.13 </span> SDO_GEOR_UTL.fillEmptyBlocks",
                            "href":"sdo_geor_utl-fillemptyblocks.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.14 </span> SDO_GEOR_UTL.generateColorRamp",
                            "href":"sdo_geor_utl-generatecolorramp.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.15 </span> SDO_GEOR_UTL.generateGrayRamp",
                            "href":"sdo_geor_utl-generategrayramp.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.16 </span> SDO_GEOR_UTL.get_rasterTile",
                            "href":"sdo_geor_utl-get_rastertile.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.17 </span> SDO_GEOR_UTL.getAllStatusReport",
                            "href":"sdo_geor_utl-getallstatusreport.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.18 </span> SDO_GEOR_UTL.getMaxMemSize",
                            "href":"sdo_geor_utl-getmaxmemsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.19 </span> SDO_GEOR_UTL.getReadBlockMemSize",
                            "href":"sdo_geor_utl-getreadblockmemsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.20 </span> SDO_GEOR_UTL.getProgress",
                            "href":"sdo_geor_utl-getprogress.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.21 </span> SDO_GEOR_UTL.getStatusReport",
                            "href":"sdo_geor_utl-getstatusreport.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.22 </span> SDO_GEOR_UTL.getWriteBlockMemSize",
                            "href":"sdo_geor_utl-getwriteblockmemsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.23 </span> SDO_GEOR_UTL.isReporting",
                            "href":"sdo_geor_utl-isreporting.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.24 </span> SDO_GEOR_UTL.makeRDTNamesUnique",
                            "href":"sdo_geor_utl-makerdtnamesunique.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.25 </span> SDO_GEOR_UTL.recreateDMLTriggers",
                            "href":"sdo_geor_utl-recreatedmltriggers.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.26 </span> SDO_GEOR_UTL.renameRDT",
                            "href":"sdo_geor_utl-renamerdt.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.27 </span> SDO_GEOR_UTL.setClientID",
                            "href":"sdo_geor_utl-setclientid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.28 </span> SDO_GEOR_UTL.setMaxMemSize",
                            "href":"sdo_geor_utl-setmaxmemsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.29 </span> SDO_GEOR_UTL.setReadBlockMemSize",
                            "href":"sdo_geor_utl-setreadblockmemsize.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.30 </span> SDO_GEOR_UTL.setSeqID",
                            "href":"sdo_geor_utl-setseqid.html"
                        },
                        {
                            "title":"<span class=\"secnum\">13.31 </span> SDO_GEOR_UTL.setWriteBlockMemSize",
                            "href":"sdo_geor_utl-setwriteblockmemsize.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> GeoRaster Metadata XML Schema",
                    "href":"georaster-metadata-xml-schema.html"
                },
                {
                    "title":"<span class=\"secnum\">B </span> GeoRaster REST API Reference",
                    "href":"georaster-rest-api-reference.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">B.1 </span> GeoRaster REST API Architecture",
                            "href":"georaster-rest-api-architecture.html#GUID-5894F213-D8E3-40DC-88B3-DD92BACF70C0"
                        },
                        {
                            "title":"<span class=\"secnum\">B.2 </span> Deploying and Configuring the GeoRaster REST API",
                            "href":"deploying-and-configuring-georaster-rest-api.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B.3 </span> Authentication",
                            "href":"authentication.html"
                        },
                        {
                            "title":"<span class=\"secnum\">B.4 </span> GeoRaster REST API Endpoints Examples",
                            "href":"georaster-rest-api-endpoints-examples.html#GUID-580BBC96-8080-4DA6-B489-DF270709D150"
                        },
                        {
                            "title":"<span class=\"secnum\">B.5 </span> GeoRaster REST API Demonstration Web Page",
                            "href":"georaster-rest-api-demonstration-web-page.html"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">C </span> Creating and Using Raster Tile Service for Web Application",
                    "href":"creating-and-using-raster-tile-service-web-application.html",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">C.1 </span> Example 1: A Raster Tile Service Using ORDS With a Single Raster Layer",
                            "href":"example-1-raster-tile-service-using-ords-single-raster-layer.html"
                        },
                        {
                            "title":"<span class=\"secnum\">C.2 </span> Example 2: A Raster Tile Service Using ORDS With a Terrain Layer and an Image Layer for 3D Visualization",
                            "href":"example-2-raster-tile-service-using-ords-terrain-layer-and-image-layer-3d-visualization.html"
                        }
                    ]
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});