define(
{
    "reducedVersion":true,
    "toc":[
        {
            "heading":"Table of Contents",
            "topics":[
                {
                    "title":"List of Tables",
                    "href":"lot.html"
                },
                {
                    "title":"Title and Copyright Information",
                    "href":"index.html"
                },
                {
                    "title":"Preface",
                    "href":"preface.html#GUID-A2B859F8-785E-45A1-9395-8382B419B080"
                },
                {
                    "title":"Changes in This Release for Oracle AI Database Java Developer's Guide",
                    "href":"changes-in-this-release.html#GUID-95058327-1F7D-495F-B374-3DE9C6B15B22"
                },
                {
                    "title":"<span class=\"secnum\">1 </span> Introduction to Java in Oracle AI Database",
                    "href":"Java-introduction.html#GUID-912A14D4-2621-4955-85BD-A04E17EE6D21",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">1.1 </span> Overview of Java",
                            "href":"Java-overview.html#GUID-17B81887-C338-4489-924D-FDDF2468DEA7"
                        },
                        {
                            "title":"<span class=\"secnum\">1.2 </span> About Using Java in Oracle Database",
                            "href":"using-Java.html#GUID-740E7303-60E4-4DFF-9370-3AEEFEE8E394"
                        },
                        {
                            "title":"<span class=\"secnum\">1.3 </span> Overview of Oracle JVM",
                            "href":"Oracle-JVM-overview.html#GUID-391B265A-D656-4589-A4F5-C4F801340886"
                        },
                        {
                            "title":"<span class=\"secnum\">1.4 </span> Feature List of Oracle JVM",
                            "href":"Oracle-JVM-feature-list.html#GUID-82ECE7EC-C984-42C1-8384-98D4D6C3339E"
                        },
                        {
                            "title":"<span class=\"secnum\">1.5 </span> Main Components of Oracle JVM",
                            "href":"Oracle-JVM-components.html#GUID-A1C2A4DD-3C7B-4282-A29E-1317C0C0E630"
                        },
                        {
                            "title":"<span class=\"secnum\">1.6 </span> Java Programming in Oracle Database",
                            "href":"Java-application-strategy.html#GUID-643B10E4-BB92-441C-A14D-E203C592B85B"
                        },
                        {
                            "title":"<span class=\"secnum\">1.7 </span> Memory Model for Dedicated Mode Sessions",
                            "href":"memory-model.html#GUID-4C9B12A2-F5FE-4434-9948-FC2D46AFC590"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">2 </span> Java Applications on Oracle AI Database",
                    "href":"Java-applications-in-database.html#GUID-E7EEC053-2CAC-4A5D-8C90-EBFD047D32F7",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">2.1 </span> Database Sessions Imposed on Java Applications",
                            "href":"Java-application-database-session.html#GUID-6CE54CCD-DF29-4023-9F67-D7F57183DC6F"
                        },
                        {
                            "title":"<span class=\"secnum\">2.2 </span> Execution Control of Java Applications",
                            "href":"execution-control.html#GUID-2EEC2BCB-8FF6-4A24-9536-A18201A2A5B8"
                        },
                        {
                            "title":"<span class=\"secnum\">2.3 </span> Java Code, Binaries, and Resources Storage",
                            "href":"Java-code-binaries-resources-storage.html#GUID-DC6258F4-E0FF-4195-855E-7CA3F66F7959"
                        },
                        {
                            "title":"<span class=\"secnum\">2.4 </span> About Java Classes Loaded in the Database",
                            "href":"Java-classes-in-database.html#GUID-F6E236B7-8907-42B2-AD00-689A036218B4"
                        },
                        {
                            "title":"<span class=\"secnum\">2.5 </span> Preparing Java Class Methods for Execution",
                            "href":"preparing-Java-class-methods.html#GUID-0183CF7A-911E-4F3A-AA17-989023010C2D"
                        },
                        {
                            "title":"<span class=\"secnum\">2.6 </span> User Interfaces on the Server",
                            "href":"server-user-interface.html#GUID-D74251C4-2575-411E-9361-8E333D167BA0"
                        },
                        {
                            "title":"<span class=\"secnum\">2.7 </span> Shortened Class Names",
                            "href":"shortened-class-names.html#GUID-7A13AB37-4680-4E22-83EA-830C79E61126"
                        },
                        {
                            "title":"<span class=\"secnum\">2.8 </span> Class.forName() in Oracle Database",
                            "href":"Class-forName-method.html#GUID-8F47EA6B-A990-4708-9D65-B84437F173D5"
                        },
                        {
                            "title":"<span class=\"secnum\">2.9 </span> About Managing Your Operating System Resources",
                            "href":"managing-OS.html#GUID-A3A7F414-245C-431F-8D03-4D85A1BCD3EA"
                        },
                        {
                            "title":"<span class=\"secnum\">2.10 </span> About Using the Runtime.exec Functionality in Oracle Database",
                            "href":"using-Runtime-exec.html#GUID-21789439-5F9A-4709-9082-F3F5638B6CCC"
                        },
                        {
                            "title":"<span class=\"secnum\">2.11 </span> Managing Your Applications Using JMX",
                            "href":"using-JMX.html#GUID-DCBEAE2C-7C92-4AE5-8069-CD4E5FFDAFB4"
                        },
                        {
                            "title":"<span class=\"secnum\">2.12 </span> Overview of Threading in Oracle Database",
                            "href":"threading-in-database.html#GUID-7A51D651-181B-405D-BD98-F74037496902"
                        },
                        {
                            "title":"<span class=\"secnum\">2.13 </span> Shared Servers Considerations",
                            "href":"shared-server-consideration.html#GUID-94B10C5C-91C0-48EC-9C41-98FE4C2E2F9E"
                        },
                        {
                            "title":"<span class=\"secnum\">2.14 </span> Oracle JVM Rolling Patching",
                            "href":"Oracle-JVM-Rolling-Updates.html#GUID-3AF96510-E5C2-4125-83EC-C83C366B30E5"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">3 </span> Calling Java Methods in Oracle AI Database",
                    "href":"calling-Java-methods.html#GUID-1B69193D-736A-46C6-9432-5D356AD588B3",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">3.1 </span> Invoking Java Methods",
                            "href":"invoking-Java-methods.html#GUID-21F89FA2-D947-42C1-B16A-6722A219EBDA"
                        },
                        {
                            "title":"<span class=\"secnum\">3.2 </span> How To Tell If You Are Running on the Server",
                            "href":"running-on-server.html#GUID-B6432415-D7E7-4502-8AAB-17EDED514598"
                        },
                        {
                            "title":"<span class=\"secnum\">3.3 </span> About Redirecting Output on the Server",
                            "href":"redirecting-server-output.html#GUID-9045D497-CD72-43B7-B566-685EC301C654"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">4 </span> Java Installation and Configuration",
                    "href":"installation-and-configuration.html#GUID-D4659736-30EB-4810-ADA0-F2D8E1BE4F77",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">4.1 </span> Initializing a Java-Enabled Database",
                            "href":"initializing-Java-enabled-database.html#GUID-7825F0CC-F403-4D30-BA24-EEF00CEBAB63"
                        },
                        {
                            "title":"<span class=\"secnum\">4.2 </span> Configuring Oracle JVM",
                            "href":"configuring-Oracle-JVM.html#GUID-39EE0E84-2418-4AA6-8BE8-8FDEBDE53BCA"
                        },
                        {
                            "title":"<span class=\"secnum\">4.3 </span> The DBMS_JAVA Package",
                            "href":"about-DBMS-JAVA-package.html#GUID-04D7F902-A3CE-4E1D-B053-75E4DCE08D97"
                        },
                        {
                            "title":"<span class=\"secnum\">4.4 </span> Enabling the Java Client",
                            "href":"enabling-Java-client.html#GUID-51702BAF-13F2-4EFD-9E69-044F4B67E5E1"
                        },
                        {
                            "title":"<span class=\"secnum\">4.5 </span> Two-Tier Duration for Java Session State",
                            "href":"two-tier-Java-session-duration.html#GUID-3C54310C-CFD0-4831-AF45-3A23C6EE567E"
                        },
                        {
                            "title":"<span class=\"secnum\">4.6 </span> About Setting System Properties",
                            "href":"setting-system-properties.html#GUID-502B50E9-27AA-436F-BB9C-29B4DBC1E66F"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">5 </span> Developing Java Stored Procedures",
                    "href":"developing-Java-stored-procedures.html#GUID-AE1E5C4B-A077-4D1E-8821-6A7142BF1FEA",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">5.1 </span> Stored Procedures and Run-Time Contexts",
                            "href":"stored-procedures-runtime-contexts.html#GUID-3FD56429-9F6C-4323-B175-FCD484C367A5"
                        },
                        {
                            "title":"<span class=\"secnum\">5.2 </span> Advantages of Stored Procedures",
                            "href":"stored-procedure-advantages.html#GUID-B6F864FC-5C87-45DC-BBEC-2CEE469A939C"
                        },
                        {
                            "title":"<span class=\"secnum\">5.3 </span> Running Java Stored Procedures",
                            "href":"running-Java-stored-procedures.html#GUID-11B2344A-7C07-4DFB-90D1-748EA814F5E6"
                        },
                        {
                            "title":"<span class=\"secnum\">5.4 </span> Debugging Java Stored Procedures",
                            "href":"debugging-Java-stored-procedures.html#GUID-B3934F43-CE6B-4744-8C9E-BB32AEB13D0A"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">6 </span> Publishing Java Classes With Call Specifications",
                    "href":"publishing-Java-classes.html#GUID-C6DB962A-CCA6-44A1-990C-3E52636A0634",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">6.1 </span> What Are Call Specifications?",
                            "href":"about-call-specifications.html#GUID-F8F63242-6672-480E-9C9E-82236752725B"
                        },
                        {
                            "title":"<span class=\"secnum\">6.2 </span> Defining Call Specifications",
                            "href":"defining-call-specifications.html#GUID-61370303-0F46-4FAC-8CDB-EBC42F08AE68"
                        },
                        {
                            "title":"<span class=\"secnum\">6.3 </span> Writing Top-Level Call Specifications",
                            "href":"writing-top-level-call-specifications.html#GUID-140C918E-A174-42BA-AC1F-87907BD0E878"
                        },
                        {
                            "title":"<span class=\"secnum\">6.4 </span> Writing Packaged Call Specifications",
                            "href":"writing-packaged-call-specifications.html#GUID-EC3F1DCD-802C-4D29-B71C-4CADDCDB3128"
                        },
                        {
                            "title":"<span class=\"secnum\">6.5 </span> Writing Object Type Call Specifications",
                            "href":"writing-object-type-call-specifications.html#GUID-46277858-79F1-4150-A283-C9C630548329"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">7 </span> Calling Stored Procedures",
                    "href":"calling-stored-procedures.html#GUID-1ACD765F-B6C6-41FC-96E9-A9B03C73C64D",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">7.1 </span> Calling Java from the Top Level",
                            "href":"calling-Java-from-top-level.html#GUID-37426C55-3224-4D6C-AFD6-14D8454A1CAF"
                        },
                        {
                            "title":"<span class=\"secnum\">7.2 </span> Calling Java from Database Triggers",
                            "href":"calling-Java-from-database-triggers.html#GUID-5C498DEF-0348-484D-AA26-2A88EF348D5C"
                        },
                        {
                            "title":"<span class=\"secnum\">7.3 </span> Calling Java from SQL DML",
                            "href":"calling-Java-from-SQL-DML.html#GUID-286DC2FE-3D3D-4585-942F-7C23A8631FFD"
                        },
                        {
                            "title":"<span class=\"secnum\">7.4 </span> Calling Java from PL/SQL",
                            "href":"calling-Java-from-PL-SQL.html#GUID-499ABE6B-4391-43C8-A527-74A6C7B0A0FF"
                        },
                        {
                            "title":"<span class=\"secnum\">7.5 </span> Calling PL/SQL from Java",
                            "href":"calling-PL-SQL-from-Java.html#GUID-F2FC29B6-F20F-49FB-99CB-56C9C15ECFB5"
                        },
                        {
                            "title":"<span class=\"secnum\">7.6 </span> How Oracle JVM Handles Exceptions",
                            "href":"Oracle-JVM-exception-handling.html#GUID-DBB6AE15-B27E-4B24-BAC1-B39175E18B58"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">8 </span> Java Stored Procedures Application Example",
                    "href":"Java-stored-procedure-application-example.html#GUID-F3E46789-808B-4D0D-84B7-95AA8DB66B55",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">8.1 </span> About Planning the Database Schema",
                            "href":"planning-database-schema.html#GUID-6F0CC457-D750-4E90-B706-C2B13C8B7C18"
                        },
                        {
                            "title":"<span class=\"secnum\">8.2 </span> Creating the Database Tables",
                            "href":"creating-database-tables.html#GUID-877C70F9-AFC3-4789-9271-1BEF5F3DF30E"
                        },
                        {
                            "title":"<span class=\"secnum\">8.3 </span> Writing the Java Classes",
                            "href":"writing-the-Java-classes.html#GUID-9863F339-7175-4698-B33C-87DC52210A13"
                        },
                        {
                            "title":"<span class=\"secnum\">8.4 </span> Loading the Java Classes",
                            "href":"loading-the-Java-classes.html#GUID-B58157CC-4BE4-421D-834B-B6B786A8597E"
                        },
                        {
                            "title":"<span class=\"secnum\">8.5 </span> Publishing the Java Classes",
                            "href":"publishing-the-Java-classes.html#GUID-13BA8CF7-3F2C-4329-9B98-A76972F5E06C"
                        },
                        {
                            "title":"<span class=\"secnum\">8.6 </span> Calling the Java Stored Procedures",
                            "href":"calling-Java-stored-procedures.html#GUID-0BF49E53-CE46-4FB3-A62F-A2C61BC80CDA"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">9 </span> Oracle AI Database Java Application Performance",
                    "href":"Java-application-performance.html#GUID-7AB351A8-AA78-477C-AC3F-B5AD74E79A2B",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">9.1 </span> Oracle JVM Just-in-Time Compiler (JIT)",
                            "href":"Oracle-JVM-JIT.html#GUID-23D5BA60-A2B3-45F9-93DF-81A3D971CA50"
                        },
                        {
                            "title":"<span class=\"secnum\">9.2 </span> About Java Memory Usage",
                            "href":"about-Java-memory-usage.html#GUID-D660F569-3654-4C5F-9D25-5D5A3E05E9AD"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">10 </span> Security for Oracle AI Database Java Applications",
                    "href":"database-Java-application-security.html#GUID-BCFBD7DC-40E3-4707-BD01-E47E3D0963B2",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">10.1 </span> Network Connection Security",
                            "href":"network-connection-security.html#GUID-BAC012AE-F7B1-4680-9B27-BF3BF5CF5E05"
                        },
                        {
                            "title":"<span class=\"secnum\">10.2 </span> Database Contents and Oracle JVM Security",
                            "href":"database-contents-Oracle-JVM-security.html#GUID-54515619-575D-4EFB-B745-F857A07813A6"
                        },
                        {
                            "title":"<span class=\"secnum\">10.3 </span> Database Authentication Mechanisms Available with Oracle JVM",
                            "href":"Oracle-JVM-authentication-mechanism.html#GUID-195F2B1F-5647-48D4-B075-2829BAD021F1"
                        },
                        {
                            "title":"<span class=\"secnum\">10.4 </span> Secure Use of Runtime.exec Functionality in Oracle Database",
                            "href":"Runtime-exe-secure-use.html#GUID-63109A8A-028C-4DFC-B24B-A2A6DB7FAE19"
                        },
                        {
                            "title":"<span class=\"secnum\">10.5 </span> Database Security in a Multitenant Environment",
                            "href":"DB-security-in-multitenant.html#GUID-71533511-C90F-4656-A46A-306A4E56787E"
                        },
                        {
                            "title":"<span class=\"secnum\">10.6 </span> FIPS Support",
                            "href":"FIPS-support.html#GUID-C9213EC3-820E-414C-AE48-C7CD1FBE945B"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">11 </span> Native Oracle JVM Support for JNDI",
                    "href":"native-JNDI-support.html#GUID-579E3C42-6F26-406E-A0B1-A8B678E27972",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">11.1 </span> Overview of Oracle JVM Support for JNDI",
                            "href":"JNDI-support-overview.html#GUID-447D0B43-0B5C-4394-840C-421714F30251"
                        },
                        {
                            "title":"<span class=\"secnum\">11.2 </span> Requirements for Oracle JVM Support for JNDI",
                            "href":"JNDI-support-requirement.html#GUID-541B6C4B-AD02-4826-AD97-47270150AEE1"
                        },
                        {
                            "title":"<span class=\"secnum\">11.3 </span> OJDS Command-Line Tools",
                            "href":"OJDS-command-tools.html#GUID-BB7CFB26-2BAC-4680-AC0B-20B4C8328DE7"
                        },
                        {
                            "title":"<span class=\"secnum\">11.4 </span> OJDS APIs and Classes",
                            "href":"OJDS-APIs-classes.html#GUID-683DEC5A-01EA-4EC3-B67B-8A46A99442C6"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">12 </span> Schema Objects and Oracle JVM Utilities",
                    "href":"schema-objects-and-Oracle-JVM-utilities.html#GUID-2A76FBC2-3A4A-4620-9A83-CA01724B13DB",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">12.1 </span> Overview of Schema Objects",
                            "href":"schema-objects-overview.html#GUID-063A65CD-B42C-43AD-ABA8-77465AC0F353"
                        },
                        {
                            "title":"<span class=\"secnum\">12.2 </span> What and When to Load",
                            "href":"loading-schema-objects.html#GUID-AEA77CB1-1D58-430A-96CF-37D319440084"
                        },
                        {
                            "title":"<span class=\"secnum\">12.3 </span> Resolution of Schema Objects",
                            "href":"schema-objects-resolution.html#GUID-BD1FC187-1E43-473C-A57B-B18D2ED4BB5E"
                        },
                        {
                            "title":"<span class=\"secnum\">12.4 </span> Compilation of Schema Objects",
                            "href":"schema-objects-compilation.html#GUID-B1F4D71D-F025-45DB-B8E0-6E156ECBD60E"
                        },
                        {
                            "title":"<span class=\"secnum\">12.5 </span> The ojvmtc Tool",
                            "href":"ojvmtc-tool.html#GUID-708836F1-6003-484E-9AAC-8A6BF24362C7"
                        },
                        {
                            "title":"<span class=\"secnum\">12.6 </span> The loadjava Tool",
                            "href":"loadjava-tool.html#GUID-033299E6-07E2-4C2C-9E26-A2FE25118F1C"
                        },
                        {
                            "title":"<span class=\"secnum\">12.7 </span> The dropjava Tool",
                            "href":"dropjava-tool.html#GUID-BA27EC86-8FE7-44EC-9E4B-4085CAACA2CE"
                        },
                        {
                            "title":"<span class=\"secnum\">12.8 </span> The ojvmjava Tool",
                            "href":"ojvmjava-tool.html#GUID-E3141F37-82FC-45F4-86BF-FED2ED823BC4"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">13 </span> Database Web Services",
                    "href":"database-web-services.html#GUID-4BCABFBB-62C8-4D02-A62D-8BB0F68FF126",
                    "topics":[
                        {
                            "title":"<span class=\"secnum\">13.1 </span> Overview of Database Web Services",
                            "href":"database-web-services-overview.html#GUID-472129F7-A3AE-4B35-82EE-0F6B06EA208E"
                        },
                        {
                            "title":"<span class=\"secnum\">13.2 </span> About Using Oracle Database as Web Services Consumer",
                            "href":"database-as-web-service-consumer.html#GUID-F84EC95B-0F0A-48B7-B0B1-E04BE9E704D8"
                        }
                    ]
                },
                {
                    "title":"<span class=\"secnum\">A </span> DBMS_JAVA Package",
                    "href":"DBMS-JAVA-package.html#GUID-3C89E0FC-C707-4D3D-9263-C33D866DBC1B"
                },
                {
                    "title":"<span class=\"secnum\">B </span> Classpath Extensions and User Classloaded Metadata",
                    "href":"classpath-extensions-user-classes-metadata.html#GUID-C948182D-D9C7-45DB-9B7A-648BBCA47F6E"
                },
                {
                    "title":"Index",
                    "href":"book-index.html"
                }
            ]
        }
    ]
});